/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.text.ParcelableSpan;
import android.text.TextPaint;
import android.text.style.CharacterStyle;
import android.util.Log;
import android.view.inputmethod.InputMethodManager;
import com.android.internal.R;
import java.util.Arrays;
import java.util.Locale;

public class SuggestionSpan
extends CharacterStyle
implements ParcelableSpan {
    public static final String ACTION_SUGGESTION_PICKED = "android.text.style.SUGGESTION_PICKED";
    public static final Parcelable.Creator<SuggestionSpan> CREATOR = new Parcelable.Creator<SuggestionSpan>(){

        @Override
        public SuggestionSpan createFromParcel(Parcel parcel) {
            return new SuggestionSpan(parcel);
        }

        public SuggestionSpan[] newArray(int n) {
            return new SuggestionSpan[n];
        }
    };
    public static final int FLAG_AUTO_CORRECTION = 4;
    public static final int FLAG_EASY_CORRECT = 1;
    public static final int FLAG_MISSPELLED = 2;
    public static final int SUGGESTIONS_MAX_SIZE = 5;
    public static final String SUGGESTION_SPAN_PICKED_AFTER = "after";
    public static final String SUGGESTION_SPAN_PICKED_BEFORE = "before";
    public static final String SUGGESTION_SPAN_PICKED_HASHCODE = "hashcode";
    private static final String TAG = "SuggestionSpan";
    private int mAutoCorrectionUnderlineColor;
    private float mAutoCorrectionUnderlineThickness;
    private int mEasyCorrectUnderlineColor;
    private float mEasyCorrectUnderlineThickness;
    private int mFlags;
    private final int mHashCode;
    private final String mLocaleString;
    private int mMisspelledUnderlineColor;
    private float mMisspelledUnderlineThickness;
    private final String mNotificationTargetClassName;
    private final String mNotificationTargetPackageName;
    private final String[] mSuggestions;

    /*
     * Enabled aggressive block sorting
     */
    public SuggestionSpan(Context context, Locale locale, String[] stringArray, int n, Class<?> clazz) {
        this.mSuggestions = Arrays.copyOf(stringArray, Math.min(5, stringArray.length));
        this.mFlags = n;
        if (locale != null) {
            this.mLocaleString = locale.toString();
        } else if (context != null) {
            this.mLocaleString = context.getResources().getConfiguration().locale.toString();
        } else {
            Log.e(TAG, "No locale or context specified in SuggestionSpan constructor");
            this.mLocaleString = "";
        }
        this.mNotificationTargetPackageName = context != null ? context.getPackageName() : null;
        this.mNotificationTargetClassName = clazz != null ? clazz.getCanonicalName() : "";
        this.mHashCode = SuggestionSpan.hashCodeInternal(this.mSuggestions, this.mLocaleString, this.mNotificationTargetClassName);
        this.initStyle(context);
    }

    public SuggestionSpan(Context context, String[] stringArray, int n) {
        this(context, null, stringArray, n, null);
    }

    public SuggestionSpan(Parcel parcel) {
        this.mSuggestions = parcel.readStringArray();
        this.mFlags = parcel.readInt();
        this.mLocaleString = parcel.readString();
        this.mNotificationTargetClassName = parcel.readString();
        this.mNotificationTargetPackageName = parcel.readString();
        this.mHashCode = parcel.readInt();
        this.mEasyCorrectUnderlineColor = parcel.readInt();
        this.mEasyCorrectUnderlineThickness = parcel.readFloat();
        this.mMisspelledUnderlineColor = parcel.readInt();
        this.mMisspelledUnderlineThickness = parcel.readFloat();
        this.mAutoCorrectionUnderlineColor = parcel.readInt();
        this.mAutoCorrectionUnderlineThickness = parcel.readFloat();
    }

    public SuggestionSpan(Locale locale, String[] stringArray, int n) {
        this(null, locale, stringArray, n, null);
    }

    private static int hashCodeInternal(String[] stringArray, String string2, String string3) {
        Object[] objectArray = new Object[]{SystemClock.uptimeMillis(), stringArray, string2, string3};
        return Arrays.hashCode(objectArray);
    }

    private void initStyle(Context context) {
        if (context == null) {
            this.mMisspelledUnderlineThickness = 0.0f;
            this.mEasyCorrectUnderlineThickness = 0.0f;
            this.mAutoCorrectionUnderlineThickness = 0.0f;
            this.mMisspelledUnderlineColor = -16777216;
            this.mEasyCorrectUnderlineColor = -16777216;
            this.mAutoCorrectionUnderlineColor = -16777216;
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(null, R.styleable.SuggestionSpan, 0x1010410, 0);
        this.mMisspelledUnderlineThickness = typedArray.getDimension(1, 0.0f);
        this.mMisspelledUnderlineColor = typedArray.getColor(0, -16777216);
        TypedArray typedArray2 = context.obtainStyledAttributes(null, R.styleable.SuggestionSpan, 16843791, 0);
        this.mEasyCorrectUnderlineThickness = typedArray2.getDimension(1, 0.0f);
        this.mEasyCorrectUnderlineColor = typedArray2.getColor(0, -16777216);
        TypedArray typedArray3 = context.obtainStyledAttributes(null, R.styleable.SuggestionSpan, 0x1010411, 0);
        this.mAutoCorrectionUnderlineThickness = typedArray3.getDimension(1, 0.0f);
        this.mAutoCorrectionUnderlineColor = typedArray3.getColor(0, -16777216);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object object) {
        boolean bl = object instanceof SuggestionSpan;
        boolean bl2 = false;
        if (bl) {
            int n = ((SuggestionSpan)object).hashCode();
            int n2 = this.mHashCode;
            bl2 = false;
            if (n == n2) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public String getLocale() {
        return this.mLocaleString;
    }

    public String getNotificationTargetClassName() {
        return this.mNotificationTargetClassName;
    }

    @Override
    public int getSpanTypeId() {
        return 19;
    }

    public String[] getSuggestions() {
        return this.mSuggestions;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getUnderlineColor() {
        boolean bl = (2 & this.mFlags) != 0;
        boolean bl2 = (1 & this.mFlags) != 0;
        boolean bl3 = (4 & this.mFlags) != 0;
        if (bl2) {
            if (!bl) return this.mEasyCorrectUnderlineColor;
            return this.mMisspelledUnderlineColor;
        }
        int n = 0;
        if (!bl3) return n;
        return this.mAutoCorrectionUnderlineColor;
    }

    public int hashCode() {
        return this.mHashCode;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void notifySelection(Context context, String string2, int n) {
        InputMethodManager inputMethodManager;
        block6: {
            block5: {
                Intent intent = new Intent();
                if (context == null || this.mNotificationTargetClassName == null) break block5;
                if (this.mSuggestions == null || n < 0 || n >= this.mSuggestions.length) {
                    Log.w(TAG, "Unable to notify the suggestion as the index is out of range index=" + n + " length=" + this.mSuggestions.length);
                    return;
                }
                if (this.mNotificationTargetPackageName != null) {
                    intent.setClassName(this.mNotificationTargetPackageName, this.mNotificationTargetClassName);
                    intent.setAction(ACTION_SUGGESTION_PICKED);
                    intent.putExtra(SUGGESTION_SPAN_PICKED_BEFORE, string2);
                    intent.putExtra(SUGGESTION_SPAN_PICKED_AFTER, this.mSuggestions[n]);
                    intent.putExtra(SUGGESTION_SPAN_PICKED_HASHCODE, this.hashCode());
                    context.sendBroadcast(intent);
                    return;
                }
                inputMethodManager = InputMethodManager.peekInstance();
                if (inputMethodManager != null) break block6;
            }
            return;
        }
        inputMethodManager.notifySuggestionPicked(this, string2, n);
    }

    public void setFlags(int n) {
        this.mFlags = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void updateDrawState(TextPaint textPaint) {
        boolean bl = (2 & this.mFlags) != 0;
        boolean bl2 = (1 & this.mFlags) != 0;
        boolean bl3 = (4 & this.mFlags) != 0;
        if (bl2) {
            if (!bl) {
                textPaint.setUnderlineText(this.mEasyCorrectUnderlineColor, this.mEasyCorrectUnderlineThickness);
                return;
            } else {
                if (textPaint.underlineColor != 0) return;
                textPaint.setUnderlineText(this.mMisspelledUnderlineColor, this.mMisspelledUnderlineThickness);
                return;
            }
        }
        if (!bl3) return;
        textPaint.setUnderlineText(this.mAutoCorrectionUnderlineColor, this.mAutoCorrectionUnderlineThickness);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeStringArray(this.mSuggestions);
        parcel.writeInt(this.mFlags);
        parcel.writeString(this.mLocaleString);
        parcel.writeString(this.mNotificationTargetClassName);
        parcel.writeString(this.mNotificationTargetPackageName);
        parcel.writeInt(this.mHashCode);
        parcel.writeInt(this.mEasyCorrectUnderlineColor);
        parcel.writeFloat(this.mEasyCorrectUnderlineThickness);
        parcel.writeInt(this.mMisspelledUnderlineColor);
        parcel.writeFloat(this.mMisspelledUnderlineThickness);
        parcel.writeInt(this.mAutoCorrectionUnderlineColor);
        parcel.writeFloat(this.mAutoCorrectionUnderlineThickness);
    }
}

