/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TypeEvaluator;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.transition.Transition;
import android.transition.TransitionSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

public class TransitionUtils {
    private static int MAX_IMAGE_SIZE = 0x100000;

    public static View copyViewImage(ViewGroup viewGroup, View view, View view2) {
        Matrix matrix = new Matrix();
        matrix.setTranslate(-view2.getScrollX(), -view2.getScrollY());
        view.transformMatrixToGlobal(matrix);
        viewGroup.transformMatrixToLocal(matrix);
        RectF rectF = new RectF(0.0f, 0.0f, view.getWidth(), view.getHeight());
        matrix.mapRect(rectF);
        int n = Math.round(rectF.left);
        int n2 = Math.round(rectF.top);
        int n3 = Math.round(rectF.right);
        int n4 = Math.round(rectF.bottom);
        ImageView imageView = new ImageView(view.getContext());
        imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        Bitmap bitmap = TransitionUtils.createViewBitmap(view, matrix, rectF);
        if (bitmap != null) {
            imageView.setImageBitmap(bitmap);
        }
        imageView.measure(View.MeasureSpec.makeMeasureSpec(n3 - n, 0x40000000), View.MeasureSpec.makeMeasureSpec(n4 - n2, 0x40000000));
        imageView.layout(n, n2, n3, n4);
        return imageView;
    }

    public static Bitmap createViewBitmap(View view, Matrix matrix, RectF rectF) {
        int n = Math.round(rectF.width());
        int n2 = Math.round(rectF.height());
        Bitmap bitmap = null;
        if (n > 0) {
            bitmap = null;
            if (n2 > 0) {
                float f = Math.min(1.0f, (float)MAX_IMAGE_SIZE / (float)(n * n2));
                int n3 = (int)(f * (float)n);
                int n4 = (int)(f * (float)n2);
                matrix.postTranslate(-rectF.left, -rectF.top);
                matrix.postScale(f, f);
                bitmap = Bitmap.createBitmap(n3, n4, Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                canvas.concat(matrix);
                view.draw(canvas);
            }
        }
        return bitmap;
    }

    static Animator mergeAnimators(Animator animator2, Animator animator3) {
        if (animator2 == null) {
            return animator3;
        }
        if (animator3 == null) {
            return animator2;
        }
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(animator2, animator3);
        return animatorSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Transition mergeTransitions(Transition ... transitionArray) {
        int n = 0;
        int n2 = -1;
        for (int i = 0; i < transitionArray.length; ++i) {
            if (transitionArray[i] == null) continue;
            ++n;
            n2 = i;
        }
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return transitionArray[n2];
        }
        TransitionSet transitionSet = new TransitionSet();
        int n3 = 0;
        while (n3 < transitionArray.length) {
            if (transitionArray[n3] != null) {
                transitionSet.addTransition(transitionArray[n3]);
            }
            ++n3;
        }
        return transitionSet;
    }

    public static class MatrixEvaluator
    implements TypeEvaluator<Matrix> {
        float[] mTempEndValues;
        Matrix mTempMatrix;
        float[] mTempStartValues = new float[9];

        public MatrixEvaluator() {
            this.mTempEndValues = new float[9];
            this.mTempMatrix = new Matrix();
        }

        @Override
        public Matrix evaluate(float f, Matrix matrix, Matrix matrix2) {
            matrix.getValues(this.mTempStartValues);
            matrix2.getValues(this.mTempEndValues);
            for (int i = 0; i < 9; ++i) {
                float f2 = this.mTempEndValues[i] - this.mTempStartValues[i];
                this.mTempEndValues[i] = this.mTempStartValues[i] + f * f2;
            }
            this.mTempMatrix.setValues(this.mTempEndValues);
            return this.mTempMatrix;
        }
    }
}

