/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.Base64;
import android.util.Base64DataException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Base64OutputStream
extends FilterOutputStream {
    private static byte[] EMPTY = new byte[0];
    private int bpos = 0;
    private byte[] buffer = null;
    private final Base64.Coder coder;
    private final int flags;

    public Base64OutputStream(OutputStream outputStream, int n) {
        this(outputStream, n, true);
    }

    public Base64OutputStream(OutputStream outputStream, int n, boolean bl) {
        super(outputStream);
        this.flags = n;
        if (bl) {
            this.coder = new Base64.Encoder(n, null);
            return;
        }
        this.coder = new Base64.Decoder(n, null);
    }

    private byte[] embiggen(byte[] byArray, int n) {
        if (byArray == null || byArray.length < n) {
            byArray = new byte[n];
        }
        return byArray;
    }

    private void flushBuffer() throws IOException {
        if (this.bpos > 0) {
            this.internalWrite(this.buffer, 0, this.bpos, false);
            this.bpos = 0;
        }
    }

    private void internalWrite(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        this.coder.output = this.embiggen(this.coder.output, this.coder.maxOutputSize(n2));
        if (!this.coder.process(byArray, n, n2, bl)) {
            throw new Base64DataException("bad base-64");
        }
        this.out.write(this.coder.output, 0, this.coder.op);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        IOException iOException;
        block7: {
            iOException = null;
            try {
                this.flushBuffer();
                this.internalWrite(EMPTY, 0, 0, true);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            try {
                if ((0x10 & this.flags) == 0) {
                    this.out.close();
                    break block7;
                }
                this.out.flush();
            }
            catch (IOException iOException3) {
                if (iOException == null) break block7;
                iOException = iOException3;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    @Override
    public void write(int n) throws IOException {
        if (this.buffer == null) {
            this.buffer = new byte[1024];
        }
        if (this.bpos >= this.buffer.length) {
            this.internalWrite(this.buffer, 0, this.bpos, false);
            this.bpos = 0;
        }
        byte[] byArray = this.buffer;
        int n2 = this.bpos;
        this.bpos = n2 + 1;
        byArray[n2] = (byte)n;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return;
        }
        this.flushBuffer();
        this.internalWrite(byArray, n, n2, false);
    }
}

