/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.ListIterator;

public final class LocalLog {
    private LinkedList<String> mLog = new LinkedList();
    private int mMaxLines;
    private long mNow;

    public LocalLog(int n) {
        this.mMaxLines = n;
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        synchronized (this) {
            ListIterator<String> listIterator = this.mLog.listIterator(0);
            while (listIterator.hasNext()) {
                printWriter.println((String)listIterator.next());
            }
            return;
        }
    }

    public void log(String string2) {
        synchronized (this) {
            if (this.mMaxLines > 0) {
                this.mNow = System.currentTimeMillis();
                StringBuilder stringBuilder = new StringBuilder();
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(this.mNow);
                stringBuilder.append(String.format("%tm-%td %tH:%tM:%tS.%tL", calendar, calendar, calendar, calendar, calendar, calendar));
                this.mLog.add(stringBuilder.toString() + " - " + string2);
                while (this.mLog.size() > this.mMaxLines) {
                    this.mLog.remove();
                }
            }
            return;
        }
    }
}

