/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.Log;
import java.io.Writer;

public class LogWriter
extends Writer {
    private final int mBuffer;
    private StringBuilder mBuilder = new StringBuilder(128);
    private final int mPriority;
    private final String mTag;

    public LogWriter(int n, String string2) {
        this.mPriority = n;
        this.mTag = string2;
        this.mBuffer = 0;
    }

    public LogWriter(int n, String string2, int n2) {
        this.mPriority = n;
        this.mTag = string2;
        this.mBuffer = n2;
    }

    private void flushBuilder() {
        if (this.mBuilder.length() > 0) {
            Log.println_native(this.mBuffer, this.mPriority, this.mTag, this.mBuilder.toString());
            this.mBuilder.delete(0, this.mBuilder.length());
        }
    }

    @Override
    public void close() {
        this.flushBuilder();
    }

    @Override
    public void flush() {
        this.flushBuilder();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void write(char[] cArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            char c = cArray[n + n3];
            if (c == '\n') {
                this.flushBuilder();
            } else {
                this.mBuilder.append(c);
            }
            ++n3;
        }
        return;
    }
}

