/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import com.android.internal.util.Preconditions;

public final class SizeF {
    private final float mHeight;
    private final float mWidth;

    public SizeF(float f, float f2) {
        this.mWidth = Preconditions.checkArgumentFinite(f, "width");
        this.mHeight = Preconditions.checkArgumentFinite(f2, "height");
    }

    private static NumberFormatException invalidSizeF(String string2) {
        throw new NumberFormatException("Invalid SizeF: \"" + string2 + "\"");
    }

    public static SizeF parseSizeF(String string2) throws NumberFormatException {
        Preconditions.checkNotNull(string2, "string must not be null");
        int n = string2.indexOf(42);
        if (n < 0) {
            n = string2.indexOf(120);
        }
        if (n < 0) {
            throw SizeF.invalidSizeF(string2);
        }
        try {
            SizeF sizeF = new SizeF(Float.parseFloat(string2.substring(0, n)), Float.parseFloat(string2.substring(n + 1)));
            return sizeF;
        }
        catch (NumberFormatException numberFormatException) {
            throw SizeF.invalidSizeF(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw SizeF.invalidSizeF(string2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl = true;
        if (object == null) {
            return false;
        }
        if (this == object) {
            return bl;
        }
        if (!(object instanceof SizeF)) return false;
        SizeF sizeF = (SizeF)object;
        if (this.mWidth != sizeF.mWidth) return false;
        if (this.mHeight != sizeF.mHeight) return false;
        return bl;
    }

    public float getHeight() {
        return this.mHeight;
    }

    public float getWidth() {
        return this.mWidth;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.mWidth) ^ Float.floatToIntBits(this.mHeight);
    }

    public String toString() {
        return this.mWidth + "x" + this.mHeight;
    }
}

