/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.FloatMath;

public abstract class Spline {
    public static Spline createLinearSpline(float[] fArray, float[] fArray2) {
        return new LinearSpline(fArray, fArray2);
    }

    public static Spline createMonotoneCubicSpline(float[] fArray, float[] fArray2) {
        return new MonotoneCubicSpline(fArray, fArray2);
    }

    public static Spline createSpline(float[] fArray, float[] fArray2) {
        if (!Spline.isStrictlyIncreasing(fArray)) {
            throw new IllegalArgumentException("The control points must all have strictly increasing X values.");
        }
        if (Spline.isMonotonic(fArray2)) {
            return Spline.createMonotoneCubicSpline(fArray, fArray2);
        }
        return Spline.createLinearSpline(fArray, fArray2);
    }

    private static boolean isMonotonic(float[] fArray) {
        if (fArray == null || fArray.length < 2) {
            throw new IllegalArgumentException("There must be at least two control points.");
        }
        float f = fArray[0];
        for (int i = 1; i < fArray.length; ++i) {
            float f2 = fArray[i];
            if (f2 < f) {
                return false;
            }
            f = f2;
        }
        return true;
    }

    private static boolean isStrictlyIncreasing(float[] fArray) {
        if (fArray == null || fArray.length < 2) {
            throw new IllegalArgumentException("There must be at least two control points.");
        }
        float f = fArray[0];
        for (int i = 1; i < fArray.length; ++i) {
            float f2 = fArray[i];
            if (f2 <= f) {
                return false;
            }
            f = f2;
        }
        return true;
    }

    public abstract float interpolate(float var1);

    public static class LinearSpline
    extends Spline {
        private final float[] mM;
        private final float[] mX;
        private final float[] mY;

        public LinearSpline(float[] fArray, float[] fArray2) {
            if (fArray == null || fArray2 == null || fArray.length != fArray2.length || fArray.length < 2) {
                throw new IllegalArgumentException("There must be at least two control points and the arrays must be of equal length.");
            }
            int n = fArray.length;
            this.mM = new float[n - 1];
            for (int i = 0; i < n - 1; ++i) {
                this.mM[i] = (fArray2[i + 1] - fArray2[i]) / (fArray[i + 1] - fArray[i]);
            }
            this.mX = fArray;
            this.mY = fArray2;
        }

        @Override
        public float interpolate(float f) {
            int n = this.mX.length;
            if (Float.isNaN(f)) {
                return f;
            }
            if (f <= this.mX[0]) {
                return this.mY[0];
            }
            if (f >= this.mX[n - 1]) {
                return this.mY[n - 1];
            }
            int n2 = 0;
            while (f >= this.mX[n2 + 1]) {
                if (f != this.mX[++n2]) continue;
                return this.mY[n2];
            }
            return this.mY[n2] + this.mM[n2] * (f - this.mX[n2]);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            int n = this.mX.length;
            stringBuilder.append("LinearSpline{[");
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("(").append(this.mX[i]);
                stringBuilder.append(", ").append(this.mY[i]);
                if (i < n - 1) {
                    stringBuilder.append(": ").append(this.mM[i]);
                }
                stringBuilder.append(")");
            }
            stringBuilder.append("]}");
            return stringBuilder.toString();
        }
    }

    public static class MonotoneCubicSpline
    extends Spline {
        private float[] mM;
        private float[] mX;
        private float[] mY;

        /*
         * Enabled aggressive block sorting
         */
        public MonotoneCubicSpline(float[] fArray, float[] fArray2) {
            if (fArray == null || fArray2 == null || fArray.length != fArray2.length || fArray.length < 2) {
                throw new IllegalArgumentException("There must be at least two control points and the arrays must be of equal length.");
            }
            int n = fArray.length;
            float[] fArray3 = new float[n - 1];
            float[] fArray4 = new float[n];
            for (int i = 0; i < n - 1; ++i) {
                float f = fArray[i + 1] - fArray[i];
                if (f <= 0.0f) {
                    throw new IllegalArgumentException("The control points must all have strictly increasing X values.");
                }
                fArray3[i] = (fArray2[i + 1] - fArray2[i]) / f;
            }
            fArray4[0] = fArray3[0];
            for (int i = 1; i < n - 1; ++i) {
                fArray4[i] = 0.5f * (fArray3[i - 1] + fArray3[i]);
            }
            fArray4[n - 1] = fArray3[n - 2];
            int n2 = 0;
            while (true) {
                if (n2 >= n - 1) {
                    this.mX = fArray;
                    this.mY = fArray2;
                    this.mM = fArray4;
                    return;
                }
                if (fArray3[n2] == 0.0f) {
                    fArray4[n2] = 0.0f;
                    fArray4[n2 + 1] = 0.0f;
                } else {
                    float f = fArray4[n2] / fArray3[n2];
                    float f2 = fArray4[n2 + 1] / fArray3[n2];
                    if (f < 0.0f || f2 < 0.0f) {
                        throw new IllegalArgumentException("The control points must have monotonic Y values.");
                    }
                    float f3 = FloatMath.hypot(f, f2);
                    if (f3 > 9.0f) {
                        float f4 = 3.0f / f3;
                        fArray4[n2] = f4 * f * fArray3[n2];
                        fArray4[n2 + 1] = f4 * f2 * fArray3[n2];
                    }
                }
                ++n2;
            }
        }

        @Override
        public float interpolate(float f) {
            int n = this.mX.length;
            if (Float.isNaN(f)) {
                return f;
            }
            if (f <= this.mX[0]) {
                return this.mY[0];
            }
            if (f >= this.mX[n - 1]) {
                return this.mY[n - 1];
            }
            int n2 = 0;
            while (f >= this.mX[n2 + 1]) {
                if (f != this.mX[++n2]) continue;
                return this.mY[n2];
            }
            float f2 = this.mX[n2 + 1] - this.mX[n2];
            float f3 = (f - this.mX[n2]) / f2;
            return (this.mY[n2] * (1.0f + 2.0f * f3) + f3 * (f2 * this.mM[n2])) * (1.0f - f3) * (1.0f - f3) + f3 * (f3 * (this.mY[n2 + 1] * (3.0f - 2.0f * f3) + f2 * this.mM[n2 + 1] * (f3 - 1.0f)));
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            int n = this.mX.length;
            stringBuilder.append("MonotoneCubicSpline{[");
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("(").append(this.mX[i]);
                stringBuilder.append(", ").append(this.mY[i]);
                stringBuilder.append(": ").append(this.mM[i]).append(")");
            }
            stringBuilder.append("]}");
            return stringBuilder.toString();
        }
    }
}

