/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.util.Log;
import android.view.HardwareLayer;
import android.view.View;

public class TextureView
extends View {
    private static final String LOG_TAG = "TextureView";
    private Canvas mCanvas;
    private boolean mHadSurface;
    private HardwareLayer mLayer;
    private SurfaceTextureListener mListener;
    private final Object[] mLock;
    private final Matrix mMatrix = new Matrix();
    private boolean mMatrixChanged;
    private long mNativeWindow;
    private final Object[] mNativeWindowLock;
    private boolean mOpaque = true;
    private int mSaveCount;
    private SurfaceTexture mSurface;
    private boolean mUpdateLayer;
    private final SurfaceTexture.OnFrameAvailableListener mUpdateListener;
    private boolean mUpdateSurface;

    public TextureView(Context context) {
        super(context);
        this.mLock = new Object[0];
        this.mNativeWindowLock = new Object[0];
        this.mUpdateListener = new SurfaceTexture.OnFrameAvailableListener(){

            @Override
            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                TextureView.this.updateLayer();
                TextureView.this.invalidate();
            }
        };
        this.init();
    }

    public TextureView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mLock = new Object[0];
        this.mNativeWindowLock = new Object[0];
        this.mUpdateListener = new /* invalid duplicate definition of identical inner class */;
        this.init();
    }

    public TextureView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.mLock = new Object[0];
        this.mNativeWindowLock = new Object[0];
        this.mUpdateListener = new /* invalid duplicate definition of identical inner class */;
        this.init();
    }

    public TextureView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.mLock = new Object[0];
        this.mNativeWindowLock = new Object[0];
        this.mUpdateListener = new /* invalid duplicate definition of identical inner class */;
        this.init();
    }

    private void applyTransformMatrix() {
        if (this.mMatrixChanged && this.mLayer != null) {
            this.mLayer.setTransform(this.mMatrix);
            this.mMatrixChanged = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void applyUpdate() {
        block8: {
            block7: {
                if (this.mLayer == null) break block7;
                Object[] objectArray = this.mLock;
                synchronized (objectArray) {
                    if (!this.mUpdateLayer) {
                        return;
                    }
                    this.mUpdateLayer = false;
                }
                this.mLayer.prepare(this.getWidth(), this.getHeight(), this.mOpaque);
                this.mLayer.updateSurfaceTexture();
                if (this.mListener != null) break block8;
            }
            return;
        }
        this.mListener.onSurfaceTextureUpdated(this.mSurface);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void destroySurface() {
        if (this.mLayer != null) {
            this.mLayer.detachSurfaceTexture();
            boolean bl = true;
            if (this.mListener != null) {
                bl = this.mListener.onSurfaceTextureDestroyed(this.mSurface);
            }
            Object[] objectArray = this.mNativeWindowLock;
            synchronized (objectArray) {
                this.nDestroyNativeWindow();
            }
            this.mLayer.destroy();
            if (bl) {
                this.mSurface.release();
            }
            this.mSurface = null;
            this.mLayer = null;
            this.mHadSurface = true;
        }
    }

    private void init() {
        this.mLayerPaint = new Paint();
    }

    private native void nCreateNativeWindow(SurfaceTexture var1);

    private native void nDestroyNativeWindow();

    private static native boolean nLockCanvas(long var0, Canvas var2, Rect var3);

    private static native void nUnlockCanvasAndPost(long var0, Canvas var2);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateLayer() {
        Object[] objectArray = this.mLock;
        synchronized (objectArray) {
            this.mUpdateLayer = true;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateLayerAndInvalidate() {
        Object[] objectArray = this.mLock;
        synchronized (objectArray) {
            this.mUpdateLayer = true;
        }
        this.invalidate();
    }

    @Override
    public void buildLayer() {
    }

    @Override
    protected void destroyHardwareResources() {
        super.destroyHardwareResources();
        this.destroySurface();
        this.invalidateParentCaches();
        this.invalidate(true);
    }

    @Override
    public final void draw(Canvas canvas) {
        this.mPrivateFlags = 0x20 | 0xFF9FFFFF & this.mPrivateFlags;
        this.applyUpdate();
        this.applyTransformMatrix();
    }

    public Bitmap getBitmap() {
        return this.getBitmap(this.getWidth(), this.getHeight());
    }

    public Bitmap getBitmap(int n, int n2) {
        if (this.isAvailable() && n > 0 && n2 > 0) {
            return this.getBitmap(Bitmap.createBitmap(this.getResources().getDisplayMetrics(), n, n2, Bitmap.Config.ARGB_8888));
        }
        return null;
    }

    public Bitmap getBitmap(Bitmap bitmap) {
        if (bitmap != null && this.isAvailable()) {
            this.applyUpdate();
            this.applyTransformMatrix();
            if (this.mLayer == null && this.mUpdateSurface) {
                this.getHardwareLayer();
            }
            if (this.mLayer != null) {
                this.mLayer.copyInto(bitmap);
            }
        }
        return bitmap;
    }

    @Override
    HardwareLayer getHardwareLayer() {
        this.mPrivateFlags = 0x8020 | this.mPrivateFlags;
        this.mPrivateFlags = 0xFF9FFFFF & this.mPrivateFlags;
        if (this.mLayer == null) {
            if (this.mAttachInfo == null || this.mAttachInfo.mHardwareRenderer == null) {
                return null;
            }
            this.mLayer = this.mAttachInfo.mHardwareRenderer.createTextureLayer();
            if (!this.mUpdateSurface) {
                this.mSurface = new SurfaceTexture(false);
                this.mLayer.setSurfaceTexture(this.mSurface);
            }
            this.mSurface.setDefaultBufferSize(this.getWidth(), this.getHeight());
            this.nCreateNativeWindow(this.mSurface);
            this.mSurface.setOnFrameAvailableListener(this.mUpdateListener, this.mAttachInfo.mHandler);
            if (this.mListener != null && !this.mUpdateSurface) {
                this.mListener.onSurfaceTextureAvailable(this.mSurface, this.getWidth(), this.getHeight());
            }
            this.mLayer.setLayerPaint(this.mLayerPaint);
        }
        if (this.mUpdateSurface) {
            this.mUpdateSurface = false;
            this.updateLayer();
            this.mMatrixChanged = true;
            this.mLayer.setSurfaceTexture(this.mSurface);
            this.mSurface.setDefaultBufferSize(this.getWidth(), this.getHeight());
        }
        this.applyUpdate();
        this.applyTransformMatrix();
        return this.mLayer;
    }

    @Override
    public int getLayerType() {
        return 2;
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.mSurface;
    }

    public SurfaceTextureListener getSurfaceTextureListener() {
        return this.mListener;
    }

    public Matrix getTransform(Matrix matrix) {
        if (matrix == null) {
            matrix = new Matrix();
        }
        matrix.set(this.mMatrix);
        return matrix;
    }

    @Override
    boolean hasStaticLayer() {
        return true;
    }

    public boolean isAvailable() {
        return this.mSurface != null;
    }

    @Override
    public boolean isOpaque() {
        return this.mOpaque;
    }

    public Canvas lockCanvas() {
        return this.lockCanvas(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Canvas lockCanvas(Rect rect) {
        if (!this.isAvailable()) {
            return null;
        }
        if (this.mCanvas == null) {
            this.mCanvas = new Canvas();
        }
        Object[] objectArray = this.mNativeWindowLock;
        synchronized (objectArray) {
            if (!TextureView.nLockCanvas(this.mNativeWindow, this.mCanvas, rect)) {
                return null;
            }
        }
        this.mSaveCount = this.mCanvas.save();
        return this.mCanvas;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isHardwareAccelerated()) {
            Log.w(LOG_TAG, "A TextureView or a subclass can only be used with hardware acceleration enabled.");
        }
        if (this.mHadSurface) {
            this.invalidate(true);
            this.mHadSurface = false;
        }
    }

    @Override
    protected void onDetachedFromWindowInternal() {
        this.destroySurface();
        super.onDetachedFromWindowInternal();
    }

    @Override
    protected final void onDraw(Canvas canvas) {
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        if (this.mSurface != null) {
            this.mSurface.setDefaultBufferSize(this.getWidth(), this.getHeight());
            this.updateLayer();
            if (this.mListener != null) {
                this.mListener.onSurfaceTextureSizeChanged(this.mSurface, this.getWidth(), this.getHeight());
            }
        }
    }

    @Override
    protected void onVisibilityChanged(View view, int n) {
        block5: {
            block4: {
                super.onVisibilityChanged(view, n);
                if (this.mSurface == null) break block4;
                if (n != 0) break block5;
                if (this.mLayer != null) {
                    this.mSurface.setOnFrameAvailableListener(this.mUpdateListener, this.mAttachInfo.mHandler);
                }
                this.updateLayerAndInvalidate();
            }
            return;
        }
        this.mSurface.setOnFrameAvailableListener(null);
    }

    @Override
    public void setLayerPaint(Paint paint) {
        this.setLayerType(0, paint);
    }

    @Override
    public void setLayerType(int n, Paint paint) {
        if (paint != this.mLayerPaint) {
            if (paint == null) {
                paint = new Paint();
            }
            this.mLayerPaint = paint;
            this.invalidate();
        }
    }

    public void setOpaque(boolean bl) {
        if (bl != this.mOpaque) {
            this.mOpaque = bl;
            if (this.mLayer != null) {
                this.updateLayerAndInvalidate();
            }
        }
    }

    public void setSurfaceTexture(SurfaceTexture surfaceTexture) {
        if (surfaceTexture == null) {
            throw new NullPointerException("surfaceTexture must not be null");
        }
        if (this.mSurface != null) {
            this.mSurface.release();
        }
        this.mSurface = surfaceTexture;
        this.mUpdateSurface = true;
        this.invalidateParentIfNeeded();
    }

    public void setSurfaceTextureListener(SurfaceTextureListener surfaceTextureListener) {
        this.mListener = surfaceTextureListener;
    }

    public void setTransform(Matrix matrix) {
        this.mMatrix.set(matrix);
        this.mMatrixChanged = true;
        this.invalidateParentIfNeeded();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unlockCanvasAndPost(Canvas canvas) {
        if (this.mCanvas != null && canvas == this.mCanvas) {
            canvas.restoreToCount(this.mSaveCount);
            this.mSaveCount = 0;
            Object[] objectArray = this.mNativeWindowLock;
            synchronized (objectArray) {
                TextureView.nUnlockCanvasAndPost(this.mNativeWindow, this.mCanvas);
                return;
            }
        }
    }

    public static interface SurfaceTextureListener {
        public void onSurfaceTextureAvailable(SurfaceTexture var1, int var2, int var3);

        public boolean onSurfaceTextureDestroyed(SurfaceTexture var1);

        public void onSurfaceTextureSizeChanged(SurfaceTexture var1, int var2, int var3);

        public void onSurfaceTextureUpdated(SurfaceTexture var1);
    }
}

