/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class ViewDebug {
    private static final int CAPTURE_TIMEOUT = 4000;
    public static final boolean DEBUG_DRAG = false;
    private static final String REMOTE_COMMAND_CAPTURE = "CAPTURE";
    private static final String REMOTE_COMMAND_CAPTURE_LAYERS = "CAPTURE_LAYERS";
    private static final String REMOTE_COMMAND_DUMP = "DUMP";
    private static final String REMOTE_COMMAND_DUMP_THEME = "DUMP_THEME";
    private static final String REMOTE_COMMAND_INVALIDATE = "INVALIDATE";
    private static final String REMOTE_COMMAND_OUTPUT_DISPLAYLIST = "OUTPUT_DISPLAYLIST";
    private static final String REMOTE_COMMAND_REQUEST_LAYOUT = "REQUEST_LAYOUT";
    private static final String REMOTE_PROFILE = "PROFILE";
    @Deprecated
    public static final boolean TRACE_HIERARCHY;
    @Deprecated
    public static final boolean TRACE_RECYCLER;
    private static HashMap<Class<?>, Field[]> mCapturedViewFieldsForClasses;
    private static HashMap<Class<?>, Method[]> mCapturedViewMethodsForClasses;
    private static HashMap<AccessibleObject, ExportedProperty> sAnnotations;
    private static HashMap<Class<?>, Field[]> sFieldsForClasses;
    private static HashMap<Class<?>, Method[]> sMethodsForClasses;

    static {
        mCapturedViewMethodsForClasses = null;
        mCapturedViewFieldsForClasses = null;
    }

    private static Object callMethodOnAppropriateTheadBlocking(final Method method, Object object) throws IllegalAccessException, InvocationTargetException, TimeoutException {
        if (!(object instanceof View)) {
            return method.invoke(object, null);
        }
        final View view = (View)object;
        FutureTask<Object> futureTask = new FutureTask<Object>(new Callable<Object>(){

            @Override
            public Object call() throws IllegalAccessException, InvocationTargetException {
                return method.invoke(view, null);
            }
        });
        Handler handler = view.getHandler();
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper());
        }
        handler.post(futureTask);
        while (true) {
            try {
                Object object2 = futureTask.get(4000L, TimeUnit.MILLISECONDS);
                return object2;
            }
            catch (ExecutionException executionException) {
                Throwable throwable = executionException.getCause();
                if (throwable instanceof IllegalAccessException) {
                    throw (IllegalAccessException)throwable;
                }
                if (throwable instanceof InvocationTargetException) {
                    throw (InvocationTargetException)throwable;
                }
                throw new RuntimeException("Unexpected exception", throwable);
            }
            catch (CancellationException cancellationException) {
                throw new RuntimeException("Unexpected cancellation exception", cancellationException);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void capture(View view, OutputStream outputStream, View view2) throws IOException {
        BufferedOutputStream bufferedOutputStream;
        Bitmap bitmap;
        block6: {
            BufferedOutputStream bufferedOutputStream2;
            bitmap = ViewDebug.performViewCapture(view2, false);
            if (bitmap == null) {
                Log.w("View", "Failed to create capture bitmap!");
                bitmap = Bitmap.createBitmap(view.getResources().getDisplayMetrics(), 1, 1, Bitmap.Config.ARGB_8888);
            }
            bufferedOutputStream = null;
            try {
                bufferedOutputStream2 = new BufferedOutputStream(outputStream, 32768);
            }
            catch (Throwable throwable) {}
            try {
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, bufferedOutputStream2);
                bufferedOutputStream2.flush();
                if (bufferedOutputStream2 == null) break block6;
            }
            catch (Throwable throwable) {
                bufferedOutputStream = bufferedOutputStream2;
            }
            bufferedOutputStream2.close();
        }
        bitmap.recycle();
        return;
        {
            void var6_7;
            if (bufferedOutputStream != null) {
                bufferedOutputStream.close();
            }
            bitmap.recycle();
            throw var6_7;
        }
    }

    private static void capture(View view, OutputStream outputStream, String string2) throws IOException {
        ViewDebug.capture(view, outputStream, ViewDebug.findView(view, string2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void captureLayers(View view, DataOutputStream dataOutputStream) throws IOException {
        try {
            Rect rect = new Rect();
            try {
                view.mAttachInfo.mSession.getDisplayFrame(view.mAttachInfo.mWindow, rect);
            }
            catch (RemoteException remoteException) {}
            dataOutputStream.writeInt(rect.width());
            dataOutputStream.writeInt(rect.height());
            ViewDebug.captureViewLayer(view, dataOutputStream, true);
            dataOutputStream.write(2);
            return;
        }
        finally {
            dataOutputStream.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void captureViewLayer(View view, DataOutputStream dataOutputStream, boolean bl) throws IOException {
        boolean bl2 = view.getVisibility() == 0 && bl;
        if ((0x80 & view.mPrivateFlags) != 128) {
            int n = view.getId();
            String string2 = view.getClass().getSimpleName();
            if (n != -1) {
                string2 = ViewDebug.resolveId(view.getContext(), n).toString();
            }
            dataOutputStream.write(1);
            dataOutputStream.writeUTF(string2);
            int n2 = bl2 ? 1 : 0;
            dataOutputStream.writeByte(n2);
            int[] nArray = new int[2];
            view.getLocationInWindow(nArray);
            dataOutputStream.writeInt(nArray[0]);
            dataOutputStream.writeInt(nArray[1]);
            dataOutputStream.flush();
            Bitmap bitmap = ViewDebug.performViewCapture(view, true);
            if (bitmap != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2 * (bitmap.getWidth() * bitmap.getHeight()));
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, byteArrayOutputStream);
                dataOutputStream.writeInt(byteArrayOutputStream.size());
                byteArrayOutputStream.writeTo(dataOutputStream);
            }
            dataOutputStream.flush();
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = viewGroup.getChildCount();
            for (int i = 0; i < n; ++i) {
                ViewDebug.captureViewLayer(viewGroup.getChildAt(i), dataOutputStream, bl2);
            }
        }
        if (view.mOverlay != null) {
            ViewDebug.captureViewLayer(view.getOverlay().mOverlayViewGroup, dataOutputStream, bl2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String capturedViewExportFields(Object object, Class<?> clazz, String string2) {
        if (object == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Field[] fieldArray = ViewDebug.capturedViewGetPropertyFields(clazz);
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                Object object2 = field.get(object);
                stringBuilder.append(string2);
                stringBuilder.append(field.getName());
                stringBuilder.append("=");
                if (object2 != null) {
                    stringBuilder.append(object2.toString().replace("\n", "\\n"));
                } else {
                    stringBuilder.append("null");
                }
                stringBuilder.append(' ');
            }
            catch (IllegalAccessException illegalAccessException) {}
            ++n2;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String capturedViewExportMethods(Object object, Class<?> clazz, String string2) {
        if (object == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Method[] methodArray = ViewDebug.capturedViewGetPropertyMethods(clazz);
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            try {
                Object object2 = method.invoke(object, null);
                Class<?> clazz2 = method.getReturnType();
                if (method.getAnnotation(CapturedViewProperty.class).retrieveReturn()) {
                    stringBuilder.append(ViewDebug.capturedViewExportMethods(object2, clazz2, method.getName() + "#"));
                } else {
                    stringBuilder.append(string2);
                    stringBuilder.append(method.getName());
                    stringBuilder.append("()=");
                    if (object2 != null) {
                        stringBuilder.append(object2.toString().replace("\n", "\\n"));
                    } else {
                        stringBuilder.append("null");
                    }
                    stringBuilder.append("; ");
                }
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            ++n2;
        }
        return stringBuilder.toString();
    }

    private static Field[] capturedViewGetPropertyFields(Class<?> clazz) {
        HashMap<Class<?>, Field[]> hashMap;
        Field[] fieldArray;
        if (mCapturedViewFieldsForClasses == null) {
            mCapturedViewFieldsForClasses = new HashMap();
        }
        if ((fieldArray = (hashMap = mCapturedViewFieldsForClasses).get(clazz)) != null) {
            return fieldArray;
        }
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Field field : clazz.getFields()) {
            if (!field.isAnnotationPresent(CapturedViewProperty.class)) continue;
            field.setAccessible(true);
            arrayList.add(field);
        }
        Field[] fieldArray2 = arrayList.toArray(new Field[arrayList.size()]);
        hashMap.put(clazz, fieldArray2);
        return fieldArray2;
    }

    private static Method[] capturedViewGetPropertyMethods(Class<?> clazz) {
        HashMap<Class<?>, Method[]> hashMap;
        Method[] methodArray;
        if (mCapturedViewMethodsForClasses == null) {
            mCapturedViewMethodsForClasses = new HashMap();
        }
        if ((methodArray = (hashMap = mCapturedViewMethodsForClasses).get(clazz)) != null) {
            return methodArray;
        }
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            if (method.getParameterTypes().length != 0 || !method.isAnnotationPresent(CapturedViewProperty.class) || method.getReturnType() == Void.class) continue;
            method.setAccessible(true);
            arrayList.add(method);
        }
        Method[] methodArray2 = arrayList.toArray(new Method[arrayList.size()]);
        hashMap.put(clazz, methodArray2);
        return methodArray2;
    }

    /*
     * Enabled aggressive block sorting
     */
    static void dispatchCommand(View view, String string2, String string3, OutputStream outputStream) throws IOException {
        View view2 = view.getRootView();
        if (REMOTE_COMMAND_DUMP.equalsIgnoreCase(string2)) {
            ViewDebug.dump(view2, false, true, outputStream);
            return;
        } else {
            if (REMOTE_COMMAND_DUMP_THEME.equalsIgnoreCase(string2)) {
                ViewDebug.dumpTheme(view2, outputStream);
                return;
            }
            if (REMOTE_COMMAND_CAPTURE_LAYERS.equalsIgnoreCase(string2)) {
                ViewDebug.captureLayers(view2, new DataOutputStream(outputStream));
                return;
            }
            String[] stringArray = string3.split(" ");
            if (REMOTE_COMMAND_CAPTURE.equalsIgnoreCase(string2)) {
                ViewDebug.capture(view2, outputStream, stringArray[0]);
                return;
            }
            if (REMOTE_COMMAND_OUTPUT_DISPLAYLIST.equalsIgnoreCase(string2)) {
                ViewDebug.outputDisplayList(view2, stringArray[0]);
                return;
            }
            if (REMOTE_COMMAND_INVALIDATE.equalsIgnoreCase(string2)) {
                ViewDebug.invalidate(view2, stringArray[0]);
                return;
            }
            if (REMOTE_COMMAND_REQUEST_LAYOUT.equalsIgnoreCase(string2)) {
                ViewDebug.requestLayout(view2, stringArray[0]);
                return;
            }
            if (!REMOTE_PROFILE.equalsIgnoreCase(string2)) return;
            ViewDebug.profile(view2, outputStream, stringArray[0]);
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void dump(View var0, boolean var1_1, boolean var2_2, OutputStream var3_3) throws IOException {
        block12: {
            var4_4 = new BufferedWriter(new OutputStreamWriter(var3_3, "utf-8"), 32768);
            try {
                var8_5 = var0.getRootView();
                if (var8_5 instanceof ViewGroup) {
                    var9_6 = (ViewGroup)var8_5;
                    ViewDebug.dumpViewHierarchy(var9_6.getContext(), var9_6, var4_4, 0, var1_1, var2_2);
                }
                var4_4.write("DONE.");
                var4_4.newLine();
                if (var4_4 == null) break block12;
            }
            catch (Exception var5_9) {
                ** continue;
            }
            var4_4.close();
        }
        return;
        catch (Exception var5_7) {
            var4_4 = null;
lbl17:
            // 2 sources

            while (true) {
                Log.w("View", "Problem dumping the view:", (Throwable)var5_8);
                if (var4_4 == null) ** continue;
                var4_4.close();
                return;
            }
        }
        catch (Throwable var6_10) {
            var4_4 = null;
lbl26:
            // 2 sources

            while (true) {
                if (var4_4 != null) {
                    var4_4.close();
                }
                throw var6_11;
            }
        }
        {
            catch (Throwable var6_12) {
                ** continue;
            }
        }
    }

    public static void dumpCapturedView(String string2, Object object) {
        Class<?> clazz = object.getClass();
        StringBuilder stringBuilder = new StringBuilder(clazz.getName() + ": ");
        stringBuilder.append(ViewDebug.capturedViewExportFields(object, clazz, ""));
        stringBuilder.append(ViewDebug.capturedViewExportMethods(object, clazz, ""));
        Log.d(string2, stringBuilder.toString());
    }

    /*
     * Unable to fully structure code
     */
    public static void dumpTheme(View var0, OutputStream var1_1) throws IOException {
        block16: {
            var2_2 = null;
            var3_3 = new BufferedWriter(new OutputStreamWriter(var1_1, "utf-8"), 32768);
            try {
                var7_4 = ViewDebug.getStyleAttributesDump(var0.getContext().getResources(), var0.getContext().getTheme());
                if (var7_4 == null) ** GOTO lbl15
                var8_5 = 0;
            }
            catch (Throwable var5_11) {
                var2_2 = var3_3;
                ** continue;
            }
            catch (Exception var4_8) {
                var2_2 = var3_3;
                ** continue;
            }
lbl8:
            // 2 sources

            while (true) {
                if (var8_5 < var7_4.length) {
                    if (var7_4[var8_5] != null) {
                        var3_3.write(var7_4[var8_5] + "\n");
                        var3_3.write(var7_4[var8_5 + 1] + "\n");
                    }
                    break block16;
                }
lbl15:
                // 3 sources

                var3_3.write("DONE.");
                var3_3.newLine();
                ** if (var3_3 == null) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    var3_3.close();
                    return;
                }
lbl-1000:
                // 1 sources

                {
                }
                break;
            }
            catch (Exception var4_6) lbl-1000:
            // 2 sources

            {
                while (true) {
                    try {
                        Log.w("View", "Problem dumping View Theme:", (Throwable)var4_7);
                        if (var2_2 == null) ** continue;
                    }
                    catch (Throwable var5_9) lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            if (var2_2 != null) {
                                var2_2.close();
                            }
                            throw var5_10;
                        }
                    }
                    var2_2.close();
                    return;
                }
            }
            return;
        }
        var8_5 += 2;
        ** while (true)
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean dumpView(Context context, View view, BufferedWriter bufferedWriter, int n, boolean bl) {
        for (int i = 0; i < n; ++i) {
            try {
                bufferedWriter.write(32);
                continue;
            }
            catch (IOException iOException) {
                Log.w("View", "Error while dumping hierarchy tree");
                return false;
            }
        }
        {
            String string2 = view.getClass().getName();
            if (string2.equals("android.view.ViewOverlay$OverlayViewGroup")) {
                string2 = "ViewOverlay";
            }
            bufferedWriter.write(string2);
            bufferedWriter.write(64);
            bufferedWriter.write(Integer.toHexString(view.hashCode()));
            bufferedWriter.write(32);
            if (bl) {
                ViewDebug.dumpViewProperties(context, view, bufferedWriter);
            }
            bufferedWriter.newLine();
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void dumpViewHierarchy(Context context, ViewGroup viewGroup, BufferedWriter bufferedWriter, int n, boolean bl, boolean bl2) {
        block7: {
            block6: {
                if (!ViewDebug.dumpView(context, viewGroup, bufferedWriter, n, bl2) || bl) break block6;
                int n2 = viewGroup.getChildCount();
                for (int i = 0; i < n2; ++i) {
                    View view = viewGroup.getChildAt(i);
                    if (view instanceof ViewGroup) {
                        ViewDebug.dumpViewHierarchy(context, (ViewGroup)view, bufferedWriter, n + 1, bl, bl2);
                    } else {
                        ViewDebug.dumpView(context, view, bufferedWriter, n + 1, bl2);
                    }
                    if (view.mOverlay == null) continue;
                    ViewDebug.dumpViewHierarchy(context, view.getOverlay().mOverlayViewGroup, bufferedWriter, n + 2, bl, bl2);
                }
                if (viewGroup instanceof HierarchyHandler) break block7;
            }
            return;
        }
        ((HierarchyHandler)((Object)viewGroup)).dumpViewHierarchyWithProperties(bufferedWriter, n + 1);
    }

    private static void dumpViewProperties(Context context, Object object, BufferedWriter bufferedWriter) throws IOException {
        ViewDebug.dumpViewProperties(context, object, bufferedWriter, "");
    }

    private static void dumpViewProperties(Context context, Object object, BufferedWriter bufferedWriter, String string2) throws IOException {
        if (object == null) {
            bufferedWriter.write(string2 + "=4,null ");
            return;
        }
        Class<?> clazz = object.getClass();
        do {
            ViewDebug.exportFields(context, object, bufferedWriter, clazz, string2);
            ViewDebug.exportMethods(context, object, bufferedWriter, clazz, string2);
        } while ((clazz = clazz.getSuperclass()) != Object.class);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void exportFields(Context var0, Object var1_1, BufferedWriter var2_2, Class<?> var3_3, String var4_4) throws IOException {
        var5_5 = ViewDebug.getExportedPropertyFields(var3_3);
        var6_6 = var5_5.length;
        var7_7 = 0;
        while (true) {
            block13: {
                block15: {
                    block16: {
                        block23: {
                            block11: {
                                block12: {
                                    if (var7_7 >= var6_6) break block16;
                                    var8_8 = var5_5[var7_7];
                                    try {
                                        block22: {
                                            block20: {
                                                block14: {
                                                    block21: {
                                                        block19: {
                                                            block17: {
                                                                block18: {
                                                                    var10_10 = var8_8.getType();
                                                                    var11_11 = ViewDebug.sAnnotations.get(var8_8);
                                                                    var12_12 = var11_11.category().length() != 0 ? var11_11.category() + ":" : "";
                                                                    if (var10_10 != Integer.TYPE && var10_10 != Byte.TYPE) break block17;
                                                                    if (!var11_11.resolveId() || var0 == null) break block18;
                                                                    var13_13 = ViewDebug.resolveId(var0, var8_8.getInt(var1_1));
                                                                    break block19;
                                                                }
                                                                var14_14 = var11_11.flagMapping();
                                                                if (var14_14.length > 0) {
                                                                    ViewDebug.exportUnrolledFlags(var2_2, var14_14, var8_8.getInt(var1_1), var12_12 + var4_4 + var8_8.getName() + '_');
                                                                }
                                                                var15_15 = var11_11.mapping();
                                                                var16_16 = var15_15.length;
                                                                var13_13 = null;
                                                                if (var16_16 <= 0) break block20;
                                                                break block21;
                                                            }
                                                            if (var10_10 != int[].class) break block11;
                                                            break block12;
                                                        }
lbl28:
                                                        // 7 sources

                                                        while (true) {
                                                            if (var13_13 == null) {
                                                                var13_13 = var8_8.get(var1_1);
                                                            }
                                                            ViewDebug.writeEntry(var2_2, var12_12 + var4_4, var8_8.getName(), "", var13_13);
                                                            break block13;
                                                            break;
                                                        }
                                                    }
                                                    var17_17 = var8_8.getInt(var1_1);
                                                    var18_18 = var15_15.length;
                                                    var19_19 = 0;
                                                    do {
                                                        var20_20 = ++var19_19;
                                                        var13_13 = null;
                                                        if (var20_20 >= var18_18) break block14;
                                                    } while ((var21_21 = var15_15[var19_19]).from() != var17_17);
                                                    var13_13 = var21_21.to();
                                                }
                                                if (var13_13 == null) {
                                                    var13_13 = var17_17;
                                                }
                                            }
                                            if (!var11_11.formatToHexString()) ** GOTO lbl28
                                            var13_13 = var8_8.get(var1_1);
                                            if (var10_10 != Integer.TYPE) break block22;
                                            var13_13 = ViewDebug.formatIntToHexString((Integer)var13_13);
                                            ** GOTO lbl28
                                        }
                                        if (var10_10 != Byte.TYPE) ** GOTO lbl28
                                        var13_13 = "0x" + Byte.toHexString((byte)((Byte)var13_13), (boolean)true);
                                        ** GOTO lbl28
                                    }
                                    catch (IllegalAccessException var9_9) {}
                                }
                                ViewDebug.exportUnrolledArray(var0, var2_2, var11_11, (int[])var8_8.get(var1_1), var12_12 + var4_4 + var8_8.getName() + '_', "");
                            }
                            if (var10_10 != String[].class) break block23;
                            var22_22 = (String[])var8_8.get(var1_1);
                            if (!var11_11.hasAdjacentMapping() || var22_22 == null) break block13;
                            break block15;
                            break block13;
                        }
                        var28_28 = var10_10.isPrimitive();
                        var13_13 = null;
                        if (var28_28) ** GOTO lbl28
                        var29_29 = var11_11.deepExport();
                        var13_13 = null;
                        if (var29_29) ** break;
                        ** continue;
                        ViewDebug.dumpViewProperties(var0, var8_8.get(var1_1), var2_2, var4_4 + var11_11.prefix());
                        break block13;
                    }
                    return;
                }
                for (var23_23 = 0; var23_23 < (var24_24 = var22_22.length); var23_23 += 2) {
                    if (var22_22[var23_23] == null) continue;
                    var25_25 = var12_12 + var4_4;
                    var26_26 = var22_22[var23_23];
                    var27_27 = var22_22[var23_23 + 1] == null ? "null" : var22_22[var23_23 + 1];
                    ViewDebug.writeEntry(var2_2, var25_25, var26_26, "", var27_27);
                }
            }
            ++var7_7;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void exportMethods(Context var0, Object var1_1, BufferedWriter var2_2, Class<?> var3_3, String var4_4) throws IOException {
        var5_5 = ViewDebug.getExportedPropertyMethods(var3_3);
        var6_6 = var5_5.length;
        var7_7 = 0;
        while (true) {
            block14: {
                block15: {
                    block23: {
                        block13: {
                            block20: {
                                block19: {
                                    block18: {
                                        block16: {
                                            block17: {
                                                if (var7_7 >= var6_6) {
                                                    return;
                                                }
                                                var8_8 = var5_5[var7_7];
                                                var12_12 = ViewDebug.callMethodOnAppropriateTheadBlocking(var8_8, var1_1);
                                                var13_13 = var8_8.getReturnType();
                                                var14_14 = ViewDebug.sAnnotations.get(var8_8);
                                                var15_15 = var14_14.category().length() != 0 ? var14_14.category() + ":" : "";
                                                if (var13_13 != Integer.TYPE) break block16;
                                                if (!var14_14.resolveId() || var0 == null) break block17;
                                                var12_12 = ViewDebug.resolveId(var0, (Integer)var12_12);
                                                break block18;
                                            }
                                            var22_22 = var14_14.flagMapping();
                                            if (var22_22.length > 0) {
                                                ViewDebug.exportUnrolledFlags(var2_2, var22_22, (Integer)var12_12, var15_15 + var4_4 + var8_8.getName() + '_');
                                            }
                                            if ((var23_23 = var14_14.mapping()).length <= 0) break block18;
                                            break block19;
                                        }
                                        if (var13_13 != int[].class) break block13;
                                        break block20;
                                    }
lbl27:
                                    // 3 sources

                                    while (true) {
                                        ViewDebug.writeEntry(var2_2, var15_15 + var4_4, var8_8.getName(), "()", var12_12);
                                        break block14;
                                        break;
                                    }
                                }
                                var24_24 = (Integer)var12_12;
                                var25_25 = var23_23.length;
                                var26_26 = 0;
                                while (true) {
                                    block22: {
                                        block21: {
                                            var27_27 = false;
                                            if (var26_26 >= var25_25) break block21;
                                            var28_28 = var23_23[var26_26];
                                            if (var28_28.from() != var24_24) break block22;
                                            var12_12 = var28_28.to();
                                            var27_27 = true;
                                        }
                                        if (!var27_27) {
                                            var12_12 = var24_24;
                                        }
                                        ** GOTO lbl27
                                    }
                                    ++var26_26;
                                }
                            }
                            ViewDebug.exportUnrolledArray(var0, var2_2, var14_14, (int[])var12_12, var15_15 + var4_4 + var8_8.getName() + '_', "()");
                        }
                        if (var13_13 != String[].class) break block23;
                        try {
                            var16_16 = (String[])var12_12;
                            if (!var14_14.hasAdjacentMapping() || var16_16 == null) break block14;
                            break block15;
                        }
                        catch (InvocationTargetException var10_10) {
                        }
                        catch (TimeoutException var9_9) {
                            // empty catch block
                        }
                        catch (IllegalAccessException var11_11) {}
                        break block14;
                    }
                    if (!var13_13.isPrimitive() && var14_14.deepExport()) ** break;
                    ** continue;
                    var21_21 = var4_4 + var14_14.prefix();
                    ViewDebug.dumpViewProperties(var0, var12_12, var2_2, var21_21);
                    break block14;
                }
                for (var17_17 = 0; var17_17 < var16_16.length; var17_17 += 2) {
                    if (var16_16[var17_17] == null) continue;
                    var18_18 = var15_15 + var4_4;
                    var19_19 = var16_16[var17_17];
                    var20_20 = var16_16[var17_17 + 1] == null ? "null" : var16_16[var17_17 + 1];
                    ViewDebug.writeEntry(var2_2, var18_18, var19_19, "()", var20_20);
                }
            }
            ++var7_7;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void exportUnrolledArray(Context var0, BufferedWriter var1_1, ExportedProperty var2_2, int[] var3_3, String var4_4, String var5_5) throws IOException {
        block14: {
            block13: {
                block12: {
                    block11: {
                        block15: {
                            block17: {
                                block16: {
                                    var6_6 = var2_2.indexMapping();
                                    if (var6_6.length <= 0) break block16;
                                    var7_7 = true;
lbl4:
                                    // 2 sources

                                    while ((var8_8 = var2_2.mapping()).length > 0) {
                                        var9_9 = true;
lbl6:
                                        // 2 sources

                                        while (var2_2.resolveId() && var0 != null) {
                                            var10_10 = true;
lbl8:
                                            // 2 sources

                                            while (true) {
                                                var11_11 = var3_3.length;
                                                block3: for (var12_12 = 0; var12_12 < var11_11; ++var12_12) {
                                                    var13_13 = var3_3[var12_12];
                                                    var14_14 = String.valueOf(var12_12);
                                                    if (!var7_7) ** GOTO lbl21
                                                    var19_19 = var6_6.length;
                                                    var20_20 = 0;
lbl16:
                                                    // 2 sources

                                                    while (true) {
                                                        if (var20_20 < var19_19) {
                                                            var21_21 = var6_6[var20_20];
                                                            if (var21_21.from() != var12_12) break block11;
                                                            var14_14 = var21_21.to();
                                                        }
lbl21:
                                                        // 4 sources

                                                        var15_15 = null;
                                                        if (!var9_9) ** GOTO lbl31
                                                        var16_16 = var8_8.length;
                                                        var17_17 = 0;
lbl25:
                                                        // 2 sources

                                                        while (true) {
                                                            var15_15 = null;
                                                            if (var17_17 < var16_16) {
                                                                var18_18 = var8_8[var17_17];
                                                                if (var18_18.from() != var13_13) break block12;
                                                                var15_15 = var18_18.to();
                                                            }
lbl31:
                                                            // 4 sources

                                                            if (var10_10) {
                                                                if (var15_15 == null) {
                                                                    var15_15 = (String)ViewDebug.resolveId(var0, var13_13);
                                                                }
lbl34:
                                                                // 4 sources

                                                                while (true) {
                                                                    ViewDebug.writeEntry(var1_1, var4_4, var14_14, var5_5, var15_15);
                                                                    continue block3;
                                                                    break;
                                                                }
                                                            }
                                                            break block13;
                                                            break;
                                                        }
                                                        break;
                                                    }
                                                }
                                                break block14;
                                                break;
                                            }
                                        }
                                        break block15;
                                    }
                                    break block17;
                                }
                                var7_7 = false;
                                ** GOTO lbl4
                            }
                            var9_9 = false;
                            ** GOTO lbl6
                        }
                        var10_10 = false;
                        ** while (true)
                    }
                    ++var20_20;
                    ** while (true)
                }
                ++var17_17;
                ** while (true)
            }
            var15_15 = String.valueOf(var13_13);
            ** while (true)
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void exportUnrolledFlags(BufferedWriter bufferedWriter, FlagToString[] flagToStringArray, int n, String string2) throws IOException {
        int n2 = flagToStringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FlagToString flagToString = flagToStringArray[n3];
            boolean bl = flagToString.outputIf();
            int n4 = n & flagToString.mask();
            boolean bl2 = n4 == flagToString.equals();
            if (bl2 && bl || !bl2 && !bl) {
                ViewDebug.writeEntry(bufferedWriter, string2, flagToString.name(), "", ViewDebug.formatIntToHexString(n4));
            }
            ++n3;
        }
        return;
    }

    public static View findView(View view, String string2) {
        if (string2.indexOf(64) != -1) {
            String[] stringArray = string2.split("@");
            String string3 = stringArray[0];
            int n = (int)Long.parseLong(stringArray[1], 16);
            View view2 = view.getRootView();
            boolean bl = view2 instanceof ViewGroup;
            View view3 = null;
            if (bl) {
                view3 = ViewDebug.findView((ViewGroup)view2, string3, n);
            }
            return view3;
        }
        int n = view.getResources().getIdentifier(string2, null, null);
        return view.getRootView().findViewById(n);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private static View findView(ViewGroup viewGroup, String string2, int n) {
        void var6_4;
        if (ViewDebug.isRequestedView(viewGroup, string2, n)) {
            ViewGroup viewGroup2 = viewGroup;
            return var6_4;
        }
        int n2 = viewGroup.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            View view = viewGroup.getChildAt(n3);
            if (view instanceof ViewGroup) {
                View view2 = ViewDebug.findView((ViewGroup)view, string2, n);
                if (view2 != null) return var6_4;
            } else if (ViewDebug.isRequestedView(view, string2, n)) {
                return view;
            }
            if (view.mOverlay != null) {
                View view3 = ViewDebug.findView(view.mOverlay.mOverlayViewGroup, string2, n);
                if (view3 != null) return var6_4;
            }
            if (view instanceof HierarchyHandler) {
                View view4 = ((HierarchyHandler)((Object)view)).findHierarchyView(string2, n);
                if (view4 != null) return var6_4;
            }
            ++n3;
        }
        return null;
    }

    private static String formatIntToHexString(int n) {
        return "0x" + Integer.toHexString(n).toUpperCase();
    }

    private static Field[] getExportedPropertyFields(Class<?> clazz) {
        HashMap<Class<?>, Field[]> hashMap;
        Field[] fieldArray;
        if (sFieldsForClasses == null) {
            sFieldsForClasses = new HashMap();
        }
        if (sAnnotations == null) {
            sAnnotations = new HashMap(512);
        }
        if ((fieldArray = (hashMap = sFieldsForClasses).get(clazz)) != null) {
            return fieldArray;
        }
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ExportedProperty.class)) continue;
            field.setAccessible(true);
            arrayList.add(field);
            sAnnotations.put(field, field.getAnnotation(ExportedProperty.class));
        }
        Field[] fieldArray2 = arrayList.toArray(new Field[arrayList.size()]);
        hashMap.put(clazz, fieldArray2);
        return fieldArray2;
    }

    private static Method[] getExportedPropertyMethods(Class<?> clazz) {
        HashMap<Class<?>, Method[]> hashMap;
        Method[] methodArray;
        if (sMethodsForClasses == null) {
            sMethodsForClasses = new HashMap(100);
        }
        if (sAnnotations == null) {
            sAnnotations = new HashMap(512);
        }
        if ((methodArray = (hashMap = sMethodsForClasses).get(clazz)) != null) {
            return methodArray;
        }
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Method method : clazz.getDeclaredMethods()) {
            if (method.getParameterTypes().length != 0 || !method.isAnnotationPresent(ExportedProperty.class) || method.getReturnType() == Void.class) continue;
            method.setAccessible(true);
            arrayList.add(method);
            sAnnotations.put(method, method.getAnnotation(ExportedProperty.class));
        }
        Method[] methodArray2 = arrayList.toArray(new Method[arrayList.size()]);
        hashMap.put(clazz, methodArray2);
        return methodArray2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String[] getStyleAttributesDump(Resources resources, Resources.Theme theme) {
        TypedValue typedValue = new TypedValue();
        int n = 0;
        int[] nArray = theme.getAllAttributes();
        String[] stringArray = new String[2 * nArray.length];
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            try {
                stringArray[n] = resources.getResourceName(n4);
                int n5 = n + 1;
                String string2 = theme.resolveAttribute(n4, typedValue, true) ? typedValue.coerceToString().toString() : "null";
                stringArray[n5] = string2;
                n += 2;
                if (typedValue.type == 1) {
                    stringArray[n - 1] = resources.getResourceName(typedValue.resourceId);
                }
            }
            catch (Resources.NotFoundException notFoundException) {}
            ++n3;
        }
        return stringArray;
    }

    public static long getViewInstanceCount() {
        return Debug.countInstancesOfClass(View.class);
    }

    public static long getViewRootImplCount() {
        return Debug.countInstancesOfClass(ViewRootImpl.class);
    }

    private static void invalidate(View view, String string2) {
        View view2 = ViewDebug.findView(view, string2);
        if (view2 != null) {
            view2.postInvalidate();
        }
    }

    public static Object invokeViewMethod(final View view, final Method method, final Object[] objectArray) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final AtomicReference atomicReference = new AtomicReference();
        final AtomicReference atomicReference2 = new AtomicReference();
        view.post(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    atomicReference.set(method.invoke(view, objectArray));
                }
                catch (InvocationTargetException invocationTargetException) {
                    atomicReference2.set(invocationTargetException.getCause());
                }
                catch (Exception exception) {
                    atomicReference2.set(exception);
                }
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
            if (atomicReference2.get() != null) {
                throw new RuntimeException((Throwable)atomicReference2.get());
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        return atomicReference.get();
    }

    private static boolean isRequestedView(View view, String string2, int n) {
        if (view.hashCode() == n) {
            String string3 = view.getClass().getName();
            if (string2.equals("ViewOverlay")) {
                return string3.equals("android.view.ViewOverlay$OverlayViewGroup");
            }
            return string2.equals(string3);
        }
        return false;
    }

    public static void outputDisplayList(View view, View view2) {
        view.getViewRootImpl().outputDisplayList(view2);
    }

    private static void outputDisplayList(View view, String string2) throws IOException {
        View view2 = ViewDebug.findView(view, string2);
        view2.getViewRootImpl().outputDisplayList(view2);
    }

    private static Bitmap performViewCapture(final View view, final boolean bl) {
        if (view != null) {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            final Bitmap[] bitmapArray = new Bitmap[1];
            view.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        bitmapArray[0] = view.createSnapshot(Bitmap.Config.ARGB_8888, 0, bl);
                        return;
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        Log.w("View", "Out of memory for bitmap");
                        return;
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }
            });
            try {
                countDownLatch.await(4000L, TimeUnit.MILLISECONDS);
                Bitmap bitmap = bitmapArray[0];
                return bitmap;
            }
            catch (InterruptedException interruptedException) {
                Log.w("View", "Could not complete the capture of the view " + view);
                Thread.currentThread().interrupt();
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void profile(View var0, OutputStream var1_1, String var2_2) throws IOException {
        var3_3 = ViewDebug.findView(var0, var2_2);
        var4_4 = null;
        var5_5 = new BufferedWriter(new OutputStreamWriter(var1_1), 32768);
        if (var3_3 == null) ** GOTO lbl9
        try {
            block11: {
                ViewDebug.profileViewAndChildren(var3_3, var5_5);
                break block11;
lbl9:
                // 1 sources

                var5_5.write("-1 -1 -1");
                var5_5.newLine();
            }
            var5_5.write("DONE.");
            var5_5.newLine();
            if (var5_5 == null) return;
        }
        catch (Exception var7_6) {
            block12: {
                var4_4 = var5_5;
                break block12;
                catch (Throwable var6_11) {
                    var4_4 = var5_5;
                    ** GOTO lbl-1000
                }
                return;
            }
lbl26:
            // 2 sources

            while (true) {
                try {
                    Log.w("View", "Problem profiling the view:", (Throwable)var7_7);
                    if (var4_4 == null) ** continue;
                }
                catch (Throwable var6_9) lbl-1000:
                // 2 sources

                {
                    if (var4_4 == null) throw var6_10;
                    var4_4.close();
                    throw var6_10;
                }
                var4_4.close();
                return;
            }
        }
        var5_5.close();
        return;
        catch (Exception var7_8) {
            var4_4 = null;
            ** continue;
        }
    }

    public static void profileViewAndChildren(View view, BufferedWriter bufferedWriter) throws IOException {
        ViewDebug.profileViewAndChildren(view, bufferedWriter, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void profileViewAndChildren(final View view, BufferedWriter bufferedWriter, boolean bl) throws IOException {
        long l = 0L;
        long l2 = bl || (0x800 & view.mPrivateFlags) != 0 ? ViewDebug.profileViewOperation(view, new ViewOperation<Void>(){

            private void forceLayout(View view2) {
                view2.forceLayout();
                if (view2 instanceof ViewGroup) {
                    ViewGroup viewGroup = (ViewGroup)view2;
                    int n = viewGroup.getChildCount();
                    for (int i = 0; i < n; ++i) {
                        this.forceLayout(viewGroup.getChildAt(i));
                    }
                }
            }

            public void post(Void ... voidArray) {
            }

            public Void[] pre() {
                this.forceLayout(view);
                return null;
            }

            public void run(Void ... voidArray) {
                view.measure(view.mOldWidthMeasureSpec, view.mOldHeightMeasureSpec);
            }
        }) : l;
        long l3 = bl || (0x2000 & view.mPrivateFlags) != 0 ? ViewDebug.profileViewOperation(view, new ViewOperation<Void>(){

            public void post(Void ... voidArray) {
            }

            public Void[] pre() {
                return null;
            }

            public void run(Void ... voidArray) {
                view.layout(view.mLeft, view.mTop, view.mRight, view.mBottom);
            }
        }) : l;
        if (bl || !view.willNotDraw() || (0x20 & view.mPrivateFlags) != 0) {
            l = ViewDebug.profileViewOperation(view, new ViewOperation<Object>(){

                @Override
                public void post(Object ... objectArray) {
                    if (objectArray[1] != null) {
                        ((Canvas)objectArray[1]).setBitmap(null);
                    }
                    if (objectArray[0] != null) {
                        ((Bitmap)objectArray[0]).recycle();
                    }
                }

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public Object[] pre() {
                    DisplayMetrics displayMetrics = view != null && view.getResources() != null ? view.getResources().getDisplayMetrics() : null;
                    Bitmap bitmap = displayMetrics != null ? Bitmap.createBitmap(displayMetrics, displayMetrics.widthPixels, displayMetrics.heightPixels, Bitmap.Config.RGB_565) : null;
                    Canvas canvas = null;
                    if (bitmap != null) {
                        canvas = new Canvas(bitmap);
                    }
                    return new Object[]{bitmap, canvas};
                }

                @Override
                public void run(Object ... objectArray) {
                    if (objectArray[1] != null) {
                        view.draw((Canvas)objectArray[1]);
                    }
                }
            });
        }
        bufferedWriter.write(String.valueOf(l2));
        bufferedWriter.write(32);
        bufferedWriter.write(String.valueOf(l3));
        bufferedWriter.write(32);
        bufferedWriter.write(String.valueOf(l));
        bufferedWriter.newLine();
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = viewGroup.getChildCount();
            for (int i = 0; i < n; ++i) {
                ViewDebug.profileViewAndChildren(viewGroup.getChildAt(i), bufferedWriter, false);
            }
        }
    }

    private static <T> long profileViewOperation(View view, final ViewOperation<T> viewOperation) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final long[] lArray = new long[1];
        view.post(new Runnable(){

            @Override
            public void run() {
                try {
                    T[] TArray = viewOperation.pre();
                    long l = Debug.threadCpuTimeNanos();
                    viewOperation.run(TArray);
                    lArray[0] = Debug.threadCpuTimeNanos() - l;
                    viewOperation.post(TArray);
                    return;
                }
                finally {
                    countDownLatch.countDown();
                }
            }
        });
        try {
            if (!countDownLatch.await(4000L, TimeUnit.MILLISECONDS)) {
                Log.w("View", "Could not complete the profiling of the view " + view);
                return -1L;
            }
        }
        catch (InterruptedException interruptedException) {
            Log.w("View", "Could not complete the profiling of the view " + view);
            Thread.currentThread().interrupt();
            return -1L;
        }
        return lArray[0];
    }

    private static void requestLayout(View view, String string2) {
        final View view2 = ViewDebug.findView(view, string2);
        if (view2 != null) {
            view.post(new Runnable(){

                @Override
                public void run() {
                    view2.requestLayout();
                }
            });
        }
    }

    static Object resolveId(Context context, int n) {
        Resources resources = context.getResources();
        if (n >= 0) {
            try {
                String string2 = resources.getResourceTypeName(n) + '/' + resources.getResourceEntryName(n);
                return string2;
            }
            catch (Resources.NotFoundException notFoundException) {
                return "id/" + ViewDebug.formatIntToHexString(n);
            }
        }
        return "NO_ID";
    }

    public static void setLayoutParameter(final View view, String string2, int n) throws NoSuchFieldException, IllegalAccessException {
        final ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        Field field = layoutParams.getClass().getField(string2);
        if (field.getType() != Integer.TYPE) {
            throw new RuntimeException("Only integer layout parameters can be set. Field " + string2 + " is of type " + field.getType().getSimpleName());
        }
        field.set(layoutParams, n);
        view.post(new Runnable(){

            @Override
            public void run() {
                view.setLayoutParams(layoutParams);
            }
        });
    }

    @Deprecated
    public static void startHierarchyTracing(String string2, View view) {
    }

    @Deprecated
    public static void startRecyclerTracing(String string2, View view) {
    }

    @Deprecated
    public static void stopHierarchyTracing() {
    }

    @Deprecated
    public static void stopRecyclerTracing() {
    }

    @Deprecated
    public static void trace(View view, HierarchyTraceType hierarchyTraceType) {
    }

    @Deprecated
    public static void trace(View view, RecyclerTraceType recyclerTraceType, int ... nArray) {
    }

    private static void writeEntry(BufferedWriter bufferedWriter, String string2, String string3, String string4, Object object) throws IOException {
        bufferedWriter.write(string2);
        bufferedWriter.write(string3);
        bufferedWriter.write(string4);
        bufferedWriter.write("=");
        ViewDebug.writeValue(bufferedWriter, object);
        bufferedWriter.write(32);
    }

    private static void writeValue(BufferedWriter bufferedWriter, Object object) throws IOException {
        if (object != null) {
            String string2;
            try {
                string2 = object.toString().replace("\n", "\\n");
            }
            catch (Throwable throwable) {
                bufferedWriter.write(String.valueOf("[EXCEPTION]".length()));
                bufferedWriter.write(",");
                bufferedWriter.write("[EXCEPTION]");
                throw throwable;
            }
            bufferedWriter.write(String.valueOf(string2.length()));
            bufferedWriter.write(",");
            bufferedWriter.write(string2);
            return;
        }
        bufferedWriter.write("4,null");
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD})
    public static @interface CapturedViewProperty {
        public boolean retrieveReturn() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD})
    public static @interface ExportedProperty {
        public String category() default "";

        public boolean deepExport() default false;

        public FlagToString[] flagMapping() default {};

        public boolean formatToHexString() default false;

        public boolean hasAdjacentMapping() default false;

        public IntToString[] indexMapping() default {};

        public IntToString[] mapping() default {};

        public String prefix() default "";

        public boolean resolveId() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface FlagToString {
        public int equals();

        public int mask();

        public String name();

        public boolean outputIf() default true;
    }

    public static interface HierarchyHandler {
        public void dumpViewHierarchyWithProperties(BufferedWriter var1, int var2);

        public View findHierarchyView(String var1, int var2);
    }

    @Deprecated
    public static final class HierarchyTraceType
    extends Enum<HierarchyTraceType> {
        private static final /* synthetic */ HierarchyTraceType[] $VALUES;
        public static final /* enum */ HierarchyTraceType BUILD_CACHE;
        public static final /* enum */ HierarchyTraceType DRAW;
        public static final /* enum */ HierarchyTraceType INVALIDATE;
        public static final /* enum */ HierarchyTraceType INVALIDATE_CHILD;
        public static final /* enum */ HierarchyTraceType INVALIDATE_CHILD_IN_PARENT;
        public static final /* enum */ HierarchyTraceType ON_LAYOUT;
        public static final /* enum */ HierarchyTraceType ON_MEASURE;
        public static final /* enum */ HierarchyTraceType REQUEST_LAYOUT;

        static {
            INVALIDATE = new HierarchyTraceType();
            INVALIDATE_CHILD = new HierarchyTraceType();
            INVALIDATE_CHILD_IN_PARENT = new HierarchyTraceType();
            REQUEST_LAYOUT = new HierarchyTraceType();
            ON_LAYOUT = new HierarchyTraceType();
            ON_MEASURE = new HierarchyTraceType();
            DRAW = new HierarchyTraceType();
            BUILD_CACHE = new HierarchyTraceType();
            HierarchyTraceType[] hierarchyTraceTypeArray = new HierarchyTraceType[]{INVALIDATE, INVALIDATE_CHILD, INVALIDATE_CHILD_IN_PARENT, REQUEST_LAYOUT, ON_LAYOUT, ON_MEASURE, DRAW, BUILD_CACHE};
            $VALUES = hierarchyTraceTypeArray;
        }

        public static HierarchyTraceType valueOf(String string2) {
            return Enum.valueOf(HierarchyTraceType.class, string2);
        }

        public static HierarchyTraceType[] values() {
            return (HierarchyTraceType[])$VALUES.clone();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface IntToString {
        public int from();

        public String to();
    }

    @Deprecated
    public static final class RecyclerTraceType
    extends Enum<RecyclerTraceType> {
        private static final /* synthetic */ RecyclerTraceType[] $VALUES;
        public static final /* enum */ RecyclerTraceType BIND_VIEW;
        public static final /* enum */ RecyclerTraceType MOVE_FROM_ACTIVE_TO_SCRAP_HEAP;
        public static final /* enum */ RecyclerTraceType MOVE_TO_SCRAP_HEAP;
        public static final /* enum */ RecyclerTraceType NEW_VIEW;
        public static final /* enum */ RecyclerTraceType RECYCLE_FROM_ACTIVE_HEAP;
        public static final /* enum */ RecyclerTraceType RECYCLE_FROM_SCRAP_HEAP;

        static {
            NEW_VIEW = new RecyclerTraceType();
            BIND_VIEW = new RecyclerTraceType();
            RECYCLE_FROM_ACTIVE_HEAP = new RecyclerTraceType();
            RECYCLE_FROM_SCRAP_HEAP = new RecyclerTraceType();
            MOVE_TO_SCRAP_HEAP = new RecyclerTraceType();
            MOVE_FROM_ACTIVE_TO_SCRAP_HEAP = new RecyclerTraceType();
            RecyclerTraceType[] recyclerTraceTypeArray = new RecyclerTraceType[]{NEW_VIEW, BIND_VIEW, RECYCLE_FROM_ACTIVE_HEAP, RECYCLE_FROM_SCRAP_HEAP, MOVE_TO_SCRAP_HEAP, MOVE_FROM_ACTIVE_TO_SCRAP_HEAP};
            $VALUES = recyclerTraceTypeArray;
        }

        public static RecyclerTraceType valueOf(String string2) {
            return Enum.valueOf(RecyclerTraceType.class, string2);
        }

        public static RecyclerTraceType[] values() {
            return (RecyclerTraceType[])$VALUES.clone();
        }
    }

    static interface ViewOperation<T> {
        public void post(T ... var1);

        public T[] pre();

        public void run(T ... var1);
    }
}

