/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Parcel;
import android.os.Parcelable;
import android.view.FrameStats;

public final class WindowContentFrameStats
extends FrameStats
implements Parcelable {
    public static final Parcelable.Creator<WindowContentFrameStats> CREATOR = new Parcelable.Creator<WindowContentFrameStats>(){

        @Override
        public WindowContentFrameStats createFromParcel(Parcel parcel) {
            return new WindowContentFrameStats(parcel);
        }

        public WindowContentFrameStats[] newArray(int n) {
            return new WindowContentFrameStats[n];
        }
    };
    private long[] mFramesPostedTimeNano;
    private long[] mFramesReadyTimeNano;

    public WindowContentFrameStats() {
    }

    private WindowContentFrameStats(Parcel parcel) {
        this.mRefreshPeriodNano = parcel.readLong();
        this.mFramesPostedTimeNano = parcel.createLongArray();
        this.mFramesPresentedTimeNano = parcel.createLongArray();
        this.mFramesReadyTimeNano = parcel.createLongArray();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public long getFramePostedTimeNano(int n) {
        if (this.mFramesPostedTimeNano == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.mFramesPostedTimeNano[n];
    }

    public long getFrameReadyTimeNano(int n) {
        if (this.mFramesReadyTimeNano == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.mFramesReadyTimeNano[n];
    }

    public void init(long l, long[] lArray, long[] lArray2, long[] lArray3) {
        this.mRefreshPeriodNano = l;
        this.mFramesPostedTimeNano = lArray;
        this.mFramesPresentedTimeNano = lArray2;
        this.mFramesReadyTimeNano = lArray3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("WindowContentFrameStats[");
        stringBuilder.append("frameCount:" + this.getFrameCount());
        stringBuilder.append(", fromTimeNano:" + this.getStartTimeNano());
        stringBuilder.append(", toTimeNano:" + this.getEndTimeNano());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeLong(this.mRefreshPeriodNano);
        parcel.writeLongArray(this.mFramesPostedTimeNano);
        parcel.writeLongArray(this.mFramesPresentedTimeNano);
        parcel.writeLongArray(this.mFramesReadyTimeNano);
    }
}

