/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.LongArray;
import android.util.Pools;
import android.view.View;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityWindowInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AccessibilityNodeInfo
implements Parcelable {
    public static final int ACTION_ACCESSIBILITY_FOCUS = 64;
    public static final String ACTION_ARGUMENT_EXTEND_SELECTION_BOOLEAN = "ACTION_ARGUMENT_EXTEND_SELECTION_BOOLEAN";
    public static final String ACTION_ARGUMENT_HTML_ELEMENT_STRING = "ACTION_ARGUMENT_HTML_ELEMENT_STRING";
    public static final String ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT = "ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT";
    public static final String ACTION_ARGUMENT_SELECTION_END_INT = "ACTION_ARGUMENT_SELECTION_END_INT";
    public static final String ACTION_ARGUMENT_SELECTION_START_INT = "ACTION_ARGUMENT_SELECTION_START_INT";
    public static final String ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE = "ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE";
    public static final int ACTION_CLEAR_ACCESSIBILITY_FOCUS = 128;
    public static final int ACTION_CLEAR_FOCUS = 2;
    public static final int ACTION_CLEAR_SELECTION = 8;
    public static final int ACTION_CLICK = 16;
    public static final int ACTION_COLLAPSE = 524288;
    public static final int ACTION_COPY = 16384;
    public static final int ACTION_CUT = 65536;
    public static final int ACTION_DISMISS = 0x100000;
    public static final int ACTION_EXPAND = 262144;
    public static final int ACTION_FOCUS = 1;
    public static final int ACTION_LONG_CLICK = 32;
    public static final int ACTION_NEXT_AT_MOVEMENT_GRANULARITY = 256;
    public static final int ACTION_NEXT_HTML_ELEMENT = 1024;
    public static final int ACTION_PASTE = 32768;
    public static final int ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY = 512;
    public static final int ACTION_PREVIOUS_HTML_ELEMENT = 2048;
    public static final int ACTION_SCROLL_BACKWARD = 8192;
    public static final int ACTION_SCROLL_FORWARD = 4096;
    public static final int ACTION_SELECT = 4;
    public static final int ACTION_SET_SELECTION = 131072;
    public static final int ACTION_SET_TEXT = 0x200000;
    private static final int ACTION_TYPE_MASK = -16777216;
    public static final int ACTIVE_WINDOW_ID = Integer.MAX_VALUE;
    public static final int ANY_WINDOW_ID = -2;
    private static final int BOOLEAN_PROPERTY_ACCESSIBILITY_FOCUSED = 1024;
    private static final int BOOLEAN_PROPERTY_CHECKABLE = 1;
    private static final int BOOLEAN_PROPERTY_CHECKED = 2;
    private static final int BOOLEAN_PROPERTY_CLICKABLE = 32;
    private static final int BOOLEAN_PROPERTY_CONTENT_INVALID = 65536;
    private static final int BOOLEAN_PROPERTY_DISMISSABLE = 16384;
    private static final int BOOLEAN_PROPERTY_EDITABLE = 4096;
    private static final int BOOLEAN_PROPERTY_ENABLED = 128;
    private static final int BOOLEAN_PROPERTY_FOCUSABLE = 4;
    private static final int BOOLEAN_PROPERTY_FOCUSED = 8;
    private static final int BOOLEAN_PROPERTY_LONG_CLICKABLE = 64;
    private static final int BOOLEAN_PROPERTY_MULTI_LINE = 32768;
    private static final int BOOLEAN_PROPERTY_OPENS_POPUP = 8192;
    private static final int BOOLEAN_PROPERTY_PASSWORD = 256;
    private static final int BOOLEAN_PROPERTY_SCROLLABLE = 512;
    private static final int BOOLEAN_PROPERTY_SELECTED = 16;
    private static final int BOOLEAN_PROPERTY_VISIBLE_TO_USER = 2048;
    public static final Parcelable.Creator<AccessibilityNodeInfo> CREATOR;
    private static final boolean DEBUG = false;
    public static final int FLAG_INCLUDE_NOT_IMPORTANT_VIEWS = 8;
    public static final int FLAG_PREFETCH_DESCENDANTS = 4;
    public static final int FLAG_PREFETCH_PREDECESSORS = 1;
    public static final int FLAG_PREFETCH_SIBLINGS = 2;
    public static final int FLAG_REPORT_VIEW_IDS = 16;
    public static final int FOCUS_ACCESSIBILITY = 2;
    public static final int FOCUS_INPUT = 1;
    private static final int LAST_LEGACY_STANDARD_ACTION = 0x200000;
    private static final int MAX_POOL_SIZE = 50;
    public static final int MOVEMENT_GRANULARITY_CHARACTER = 1;
    public static final int MOVEMENT_GRANULARITY_LINE = 4;
    public static final int MOVEMENT_GRANULARITY_PAGE = 16;
    public static final int MOVEMENT_GRANULARITY_PARAGRAPH = 8;
    public static final int MOVEMENT_GRANULARITY_WORD = 2;
    public static final long ROOT_NODE_ID = 0L;
    public static final int UNDEFINED_CONNECTION_ID = -1;
    public static final int UNDEFINED_ITEM_ID = Integer.MAX_VALUE;
    public static final int UNDEFINED_SELECTION_INDEX = -1;
    private static final long VIRTUAL_DESCENDANT_ID_MASK = -4294967296L;
    private static final int VIRTUAL_DESCENDANT_ID_SHIFT = 32;
    private static final Pools.SynchronizedPool<AccessibilityNodeInfo> sPool;
    private ArrayList<AccessibilityAction> mActions;
    private int mBooleanProperties;
    private final Rect mBoundsInParent;
    private final Rect mBoundsInScreen;
    private LongArray mChildNodeIds;
    private CharSequence mClassName;
    private CollectionInfo mCollectionInfo;
    private CollectionItemInfo mCollectionItemInfo;
    private int mConnectionId = -1;
    private CharSequence mContentDescription;
    private CharSequence mError;
    private Bundle mExtras;
    private int mInputType = 0;
    private long mLabelForId;
    private long mLabeledById;
    private int mLiveRegion = 0;
    private int mMaxTextLength = -1;
    private int mMovementGranularities;
    private CharSequence mPackageName;
    private long mParentNodeId;
    private RangeInfo mRangeInfo;
    private boolean mSealed;
    private long mSourceNodeId;
    private CharSequence mText;
    private int mTextSelectionEnd = -1;
    private int mTextSelectionStart = -1;
    private String mViewIdResourceName;
    private int mWindowId = Integer.MAX_VALUE;

    static {
        ROOT_NODE_ID = AccessibilityNodeInfo.makeNodeId(Integer.MAX_VALUE, Integer.MAX_VALUE);
        sPool = new Pools.SynchronizedPool(50);
        CREATOR = new Parcelable.Creator<AccessibilityNodeInfo>(){

            @Override
            public AccessibilityNodeInfo createFromParcel(Parcel parcel) {
                AccessibilityNodeInfo accessibilityNodeInfo = AccessibilityNodeInfo.obtain();
                accessibilityNodeInfo.initFromParcel(parcel);
                return accessibilityNodeInfo;
            }

            public AccessibilityNodeInfo[] newArray(int n) {
                return new AccessibilityNodeInfo[n];
            }
        };
    }

    private AccessibilityNodeInfo() {
        this.mSourceNodeId = ROOT_NODE_ID;
        this.mParentNodeId = ROOT_NODE_ID;
        this.mLabelForId = ROOT_NODE_ID;
        this.mLabeledById = ROOT_NODE_ID;
        this.mBoundsInParent = new Rect();
        this.mBoundsInScreen = new Rect();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addChildInternal(View view, int n, boolean bl) {
        this.enforceNotSealed();
        if (this.mChildNodeIds == null) {
            this.mChildNodeIds = new LongArray();
        }
        int n2 = view != null ? view.getAccessibilityViewId() : Integer.MAX_VALUE;
        long l = AccessibilityNodeInfo.makeNodeId(n2, n);
        if (bl && this.mChildNodeIds.indexOf(l) >= 0) {
            return;
        }
        this.mChildNodeIds.add(l);
    }

    private void addLegacyStandardActions(int n) {
        int n2;
        for (int i = n; i > 0; i &= ~n2) {
            n2 = 1 << Integer.numberOfTrailingZeros(i);
            this.addAction(AccessibilityNodeInfo.getActionSingleton(n2));
        }
    }

    private boolean canPerformRequestOverConnection(long l) {
        return this.mWindowId != Integer.MAX_VALUE && AccessibilityNodeInfo.getAccessibilityViewId(l) != Integer.MAX_VALUE && this.mConnectionId != -1;
    }

    private void clear() {
        this.mSealed = false;
        this.mSourceNodeId = ROOT_NODE_ID;
        this.mParentNodeId = ROOT_NODE_ID;
        this.mLabelForId = ROOT_NODE_ID;
        this.mLabeledById = ROOT_NODE_ID;
        this.mWindowId = Integer.MAX_VALUE;
        this.mConnectionId = -1;
        this.mMaxTextLength = -1;
        this.mMovementGranularities = 0;
        if (this.mChildNodeIds != null) {
            this.mChildNodeIds.clear();
        }
        this.mBoundsInParent.set(0, 0, 0, 0);
        this.mBoundsInScreen.set(0, 0, 0, 0);
        this.mBooleanProperties = 0;
        this.mPackageName = null;
        this.mClassName = null;
        this.mText = null;
        this.mError = null;
        this.mContentDescription = null;
        this.mViewIdResourceName = null;
        if (this.mActions != null) {
            this.mActions.clear();
        }
        this.mTextSelectionStart = -1;
        this.mTextSelectionEnd = -1;
        this.mInputType = 0;
        this.mLiveRegion = 0;
        if (this.mExtras != null) {
            this.mExtras.clear();
        }
        if (this.mRangeInfo != null) {
            this.mRangeInfo.recycle();
            this.mRangeInfo = null;
        }
        if (this.mCollectionInfo != null) {
            this.mCollectionInfo.recycle();
            this.mCollectionInfo = null;
        }
        if (this.mCollectionItemInfo != null) {
            this.mCollectionItemInfo.recycle();
            this.mCollectionItemInfo = null;
        }
    }

    private void enforceValidFocusDirection(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("Unknown direction: " + n);
            }
            case 1: 
            case 2: 
            case 17: 
            case 33: 
            case 66: 
            case 130: 
        }
    }

    private void enforceValidFocusType(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("Unknown focus type: " + n);
            }
            case 1: 
            case 2: 
        }
    }

    public static int getAccessibilityViewId(long l) {
        return (int)l;
    }

    private static AccessibilityAction getActionSingleton(int n) {
        int n2 = AccessibilityAction.sStandardActions.size();
        for (int i = 0; i < n2; ++i) {
            AccessibilityAction accessibilityAction = (AccessibilityAction)AccessibilityAction.sStandardActions.valueAt(i);
            if (n != accessibilityAction.getId()) continue;
            return accessibilityAction;
        }
        return null;
    }

    private static String getActionSymbolicName(int n) {
        switch (n) {
            default: {
                return "ACTION_UNKNOWN";
            }
            case 1: {
                return "ACTION_FOCUS";
            }
            case 2: {
                return "ACTION_CLEAR_FOCUS";
            }
            case 4: {
                return "ACTION_SELECT";
            }
            case 8: {
                return "ACTION_CLEAR_SELECTION";
            }
            case 16: {
                return "ACTION_CLICK";
            }
            case 32: {
                return "ACTION_LONG_CLICK";
            }
            case 64: {
                return "ACTION_ACCESSIBILITY_FOCUS";
            }
            case 128: {
                return "ACTION_CLEAR_ACCESSIBILITY_FOCUS";
            }
            case 256: {
                return "ACTION_NEXT_AT_MOVEMENT_GRANULARITY";
            }
            case 512: {
                return "ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY";
            }
            case 1024: {
                return "ACTION_NEXT_HTML_ELEMENT";
            }
            case 2048: {
                return "ACTION_PREVIOUS_HTML_ELEMENT";
            }
            case 4096: {
                return "ACTION_SCROLL_FORWARD";
            }
            case 8192: {
                return "ACTION_SCROLL_BACKWARD";
            }
            case 65536: {
                return "ACTION_CUT";
            }
            case 16384: {
                return "ACTION_COPY";
            }
            case 32768: {
                return "ACTION_PASTE";
            }
            case 131072: 
        }
        return "ACTION_SET_SELECTION";
    }

    private boolean getBooleanProperty(int n) {
        return (n & this.mBooleanProperties) != 0;
    }

    private static String getMovementGranularitySymbolicName(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("Unknown movement granularity: " + n);
            }
            case 1: {
                return "MOVEMENT_GRANULARITY_CHARACTER";
            }
            case 2: {
                return "MOVEMENT_GRANULARITY_WORD";
            }
            case 4: {
                return "MOVEMENT_GRANULARITY_LINE";
            }
            case 8: {
                return "MOVEMENT_GRANULARITY_PARAGRAPH";
            }
            case 16: 
        }
        return "MOVEMENT_GRANULARITY_PAGE";
    }

    public static int getVirtualDescendantId(long l) {
        return (int)((0xFFFFFFFF00000000L & l) >> 32);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void init(AccessibilityNodeInfo accessibilityNodeInfo) {
        this.mSealed = accessibilityNodeInfo.mSealed;
        this.mSourceNodeId = accessibilityNodeInfo.mSourceNodeId;
        this.mParentNodeId = accessibilityNodeInfo.mParentNodeId;
        this.mLabelForId = accessibilityNodeInfo.mLabelForId;
        this.mLabeledById = accessibilityNodeInfo.mLabeledById;
        this.mWindowId = accessibilityNodeInfo.mWindowId;
        this.mConnectionId = accessibilityNodeInfo.mConnectionId;
        this.mBoundsInParent.set(accessibilityNodeInfo.mBoundsInParent);
        this.mBoundsInScreen.set(accessibilityNodeInfo.mBoundsInScreen);
        this.mPackageName = accessibilityNodeInfo.mPackageName;
        this.mClassName = accessibilityNodeInfo.mClassName;
        this.mText = accessibilityNodeInfo.mText;
        this.mError = accessibilityNodeInfo.mError;
        this.mContentDescription = accessibilityNodeInfo.mContentDescription;
        this.mViewIdResourceName = accessibilityNodeInfo.mViewIdResourceName;
        ArrayList<AccessibilityAction> arrayList = accessibilityNodeInfo.mActions;
        if (arrayList != null && arrayList.size() > 0) {
            if (this.mActions == null) {
                this.mActions = new ArrayList<AccessibilityAction>(arrayList);
            } else {
                this.mActions.clear();
                this.mActions.addAll(accessibilityNodeInfo.mActions);
            }
        }
        this.mBooleanProperties = accessibilityNodeInfo.mBooleanProperties;
        this.mMaxTextLength = accessibilityNodeInfo.mMaxTextLength;
        this.mMovementGranularities = accessibilityNodeInfo.mMovementGranularities;
        LongArray longArray = accessibilityNodeInfo.mChildNodeIds;
        if (longArray != null && longArray.size() > 0) {
            if (this.mChildNodeIds == null) {
                this.mChildNodeIds = longArray.clone();
            } else {
                this.mChildNodeIds.clear();
                this.mChildNodeIds.addAll(longArray);
            }
        }
        this.mTextSelectionStart = accessibilityNodeInfo.mTextSelectionStart;
        this.mTextSelectionEnd = accessibilityNodeInfo.mTextSelectionEnd;
        this.mInputType = accessibilityNodeInfo.mInputType;
        this.mLiveRegion = accessibilityNodeInfo.mLiveRegion;
        if (accessibilityNodeInfo.mExtras != null && !accessibilityNodeInfo.mExtras.isEmpty()) {
            this.getExtras().putAll(accessibilityNodeInfo.mExtras);
        }
        RangeInfo rangeInfo = accessibilityNodeInfo.mRangeInfo != null ? RangeInfo.obtain(accessibilityNodeInfo.mRangeInfo) : null;
        this.mRangeInfo = rangeInfo;
        CollectionInfo collectionInfo = accessibilityNodeInfo.mCollectionInfo != null ? CollectionInfo.obtain(accessibilityNodeInfo.mCollectionInfo) : null;
        this.mCollectionInfo = collectionInfo;
        CollectionItemInfo collectionItemInfo = accessibilityNodeInfo.mCollectionItemInfo;
        CollectionItemInfo collectionItemInfo2 = null;
        if (collectionItemInfo != null) {
            collectionItemInfo2 = CollectionItemInfo.obtain(accessibilityNodeInfo.mCollectionItemInfo);
        }
        this.mCollectionItemInfo = collectionItemInfo2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initFromParcel(Parcel parcel) {
        boolean bl = parcel.readInt() == 1;
        this.mSealed = bl;
        this.mSourceNodeId = parcel.readLong();
        this.mWindowId = parcel.readInt();
        this.mParentNodeId = parcel.readLong();
        this.mLabelForId = parcel.readLong();
        this.mLabeledById = parcel.readLong();
        this.mConnectionId = parcel.readInt();
        int n = parcel.readInt();
        if (n <= 0) {
            this.mChildNodeIds = null;
        } else {
            this.mChildNodeIds = new LongArray(n);
            for (int i = 0; i < n; ++i) {
                long l = parcel.readLong();
                this.mChildNodeIds.add(l);
            }
        }
        this.mBoundsInParent.top = parcel.readInt();
        this.mBoundsInParent.bottom = parcel.readInt();
        this.mBoundsInParent.left = parcel.readInt();
        this.mBoundsInParent.right = parcel.readInt();
        this.mBoundsInScreen.top = parcel.readInt();
        this.mBoundsInScreen.bottom = parcel.readInt();
        this.mBoundsInScreen.left = parcel.readInt();
        this.mBoundsInScreen.right = parcel.readInt();
        int n2 = parcel.readInt();
        if (n2 > 0) {
            int n3 = parcel.readInt();
            this.addLegacyStandardActions(n3);
            int n4 = n2 - Integer.bitCount(n3);
            for (int i = 0; i < n4; ++i) {
                this.addAction(new AccessibilityAction(parcel.readInt(), parcel.readCharSequence()));
            }
        }
        this.mMaxTextLength = parcel.readInt();
        this.mMovementGranularities = parcel.readInt();
        this.mBooleanProperties = parcel.readInt();
        this.mPackageName = parcel.readCharSequence();
        this.mClassName = parcel.readCharSequence();
        this.mText = parcel.readCharSequence();
        this.mError = parcel.readCharSequence();
        this.mContentDescription = parcel.readCharSequence();
        this.mViewIdResourceName = parcel.readString();
        this.mTextSelectionStart = parcel.readInt();
        this.mTextSelectionEnd = parcel.readInt();
        this.mInputType = parcel.readInt();
        this.mLiveRegion = parcel.readInt();
        if (parcel.readInt() == 1) {
            this.getExtras().putAll(parcel.readBundle());
        }
        if (parcel.readInt() == 1) {
            this.mRangeInfo = RangeInfo.obtain(parcel.readInt(), parcel.readFloat(), parcel.readFloat(), parcel.readFloat());
        }
        if (parcel.readInt() == 1) {
            int n5 = parcel.readInt();
            int n6 = parcel.readInt();
            boolean bl2 = parcel.readInt() == 1;
            this.mCollectionInfo = CollectionInfo.obtain(n5, n6, bl2, parcel.readInt());
        }
        if (parcel.readInt() == 1) {
            int n7 = parcel.readInt();
            int n8 = parcel.readInt();
            int n9 = parcel.readInt();
            int n10 = parcel.readInt();
            boolean bl3 = parcel.readInt() == 1;
            boolean bl4 = parcel.readInt() == 1;
            this.mCollectionItemInfo = CollectionItemInfo.obtain(n7, n8, n9, n10, bl3, bl4);
        }
    }

    private static boolean isDefaultLegacyStandardAction(AccessibilityAction accessibilityAction) {
        return accessibilityAction.getId() <= 0x200000 && TextUtils.isEmpty(accessibilityAction.getLabel());
    }

    public static long makeNodeId(int n, int n2) {
        if (n2 == -1) {
            n2 = Integer.MAX_VALUE;
        }
        return (long)n2 << 32 | (long)n;
    }

    public static AccessibilityNodeInfo obtain() {
        AccessibilityNodeInfo accessibilityNodeInfo = sPool.acquire();
        if (accessibilityNodeInfo != null) {
            return accessibilityNodeInfo;
        }
        return new AccessibilityNodeInfo();
    }

    public static AccessibilityNodeInfo obtain(View view) {
        AccessibilityNodeInfo accessibilityNodeInfo = AccessibilityNodeInfo.obtain();
        accessibilityNodeInfo.setSource(view);
        return accessibilityNodeInfo;
    }

    public static AccessibilityNodeInfo obtain(View view, int n) {
        AccessibilityNodeInfo accessibilityNodeInfo = AccessibilityNodeInfo.obtain();
        accessibilityNodeInfo.setSource(view, n);
        return accessibilityNodeInfo;
    }

    public static AccessibilityNodeInfo obtain(AccessibilityNodeInfo accessibilityNodeInfo) {
        AccessibilityNodeInfo accessibilityNodeInfo2 = AccessibilityNodeInfo.obtain();
        accessibilityNodeInfo2.init(accessibilityNodeInfo);
        return accessibilityNodeInfo2;
    }

    private void setBooleanProperty(int n, boolean bl) {
        this.enforceNotSealed();
        if (bl) {
            this.mBooleanProperties = n | this.mBooleanProperties;
            return;
        }
        this.mBooleanProperties &= ~n;
    }

    @Deprecated
    public void addAction(int n) {
        this.enforceNotSealed();
        if ((0xFF000000 & n) != 0) {
            throw new IllegalArgumentException("Action is not a combination of the standard actions: " + n);
        }
        this.addLegacyStandardActions(n);
    }

    public void addAction(AccessibilityAction accessibilityAction) {
        this.enforceNotSealed();
        if (accessibilityAction == null) {
            return;
        }
        if (this.mActions == null) {
            this.mActions = new ArrayList();
        }
        this.mActions.remove(accessibilityAction);
        this.mActions.add(accessibilityAction);
    }

    public void addChild(View view) {
        this.addChildInternal(view, Integer.MAX_VALUE, true);
    }

    public void addChild(View view, int n) {
        this.addChildInternal(view, n, true);
    }

    public void addChildUnchecked(View view) {
        this.addChildInternal(view, Integer.MAX_VALUE, false);
    }

    public boolean canOpenPopup() {
        return this.getBooleanProperty(8192);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    protected void enforceNotSealed() {
        if (this.isSealed()) {
            throw new IllegalStateException("Cannot perform this action on a sealed instance.");
        }
    }

    protected void enforceSealed() {
        if (!this.isSealed()) {
            throw new IllegalStateException("Cannot perform this action on a not sealed instance.");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block7: {
            block6: {
                if (this == object) break block6;
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                AccessibilityNodeInfo accessibilityNodeInfo = (AccessibilityNodeInfo)object;
                if (this.mSourceNodeId != accessibilityNodeInfo.mSourceNodeId) {
                    return false;
                }
                if (this.mWindowId != accessibilityNodeInfo.mWindowId) break block7;
            }
            return true;
        }
        return false;
    }

    public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByText(String string2) {
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mSourceNodeId)) {
            return Collections.emptyList();
        }
        return AccessibilityInteractionClient.getInstance().findAccessibilityNodeInfosByText(this.mConnectionId, this.mWindowId, this.mSourceNodeId, string2);
    }

    public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByViewId(String string2) {
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mSourceNodeId)) {
            return Collections.emptyList();
        }
        return AccessibilityInteractionClient.getInstance().findAccessibilityNodeInfosByViewId(this.mConnectionId, this.mWindowId, this.mSourceNodeId, string2);
    }

    public AccessibilityNodeInfo findFocus(int n) {
        this.enforceSealed();
        this.enforceValidFocusType(n);
        if (!this.canPerformRequestOverConnection(this.mSourceNodeId)) {
            return null;
        }
        return AccessibilityInteractionClient.getInstance().findFocus(this.mConnectionId, this.mWindowId, this.mSourceNodeId, n);
    }

    public AccessibilityNodeInfo focusSearch(int n) {
        this.enforceSealed();
        this.enforceValidFocusDirection(n);
        if (!this.canPerformRequestOverConnection(this.mSourceNodeId)) {
            return null;
        }
        return AccessibilityInteractionClient.getInstance().focusSearch(this.mConnectionId, this.mWindowId, this.mSourceNodeId, n);
    }

    public List<AccessibilityAction> getActionList() {
        if (this.mActions == null) {
            return Collections.emptyList();
        }
        return this.mActions;
    }

    @Deprecated
    public int getActions() {
        int n = 0;
        if (this.mActions == null) {
            return 0;
        }
        int n2 = this.mActions.size();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.mActions.get(i).getId();
            if (n3 > 0x200000) continue;
            n |= n3;
        }
        return n;
    }

    public void getBoundsInParent(Rect rect) {
        rect.set(this.mBoundsInParent.left, this.mBoundsInParent.top, this.mBoundsInParent.right, this.mBoundsInParent.bottom);
    }

    public void getBoundsInScreen(Rect rect) {
        rect.set(this.mBoundsInScreen.left, this.mBoundsInScreen.top, this.mBoundsInScreen.right, this.mBoundsInScreen.bottom);
    }

    /*
     * Enabled aggressive block sorting
     */
    public AccessibilityNodeInfo getChild(int n) {
        this.enforceSealed();
        if (this.mChildNodeIds == null || !this.canPerformRequestOverConnection(this.mSourceNodeId)) {
            return null;
        }
        long l = this.mChildNodeIds.get(n);
        return AccessibilityInteractionClient.getInstance().findAccessibilityNodeInfoByAccessibilityId(this.mConnectionId, this.mWindowId, l, false, 4);
    }

    public int getChildCount() {
        if (this.mChildNodeIds == null) {
            return 0;
        }
        return this.mChildNodeIds.size();
    }

    public long getChildId(int n) {
        if (this.mChildNodeIds == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.mChildNodeIds.get(n);
    }

    public LongArray getChildNodeIds() {
        return this.mChildNodeIds;
    }

    public CharSequence getClassName() {
        return this.mClassName;
    }

    public CollectionInfo getCollectionInfo() {
        return this.mCollectionInfo;
    }

    public CollectionItemInfo getCollectionItemInfo() {
        return this.mCollectionItemInfo;
    }

    public CharSequence getContentDescription() {
        return this.mContentDescription;
    }

    public CharSequence getError() {
        return this.mError;
    }

    public Bundle getExtras() {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        return this.mExtras;
    }

    public int getInputType() {
        return this.mInputType;
    }

    public AccessibilityNodeInfo getLabelFor() {
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mLabelForId)) {
            return null;
        }
        return AccessibilityInteractionClient.getInstance().findAccessibilityNodeInfoByAccessibilityId(this.mConnectionId, this.mWindowId, this.mLabelForId, false, 7);
    }

    public AccessibilityNodeInfo getLabeledBy() {
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mLabeledById)) {
            return null;
        }
        return AccessibilityInteractionClient.getInstance().findAccessibilityNodeInfoByAccessibilityId(this.mConnectionId, this.mWindowId, this.mLabeledById, false, 7);
    }

    public int getLiveRegion() {
        return this.mLiveRegion;
    }

    public int getMaxTextLength() {
        return this.mMaxTextLength;
    }

    public int getMovementGranularities() {
        return this.mMovementGranularities;
    }

    public CharSequence getPackageName() {
        return this.mPackageName;
    }

    public AccessibilityNodeInfo getParent() {
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mParentNodeId)) {
            return null;
        }
        return AccessibilityInteractionClient.getInstance().findAccessibilityNodeInfoByAccessibilityId(this.mConnectionId, this.mWindowId, this.mParentNodeId, false, 7);
    }

    public long getParentNodeId() {
        return this.mParentNodeId;
    }

    public RangeInfo getRangeInfo() {
        return this.mRangeInfo;
    }

    public long getSourceNodeId() {
        return this.mSourceNodeId;
    }

    public CharSequence getText() {
        return this.mText;
    }

    public int getTextSelectionEnd() {
        return this.mTextSelectionEnd;
    }

    public int getTextSelectionStart() {
        return this.mTextSelectionStart;
    }

    public String getViewIdResourceName() {
        return this.mViewIdResourceName;
    }

    public AccessibilityWindowInfo getWindow() {
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mSourceNodeId)) {
            return null;
        }
        return AccessibilityInteractionClient.getInstance().getWindow(this.mConnectionId, this.mWindowId);
    }

    public int getWindowId() {
        return this.mWindowId;
    }

    public int hashCode() {
        return 31 * (31 * (31 + AccessibilityNodeInfo.getAccessibilityViewId(this.mSourceNodeId)) + AccessibilityNodeInfo.getVirtualDescendantId(this.mSourceNodeId)) + this.mWindowId;
    }

    public boolean isAccessibilityFocused() {
        return this.getBooleanProperty(1024);
    }

    public boolean isCheckable() {
        return this.getBooleanProperty(1);
    }

    public boolean isChecked() {
        return this.getBooleanProperty(2);
    }

    public boolean isClickable() {
        return this.getBooleanProperty(32);
    }

    public boolean isContentInvalid() {
        return this.getBooleanProperty(65536);
    }

    public boolean isDismissable() {
        return this.getBooleanProperty(16384);
    }

    public boolean isEditable() {
        return this.getBooleanProperty(4096);
    }

    public boolean isEnabled() {
        return this.getBooleanProperty(128);
    }

    public boolean isFocusable() {
        return this.getBooleanProperty(4);
    }

    public boolean isFocused() {
        return this.getBooleanProperty(8);
    }

    public boolean isLongClickable() {
        return this.getBooleanProperty(64);
    }

    public boolean isMultiLine() {
        return this.getBooleanProperty(32768);
    }

    public boolean isPassword() {
        return this.getBooleanProperty(256);
    }

    public boolean isScrollable() {
        return this.getBooleanProperty(512);
    }

    public boolean isSealed() {
        return this.mSealed;
    }

    public boolean isSelected() {
        return this.getBooleanProperty(16);
    }

    public boolean isVisibleToUser() {
        return this.getBooleanProperty(2048);
    }

    public boolean performAction(int n) {
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mSourceNodeId)) {
            return false;
        }
        return AccessibilityInteractionClient.getInstance().performAccessibilityAction(this.mConnectionId, this.mWindowId, this.mSourceNodeId, n, null);
    }

    public boolean performAction(int n, Bundle bundle) {
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mSourceNodeId)) {
            return false;
        }
        return AccessibilityInteractionClient.getInstance().performAccessibilityAction(this.mConnectionId, this.mWindowId, this.mSourceNodeId, n, bundle);
    }

    public void recycle() {
        this.clear();
        sPool.release(this);
    }

    public boolean refresh() {
        return this.refresh(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean refresh(boolean bl) {
        AccessibilityNodeInfo accessibilityNodeInfo;
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mSourceNodeId) || (accessibilityNodeInfo = AccessibilityInteractionClient.getInstance().findAccessibilityNodeInfoByAccessibilityId(this.mConnectionId, this.mWindowId, this.mSourceNodeId, bl, 0)) == null) {
            return false;
        }
        this.init(accessibilityNodeInfo);
        accessibilityNodeInfo.recycle();
        return true;
    }

    @Deprecated
    public void removeAction(int n) {
        this.enforceNotSealed();
        this.removeAction(AccessibilityNodeInfo.getActionSingleton(n));
    }

    public boolean removeAction(AccessibilityAction accessibilityAction) {
        this.enforceNotSealed();
        if (this.mActions == null || accessibilityAction == null) {
            return false;
        }
        return this.mActions.remove(accessibilityAction);
    }

    public boolean removeChild(View view) {
        return this.removeChild(view, Integer.MAX_VALUE);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean removeChild(View view, int n) {
        int n2;
        int n3;
        this.enforceNotSealed();
        LongArray longArray = this.mChildNodeIds;
        if (longArray == null || (n3 = longArray.indexOf(AccessibilityNodeInfo.makeNodeId(n2 = view != null ? view.getAccessibilityViewId() : Integer.MAX_VALUE, n))) < 0) {
            return false;
        }
        longArray.remove(n3);
        return true;
    }

    public void setAccessibilityFocused(boolean bl) {
        this.setBooleanProperty(1024, bl);
    }

    public void setBoundsInParent(Rect rect) {
        this.enforceNotSealed();
        this.mBoundsInParent.set(rect.left, rect.top, rect.right, rect.bottom);
    }

    public void setBoundsInScreen(Rect rect) {
        this.enforceNotSealed();
        this.mBoundsInScreen.set(rect.left, rect.top, rect.right, rect.bottom);
    }

    public void setCanOpenPopup(boolean bl) {
        this.enforceNotSealed();
        this.setBooleanProperty(8192, bl);
    }

    public void setCheckable(boolean bl) {
        this.setBooleanProperty(1, bl);
    }

    public void setChecked(boolean bl) {
        this.setBooleanProperty(2, bl);
    }

    public void setClassName(CharSequence charSequence) {
        this.enforceNotSealed();
        this.mClassName = charSequence;
    }

    public void setClickable(boolean bl) {
        this.setBooleanProperty(32, bl);
    }

    public void setCollectionInfo(CollectionInfo collectionInfo) {
        this.enforceNotSealed();
        this.mCollectionInfo = collectionInfo;
    }

    public void setCollectionItemInfo(CollectionItemInfo collectionItemInfo) {
        this.enforceNotSealed();
        this.mCollectionItemInfo = collectionItemInfo;
    }

    public void setConnectionId(int n) {
        this.enforceNotSealed();
        this.mConnectionId = n;
    }

    public void setContentDescription(CharSequence charSequence) {
        this.enforceNotSealed();
        this.mContentDescription = charSequence;
    }

    public void setContentInvalid(boolean bl) {
        this.setBooleanProperty(65536, bl);
    }

    public void setDismissable(boolean bl) {
        this.setBooleanProperty(16384, bl);
    }

    public void setEditable(boolean bl) {
        this.setBooleanProperty(4096, bl);
    }

    public void setEnabled(boolean bl) {
        this.setBooleanProperty(128, bl);
    }

    public void setError(CharSequence charSequence) {
        this.enforceNotSealed();
        this.mError = charSequence;
    }

    public void setFocusable(boolean bl) {
        this.setBooleanProperty(4, bl);
    }

    public void setFocused(boolean bl) {
        this.setBooleanProperty(8, bl);
    }

    public void setInputType(int n) {
        this.enforceNotSealed();
        this.mInputType = n;
    }

    public void setLabelFor(View view) {
        this.setLabelFor(view, Integer.MAX_VALUE);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setLabelFor(View view, int n) {
        this.enforceNotSealed();
        int n2 = view != null ? view.getAccessibilityViewId() : Integer.MAX_VALUE;
        this.mLabelForId = AccessibilityNodeInfo.makeNodeId(n2, n);
    }

    public void setLabeledBy(View view) {
        this.setLabeledBy(view, Integer.MAX_VALUE);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setLabeledBy(View view, int n) {
        this.enforceNotSealed();
        int n2 = view != null ? view.getAccessibilityViewId() : Integer.MAX_VALUE;
        this.mLabeledById = AccessibilityNodeInfo.makeNodeId(n2, n);
    }

    public void setLiveRegion(int n) {
        this.enforceNotSealed();
        this.mLiveRegion = n;
    }

    public void setLongClickable(boolean bl) {
        this.setBooleanProperty(64, bl);
    }

    public void setMaxTextLength(int n) {
        this.enforceNotSealed();
        this.mMaxTextLength = n;
    }

    public void setMovementGranularities(int n) {
        this.enforceNotSealed();
        this.mMovementGranularities = n;
    }

    public void setMultiLine(boolean bl) {
        this.setBooleanProperty(32768, bl);
    }

    public void setPackageName(CharSequence charSequence) {
        this.enforceNotSealed();
        this.mPackageName = charSequence;
    }

    public void setParent(View view) {
        this.setParent(view, Integer.MAX_VALUE);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setParent(View view, int n) {
        this.enforceNotSealed();
        int n2 = view != null ? view.getAccessibilityViewId() : Integer.MAX_VALUE;
        this.mParentNodeId = AccessibilityNodeInfo.makeNodeId(n2, n);
    }

    public void setPassword(boolean bl) {
        this.setBooleanProperty(256, bl);
    }

    public void setRangeInfo(RangeInfo rangeInfo) {
        this.enforceNotSealed();
        this.mRangeInfo = rangeInfo;
    }

    public void setScrollable(boolean bl) {
        this.setBooleanProperty(512, bl);
    }

    public void setSealed(boolean bl) {
        this.mSealed = bl;
    }

    public void setSelected(boolean bl) {
        this.setBooleanProperty(16, bl);
    }

    public void setSource(View view) {
        this.setSource(view, Integer.MAX_VALUE);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setSource(View view, int n) {
        this.enforceNotSealed();
        int n2 = view != null ? view.getAccessibilityWindowId() : Integer.MAX_VALUE;
        this.mWindowId = n2;
        int n3 = view != null ? view.getAccessibilityViewId() : Integer.MAX_VALUE;
        this.mSourceNodeId = AccessibilityNodeInfo.makeNodeId(n3, n);
    }

    public void setText(CharSequence charSequence) {
        this.enforceNotSealed();
        this.mText = charSequence;
    }

    public void setTextSelection(int n, int n2) {
        this.enforceNotSealed();
        this.mTextSelectionStart = n;
        this.mTextSelectionEnd = n2;
    }

    public void setViewIdResourceName(String string2) {
        this.enforceNotSealed();
        this.mViewIdResourceName = string2;
    }

    public void setVisibleToUser(boolean bl) {
        this.setBooleanProperty(2048, bl);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("; boundsInParent: " + this.mBoundsInParent);
        stringBuilder.append("; boundsInScreen: " + this.mBoundsInScreen);
        stringBuilder.append("; packageName: ").append(this.mPackageName);
        stringBuilder.append("; className: ").append(this.mClassName);
        stringBuilder.append("; text: ").append(this.mText);
        stringBuilder.append("; error: ").append(this.mError);
        stringBuilder.append("; maxTextLength: ").append(this.mMaxTextLength);
        stringBuilder.append("; contentDescription: ").append(this.mContentDescription);
        stringBuilder.append("; viewIdResName: ").append(this.mViewIdResourceName);
        stringBuilder.append("; checkable: ").append(this.isCheckable());
        stringBuilder.append("; checked: ").append(this.isChecked());
        stringBuilder.append("; focusable: ").append(this.isFocusable());
        stringBuilder.append("; focused: ").append(this.isFocused());
        stringBuilder.append("; selected: ").append(this.isSelected());
        stringBuilder.append("; clickable: ").append(this.isClickable());
        stringBuilder.append("; longClickable: ").append(this.isLongClickable());
        stringBuilder.append("; enabled: ").append(this.isEnabled());
        stringBuilder.append("; password: ").append(this.isPassword());
        stringBuilder.append("; scrollable: ").append(this.isScrollable());
        stringBuilder.append("; actions: ").append(this.mActions);
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        int n3 = this.isSealed() ? n2 : 0;
        parcel.writeInt(n3);
        parcel.writeLong(this.mSourceNodeId);
        parcel.writeInt(this.mWindowId);
        parcel.writeLong(this.mParentNodeId);
        parcel.writeLong(this.mLabelForId);
        parcel.writeLong(this.mLabeledById);
        parcel.writeInt(this.mConnectionId);
        LongArray longArray = this.mChildNodeIds;
        if (longArray == null) {
            parcel.writeInt(0);
        } else {
            int n4 = longArray.size();
            parcel.writeInt(n4);
            for (int i = 0; i < n4; ++i) {
                parcel.writeLong(longArray.get(i));
            }
        }
        parcel.writeInt(this.mBoundsInParent.top);
        parcel.writeInt(this.mBoundsInParent.bottom);
        parcel.writeInt(this.mBoundsInParent.left);
        parcel.writeInt(this.mBoundsInParent.right);
        parcel.writeInt(this.mBoundsInScreen.top);
        parcel.writeInt(this.mBoundsInScreen.bottom);
        parcel.writeInt(this.mBoundsInScreen.left);
        parcel.writeInt(this.mBoundsInScreen.right);
        if (this.mActions != null && !this.mActions.isEmpty()) {
            int n5 = this.mActions.size();
            parcel.writeInt(n5);
            int n6 = 0;
            for (int i = 0; i < n5; ++i) {
                AccessibilityAction accessibilityAction = this.mActions.get(i);
                if (!AccessibilityNodeInfo.isDefaultLegacyStandardAction(accessibilityAction)) continue;
                n6 |= accessibilityAction.getId();
            }
            parcel.writeInt(n6);
            for (int i = 0; i < n5; ++i) {
                AccessibilityAction accessibilityAction = this.mActions.get(i);
                if (AccessibilityNodeInfo.isDefaultLegacyStandardAction(accessibilityAction)) continue;
                parcel.writeInt(accessibilityAction.getId());
                parcel.writeCharSequence(accessibilityAction.getLabel());
            }
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.mMaxTextLength);
        parcel.writeInt(this.mMovementGranularities);
        parcel.writeInt(this.mBooleanProperties);
        parcel.writeCharSequence(this.mPackageName);
        parcel.writeCharSequence(this.mClassName);
        parcel.writeCharSequence(this.mText);
        parcel.writeCharSequence(this.mError);
        parcel.writeCharSequence(this.mContentDescription);
        parcel.writeString(this.mViewIdResourceName);
        parcel.writeInt(this.mTextSelectionStart);
        parcel.writeInt(this.mTextSelectionEnd);
        parcel.writeInt(this.mInputType);
        parcel.writeInt(this.mLiveRegion);
        if (this.mExtras != null) {
            parcel.writeInt(n2);
            parcel.writeBundle(this.mExtras);
        } else {
            parcel.writeInt(0);
        }
        if (this.mRangeInfo != null) {
            parcel.writeInt(n2);
            parcel.writeInt(this.mRangeInfo.getType());
            parcel.writeFloat(this.mRangeInfo.getMin());
            parcel.writeFloat(this.mRangeInfo.getMax());
            parcel.writeFloat(this.mRangeInfo.getCurrent());
        } else {
            parcel.writeInt(0);
        }
        if (this.mCollectionInfo != null) {
            parcel.writeInt(n2);
            parcel.writeInt(this.mCollectionInfo.getRowCount());
            parcel.writeInt(this.mCollectionInfo.getColumnCount());
            int n7 = this.mCollectionInfo.isHierarchical() ? n2 : 0;
            parcel.writeInt(n7);
            parcel.writeInt(this.mCollectionInfo.getSelectionMode());
        } else {
            parcel.writeInt(0);
        }
        if (this.mCollectionItemInfo != null) {
            parcel.writeInt(n2);
            parcel.writeInt(this.mCollectionItemInfo.getColumnIndex());
            parcel.writeInt(this.mCollectionItemInfo.getColumnSpan());
            parcel.writeInt(this.mCollectionItemInfo.getRowIndex());
            parcel.writeInt(this.mCollectionItemInfo.getRowSpan());
            int n8 = this.mCollectionItemInfo.isHeading() ? n2 : 0;
            parcel.writeInt(n8);
            if (!this.mCollectionItemInfo.isSelected()) {
                n2 = 0;
            }
            parcel.writeInt(n2);
        } else {
            parcel.writeInt(0);
        }
        this.recycle();
    }

    public static final class AccessibilityAction {
        public static final AccessibilityAction ACTION_ACCESSIBILITY_FOCUS;
        public static final AccessibilityAction ACTION_CLEAR_ACCESSIBILITY_FOCUS;
        public static final AccessibilityAction ACTION_CLEAR_FOCUS;
        public static final AccessibilityAction ACTION_CLEAR_SELECTION;
        public static final AccessibilityAction ACTION_CLICK;
        public static final AccessibilityAction ACTION_COLLAPSE;
        public static final AccessibilityAction ACTION_COPY;
        public static final AccessibilityAction ACTION_CUT;
        public static final AccessibilityAction ACTION_DISMISS;
        public static final AccessibilityAction ACTION_EXPAND;
        public static final AccessibilityAction ACTION_FOCUS;
        public static final AccessibilityAction ACTION_LONG_CLICK;
        public static final AccessibilityAction ACTION_NEXT_AT_MOVEMENT_GRANULARITY;
        public static final AccessibilityAction ACTION_NEXT_HTML_ELEMENT;
        public static final AccessibilityAction ACTION_PASTE;
        public static final AccessibilityAction ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY;
        public static final AccessibilityAction ACTION_PREVIOUS_HTML_ELEMENT;
        public static final AccessibilityAction ACTION_SCROLL_BACKWARD;
        public static final AccessibilityAction ACTION_SCROLL_FORWARD;
        public static final AccessibilityAction ACTION_SELECT;
        public static final AccessibilityAction ACTION_SET_SELECTION;
        public static final AccessibilityAction ACTION_SET_TEXT;
        private static final ArraySet<AccessibilityAction> sStandardActions;
        private final int mActionId;
        private final CharSequence mLabel;

        static {
            ACTION_FOCUS = new AccessibilityAction(1, null);
            ACTION_CLEAR_FOCUS = new AccessibilityAction(2, null);
            ACTION_SELECT = new AccessibilityAction(4, null);
            ACTION_CLEAR_SELECTION = new AccessibilityAction(8, null);
            ACTION_CLICK = new AccessibilityAction(16, null);
            ACTION_LONG_CLICK = new AccessibilityAction(32, null);
            ACTION_ACCESSIBILITY_FOCUS = new AccessibilityAction(64, null);
            ACTION_CLEAR_ACCESSIBILITY_FOCUS = new AccessibilityAction(128, null);
            ACTION_NEXT_AT_MOVEMENT_GRANULARITY = new AccessibilityAction(256, null);
            ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY = new AccessibilityAction(512, null);
            ACTION_NEXT_HTML_ELEMENT = new AccessibilityAction(1024, null);
            ACTION_PREVIOUS_HTML_ELEMENT = new AccessibilityAction(2048, null);
            ACTION_SCROLL_FORWARD = new AccessibilityAction(4096, null);
            ACTION_SCROLL_BACKWARD = new AccessibilityAction(8192, null);
            ACTION_COPY = new AccessibilityAction(16384, null);
            ACTION_PASTE = new AccessibilityAction(32768, null);
            ACTION_CUT = new AccessibilityAction(65536, null);
            ACTION_SET_SELECTION = new AccessibilityAction(131072, null);
            ACTION_EXPAND = new AccessibilityAction(262144, null);
            ACTION_COLLAPSE = new AccessibilityAction(524288, null);
            ACTION_DISMISS = new AccessibilityAction(0x100000, null);
            ACTION_SET_TEXT = new AccessibilityAction(0x200000, null);
            sStandardActions = new ArraySet();
            sStandardActions.add(ACTION_FOCUS);
            sStandardActions.add(ACTION_CLEAR_FOCUS);
            sStandardActions.add(ACTION_SELECT);
            sStandardActions.add(ACTION_CLEAR_SELECTION);
            sStandardActions.add(ACTION_CLICK);
            sStandardActions.add(ACTION_LONG_CLICK);
            sStandardActions.add(ACTION_ACCESSIBILITY_FOCUS);
            sStandardActions.add(ACTION_CLEAR_ACCESSIBILITY_FOCUS);
            sStandardActions.add(ACTION_NEXT_AT_MOVEMENT_GRANULARITY);
            sStandardActions.add(ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY);
            sStandardActions.add(ACTION_NEXT_HTML_ELEMENT);
            sStandardActions.add(ACTION_PREVIOUS_HTML_ELEMENT);
            sStandardActions.add(ACTION_SCROLL_FORWARD);
            sStandardActions.add(ACTION_SCROLL_BACKWARD);
            sStandardActions.add(ACTION_COPY);
            sStandardActions.add(ACTION_PASTE);
            sStandardActions.add(ACTION_CUT);
            sStandardActions.add(ACTION_SET_SELECTION);
            sStandardActions.add(ACTION_EXPAND);
            sStandardActions.add(ACTION_COLLAPSE);
            sStandardActions.add(ACTION_DISMISS);
            sStandardActions.add(ACTION_SET_TEXT);
        }

        public AccessibilityAction(int n, CharSequence charSequence) {
            if ((0xFF000000 & n) == 0 && Integer.bitCount(n) != 1) {
                throw new IllegalArgumentException("Invalid standard action id");
            }
            this.mActionId = n;
            this.mLabel = charSequence;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            boolean bl = true;
            if (object == null) {
                return false;
            }
            if (object == this) {
                return bl;
            }
            if (this.getClass() != object.getClass()) return false;
            if (this.mActionId != ((AccessibilityAction)object).mActionId) return false;
            return bl;
        }

        public int getId() {
            return this.mActionId;
        }

        public CharSequence getLabel() {
            return this.mLabel;
        }

        public int hashCode() {
            return this.mActionId;
        }

        public String toString() {
            return "AccessibilityAction: " + AccessibilityNodeInfo.getActionSymbolicName(this.mActionId) + " - " + this.mLabel;
        }
    }

    public static final class CollectionInfo {
        private static final int MAX_POOL_SIZE = 20;
        public static final int SELECTION_MODE_MULTIPLE = 2;
        public static final int SELECTION_MODE_NONE = 0;
        public static final int SELECTION_MODE_SINGLE = 1;
        private static final Pools.SynchronizedPool<CollectionInfo> sPool = new Pools.SynchronizedPool(20);
        private int mColumnCount;
        private boolean mHierarchical;
        private int mRowCount;
        private int mSelectionMode;

        private CollectionInfo(int n, int n2, boolean bl, int n3) {
            this.mRowCount = n;
            this.mColumnCount = n2;
            this.mHierarchical = bl;
            this.mSelectionMode = n3;
        }

        private void clear() {
            this.mRowCount = 0;
            this.mColumnCount = 0;
            this.mHierarchical = false;
            this.mSelectionMode = 0;
        }

        public static CollectionInfo obtain(int n, int n2, boolean bl) {
            return CollectionInfo.obtain(n, n2, bl, 0);
        }

        public static CollectionInfo obtain(int n, int n2, boolean bl, int n3) {
            CollectionInfo collectionInfo = sPool.acquire();
            if (collectionInfo == null) {
                return new CollectionInfo(n, n2, bl, n3);
            }
            collectionInfo.mRowCount = n;
            collectionInfo.mColumnCount = n2;
            collectionInfo.mHierarchical = bl;
            collectionInfo.mSelectionMode = n3;
            return collectionInfo;
        }

        public static CollectionInfo obtain(CollectionInfo collectionInfo) {
            return CollectionInfo.obtain(collectionInfo.mRowCount, collectionInfo.mColumnCount, collectionInfo.mHierarchical, collectionInfo.mSelectionMode);
        }

        public int getColumnCount() {
            return this.mColumnCount;
        }

        public int getRowCount() {
            return this.mRowCount;
        }

        public int getSelectionMode() {
            return this.mSelectionMode;
        }

        public boolean isHierarchical() {
            return this.mHierarchical;
        }

        void recycle() {
            this.clear();
            sPool.release(this);
        }
    }

    public static final class CollectionItemInfo {
        private static final int MAX_POOL_SIZE = 20;
        private static final Pools.SynchronizedPool<CollectionItemInfo> sPool = new Pools.SynchronizedPool(20);
        private int mColumnIndex;
        private int mColumnSpan;
        private boolean mHeading;
        private int mRowIndex;
        private int mRowSpan;
        private boolean mSelected;

        private CollectionItemInfo(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
            this.mRowIndex = n;
            this.mRowSpan = n2;
            this.mColumnIndex = n3;
            this.mColumnSpan = n4;
            this.mHeading = bl;
            this.mSelected = bl2;
        }

        private void clear() {
            this.mColumnIndex = 0;
            this.mColumnSpan = 0;
            this.mRowIndex = 0;
            this.mRowSpan = 0;
            this.mHeading = false;
            this.mSelected = false;
        }

        public static CollectionItemInfo obtain(int n, int n2, int n3, int n4, boolean bl) {
            return CollectionItemInfo.obtain(n, n2, n3, n4, bl, false);
        }

        public static CollectionItemInfo obtain(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
            CollectionItemInfo collectionItemInfo = sPool.acquire();
            if (collectionItemInfo == null) {
                return new CollectionItemInfo(n, n2, n3, n4, bl, bl2);
            }
            collectionItemInfo.mRowIndex = n;
            collectionItemInfo.mRowSpan = n2;
            collectionItemInfo.mColumnIndex = n3;
            collectionItemInfo.mColumnSpan = n4;
            collectionItemInfo.mHeading = bl;
            collectionItemInfo.mSelected = bl2;
            return collectionItemInfo;
        }

        public static CollectionItemInfo obtain(CollectionItemInfo collectionItemInfo) {
            return CollectionItemInfo.obtain(collectionItemInfo.mRowIndex, collectionItemInfo.mRowSpan, collectionItemInfo.mColumnIndex, collectionItemInfo.mColumnSpan, collectionItemInfo.mHeading, collectionItemInfo.mSelected);
        }

        public int getColumnIndex() {
            return this.mColumnIndex;
        }

        public int getColumnSpan() {
            return this.mColumnSpan;
        }

        public int getRowIndex() {
            return this.mRowIndex;
        }

        public int getRowSpan() {
            return this.mRowSpan;
        }

        public boolean isHeading() {
            return this.mHeading;
        }

        public boolean isSelected() {
            return this.mSelected;
        }

        void recycle() {
            this.clear();
            sPool.release(this);
        }
    }

    public static final class RangeInfo {
        private static final int MAX_POOL_SIZE = 10;
        public static final int RANGE_TYPE_FLOAT = 1;
        public static final int RANGE_TYPE_INT = 0;
        public static final int RANGE_TYPE_PERCENT = 2;
        private static final Pools.SynchronizedPool<RangeInfo> sPool = new Pools.SynchronizedPool(10);
        private float mCurrent;
        private float mMax;
        private float mMin;
        private int mType;

        private RangeInfo(int n, float f, float f2, float f3) {
            this.mType = n;
            this.mMin = f;
            this.mMax = f2;
            this.mCurrent = f3;
        }

        private void clear() {
            this.mType = 0;
            this.mMin = 0.0f;
            this.mMax = 0.0f;
            this.mCurrent = 0.0f;
        }

        public static RangeInfo obtain(int n, float f, float f2, float f3) {
            RangeInfo rangeInfo = sPool.acquire();
            if (rangeInfo != null) {
                return rangeInfo;
            }
            return new RangeInfo(n, f, f2, f3);
        }

        public static RangeInfo obtain(RangeInfo rangeInfo) {
            return RangeInfo.obtain(rangeInfo.mType, rangeInfo.mMin, rangeInfo.mMax, rangeInfo.mCurrent);
        }

        public float getCurrent() {
            return this.mCurrent;
        }

        public float getMax() {
            return this.mMax;
        }

        public float getMin() {
            return this.mMin;
        }

        public int getType() {
            return this.mType;
        }

        void recycle() {
            this.clear();
            sPool.release(this);
        }
    }
}

