/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.LongArray;
import android.util.Pools;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityNodeInfo;

public final class AccessibilityWindowInfo
implements Parcelable {
    private static final int BOOLEAN_PROPERTY_ACCESSIBLITY_FOCUSED = 4;
    private static final int BOOLEAN_PROPERTY_ACTIVE = 1;
    private static final int BOOLEAN_PROPERTY_FOCUSED = 2;
    public static final Parcelable.Creator<AccessibilityWindowInfo> CREATOR;
    private static final boolean DEBUG = false;
    private static final int MAX_POOL_SIZE = 10;
    public static final int TYPE_APPLICATION = 1;
    public static final int TYPE_INPUT_METHOD = 2;
    public static final int TYPE_SYSTEM = 3;
    private static final int UNDEFINED = -1;
    private static final Pools.SynchronizedPool<AccessibilityWindowInfo> sPool;
    private int mBooleanProperties;
    private final Rect mBoundsInScreen = new Rect();
    private LongArray mChildIds;
    private int mConnectionId = -1;
    private int mId = -1;
    private int mLayer = -1;
    private int mParentId = -1;
    private int mType = -1;

    static {
        sPool = new Pools.SynchronizedPool(10);
        CREATOR = new Parcelable.Creator<AccessibilityWindowInfo>(){

            @Override
            public AccessibilityWindowInfo createFromParcel(Parcel parcel) {
                AccessibilityWindowInfo accessibilityWindowInfo = AccessibilityWindowInfo.obtain();
                accessibilityWindowInfo.initFromParcel(parcel);
                return accessibilityWindowInfo;
            }

            public AccessibilityWindowInfo[] newArray(int n) {
                return new AccessibilityWindowInfo[n];
            }
        };
    }

    private AccessibilityWindowInfo() {
    }

    private void clear() {
        this.mType = -1;
        this.mLayer = -1;
        this.mBooleanProperties = 0;
        this.mId = -1;
        this.mParentId = -1;
        this.mBoundsInScreen.setEmpty();
        if (this.mChildIds != null) {
            this.mChildIds.clear();
        }
        this.mConnectionId = -1;
    }

    private boolean getBooleanProperty(int n) {
        return (n & this.mBooleanProperties) != 0;
    }

    private void initFromParcel(Parcel parcel) {
        this.mType = parcel.readInt();
        this.mLayer = parcel.readInt();
        this.mBooleanProperties = parcel.readInt();
        this.mId = parcel.readInt();
        this.mParentId = parcel.readInt();
        this.mBoundsInScreen.readFromParcel(parcel);
        int n = parcel.readInt();
        if (n > 0) {
            if (this.mChildIds == null) {
                this.mChildIds = new LongArray(n);
            }
            for (int i = 0; i < n; ++i) {
                int n2 = parcel.readInt();
                this.mChildIds.add(n2);
            }
        }
        this.mConnectionId = parcel.readInt();
    }

    public static AccessibilityWindowInfo obtain() {
        AccessibilityWindowInfo accessibilityWindowInfo = sPool.acquire();
        if (accessibilityWindowInfo == null) {
            accessibilityWindowInfo = new AccessibilityWindowInfo();
        }
        return accessibilityWindowInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static AccessibilityWindowInfo obtain(AccessibilityWindowInfo accessibilityWindowInfo) {
        AccessibilityWindowInfo accessibilityWindowInfo2 = AccessibilityWindowInfo.obtain();
        accessibilityWindowInfo2.mType = accessibilityWindowInfo.mType;
        accessibilityWindowInfo2.mLayer = accessibilityWindowInfo.mLayer;
        accessibilityWindowInfo2.mBooleanProperties = accessibilityWindowInfo.mBooleanProperties;
        accessibilityWindowInfo2.mId = accessibilityWindowInfo.mId;
        accessibilityWindowInfo2.mParentId = accessibilityWindowInfo.mParentId;
        accessibilityWindowInfo2.mBoundsInScreen.set(accessibilityWindowInfo.mBoundsInScreen);
        if (accessibilityWindowInfo.mChildIds != null && accessibilityWindowInfo.mChildIds.size() > 0) {
            if (accessibilityWindowInfo2.mChildIds == null) {
                accessibilityWindowInfo2.mChildIds = accessibilityWindowInfo.mChildIds.clone();
            } else {
                accessibilityWindowInfo2.mChildIds.addAll(accessibilityWindowInfo.mChildIds);
            }
        }
        accessibilityWindowInfo2.mConnectionId = accessibilityWindowInfo.mConnectionId;
        return accessibilityWindowInfo2;
    }

    private void setBooleanProperty(int n, boolean bl) {
        if (bl) {
            this.mBooleanProperties = n | this.mBooleanProperties;
            return;
        }
        this.mBooleanProperties &= ~n;
    }

    private static String typeToString(int n) {
        switch (n) {
            default: {
                return "<UNKNOWN>";
            }
            case 1: {
                return "TYPE_APPLICATION";
            }
            case 2: {
                return "TYPE_INPUT_METHOD";
            }
            case 3: 
        }
        return "TYPE_SYSTEM";
    }

    public void addChild(int n) {
        if (this.mChildIds == null) {
            this.mChildIds = new LongArray();
        }
        this.mChildIds.add(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean changed(AccessibilityWindowInfo accessibilityWindowInfo) {
        if (accessibilityWindowInfo.mId != this.mId) {
            throw new IllegalArgumentException("Not same window.");
        }
        if (accessibilityWindowInfo.mType != this.mType) {
            throw new IllegalArgumentException("Not same type.");
        }
        if (!this.mBoundsInScreen.equals(this.mBoundsInScreen) || this.mLayer != accessibilityWindowInfo.mLayer || this.mBooleanProperties != accessibilityWindowInfo.mBooleanProperties || this.mParentId != accessibilityWindowInfo.mParentId) return true;
        if (this.mChildIds == null) {
            if (accessibilityWindowInfo.mChildIds == null) return false;
            return true;
        }
        if (!this.mChildIds.equals(accessibilityWindowInfo.mChildIds)) return true;
        return false;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block6: {
            block5: {
                if (this == object) break block5;
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                AccessibilityWindowInfo accessibilityWindowInfo = (AccessibilityWindowInfo)object;
                if (this.mId != accessibilityWindowInfo.mId) break block6;
            }
            return true;
        }
        return false;
    }

    public void getBoundsInScreen(Rect rect) {
        rect.set(this.mBoundsInScreen);
    }

    public AccessibilityWindowInfo getChild(int n) {
        if (this.mChildIds == null) {
            throw new IndexOutOfBoundsException();
        }
        if (this.mConnectionId == -1) {
            return null;
        }
        int n2 = (int)this.mChildIds.get(n);
        return AccessibilityInteractionClient.getInstance().getWindow(this.mConnectionId, n2);
    }

    public int getChildCount() {
        if (this.mChildIds != null) {
            return this.mChildIds.size();
        }
        return 0;
    }

    public int getId() {
        return this.mId;
    }

    public int getLayer() {
        return this.mLayer;
    }

    public AccessibilityWindowInfo getParent() {
        if (this.mConnectionId == -1 || this.mParentId == -1) {
            return null;
        }
        return AccessibilityInteractionClient.getInstance().getWindow(this.mConnectionId, this.mParentId);
    }

    public AccessibilityNodeInfo getRoot() {
        if (this.mConnectionId == -1) {
            return null;
        }
        return AccessibilityInteractionClient.getInstance().findAccessibilityNodeInfoByAccessibilityId(this.mConnectionId, this.mId, AccessibilityNodeInfo.ROOT_NODE_ID, true, 4);
    }

    public int getType() {
        return this.mType;
    }

    public int hashCode() {
        return this.mId;
    }

    public boolean isAccessibilityFocused() {
        return this.getBooleanProperty(4);
    }

    public boolean isActive() {
        return this.getBooleanProperty(1);
    }

    public boolean isFocused() {
        return this.getBooleanProperty(2);
    }

    public void recycle() {
        this.clear();
        sPool.release(this);
    }

    public void setAccessibilityFocused(boolean bl) {
        this.setBooleanProperty(4, bl);
    }

    public void setActive(boolean bl) {
        this.setBooleanProperty(1, bl);
    }

    public void setBoundsInScreen(Rect rect) {
        this.mBoundsInScreen.set(rect);
    }

    public void setConnectionId(int n) {
        this.mConnectionId = n;
    }

    public void setFocused(boolean bl) {
        this.setBooleanProperty(2, bl);
    }

    public void setId(int n) {
        this.mId = n;
    }

    public void setLayer(int n) {
        this.mLayer = n;
    }

    public void setParentId(int n) {
        this.mParentId = n;
    }

    public void setType(int n) {
        this.mType = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AccessibilityWindowInfo[");
        stringBuilder.append("id=").append(this.mId);
        stringBuilder.append(", type=").append(AccessibilityWindowInfo.typeToString(this.mType));
        stringBuilder.append(", layer=").append(this.mLayer);
        stringBuilder.append(", bounds=").append(this.mBoundsInScreen);
        stringBuilder.append(", focused=").append(this.isFocused());
        stringBuilder.append(", active=").append(this.isActive());
        StringBuilder stringBuilder2 = stringBuilder.append(", hasParent=");
        boolean bl2 = this.mParentId != -1 ? bl : false;
        stringBuilder2.append(bl2);
        StringBuilder stringBuilder3 = stringBuilder.append(", hasChildren=");
        if (this.mChildIds == null || this.mChildIds.size() <= 0) {
            bl = false;
        }
        stringBuilder3.append(bl);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mType);
        parcel.writeInt(this.mLayer);
        parcel.writeInt(this.mBooleanProperties);
        parcel.writeInt(this.mId);
        parcel.writeInt(this.mParentId);
        this.mBoundsInScreen.writeToParcel(parcel, n);
        LongArray longArray = this.mChildIds;
        if (longArray == null) {
            parcel.writeInt(0);
        } else {
            int n2 = longArray.size();
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                parcel.writeInt((int)longArray.get(i));
            }
        }
        parcel.writeInt(this.mConnectionId);
    }
}

