/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;

public final class SparseRectFArray
implements Parcelable {
    public static final Parcelable.Creator<SparseRectFArray> CREATOR = new Parcelable.Creator<SparseRectFArray>(){

        @Override
        public SparseRectFArray createFromParcel(Parcel parcel) {
            return new SparseRectFArray(parcel);
        }

        public SparseRectFArray[] newArray(int n) {
            return new SparseRectFArray[n];
        }
    };
    private final float[] mCoordinates;
    private final int[] mFlagsArray;
    private final int[] mKeys;

    public SparseRectFArray(Parcel parcel) {
        this.mKeys = parcel.createIntArray();
        this.mCoordinates = parcel.createFloatArray();
        this.mFlagsArray = parcel.createIntArray();
    }

    private SparseRectFArray(SparseRectFArrayBuilder sparseRectFArrayBuilder) {
        if (sparseRectFArrayBuilder.mCount == 0) {
            this.mKeys = null;
            this.mCoordinates = null;
            this.mFlagsArray = null;
            return;
        }
        this.mKeys = new int[sparseRectFArrayBuilder.mCount];
        this.mCoordinates = new float[4 * sparseRectFArrayBuilder.mCount];
        this.mFlagsArray = new int[sparseRectFArrayBuilder.mCount];
        System.arraycopy((int[])sparseRectFArrayBuilder.mKeys, (int)0, (int[])this.mKeys, (int)0, (int)sparseRectFArrayBuilder.mCount);
        System.arraycopy((float[])sparseRectFArrayBuilder.mCoordinates, (int)0, (float[])this.mCoordinates, (int)0, (int)(4 * sparseRectFArrayBuilder.mCount));
        System.arraycopy((int[])sparseRectFArrayBuilder.mFlagsArray, (int)0, (int[])this.mFlagsArray, (int)0, (int)sparseRectFArrayBuilder.mCount);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl = true;
        if (object == null) {
            return false;
        }
        if (this == object) {
            return bl;
        }
        if (!(object instanceof SparseRectFArray)) return false;
        SparseRectFArray sparseRectFArray = (SparseRectFArray)object;
        if (!Arrays.equals(this.mKeys, sparseRectFArray.mKeys)) return false;
        if (!Arrays.equals(this.mCoordinates, sparseRectFArray.mCoordinates)) return false;
        if (!Arrays.equals(this.mFlagsArray, sparseRectFArray.mFlagsArray)) return false;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public RectF get(int n) {
        int n2;
        if (this.mKeys == null || n < 0 || (n2 = Arrays.binarySearch(this.mKeys, n)) < 0) {
            return null;
        }
        int n3 = n2 * 4;
        return new RectF(this.mCoordinates[n3], this.mCoordinates[n3 + 1], this.mCoordinates[n3 + 2], this.mCoordinates[n3 + 3]);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getFlags(int n, int n2) {
        int n3;
        if (this.mKeys == null || n < 0 || (n3 = Arrays.binarySearch(this.mKeys, n)) < 0) {
            return n2;
        }
        return this.mFlagsArray[n3];
    }

    public int hashCode() {
        if (this.mKeys == null || this.mKeys.length == 0) {
            return 0;
        }
        int n = this.mKeys.length;
        for (int i = 0; i < 4; ++i) {
            n = (int)((float)(n * 31) + this.mCoordinates[i]);
        }
        return n * 31 + this.mFlagsArray[0];
    }

    public String toString() {
        if (this.mKeys == null || this.mCoordinates == null || this.mFlagsArray == null) {
            return "SparseRectFArray{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SparseRectFArray{");
        for (int i = 0; i < this.mKeys.length; ++i) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            int n = i * 4;
            stringBuilder.append(this.mKeys[i]);
            stringBuilder.append(":[");
            stringBuilder.append(this.mCoordinates[n + 0]);
            stringBuilder.append(",");
            stringBuilder.append(this.mCoordinates[n + 1]);
            stringBuilder.append("],[");
            stringBuilder.append(this.mCoordinates[n + 2]);
            stringBuilder.append(",");
            stringBuilder.append(this.mCoordinates[n + 3]);
            stringBuilder.append("]:flagsArray=");
            stringBuilder.append(this.mFlagsArray[i]);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeIntArray(this.mKeys);
        parcel.writeFloatArray(this.mCoordinates);
        parcel.writeIntArray(this.mFlagsArray);
    }

    public static final class SparseRectFArrayBuilder {
        private static int INITIAL_SIZE = 16;
        private float[] mCoordinates = null;
        private int mCount = 0;
        private int[] mFlagsArray = null;
        private int[] mKeys = null;

        /*
         * Enabled aggressive block sorting
         */
        private void checkIndex(int n) {
            if (this.mCount == 0 || this.mKeys[-1 + this.mCount] < n) {
                return;
            }
            throw new IllegalArgumentException("key must be greater than all existing keys.");
        }

        private void ensureBufferSize() {
            int n;
            int n2;
            if (this.mKeys == null) {
                this.mKeys = new int[INITIAL_SIZE];
            }
            if (this.mCoordinates == null) {
                this.mCoordinates = new float[4 * INITIAL_SIZE];
            }
            if (this.mFlagsArray == null) {
                this.mFlagsArray = new int[INITIAL_SIZE];
            }
            if (this.mKeys.length <= (n2 = 1 + this.mCount)) {
                int[] nArray = new int[n2 * 2];
                System.arraycopy((int[])this.mKeys, (int)0, (int[])nArray, (int)0, (int)this.mCount);
                this.mKeys = nArray;
            }
            if (this.mCoordinates.length <= (n = 4 * (1 + this.mCount))) {
                float[] fArray = new float[n * 2];
                System.arraycopy((float[])this.mCoordinates, (int)0, (float[])fArray, (int)0, (int)(4 * this.mCount));
                this.mCoordinates = fArray;
            }
            if (this.mFlagsArray.length <= n2) {
                int[] nArray = new int[n2 * 2];
                System.arraycopy((int[])this.mFlagsArray, (int)0, (int[])nArray, (int)0, (int)this.mCount);
                this.mFlagsArray = nArray;
            }
        }

        public SparseRectFArrayBuilder append(int n, float f, float f2, float f3, float f4, int n2) {
            this.checkIndex(n);
            this.ensureBufferSize();
            int n3 = 4 * this.mCount;
            this.mCoordinates[n3 + 0] = f;
            this.mCoordinates[n3 + 1] = f2;
            this.mCoordinates[n3 + 2] = f3;
            this.mCoordinates[n3 + 3] = f4;
            int n4 = this.mCount;
            this.mFlagsArray[n4] = n2;
            this.mKeys[this.mCount] = n;
            this.mCount = 1 + this.mCount;
            return this;
        }

        public SparseRectFArray build() {
            return new SparseRectFArray(this);
        }

        public boolean isEmpty() {
            return this.mCount <= 0;
        }

        public void reset() {
            if (this.mCount == 0) {
                this.mKeys = null;
                this.mCoordinates = null;
                this.mFlagsArray = null;
            }
            this.mCount = 0;
        }
    }
}

