/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.ActivityManagerInternal;
import android.app.AppGlobals;
import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.Trace;
import android.text.TextUtils;
import android.util.AndroidRuntimeException;
import android.util.Log;
import android.webkit.IWebViewUpdateService;
import android.webkit.WebViewFactoryProvider;
import com.android.server.LocalServices;
import dalvik.system.VMRuntime;
import java.io.File;
import java.util.Arrays;

public final class WebViewFactory {
    private static final long CHROMIUM_WEBVIEW_DEFAULT_VMSIZE_BYTES = 0x6400000L;
    private static final String CHROMIUM_WEBVIEW_FACTORY = "com.android.webview.chromium.WebViewChromiumFactoryProvider";
    private static final String CHROMIUM_WEBVIEW_NATIVE_RELRO_32 = "/data/misc/shared_relro/libwebviewchromium32.relro";
    private static final String CHROMIUM_WEBVIEW_NATIVE_RELRO_64 = "/data/misc/shared_relro/libwebviewchromium64.relro";
    public static final String CHROMIUM_WEBVIEW_PACKAGE_NAME_AOSP = "com.android.webview";
    public static final String CHROMIUM_WEBVIEW_VMSIZE_SIZE_PROPERTY = "persist.sys.webview.vmsize";
    private static final boolean DEBUG = false;
    private static final String LOGTAG = "WebViewFactory";
    private static final String NULL_WEBVIEW_FACTORY = "com.android.webview.nullwebview.NullWebViewFactoryProvider";
    private static boolean sAddressSpaceReserved;
    private static PackageInfo sPackageInfo;
    private static WebViewFactoryProvider sProviderInstance;
    private static final Object sProviderLock;

    static {
        sProviderLock = new Object();
        sAddressSpaceReserved = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void createRelroFile(final boolean bl, String[] stringArray) {
        final String string2 = bl ? Build.SUPPORTED_64_BIT_ABIS[0] : Build.SUPPORTED_32_BIT_ABIS[0];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Log.e(WebViewFactory.LOGTAG, "relro file creator for " + string2 + " crashed. Proceeding without");
                    WebViewFactory.getUpdateService().notifyRelroCreationCompleted(bl, false);
                    return;
                }
                catch (RemoteException remoteException) {
                    Log.e(WebViewFactory.LOGTAG, "Cannot reach WebViewUpdateService. " + remoteException.getMessage());
                    return;
                }
            }
        };
        if (stringArray == null) throw new IllegalArgumentException("Native library paths to the WebView RelRo process must not be null!");
        try {
            if (stringArray[0] == null || stringArray[1] == null) {
                throw new IllegalArgumentException("Native library paths to the WebView RelRo process must not be null!");
            }
            if (LocalServices.getService(ActivityManagerInternal.class).startIsolatedProcess(RelroFileCreator.class.getName(), stringArray, "WebViewLoader-" + string2, string2, 1037, runnable) > 0) return;
            throw new Exception("Failed to start the relro file creator process");
        }
        catch (Throwable throwable) {
            Log.e(LOGTAG, "error starting relro file creator for abi " + string2, throwable);
            runnable.run();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Class<WebViewFactoryProvider> getFactoryClass() throws ClassNotFoundException {
        ClassLoader classLoader;
        Application application = AppGlobals.getInitialApplication();
        try {
            String string2 = WebViewFactory.getWebViewPackageName();
            sPackageInfo = application.getPackageManager().getPackageInfo(string2, 0);
            Log.i(LOGTAG, "Loading " + string2 + " version " + WebViewFactory.sPackageInfo.versionName + " (code " + WebViewFactory.sPackageInfo.versionCode + ")");
            Context context = application.createPackageContext(string2, 3);
            application.getAssets().addAssetPath(context.getApplicationInfo().sourceDir);
            classLoader = context.getClassLoader();
            Trace.traceBegin(16L, "Class.forName()");
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            try {
                return Class.forName(NULL_WEBVIEW_FACTORY);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Log.e(LOGTAG, "Chromium WebView package does not exist", nameNotFoundException);
                throw new AndroidRuntimeException(nameNotFoundException);
            }
        }
        try {
            Class<WebViewFactoryProvider> clazz = Class.forName(CHROMIUM_WEBVIEW_FACTORY, true, classLoader);
            return clazz;
        }
        finally {
            Trace.traceEnd(16L);
        }
    }

    public static PackageInfo getLoadedPackageInfo() {
        return sPackageInfo;
    }

    /*
     * Exception decompiling
     */
    static WebViewFactoryProvider getProvider() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 8[TRYBLOCK] [10 : 121->123)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static IWebViewUpdateService getUpdateService() {
        return IWebViewUpdateService.Stub.asInterface(ServiceManager.getService("webviewupdate"));
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String[] getWebViewNativeLibraryPaths() throws PackageManager.NameNotFoundException {
        String string2;
        String string3;
        boolean bl;
        String string4 = WebViewFactory.getWebViewPackageName();
        ApplicationInfo applicationInfo = AppGlobals.getInitialApplication().getPackageManager().getApplicationInfo(string4, 0);
        if (applicationInfo.primaryCpuAbi != null) {
            bl = VMRuntime.is64BitAbi((String)applicationInfo.primaryCpuAbi);
        } else {
            String string5 = applicationInfo.nativeLibraryDir;
            bl = false;
            if (string5 != null) {
                bl = applicationInfo.nativeLibraryDir.contains("64");
            }
        }
        Log.d(LOGTAG, "primaryArchIs64bit = " + bl);
        if (!TextUtils.isEmpty(applicationInfo.secondaryCpuAbi)) {
            if (bl) {
                string3 = applicationInfo.nativeLibraryDir;
                string2 = applicationInfo.secondaryNativeLibraryDir;
            } else {
                string3 = applicationInfo.secondaryNativeLibraryDir;
                string2 = applicationInfo.nativeLibraryDir;
            }
        } else if (bl) {
            string3 = applicationInfo.nativeLibraryDir;
            string2 = "";
        } else {
            string2 = applicationInfo.nativeLibraryDir;
            string3 = "";
        }
        if (string4.equals(CHROMIUM_WEBVIEW_PACKAGE_NAME_AOSP)) {
            if (!TextUtils.isEmpty(string2)) {
                string2 = string2 + "/libwebviewchromium_aosp.so";
            }
            if (TextUtils.isEmpty(string3)) return new String[]{string2, string3};
            string3 = string3 + "/libwebviewchromium_aosp.so";
            return new String[]{string2, string3};
        }
        if (!TextUtils.isEmpty(string2)) {
            string2 = string2 + "/libwebviewchromium.so";
        }
        if (TextUtils.isEmpty(string3)) return new String[]{string2, string3};
        string3 = string3 + "/libwebviewchromium.so";
        return new String[]{string2, string3};
    }

    public static String getWebViewPackageName() {
        if (AppGlobals.getInitialApplication().getPackageName().equalsIgnoreCase("com.asus.browser")) {
            try {
                if (AppGlobals.getInitialApplication().getPackageManager().getApplicationInfo(CHROMIUM_WEBVIEW_PACKAGE_NAME_AOSP, 0) != null) {
                    return CHROMIUM_WEBVIEW_PACKAGE_NAME_AOSP;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.w(LOGTAG, "Chromium WebView package AOSP does not exist", nameNotFoundException);
                return AppGlobals.getInitialApplication().getString(17039434);
            }
        }
        return AppGlobals.getInitialApplication().getString(17039434);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadNativeLibrary() {
        if (!sAddressSpaceReserved) {
            Log.e(LOGTAG, "can't load with relro file; address space not reserved");
            return;
        }
        try {
            WebViewFactory.getUpdateService().waitForRelroCreationCompleted(VMRuntime.getRuntime().is64Bit());
        }
        catch (RemoteException remoteException) {
            Log.e(LOGTAG, "error waiting for relro creation, proceeding without", remoteException);
            return;
        }
        try {
            String[] stringArray = WebViewFactory.getWebViewNativeLibraryPaths();
            if (WebViewFactory.nativeLoadWithRelroFile(stringArray[0], stringArray[1], CHROMIUM_WEBVIEW_NATIVE_RELRO_32, CHROMIUM_WEBVIEW_NATIVE_RELRO_64)) return;
            Log.w(LOGTAG, "failed to load with relro file, proceeding without");
            return;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e(LOGTAG, "Failed to list WebView package libraries for loadNativeLibrary", nameNotFoundException);
            return;
        }
    }

    private static native boolean nativeCreateRelroFile(String var0, String var1, String var2, String var3);

    private static native boolean nativeLoadWithRelroFile(String var0, String var1, String var2, String var3);

    private static native boolean nativeReserveAddressSpace(long var0);

    /*
     * Unable to fully structure code
     */
    public static void onWebViewUpdateInstalled() {
        var0 = null;
        var0 = WebViewFactory.getWebViewNativeLibraryPaths();
        if (var0 == null) ** GOTO lbl29
        var3_1 = 0L;
        var5_2 = var0;
        var6_3 = var5_2.length;
        var7_4 = 0;
        while (true) {
            block10: {
                if (var7_4 < var6_3) {
                    var8_5 = var5_2[var7_4];
                    if (var8_5 == null) break block10;
                    var9_6 = new File(var8_5);
                    if (var9_6.exists() && (var10_7 = var9_6.length()) > var3_1) {
                        var3_1 = var10_7;
                    }
                }
                try {
                    var12_8 = Math.max(2L * var3_1, 0x6400000L);
                    Log.d("WebViewFactory", "Setting new address space to " + var12_8);
                    SystemProperties.set("persist.sys.webview.vmsize", Long.toString(var12_8));
                }
                catch (Throwable var1_9) {
                    Log.e("WebViewFactory", "error preparing webview native library", var1_9);
                    ** continue;
                }
lbl29:
                // 3 sources

                while (true) {
                    WebViewFactory.prepareWebViewInSystemServer(var0);
                    return;
                }
            }
            ++var7_4;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void prepareWebViewInSystemServer() {
        String[] stringArray;
        try {
            String[] stringArray2;
            stringArray = stringArray2 = WebViewFactory.getWebViewNativeLibraryPaths();
        }
        catch (Throwable throwable) {
            Log.e(LOGTAG, "error preparing webview native library", throwable);
            stringArray = null;
        }
        WebViewFactory.prepareWebViewInSystemServer(stringArray);
    }

    private static void prepareWebViewInSystemServer(String[] stringArray) {
        if (Build.SUPPORTED_32_BIT_ABIS.length > 0) {
            WebViewFactory.createRelroFile(false, stringArray);
        }
        if (Build.SUPPORTED_64_BIT_ABIS.length > 0) {
            WebViewFactory.createRelroFile(true, stringArray);
        }
    }

    public static void prepareWebViewInZygote() {
        try {
            System.loadLibrary("webviewchromium_loader");
            long l = SystemProperties.getLong(CHROMIUM_WEBVIEW_VMSIZE_SIZE_PROPERTY, 0x6400000L);
            sAddressSpaceReserved = WebViewFactory.nativeReserveAddressSpace(l);
            if (sAddressSpaceReserved) {
                return;
            }
            Log.e(LOGTAG, "reserving " + l + " bytes of address space failed");
            return;
        }
        catch (Throwable throwable) {
            Log.e(LOGTAG, "error preparing native loader", throwable);
            return;
        }
    }

    private static class RelroFileCreator {
        private RelroFileCreator() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static void main(String[] stringArray) {
            boolean bl;
            block15: {
                block14: {
                    bl = VMRuntime.getRuntime().is64Bit();
                    try {
                        if (stringArray.length == 2 && stringArray[0] != null && stringArray[1] != null) break block14;
                        Log.e(WebViewFactory.LOGTAG, "Invalid RelroFileCreator args: " + Arrays.toString(stringArray));
                    }
                    catch (Throwable throwable) {
                        try {
                            WebViewFactory.getUpdateService().notifyRelroCreationCompleted(bl, false);
                        }
                        catch (RemoteException remoteException) {
                            Log.e(WebViewFactory.LOGTAG, "error notifying update service", remoteException);
                        }
                        Log.e(WebViewFactory.LOGTAG, "failed to create relro file");
                        System.exit(0);
                        throw throwable;
                    }
                    try {
                        WebViewFactory.getUpdateService().notifyRelroCreationCompleted(bl, false);
                    }
                    catch (RemoteException remoteException) {
                        Log.e(WebViewFactory.LOGTAG, "error notifying update service", remoteException);
                    }
                    Log.e(WebViewFactory.LOGTAG, "failed to create relro file");
                    System.exit(0);
                    return;
                }
                Log.v(WebViewFactory.LOGTAG, "RelroFileCreator (64bit = " + bl + "), " + " 32-bit lib: " + stringArray[0] + ", 64-bit lib: " + stringArray[1]);
                if (sAddressSpaceReserved) break block15;
                Log.e(WebViewFactory.LOGTAG, "can't create relro file; address space not reserved");
                try {
                    WebViewFactory.getUpdateService().notifyRelroCreationCompleted(bl, false);
                }
                catch (RemoteException remoteException) {
                    Log.e(WebViewFactory.LOGTAG, "error notifying update service", remoteException);
                }
                Log.e(WebViewFactory.LOGTAG, "failed to create relro file");
                System.exit(0);
                return;
            }
            boolean bl2 = WebViewFactory.nativeCreateRelroFile(stringArray[0], stringArray[1], WebViewFactory.CHROMIUM_WEBVIEW_NATIVE_RELRO_32, WebViewFactory.CHROMIUM_WEBVIEW_NATIVE_RELRO_64);
            if (bl2) {
                // empty if block
            }
            try {
                WebViewFactory.getUpdateService().notifyRelroCreationCompleted(bl, bl2);
            }
            catch (RemoteException remoteException) {
                Log.e(WebViewFactory.LOGTAG, "error notifying update service", remoteException);
            }
            if (!bl2) {
                Log.e(WebViewFactory.LOGTAG, "failed to create relro file");
            }
            System.exit(0);
        }
    }
}

