/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.database.DataSetObserver;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.ContextMenu;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.Adapter;

public abstract class AdapterView<T extends Adapter>
extends ViewGroup {
    public static final int INVALID_POSITION = -1;
    public static final long INVALID_ROW_ID = Long.MIN_VALUE;
    public static final int ITEM_VIEW_TYPE_HEADER_OR_FOOTER = -2;
    public static final int ITEM_VIEW_TYPE_IGNORE = -1;
    static final int SYNC_FIRST_POSITION = 1;
    static final int SYNC_MAX_DURATION_MILLIS = 100;
    static final int SYNC_SELECTED_POSITION;
    boolean mBlockLayoutRequests = false;
    boolean mDataChanged;
    private boolean mDesiredFocusableInTouchModeState;
    private boolean mDesiredFocusableState;
    private View mEmptyView;
    @ViewDebug.ExportedProperty(category="scrolling")
    int mFirstPosition = 0;
    boolean mInLayout = false;
    @ViewDebug.ExportedProperty(category="list")
    int mItemCount;
    private int mLayoutHeight;
    boolean mNeedSync = false;
    @ViewDebug.ExportedProperty(category="list")
    int mNextSelectedPosition = -1;
    long mNextSelectedRowId;
    int mOldItemCount;
    int mOldSelectedPosition = -1;
    long mOldSelectedRowId;
    OnItemClickListener mOnItemClickListener;
    OnItemLongClickListener mOnItemLongClickListener;
    OnItemSelectedListener mOnItemSelectedListener;
    @ViewDebug.ExportedProperty(category="list")
    int mSelectedPosition = -1;
    long mSelectedRowId;
    private SelectionNotifier mSelectionNotifier;
    int mSpecificTop;
    long mSyncHeight;
    int mSyncMode;
    int mSyncPosition;
    long mSyncRowId = Long.MIN_VALUE;

    public AdapterView(Context context) {
        this(context, null);
    }

    public AdapterView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public AdapterView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public AdapterView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.mNextSelectedRowId = Long.MIN_VALUE;
        this.mSelectedRowId = Long.MIN_VALUE;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        if (this.getImportantForAccessibility() == 0) {
            this.setImportantForAccessibility(1);
        }
    }

    private void fireOnSelected() {
        if (this.mOnItemSelectedListener == null) {
            return;
        }
        int n = this.getSelectedItemPosition();
        if (n >= 0) {
            View view = this.getSelectedView();
            this.mOnItemSelectedListener.onItemSelected(this, view, n, this.getAdapter().getItemId(n));
            return;
        }
        this.mOnItemSelectedListener.onNothingSelected(this);
    }

    private boolean isScrollableForAccessibility() {
        boolean bl;
        block2: {
            block3: {
                T t = this.getAdapter();
                bl = false;
                if (t == null) break block2;
                int n = t.getCount();
                bl = false;
                if (n <= 0) break block2;
                if (this.getFirstVisiblePosition() > 0) break block3;
                int n2 = this.getLastVisiblePosition();
                int n3 = n - 1;
                bl = false;
                if (n2 >= n3) break block2;
            }
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void performAccessibilityActionsOnSelected() {
        if (!AccessibilityManager.getInstance(this.mContext).isEnabled() || this.getSelectedItemPosition() < 0) {
            return;
        }
        this.sendAccessibilityEvent(4);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateEmptyStatus(boolean bl) {
        if (this.isInFilterMode()) {
            bl = false;
        }
        if (bl) {
            if (this.mEmptyView != null) {
                this.mEmptyView.setVisibility(0);
                this.setVisibility(8);
            } else {
                this.setVisibility(0);
            }
            if (this.mDataChanged) {
                this.onLayout(false, this.mLeft, this.mTop, this.mRight, this.mBottom);
            }
            return;
        }
        if (this.mEmptyView != null) {
            this.mEmptyView.setVisibility(8);
        }
        this.setVisibility(0);
    }

    @Override
    public void addView(View view) {
        throw new UnsupportedOperationException("addView(View) is not supported in AdapterView");
    }

    @Override
    public void addView(View view, int n) {
        throw new UnsupportedOperationException("addView(View, int) is not supported in AdapterView");
    }

    @Override
    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        throw new UnsupportedOperationException("addView(View, int, LayoutParams) is not supported in AdapterView");
    }

    @Override
    public void addView(View view, ViewGroup.LayoutParams layoutParams) {
        throw new UnsupportedOperationException("addView(View, LayoutParams) is not supported in AdapterView");
    }

    @Override
    protected boolean canAnimate() {
        return super.canAnimate() && this.mItemCount > 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    void checkFocus() {
        block2: {
            boolean bl;
            block4: {
                block3: {
                    T t = this.getAdapter();
                    boolean bl2 = t == null || t.getCount() == 0;
                    boolean bl3 = !bl2 || this.isInFilterMode();
                    boolean bl4 = bl3 && this.mDesiredFocusableInTouchModeState;
                    super.setFocusableInTouchMode(bl4);
                    boolean bl5 = bl3 && this.mDesiredFocusableState;
                    super.setFocusable(bl5);
                    if (this.mEmptyView == null) break block2;
                    if (t == null) break block3;
                    boolean bl6 = t.isEmpty();
                    bl = false;
                    if (!bl6) break block4;
                }
                bl = true;
            }
            this.updateEmptyStatus(bl);
        }
    }

    void checkSelectionChanged() {
        if (this.mSelectedPosition != this.mOldSelectedPosition || this.mSelectedRowId != this.mOldSelectedRowId) {
            this.selectionChanged();
            this.mOldSelectedPosition = this.mSelectedPosition;
            this.mOldSelectedRowId = this.mSelectedRowId;
        }
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        View view = this.getSelectedView();
        return view != null && view.getVisibility() == 0 && view.dispatchPopulateAccessibilityEvent(accessibilityEvent);
    }

    @Override
    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> sparseArray) {
        this.dispatchThawSelfOnly(sparseArray);
    }

    @Override
    protected void dispatchSaveInstanceState(SparseArray<Parcelable> sparseArray) {
        this.dispatchFreezeSelfOnly(sparseArray);
    }

    /*
     * Unable to fully structure code
     */
    int findSyncPosition() {
        var1_1 = this.mItemCount;
        if (var1_1 == 0) {
            var6_2 = -1;
            return var6_2;
        }
        var2_3 = this.mSyncRowId;
        var4_4 = this.mSyncPosition;
        if (var2_3 == -9223372036854775808L) {
            return -1;
        }
        var5_5 = Math.max(0, var4_4);
        var6_2 = Math.min(var1_1 - 1, var5_5);
        var7_6 = 100L + SystemClock.uptimeMillis();
        var9_7 = var6_2;
        var10_8 = var6_2;
        var11_9 = this.getAdapter();
        var12_10 = false;
        if (var11_9 != null) ** GOTO lbl22
        return -1;
        block1: while (var14_12 || var12_10 && !var13_11) {
            var6_2 = ++var10_8;
            var12_10 = false;
lbl22:
            // 4 sources

            while (true) {
                block8: {
                    block7: {
                        if (SystemClock.uptimeMillis() > var7_6) ** GOTO lbl-1000
                        if (var11_9.getItemId(var6_2) == var2_3) ** continue;
                        if (var10_8 != var1_1 - 1) break block7;
                        var13_11 = true;
lbl27:
                        // 2 sources

                        while (var9_7 == 0) {
                            var14_12 = true;
lbl29:
                            // 2 sources

                            while (var13_11 && var14_12) lbl-1000:
                            // 2 sources

                            {
                                return -1;
                            }
                            continue block1;
                        }
                        break block8;
                    }
                    var13_11 = false;
                    ** GOTO lbl27
                }
                var14_12 = false;
                ** GOTO lbl29
                break;
            }
        }
        if (!var13_11 && (var12_10 || var14_12)) ** GOTO lbl22
        var6_2 = --var9_7;
        var12_10 = true;
        ** while (true)
    }

    public abstract T getAdapter();

    @ViewDebug.CapturedViewProperty
    public int getCount() {
        return this.mItemCount;
    }

    public View getEmptyView() {
        return this.mEmptyView;
    }

    public int getFirstVisiblePosition() {
        return this.mFirstPosition;
    }

    public Object getItemAtPosition(int n) {
        T t = this.getAdapter();
        if (t == null || n < 0) {
            return null;
        }
        return t.getItem(n);
    }

    public long getItemIdAtPosition(int n) {
        T t = this.getAdapter();
        if (t == null || n < 0) {
            return Long.MIN_VALUE;
        }
        return t.getItemId(n);
    }

    public int getLastVisiblePosition() {
        return -1 + (this.mFirstPosition + this.getChildCount());
    }

    public final OnItemClickListener getOnItemClickListener() {
        return this.mOnItemClickListener;
    }

    public final OnItemLongClickListener getOnItemLongClickListener() {
        return this.mOnItemLongClickListener;
    }

    public final OnItemSelectedListener getOnItemSelectedListener() {
        return this.mOnItemSelectedListener;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public int getPositionForView(View view) {
        View view2 = view;
        try {
            View view3;
            boolean bl;
            while (!(bl = (view3 = (View)((Object)view2.getParent())).equals(this))) {
                view2 = view3;
            }
        }
        catch (ClassCastException classCastException) {
            return -1;
        }
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.getChildAt(n2).equals(view2)) {
                return n2 + this.mFirstPosition;
            }
            ++n2;
        }
        return -1;
    }

    public Object getSelectedItem() {
        T t = this.getAdapter();
        int n = this.getSelectedItemPosition();
        if (t != null && t.getCount() > 0 && n >= 0) {
            return t.getItem(n);
        }
        return null;
    }

    @ViewDebug.CapturedViewProperty
    public long getSelectedItemId() {
        return this.mNextSelectedRowId;
    }

    @ViewDebug.CapturedViewProperty
    public int getSelectedItemPosition() {
        return this.mNextSelectedPosition;
    }

    public abstract View getSelectedView();

    void handleDataChanged() {
        int n = this.mItemCount;
        boolean bl = false;
        if (n > 0) {
            boolean bl2 = this.mNeedSync;
            bl = false;
            if (bl2) {
                this.mNeedSync = false;
                int n2 = this.findSyncPosition();
                bl = false;
                if (n2 >= 0) {
                    int n3 = this.lookForSelectablePosition(n2, true);
                    bl = false;
                    if (n3 == n2) {
                        this.setNextSelectedPositionInt(n2);
                        bl = true;
                    }
                }
            }
            if (!bl) {
                int n4;
                int n5 = this.getSelectedItemPosition();
                if (n5 >= n) {
                    n5 = n - 1;
                }
                if (n5 < 0) {
                    n5 = 0;
                }
                if ((n4 = this.lookForSelectablePosition(n5, true)) < 0) {
                    n4 = this.lookForSelectablePosition(n5, false);
                }
                if (n4 >= 0) {
                    this.setNextSelectedPositionInt(n4);
                    this.checkSelectionChanged();
                    bl = true;
                }
            }
        }
        if (!bl) {
            this.mSelectedPosition = -1;
            this.mSelectedRowId = Long.MIN_VALUE;
            this.mNextSelectedPosition = -1;
            this.mNextSelectedRowId = Long.MIN_VALUE;
            this.mNeedSync = false;
            this.checkSelectionChanged();
        }
        this.notifySubtreeAccessibilityStateChangedIfNeeded();
    }

    boolean isInFilterMode() {
        return false;
    }

    int lookForSelectablePosition(int n, boolean bl) {
        return n;
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeCallbacks(this.mSelectionNotifier);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(AdapterView.class.getName());
        accessibilityEvent.setScrollable(this.isScrollableForAccessibility());
        View view = this.getSelectedView();
        if (view != null) {
            accessibilityEvent.setEnabled(view.isEnabled());
        }
        accessibilityEvent.setCurrentItemIndex(this.getSelectedItemPosition());
        accessibilityEvent.setFromIndex(this.getFirstVisiblePosition());
        accessibilityEvent.setToIndex(this.getLastVisiblePosition());
        accessibilityEvent.setItemCount(this.getCount());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(AdapterView.class.getName());
        accessibilityNodeInfo.setScrollable(this.isScrollableForAccessibility());
        View view = this.getSelectedView();
        if (view != null) {
            accessibilityNodeInfo.setEnabled(view.isEnabled());
        }
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        this.mLayoutHeight = this.getHeight();
    }

    @Override
    public boolean onRequestSendAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
        if (super.onRequestSendAccessibilityEvent(view, accessibilityEvent)) {
            AccessibilityEvent accessibilityEvent2 = AccessibilityEvent.obtain();
            this.onInitializeAccessibilityEvent(accessibilityEvent2);
            view.dispatchPopulateAccessibilityEvent(accessibilityEvent2);
            accessibilityEvent.appendRecord(accessibilityEvent2);
            return true;
        }
        return false;
    }

    public boolean performItemClick(View view, int n, long l) {
        OnItemClickListener onItemClickListener = this.mOnItemClickListener;
        boolean bl = false;
        if (onItemClickListener != null) {
            this.playSoundEffect(0);
            this.mOnItemClickListener.onItemClick(this, view, n, l);
            if (view != null) {
                view.sendAccessibilityEvent(1);
            }
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    void rememberSyncState() {
        block6: {
            block5: {
                if (this.getChildCount() <= 0) break block5;
                this.mNeedSync = true;
                this.mSyncHeight = this.mLayoutHeight;
                if (this.mSelectedPosition < 0) break block6;
                View view = this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
                this.mSyncRowId = this.mNextSelectedRowId;
                this.mSyncPosition = this.mNextSelectedPosition;
                if (view != null) {
                    this.mSpecificTop = view.getTop();
                }
                this.mSyncMode = 0;
            }
            return;
        }
        View view = this.getChildAt(0);
        T t = this.getAdapter();
        this.mSyncRowId = this.mFirstPosition >= 0 && this.mFirstPosition < t.getCount() ? t.getItemId(this.mFirstPosition) : -1L;
        this.mSyncPosition = this.mFirstPosition;
        if (view != null) {
            this.mSpecificTop = view.getTop();
        }
        this.mSyncMode = 1;
    }

    @Override
    public void removeAllViews() {
        throw new UnsupportedOperationException("removeAllViews() is not supported in AdapterView");
    }

    @Override
    public void removeView(View view) {
        throw new UnsupportedOperationException("removeView(View) is not supported in AdapterView");
    }

    @Override
    public void removeViewAt(int n) {
        throw new UnsupportedOperationException("removeViewAt(int) is not supported in AdapterView");
    }

    void selectionChanged() {
        block5: {
            block4: {
                if (this.mOnItemSelectedListener == null && !AccessibilityManager.getInstance(this.mContext).isEnabled()) break block4;
                if (!this.mInLayout && !this.mBlockLayoutRequests) break block5;
                if (this.mSelectionNotifier == null) {
                    this.mSelectionNotifier = new SelectionNotifier();
                }
                this.post(this.mSelectionNotifier);
            }
            return;
        }
        this.fireOnSelected();
        this.performAccessibilityActionsOnSelected();
    }

    public abstract void setAdapter(T var1);

    /*
     * Enabled aggressive block sorting
     */
    @RemotableViewMethod
    public void setEmptyView(View view) {
        T t;
        boolean bl = true;
        this.mEmptyView = view;
        if (view != null && view.getImportantForAccessibility() == 0) {
            view.setImportantForAccessibility(bl ? 1 : 0);
        }
        if ((t = this.getAdapter()) != null && !t.isEmpty()) {
            bl = false;
        }
        this.updateEmptyStatus(bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setFocusable(boolean bl) {
        boolean bl2 = true;
        T t = this.getAdapter();
        boolean bl3 = t == null || t.getCount() == 0 ? bl2 : false;
        this.mDesiredFocusableState = bl;
        if (!bl) {
            this.mDesiredFocusableInTouchModeState = false;
        }
        if (!bl || bl3 && !this.isInFilterMode()) {
            bl2 = false;
        }
        super.setFocusable(bl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setFocusableInTouchMode(boolean bl) {
        boolean bl2 = true;
        T t = this.getAdapter();
        boolean bl3 = t == null || t.getCount() == 0 ? bl2 : false;
        this.mDesiredFocusableInTouchModeState = bl;
        if (bl) {
            this.mDesiredFocusableState = bl2;
        }
        if (!bl || bl3 && !this.isInFilterMode()) {
            bl2 = false;
        }
        super.setFocusableInTouchMode(bl2);
    }

    void setNextSelectedPositionInt(int n) {
        this.mNextSelectedPosition = n;
        this.mNextSelectedRowId = this.getItemIdAtPosition(n);
        if (this.mNeedSync && this.mSyncMode == 0 && n >= 0) {
            this.mSyncPosition = n;
            this.mSyncRowId = this.mNextSelectedRowId;
        }
    }

    @Override
    public void setOnClickListener(View.OnClickListener onClickListener) {
        throw new RuntimeException("Don't call setOnClickListener for an AdapterView. You probably want setOnItemClickListener instead");
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    public void setOnItemLongClickListener(OnItemLongClickListener onItemLongClickListener) {
        if (!this.isLongClickable()) {
            this.setLongClickable(true);
        }
        this.mOnItemLongClickListener = onItemLongClickListener;
    }

    public void setOnItemSelectedListener(OnItemSelectedListener onItemSelectedListener) {
        this.mOnItemSelectedListener = onItemSelectedListener;
    }

    void setSelectedPositionInt(int n) {
        this.mSelectedPosition = n;
        this.mSelectedRowId = this.getItemIdAtPosition(n);
    }

    public abstract void setSelection(int var1);

    public static class AdapterContextMenuInfo
    implements ContextMenu.ContextMenuInfo {
        public long id;
        public int position;
        public View targetView;

        public AdapterContextMenuInfo(View view, int n, long l) {
            this.targetView = view;
            this.position = n;
            this.id = l;
        }
    }

    class AdapterDataSetObserver
    extends DataSetObserver {
        private Parcelable mInstanceState = null;

        AdapterDataSetObserver() {
        }

        public void clearSavedState() {
            this.mInstanceState = null;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onChanged() {
            AdapterView.this.mDataChanged = true;
            AdapterView.this.mOldItemCount = AdapterView.this.mItemCount;
            AdapterView.this.mItemCount = AdapterView.this.getAdapter().getCount();
            if (AdapterView.this.getAdapter().hasStableIds() && this.mInstanceState != null && AdapterView.this.mOldItemCount == 0 && AdapterView.this.mItemCount > 0) {
                AdapterView.this.onRestoreInstanceState(this.mInstanceState);
                this.mInstanceState = null;
            } else {
                AdapterView.this.rememberSyncState();
            }
            AdapterView.this.checkFocus();
            AdapterView.this.requestLayout();
        }

        @Override
        public void onInvalidated() {
            AdapterView.this.mDataChanged = true;
            if (AdapterView.this.getAdapter().hasStableIds()) {
                this.mInstanceState = AdapterView.this.onSaveInstanceState();
            }
            AdapterView.this.mOldItemCount = AdapterView.this.mItemCount;
            AdapterView.this.mItemCount = 0;
            AdapterView.this.mSelectedPosition = -1;
            AdapterView.this.mSelectedRowId = Long.MIN_VALUE;
            AdapterView.this.mNextSelectedPosition = -1;
            AdapterView.this.mNextSelectedRowId = Long.MIN_VALUE;
            AdapterView.this.mNeedSync = false;
            AdapterView.this.checkFocus();
            AdapterView.this.requestLayout();
        }
    }

    public static interface OnItemClickListener {
        public void onItemClick(AdapterView<?> var1, View var2, int var3, long var4);
    }

    public static interface OnItemLongClickListener {
        public boolean onItemLongClick(AdapterView<?> var1, View var2, int var3, long var4);
    }

    public static interface OnItemSelectedListener {
        public void onItemSelected(AdapterView<?> var1, View var2, int var3, long var4);

        public void onNothingSelected(AdapterView<?> var1);
    }

    private class SelectionNotifier
    implements Runnable {
        private SelectionNotifier() {
        }

        @Override
        public void run() {
            if (AdapterView.this.mDataChanged) {
                if (AdapterView.this.getAdapter() != null) {
                    AdapterView.this.post(this);
                }
                return;
            }
            AdapterView.this.fireOnSelected();
            AdapterView.this.performAccessibilityActionsOnSelected();
        }
    }
}

