/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.provider.Settings;
import android.text.format.DateFormat;
import android.text.format.Time;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.widget.RemoteViews;
import android.widget.TextView;
import java.text.SimpleDateFormat;
import java.util.Date;

@RemoteViews.RemoteView
public class DateTimeView
extends TextView {
    private static final int SHOW_MONTH_DAY_YEAR = 1;
    private static final int SHOW_TIME = 0;
    private static final String TAG = "DateTimeView";
    private static final long TWELVE_HOURS_IN_MINUTES = 720L;
    private static final long TWENTY_FOUR_HOURS_IN_MILLIS = 86400000L;
    private boolean mAttachedToWindow;
    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.TIME_TICK".equals(intent.getAction()) && System.currentTimeMillis() < DateTimeView.this.mUpdateTimeMillis) {
                return;
            }
            DateTimeView.this.mLastFormat = null;
            DateTimeView.this.update();
        }
    };
    private ContentObserver mContentObserver = new ContentObserver(new Handler()){

        @Override
        public void onChange(boolean bl) {
            DateTimeView.this.mLastFormat = null;
            DateTimeView.this.update();
        }
    };
    int mLastDisplay = -1;
    java.text.DateFormat mLastFormat;
    Date mTime;
    long mTimeMillis;
    private long mUpdateTimeMillis;

    public DateTimeView(Context context) {
        super(context);
    }

    public DateTimeView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    private java.text.DateFormat getDateFormat() {
        String string2 = Settings.System.getString(this.getContext().getContentResolver(), "date_format");
        if (string2 == null || "".equals(string2)) {
            return java.text.DateFormat.getDateInstance(3);
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            return simpleDateFormat;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return java.text.DateFormat.getDateInstance(3);
        }
    }

    private java.text.DateFormat getTimeFormat() {
        return DateFormat.getTimeFormat(this.getContext());
    }

    private void registerReceivers() {
        Context context = this.getContext();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.TIME_TICK");
        intentFilter.addAction("android.intent.action.TIME_SET");
        intentFilter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        intentFilter.addAction("android.intent.action.TIMEZONE_CHANGED");
        context.registerReceiver(this.mBroadcastReceiver, intentFilter);
        Uri uri = Settings.System.getUriFor("date_format");
        context.getContentResolver().registerContentObserver(uri, true, this.mContentObserver);
    }

    private void unregisterReceivers() {
        Context context = this.getContext();
        context.unregisterReceiver(this.mBroadcastReceiver);
        context.getContentResolver().unregisterContentObserver(this.mContentObserver);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.registerReceivers();
        this.mAttachedToWindow = true;
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.unregisterReceivers();
        this.mAttachedToWindow = false;
    }

    @RemotableViewMethod
    public void setTime(long l) {
        Time time = new Time();
        time.set(l);
        time.second = 0;
        this.mTimeMillis = time.toMillis(false);
        this.mTime = new Date(-1900 + time.year, time.month, time.monthDay, time.hour, time.minute, 0);
        this.update();
    }

    /*
     * Enabled aggressive block sorting
     */
    void update() {
        java.text.DateFormat dateFormat;
        if (this.mTime == null) {
            return;
        }
        System.nanoTime();
        Time time = new Time();
        time.set(this.mTimeMillis);
        time.second = 0;
        time.hour = -12 + time.hour;
        long l = time.toMillis(false);
        time.hour = 12 + time.hour;
        long l2 = time.toMillis(false);
        time.hour = 0;
        time.minute = 0;
        long l3 = time.toMillis(false);
        time.monthDay = 1 + time.monthDay;
        long l4 = time.toMillis(false);
        time.set(System.currentTimeMillis());
        time.second = 0;
        long l5 = time.normalize(false);
        int n = l5 >= l3 && l5 < l4 || l5 >= l && l5 < l2 ? 0 : 1;
        if (n == this.mLastDisplay && this.mLastFormat != null) {
            dateFormat = this.mLastFormat;
        } else {
            switch (n) {
                default: {
                    RuntimeException runtimeException = new RuntimeException("unknown display value: " + n);
                    throw runtimeException;
                }
                case 0: {
                    dateFormat = this.getTimeFormat();
                    break;
                }
                case 1: {
                    dateFormat = this.getDateFormat();
                }
            }
            this.mLastFormat = dateFormat;
        }
        this.setText(dateFormat.format(this.mTime));
        if (n == 0) {
            if (l2 <= l4) {
                l2 = l4;
            }
            this.mUpdateTimeMillis = l2;
        } else if (this.mTimeMillis < l5) {
            this.mUpdateTimeMillis = 0L;
        } else {
            if (l >= l3) {
                l = l3;
            }
            this.mUpdateTimeMillis = l;
        }
        System.nanoTime();
    }
}

