/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.RemoteViews;
import com.android.internal.R;
import java.util.ArrayList;

@RemoteViews.RemoteView
public class FrameLayout
extends ViewGroup {
    private static final int DEFAULT_CHILD_GRAVITY = 0x800033;
    @ViewDebug.ExportedProperty(category="drawing")
    private Drawable mForeground;
    boolean mForegroundBoundsChanged = false;
    @ViewDebug.ExportedProperty(category="drawing")
    private int mForegroundGravity = 119;
    @ViewDebug.ExportedProperty(category="drawing")
    protected boolean mForegroundInPadding = true;
    @ViewDebug.ExportedProperty(category="padding")
    private int mForegroundPaddingBottom = 0;
    @ViewDebug.ExportedProperty(category="padding")
    private int mForegroundPaddingLeft = 0;
    @ViewDebug.ExportedProperty(category="padding")
    private int mForegroundPaddingRight = 0;
    @ViewDebug.ExportedProperty(category="padding")
    private int mForegroundPaddingTop = 0;
    private ColorStateList mForegroundTintList = null;
    private PorterDuff.Mode mForegroundTintMode = null;
    private boolean mHasForegroundTint = false;
    private boolean mHasForegroundTintMode = false;
    private final ArrayList<View> mMatchParentChildren;
    @ViewDebug.ExportedProperty(category="measurement")
    boolean mMeasureAllChildren = false;
    private final Rect mOverlayBounds;
    private final Rect mSelfBounds = new Rect();

    public FrameLayout(Context context) {
        super(context);
        this.mOverlayBounds = new Rect();
        this.mMatchParentChildren = new ArrayList(1);
    }

    public FrameLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public FrameLayout(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public FrameLayout(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.mOverlayBounds = new Rect();
        this.mMatchParentChildren = new ArrayList(1);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.FrameLayout, n, n2);
        this.mForegroundGravity = typedArray.getInt(2, this.mForegroundGravity);
        Drawable drawable2 = typedArray.getDrawable(0);
        if (drawable2 != null) {
            this.setForeground(drawable2);
        }
        if (typedArray.getBoolean(1, false)) {
            this.setMeasureAllChildren(true);
        }
        if (typedArray.hasValue(4)) {
            this.mForegroundTintMode = Drawable.parseTintMode(typedArray.getInt(4, -1), this.mForegroundTintMode);
            this.mHasForegroundTintMode = true;
        }
        if (typedArray.hasValue(3)) {
            this.mForegroundTintList = typedArray.getColorStateList(3);
            this.mHasForegroundTint = true;
        }
        this.mForegroundInPadding = typedArray.getBoolean(5, true);
        typedArray.recycle();
        this.applyForegroundTint();
    }

    private void applyForegroundTint() {
        if (this.mForeground != null && (this.mHasForegroundTint || this.mHasForegroundTintMode)) {
            this.mForeground = this.mForeground.mutate();
            if (this.mHasForegroundTint) {
                this.mForeground.setTintList(this.mForegroundTintList);
            }
            if (this.mHasForegroundTintMode) {
                this.mForeground.setTintMode(this.mForegroundTintMode);
            }
        }
    }

    private int getPaddingBottomWithForeground() {
        if (this.mForegroundInPadding) {
            return Math.max(this.mPaddingBottom, this.mForegroundPaddingBottom);
        }
        return this.mPaddingBottom + this.mForegroundPaddingBottom;
    }

    private int getPaddingTopWithForeground() {
        if (this.mForegroundInPadding) {
            return Math.max(this.mPaddingTop, this.mForegroundPaddingTop);
        }
        return this.mPaddingTop + this.mForegroundPaddingTop;
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mForeground != null) {
            Drawable drawable2 = this.mForeground;
            if (this.mForegroundBoundsChanged) {
                this.mForegroundBoundsChanged = false;
                Rect rect = this.mSelfBounds;
                Rect rect2 = this.mOverlayBounds;
                int n = this.mRight - this.mLeft;
                int n2 = this.mBottom - this.mTop;
                if (this.mForegroundInPadding) {
                    rect.set(0, 0, n, n2);
                } else {
                    rect.set(this.mPaddingLeft, this.mPaddingTop, n - this.mPaddingRight, n2 - this.mPaddingBottom);
                }
                int n3 = this.getLayoutDirection();
                Gravity.apply(this.mForegroundGravity, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight(), rect, rect2, n3);
                drawable2.setBounds(rect2);
            }
            drawable2.draw(canvas);
        }
    }

    @Override
    public void drawableHotspotChanged(float f, float f2) {
        super.drawableHotspotChanged(f, f2);
        if (this.mForeground != null) {
            this.mForeground.setHotspot(f, f2);
        }
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mForeground != null && this.mForeground.isStateful()) {
            this.mForeground.setState(this.getDrawableState());
        }
    }

    @Override
    public boolean gatherTransparentRegion(Region region) {
        boolean bl = super.gatherTransparentRegion(region);
        if (region != null && this.mForeground != null) {
            this.applyDrawableToTransparentRegion(this.mForeground, region);
        }
        return bl;
    }

    @Override
    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    @Override
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    @Deprecated
    public boolean getConsiderGoneChildrenWhenMeasuring() {
        return this.getMeasureAllChildren();
    }

    public Drawable getForeground() {
        return this.mForeground;
    }

    public int getForegroundGravity() {
        return this.mForegroundGravity;
    }

    public ColorStateList getForegroundTintList() {
        return this.mForegroundTintList;
    }

    public PorterDuff.Mode getForegroundTintMode() {
        return this.mForegroundTintMode;
    }

    public boolean getMeasureAllChildren() {
        return this.mMeasureAllChildren;
    }

    int getPaddingLeftWithForeground() {
        if (this.mForegroundInPadding) {
            return Math.max(this.mPaddingLeft, this.mForegroundPaddingLeft);
        }
        return this.mPaddingLeft + this.mForegroundPaddingLeft;
    }

    int getPaddingRightWithForeground() {
        if (this.mForegroundInPadding) {
            return Math.max(this.mPaddingRight, this.mForegroundPaddingRight);
        }
        return this.mPaddingRight + this.mForegroundPaddingRight;
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mForeground != null) {
            this.mForeground.jumpToCurrentState();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void layoutChildren(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = this.getChildCount();
        int n6 = this.getPaddingLeftWithForeground();
        int n7 = n3 - n - this.getPaddingRightWithForeground();
        int n8 = this.getPaddingTopWithForeground();
        int n9 = n4 - n2 - this.getPaddingBottomWithForeground();
        this.mForegroundBoundsChanged = true;
        int n10 = 0;
        while (true) {
            block12: {
                int n11;
                int n12;
                int n13;
                int n14;
                int n15;
                LayoutParams layoutParams;
                View view;
                block13: {
                    if (n10 >= n5) {
                        return;
                    }
                    view = this.getChildAt(n10);
                    if (view.getVisibility() == 8) break block12;
                    layoutParams = (LayoutParams)view.getLayoutParams();
                    n15 = view.getMeasuredWidth();
                    n14 = view.getMeasuredHeight();
                    int n16 = layoutParams.gravity;
                    if (n16 == -1) {
                        n16 = 0x800033;
                    }
                    int n17 = Gravity.getAbsoluteGravity(n16, this.getLayoutDirection());
                    n13 = n16 & 0x70;
                    switch (n17 & 7) {
                        default: {
                            break;
                        }
                        case 1: {
                            n12 = n6 + (n7 - n6 - n15) / 2 + layoutParams.leftMargin - layoutParams.rightMargin;
                            break block13;
                        }
                        case 5: {
                            if (bl) break;
                            n12 = n7 - n15 - layoutParams.rightMargin;
                            break block13;
                        }
                    }
                    n12 = n6 + layoutParams.leftMargin;
                }
                switch (n13) {
                    default: {
                        n11 = n8 + layoutParams.topMargin;
                        break;
                    }
                    case 48: {
                        n11 = n8 + layoutParams.topMargin;
                        break;
                    }
                    case 16: {
                        n11 = n8 + (n9 - n8 - n14) / 2 + layoutParams.topMargin - layoutParams.bottomMargin;
                        break;
                    }
                    case 80: {
                        n11 = n9 - n14 - layoutParams.bottomMargin;
                    }
                }
                view.layout(n12, n11, n12 + n15, n11 + n14);
            }
            ++n10;
        }
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(FrameLayout.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(FrameLayout.class.getName());
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        this.layoutChildren(n, n2, n3, n4, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3 = this.getChildCount();
        boolean bl = View.MeasureSpec.getMode(n) != 0x40000000 || View.MeasureSpec.getMode(n2) != 0x40000000;
        this.mMatchParentChildren.clear();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n3; ++i) {
            View view = this.getChildAt(i);
            if (!this.mMeasureAllChildren && view.getVisibility() == 8) continue;
            this.measureChildWithMargins(view, n, 0, n2, 0);
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            n5 = Math.max(n5, view.getMeasuredWidth() + layoutParams.leftMargin + layoutParams.rightMargin);
            n4 = Math.max(n4, view.getMeasuredHeight() + layoutParams.topMargin + layoutParams.bottomMargin);
            n6 = FrameLayout.combineMeasuredStates(n6, view.getMeasuredState());
            if (!bl || layoutParams.width != -1 && layoutParams.height != -1) continue;
            this.mMatchParentChildren.add(view);
        }
        int n7 = n5 + (this.getPaddingLeftWithForeground() + this.getPaddingRightWithForeground());
        int n8 = Math.max(n4 + (this.getPaddingTopWithForeground() + this.getPaddingBottomWithForeground()), this.getSuggestedMinimumHeight());
        int n9 = Math.max(n7, this.getSuggestedMinimumWidth());
        Drawable drawable2 = this.getForeground();
        if (drawable2 != null) {
            n8 = Math.max(n8, drawable2.getMinimumHeight());
            n9 = Math.max(n9, drawable2.getMinimumWidth());
        }
        this.setMeasuredDimension(FrameLayout.resolveSizeAndState(n9, n, n6), FrameLayout.resolveSizeAndState(n8, n2, n6 << 16));
        int n10 = this.mMatchParentChildren.size();
        if (n10 > 1) {
            for (int i = 0; i < n10; ++i) {
                View view = this.mMatchParentChildren.get(i);
                ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
                int n11 = marginLayoutParams.width == -1 ? View.MeasureSpec.makeMeasureSpec(this.getMeasuredWidth() - this.getPaddingLeftWithForeground() - this.getPaddingRightWithForeground() - marginLayoutParams.leftMargin - marginLayoutParams.rightMargin, 0x40000000) : FrameLayout.getChildMeasureSpec(n, this.getPaddingLeftWithForeground() + this.getPaddingRightWithForeground() + marginLayoutParams.leftMargin + marginLayoutParams.rightMargin, marginLayoutParams.width);
                int n12 = marginLayoutParams.height == -1 ? View.MeasureSpec.makeMeasureSpec(this.getMeasuredHeight() - this.getPaddingTopWithForeground() - this.getPaddingBottomWithForeground() - marginLayoutParams.topMargin - marginLayoutParams.bottomMargin, 0x40000000) : FrameLayout.getChildMeasureSpec(n2, this.getPaddingTopWithForeground() + this.getPaddingBottomWithForeground() + marginLayoutParams.topMargin + marginLayoutParams.bottomMargin, marginLayoutParams.height);
                view.measure(n11, n12);
            }
        }
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.mForegroundBoundsChanged = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setForeground(Drawable drawable2) {
        if (this.mForeground != drawable2) {
            if (this.mForeground != null) {
                this.mForeground.setCallback(null);
                this.unscheduleDrawable(this.mForeground);
            }
            this.mForeground = drawable2;
            this.mForegroundPaddingLeft = 0;
            this.mForegroundPaddingTop = 0;
            this.mForegroundPaddingRight = 0;
            this.mForegroundPaddingBottom = 0;
            if (drawable2 != null) {
                Rect rect;
                this.setWillNotDraw(false);
                drawable2.setCallback(this);
                drawable2.setLayoutDirection(this.getLayoutDirection());
                if (drawable2.isStateful()) {
                    drawable2.setState(this.getDrawableState());
                }
                this.applyForegroundTint();
                if (this.mForegroundGravity == 119 && drawable2.getPadding(rect = new Rect())) {
                    this.mForegroundPaddingLeft = rect.left;
                    this.mForegroundPaddingTop = rect.top;
                    this.mForegroundPaddingRight = rect.right;
                    this.mForegroundPaddingBottom = rect.bottom;
                }
            } else {
                this.setWillNotDraw(true);
            }
            this.requestLayout();
            this.invalidate();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @RemotableViewMethod
    public void setForegroundGravity(int n) {
        if (this.mForegroundGravity != n) {
            if ((0x800007 & n) == 0) {
                n |= 0x800003;
            }
            if ((n & 0x70) == 0) {
                n |= 0x30;
            }
            this.mForegroundGravity = n;
            if (this.mForegroundGravity == 119 && this.mForeground != null) {
                Rect rect = new Rect();
                if (this.mForeground.getPadding(rect)) {
                    this.mForegroundPaddingLeft = rect.left;
                    this.mForegroundPaddingTop = rect.top;
                    this.mForegroundPaddingRight = rect.right;
                    this.mForegroundPaddingBottom = rect.bottom;
                }
            } else {
                this.mForegroundPaddingLeft = 0;
                this.mForegroundPaddingTop = 0;
                this.mForegroundPaddingRight = 0;
                this.mForegroundPaddingBottom = 0;
            }
            this.requestLayout();
        }
    }

    public void setForegroundTintList(ColorStateList colorStateList) {
        this.mForegroundTintList = colorStateList;
        this.mHasForegroundTint = true;
        this.applyForegroundTint();
    }

    public void setForegroundTintMode(PorterDuff.Mode mode) {
        this.mForegroundTintMode = mode;
        this.mHasForegroundTintMode = true;
        this.applyForegroundTint();
    }

    @RemotableViewMethod
    public void setMeasureAllChildren(boolean bl) {
        this.mMeasureAllChildren = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @RemotableViewMethod
    public void setVisibility(int n) {
        super.setVisibility(n);
        if (this.mForeground != null) {
            Drawable drawable2 = this.mForeground;
            boolean bl = n == 0;
            drawable2.setVisible(bl, false);
        }
    }

    @Override
    public boolean shouldDelayChildPressedState() {
        return false;
    }

    @Override
    protected boolean verifyDrawable(Drawable drawable2) {
        return super.verifyDrawable(drawable2) || drawable2 == this.mForeground;
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public int gravity = -1;

        public LayoutParams(int n, int n2) {
            super(n, n2);
        }

        public LayoutParams(int n, int n2, int n3) {
            super(n, n2);
            this.gravity = n3;
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.FrameLayout_Layout);
            this.gravity = typedArray.getInt(0, -1);
            typedArray.recycle();
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }

        public LayoutParams(LayoutParams layoutParams) {
            super(layoutParams);
            this.gravity = layoutParams.gravity;
        }
    }
}

