/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.view.View;
import android.widget.ImageView;
import android.widget.ResourceCursorTreeAdapter;
import android.widget.TextView;

public abstract class SimpleCursorTreeAdapter
extends ResourceCursorTreeAdapter {
    private int[] mChildFrom;
    private String[] mChildFromNames;
    private int[] mChildTo;
    private int[] mGroupFrom;
    private String[] mGroupFromNames;
    private int[] mGroupTo;
    private ViewBinder mViewBinder;

    public SimpleCursorTreeAdapter(Context context, Cursor cursor, int n, int n2, String[] stringArray, int[] nArray, int n3, int n4, String[] stringArray2, int[] nArray2) {
        super(context, cursor, n, n2, n3, n4);
        this.init(stringArray, nArray, stringArray2, nArray2);
    }

    public SimpleCursorTreeAdapter(Context context, Cursor cursor, int n, int n2, String[] stringArray, int[] nArray, int n3, String[] stringArray2, int[] nArray2) {
        super(context, cursor, n, n2, n3);
        this.init(stringArray, nArray, stringArray2, nArray2);
    }

    public SimpleCursorTreeAdapter(Context context, Cursor cursor, int n, String[] stringArray, int[] nArray, int n2, String[] stringArray2, int[] nArray2) {
        super(context, cursor, n, n2);
        this.init(stringArray, nArray, stringArray2, nArray2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void bindView(View view, Context context, Cursor cursor, int[] nArray, int[] nArray2) {
        ViewBinder viewBinder = this.mViewBinder;
        int n = 0;
        while (n < nArray2.length) {
            View view2 = view.findViewById(nArray2[n]);
            if (view2 != null) {
                boolean bl = false;
                if (viewBinder != null) {
                    bl = viewBinder.setViewValue(view2, cursor, nArray[n]);
                }
                if (!bl) {
                    String string2 = cursor.getString(nArray[n]);
                    if (string2 == null) {
                        string2 = "";
                    }
                    if (view2 instanceof TextView) {
                        this.setViewText((TextView)view2, string2);
                    } else {
                        if (!(view2 instanceof ImageView)) {
                            throw new IllegalStateException("SimpleCursorTreeAdapter can bind values only to TextView and ImageView!");
                        }
                        this.setViewImage((ImageView)view2, string2);
                    }
                }
            }
            ++n;
        }
        return;
    }

    private void init(String[] stringArray, int[] nArray, String[] stringArray2, int[] nArray2) {
        this.mGroupFromNames = stringArray;
        this.mGroupTo = nArray;
        this.mChildFromNames = stringArray2;
        this.mChildTo = nArray2;
    }

    private void initFromColumns(Cursor cursor, String[] stringArray, int[] nArray) {
        for (int i = -1 + stringArray.length; i >= 0; --i) {
            nArray[i] = cursor.getColumnIndexOrThrow(stringArray[i]);
        }
    }

    @Override
    protected void bindChildView(View view, Context context, Cursor cursor, boolean bl) {
        if (this.mChildFrom == null) {
            this.mChildFrom = new int[this.mChildFromNames.length];
            this.initFromColumns(cursor, this.mChildFromNames, this.mChildFrom);
        }
        this.bindView(view, context, cursor, this.mChildFrom, this.mChildTo);
    }

    @Override
    protected void bindGroupView(View view, Context context, Cursor cursor, boolean bl) {
        if (this.mGroupFrom == null) {
            this.mGroupFrom = new int[this.mGroupFromNames.length];
            this.initFromColumns(cursor, this.mGroupFromNames, this.mGroupFrom);
        }
        this.bindView(view, context, cursor, this.mGroupFrom, this.mGroupTo);
    }

    public ViewBinder getViewBinder() {
        return this.mViewBinder;
    }

    public void setViewBinder(ViewBinder viewBinder) {
        this.mViewBinder = viewBinder;
    }

    protected void setViewImage(ImageView imageView, String string2) {
        try {
            imageView.setImageResource(Integer.parseInt(string2));
            return;
        }
        catch (NumberFormatException numberFormatException) {
            imageView.setImageURI(Uri.parse(string2));
            return;
        }
    }

    public void setViewText(TextView textView, String string2) {
        textView.setText(string2);
    }

    public static interface ViewBinder {
        public boolean setViewValue(View var1, Cursor var2, int var3);
    }
}

