/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.RadialTimePickerView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.TimePicker;
import android.widget.TimePickerClockDelegate;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Locale;

class TimePickerSpinnerDelegate
extends TimePicker.AbstractTimePickerDelegate
implements RadialTimePickerView.OnValueSelectedListener {
    private static final int AM = 0;
    private static final int AMPM_INDEX = 2;
    private static final boolean DEFAULT_ENABLED_STATE = true;
    private static final int ENABLE_PICKER_INDEX = 3;
    private static final int HOURS_IN_HALF_DAY = 12;
    private static final int HOUR_INDEX = 0;
    private static final int MINUTE_INDEX = 1;
    private static final int PM = 1;
    private static final String TAG = "TimePickerDelegate";
    private boolean mAllowAutoAdvance;
    private int mAmKeyCode;
    private TextView mAmPmTextView;
    private String mAmText;
    private String mDeletedKeyFormat;
    private String mDoublePlaceholderText;
    private final View.OnFocusChangeListener mFocusListener;
    private View mHeaderView;
    private String mHourPickerDescription;
    private TextView mHourView;
    private boolean mInKbMode;
    private int mInitialHourOfDay;
    private int mInitialMinute;
    private boolean mIs24HourView;
    private boolean mIsEnabled = true;
    private final View.OnKeyListener mKeyListener;
    private Node mLegalTimesTree;
    private String mMinutePickerDescription;
    private TextView mMinuteView;
    private char mPlaceholderText;
    private int mPmKeyCode;
    private String mPmText;
    private RadialTimePickerView mRadialTimePickerView;
    private String mSelectHours;
    private String mSelectMinutes;
    private TextView mSeparatorView;
    private Calendar mTempCalendar;
    private ArrayList<Integer> mTypedTimes = new ArrayList();

    public TimePickerSpinnerDelegate(TimePicker timePicker, Context context, AttributeSet attributeSet, int n, int n2) {
        super(timePicker, context);
        View.OnFocusChangeListener onFocusChangeListener;
        View.OnKeyListener onKeyListener;
        this.mKeyListener = onKeyListener = new View.OnKeyListener(){

            @Override
            public boolean onKey(View view, int n, KeyEvent keyEvent) {
                if (keyEvent.getAction() == 1) {
                    return TimePickerSpinnerDelegate.this.processKeyUp(n);
                }
                return false;
            }
        };
        this.mFocusListener = onFocusChangeListener = new View.OnFocusChangeListener(){

            @Override
            public void onFocusChange(View view, boolean bl) {
                if (!bl && TimePickerSpinnerDelegate.this.mInKbMode && TimePickerSpinnerDelegate.this.isTypedTimeFullyLegal()) {
                    TimePickerSpinnerDelegate.this.finishKbMode();
                    if (TimePickerSpinnerDelegate.this.mOnTimeChangedListener != null) {
                        TimePickerSpinnerDelegate.this.mOnTimeChangedListener.onTimeChanged(TimePickerSpinnerDelegate.this.mDelegator, TimePickerSpinnerDelegate.this.mRadialTimePickerView.getCurrentHour(), TimePickerSpinnerDelegate.this.mRadialTimePickerView.getCurrentMinute());
                    }
                }
            }
        };
        TypedArray typedArray = this.mContext.obtainStyledAttributes(attributeSet, R.styleable.TimePicker, n, n2);
        LayoutInflater layoutInflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        Resources resources = this.mContext.getResources();
        this.mHourPickerDescription = resources.getString(17040998);
        this.mSelectHours = resources.getString(17041000);
        this.mMinutePickerDescription = resources.getString(17040999);
        this.mSelectMinutes = resources.getString(17041001);
        String[] stringArray = TimePickerClockDelegate.getAmPmStrings(context);
        this.mAmText = stringArray[0];
        this.mPmText = stringArray[1];
        View view = layoutInflater.inflate(typedArray.getResourceId(9, 17367291), null);
        this.mDelegator.addView(view);
        this.mHourView = (TextView)view.findViewById(16909280);
        this.mSeparatorView = (TextView)view.findViewById(16909281);
        this.mMinuteView = (TextView)view.findViewById(16909282);
        this.mAmPmTextView = (TextView)view.findViewById(16909283);
        int n3 = typedArray.getResourceId(1, 0);
        if (n3 != 0) {
            this.mHourView.setTextAppearance(context, n3);
            this.mSeparatorView.setTextAppearance(context, n3);
            this.mMinuteView.setTextAppearance(context, n3);
        }
        int n4 = typedArray.getColor(11, resources.getColor(17170669));
        this.mHourView.setTextColor(ColorStateList.addFirstIfMissing(this.mHourView.getTextColors(), 0x10100A1, n4));
        this.mMinuteView.setTextColor(ColorStateList.addFirstIfMissing(this.mMinuteView.getTextColors(), 0x10100A1, n4));
        int n5 = typedArray.getResourceId(2, 0);
        if (n5 != 0) {
            this.mAmPmTextView.setTextAppearance(context, n5);
        }
        this.mHeaderView = view.findViewById(16909279);
        this.mHeaderView.setBackground(typedArray.getDrawable(0));
        typedArray.recycle();
        this.mRadialTimePickerView = (RadialTimePickerView)view.findViewById(16909285);
        this.setupListeners();
        this.mAllowAutoAdvance = true;
        this.mDoublePlaceholderText = resources.getString(17041009);
        this.mDeletedKeyFormat = resources.getString(17041007);
        this.mPlaceholderText = this.mDoublePlaceholderText.charAt(0);
        this.mPmKeyCode = -1;
        this.mAmKeyCode = -1;
        this.generateLegalTimesTree();
        Calendar calendar = Calendar.getInstance(this.mCurrentLocale);
        this.initialize(calendar.get(11), calendar.get(12), false, 0);
    }

    private boolean addKeyIfLegal(int n) {
        if (this.mIs24HourView && this.mTypedTimes.size() == 4 || !this.mIs24HourView && this.isTypedTimeFullyLegal()) {
            return false;
        }
        this.mTypedTimes.add(n);
        if (!this.isTypedTimeLegalSoFar()) {
            this.deleteLastTypedKey();
            return false;
        }
        int n2 = this.getValFromKeyCode(n);
        RadialTimePickerView radialTimePickerView = this.mRadialTimePickerView;
        Object[] objectArray = new Object[]{n2};
        radialTimePickerView.announceForAccessibility(String.format("%d", objectArray));
        if (this.isTypedTimeFullyLegal()) {
            if (!this.mIs24HourView && this.mTypedTimes.size() <= 3) {
                this.mTypedTimes.add(-1 + this.mTypedTimes.size(), 7);
                this.mTypedTimes.add(-1 + this.mTypedTimes.size(), 7);
            }
            this.onValidationChanged(true);
        }
        return true;
    }

    private int computeMaxWidthOfNumbers(int n) {
        TextView textView = new TextView(this.mContext);
        textView.setTextAppearance(this.mContext, 16974879);
        textView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = new Object[]{i};
            textView.setText(String.format("%02d", objectArray));
            textView.measure(0, 0);
            n2 = Math.max(n2, textView.getMeasuredWidth());
        }
        return n2;
    }

    private int deleteLastTypedKey() {
        int n = this.mTypedTimes.remove(-1 + this.mTypedTimes.size());
        if (!this.isTypedTimeFullyLegal()) {
            this.onValidationChanged(false);
        }
        return n;
    }

    private void finishKbMode() {
        this.mInKbMode = false;
        if (!this.mTypedTimes.isEmpty()) {
            int[] nArray = this.getEnteredTime(null);
            this.mRadialTimePickerView.setCurrentHour(nArray[0]);
            this.mRadialTimePickerView.setCurrentMinute(nArray[1]);
            if (!this.mIs24HourView) {
                this.mRadialTimePickerView.setAmOrPm(nArray[2]);
            }
            this.mTypedTimes.clear();
        }
        this.updateDisplay(false);
        this.mRadialTimePickerView.setInputEnabled(true);
    }

    private void generateLegalTimesTree() {
        Node node;
        this.mLegalTimesTree = node = new Node(new int[0]);
        if (this.mIs24HourView) {
            Node node2 = new Node(7, 8, 9, 10, 11, 12);
            Node node3 = new Node(7, 8, 9, 10, 11, 12, 13, 14, 15, 16);
            node2.addChild(node3);
            Node node4 = new Node(7, 8);
            this.mLegalTimesTree.addChild(node4);
            Node node5 = new Node(7, 8, 9, 10, 11, 12);
            node4.addChild(node5);
            node5.addChild(node2);
            Node node6 = new Node(13, 14, 15, 16);
            node5.addChild(node6);
            Node node7 = new Node(13, 14, 15, 16);
            node4.addChild(node7);
            node7.addChild(node2);
            Node node8 = new Node(9);
            this.mLegalTimesTree.addChild(node8);
            Node node9 = new Node(7, 8, 9, 10);
            node8.addChild(node9);
            node9.addChild(node2);
            Node node10 = new Node(11, 12);
            node8.addChild(node10);
            node10.addChild(node3);
            Node node11 = new Node(10, 11, 12, 13, 14, 15, 16);
            this.mLegalTimesTree.addChild(node11);
            node11.addChild(node2);
            return;
        }
        int[] nArray = new int[]{this.getAmOrPmKeyCode(0), this.getAmOrPmKeyCode(1)};
        Node node12 = new Node(nArray);
        Node node13 = new Node(8);
        this.mLegalTimesTree.addChild(node13);
        node13.addChild(node12);
        Node node14 = new Node(7, 8, 9);
        node13.addChild(node14);
        node14.addChild(node12);
        Node node15 = new Node(7, 8, 9, 10, 11, 12);
        node14.addChild(node15);
        node15.addChild(node12);
        Node node16 = new Node(7, 8, 9, 10, 11, 12, 13, 14, 15, 16);
        node15.addChild(node16);
        node16.addChild(node12);
        Node node17 = new Node(13, 14, 15, 16);
        node14.addChild(node17);
        node17.addChild(node12);
        Node node18 = new Node(10, 11, 12);
        node13.addChild(node18);
        Node node19 = new Node(7, 8, 9, 10, 11, 12, 13, 14, 15, 16);
        node18.addChild(node19);
        node19.addChild(node12);
        Node node20 = new Node(9, 10, 11, 12, 13, 14, 15, 16);
        this.mLegalTimesTree.addChild(node20);
        node20.addChild(node12);
        Node node21 = new Node(7, 8, 9, 10, 11, 12);
        node20.addChild(node21);
        Node node22 = new Node(7, 8, 9, 10, 11, 12, 13, 14, 15, 16);
        node21.addChild(node22);
        node22.addChild(node12);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getAmOrPmKeyCode(int n) {
        int n2 = -1;
        if (this.mAmKeyCode == n2 || this.mPmKeyCode == n2) {
            KeyCharacterMap keyCharacterMap = KeyCharacterMap.load(n2);
            for (int i = 0; i < Math.max(this.mAmText.length(), this.mPmText.length()); ++i) {
                char c;
                char c2 = this.mAmText.toLowerCase(this.mCurrentLocale).charAt(i);
                if (c2 == (c = this.mPmText.toLowerCase(this.mCurrentLocale).charAt(i))) continue;
                KeyEvent[] keyEventArray = keyCharacterMap.getEvents(new char[]{c2, c});
                if (keyEventArray != null && keyEventArray.length == 4) {
                    this.mAmKeyCode = keyEventArray[0].getKeyCode();
                    this.mPmKeyCode = keyEventArray[2].getKeyCode();
                    break;
                }
                Log.e(TAG, "Unable to find keycodes for AM and PM.");
                break;
            }
        }
        if (n == 0) {
            return this.mAmKeyCode;
        }
        if (n != 1) return n2;
        return this.mPmKeyCode;
    }

    private int getCurrentItemShowing() {
        return this.mRadialTimePickerView.getCurrentItemShowing();
    }

    /*
     * Enabled aggressive block sorting
     */
    private int[] getEnteredTime(boolean[] blArray) {
        int n = -1;
        int n2 = 1;
        if (!this.mIs24HourView && this.isTypedTimeFullyLegal()) {
            int n3 = this.mTypedTimes.get(-1 + this.mTypedTimes.size());
            if (n3 == this.getAmOrPmKeyCode(0)) {
                n = 0;
            } else if (n3 == this.getAmOrPmKeyCode(1)) {
                n = 1;
            }
            n2 = 2;
        }
        int n4 = -1;
        int n5 = -1;
        int n6 = n2;
        while (n6 <= this.mTypedTimes.size()) {
            int n7 = this.getValFromKeyCode(this.mTypedTimes.get(this.mTypedTimes.size() - n6));
            if (n6 == n2) {
                n4 = n7;
            } else if (n6 == n2 + 1) {
                n4 += n7 * 10;
                if (blArray != null && n7 == 0) {
                    blArray[1] = true;
                }
            } else if (n6 == n2 + 2) {
                n5 = n7;
            } else if (n6 == n2 + 3) {
                n5 += n7 * 10;
                if (blArray != null && n7 == 0) {
                    blArray[0] = true;
                }
            }
            ++n6;
        }
        return new int[]{n5, n4, n};
    }

    private ArrayList<Integer> getTypedTimes() {
        return this.mTypedTimes;
    }

    private int getValFromKeyCode(int n) {
        switch (n) {
            default: {
                return -1;
            }
            case 7: {
                return 0;
            }
            case 8: {
                return 1;
            }
            case 9: {
                return 2;
            }
            case 10: {
                return 3;
            }
            case 11: {
                return 4;
            }
            case 12: {
                return 5;
            }
            case 13: {
                return 6;
            }
            case 14: {
                return 7;
            }
            case 15: {
                return 8;
            }
            case 16: 
        }
        return 9;
    }

    private boolean inKbMode() {
        return this.mInKbMode;
    }

    private void initialize(int n, int n2, boolean bl, int n3) {
        this.mInitialHourOfDay = n;
        this.mInitialMinute = n2;
        this.mIs24HourView = bl;
        this.mInKbMode = false;
        this.updateUI(n3);
    }

    private boolean isTypedTimeFullyLegal() {
        boolean bl;
        block5: {
            block4: {
                if (this.mIs24HourView) {
                    int[] nArray = this.getEnteredTime(null);
                    return nArray[0] >= 0 && nArray[1] >= 0 && nArray[1] < 60;
                }
                if (this.mTypedTimes.contains(this.getAmOrPmKeyCode(0))) break block4;
                boolean bl2 = this.mTypedTimes.contains(this.getAmOrPmKeyCode(1));
                bl = false;
                if (!bl2) break block5;
            }
            bl = true;
        }
        return bl;
    }

    private boolean isTypedTimeLegalSoFar() {
        Node node = this.mLegalTimesTree;
        Iterator<Integer> iterator = this.mTypedTimes.iterator();
        while (iterator.hasNext()) {
            if ((node = node.canReach(iterator.next())) != null) continue;
            return false;
        }
        return true;
    }

    private static int lastIndexOfAny(String string2, char[] cArray) {
        int n = cArray.length;
        if (n > 0) {
            for (int i = -1 + string2.length(); i >= 0; --i) {
                char c = string2.charAt(i);
                for (int j = 0; j < n; ++j) {
                    if (c != cArray[j]) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    private static int modulo12(int n, boolean bl) {
        int n2 = n % 12;
        if (n2 == 0 && !bl) {
            n2 = 12;
        }
        return n2;
    }

    private void onTimeChanged() {
        this.mDelegator.sendAccessibilityEvent(4);
        if (this.mOnTimeChangedListener != null) {
            this.mOnTimeChangedListener.onTimeChanged(this.mDelegator, this.getCurrentHour(), this.getCurrentMinute());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean processKeyUp(int n) {
        int n2;
        block9: {
            block10: {
                String string2;
                block7: {
                    block8: {
                        n2 = 1;
                        if (n != 67) break block8;
                        if (!this.mInKbMode) return 0 != 0;
                        if (this.mTypedTimes.isEmpty()) return 0 != 0;
                        int n3 = this.deleteLastTypedKey();
                        if (n3 == this.getAmOrPmKeyCode(0)) {
                            string2 = this.mAmText;
                            break block7;
                        } else if (n3 == this.getAmOrPmKeyCode(n2)) {
                            string2 = this.mPmText;
                            break block7;
                        } else {
                            Object[] objectArray = new Object[n2];
                            objectArray[0] = this.getValFromKeyCode(n3);
                            string2 = String.format("%d", objectArray);
                        }
                        break block7;
                    }
                    if (n != 7 && n != 8 && n != 9 && n != 10 && n != 11 && n != 12 && n != 13 && n != 14 && n != 15 && n != 16) {
                        if (this.mIs24HourView) return 0 != 0;
                        if (n != this.getAmOrPmKeyCode(0)) {
                            if (n != this.getAmOrPmKeyCode(n2)) return 0 != 0;
                        }
                    }
                    if (this.mInKbMode) break block9;
                    if (this.mRadialTimePickerView == null) {
                        Log.e(TAG, "Unable to initiate keyboard mode, TimePicker was null.");
                        return n2 != 0;
                    }
                    break block10;
                }
                RadialTimePickerView radialTimePickerView = this.mRadialTimePickerView;
                String string3 = this.mDeletedKeyFormat;
                Object[] objectArray = new Object[n2];
                objectArray[0] = string2;
                radialTimePickerView.announceForAccessibility(String.format(string3, objectArray));
                this.updateDisplay(n2 != 0);
                return 0 != 0;
            }
            this.mTypedTimes.clear();
            this.tryStartingKbMode(n);
            return n2 != 0;
        }
        if (!this.addKeyIfLegal(n)) return n2 != 0;
        this.updateDisplay(false);
        return n2 != 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setCurrentItemShowing(int n, boolean bl, boolean bl2) {
        int n2 = 1;
        this.mRadialTimePickerView.setCurrentItemShowing(n, bl);
        if (n == 0) {
            int n3 = this.mRadialTimePickerView.getCurrentHour();
            if (!this.mIs24HourView) {
                n3 %= 12;
            }
            this.mRadialTimePickerView.setContentDescription(this.mHourPickerDescription + ": " + n3);
            if (bl2) {
                this.mRadialTimePickerView.announceForAccessibility(this.mSelectHours);
            }
        } else {
            int n4 = this.mRadialTimePickerView.getCurrentMinute();
            this.mRadialTimePickerView.setContentDescription(this.mMinutePickerDescription + ": " + n4);
            if (bl2) {
                this.mRadialTimePickerView.announceForAccessibility(this.mSelectMinutes);
            }
        }
        TextView textView = this.mHourView;
        int n5 = n == 0 ? n2 : 0;
        textView.setSelected(n5 != 0);
        TextView textView2 = this.mMinuteView;
        if (n != n2) {
            n2 = 0;
        }
        textView2.setSelected(n2 != 0);
    }

    private void setInKbMode(boolean bl) {
        this.mInKbMode = bl;
    }

    private void setTypedTimes(ArrayList<Integer> arrayList) {
        this.mTypedTimes = arrayList;
    }

    private void setupListeners() {
        this.mHeaderView.setOnKeyListener(this.mKeyListener);
        this.mHeaderView.setOnFocusChangeListener(this.mFocusListener);
        this.mHeaderView.setFocusable(true);
        this.mRadialTimePickerView.setOnValueSelectedListener(this);
        this.mHourView.setOnClickListener(new View.OnClickListener(){

            @Override
            public void onClick(View view) {
                TimePickerSpinnerDelegate.this.setCurrentItemShowing(0, true, true);
                TimePickerSpinnerDelegate.this.tryVibrate();
            }
        });
        this.mMinuteView.setOnClickListener(new View.OnClickListener(){

            @Override
            public void onClick(View view) {
                TimePickerSpinnerDelegate.this.setCurrentItemShowing(1, true, true);
                TimePickerSpinnerDelegate.this.tryVibrate();
            }
        });
    }

    private void tryStartingKbMode(int n) {
        if (n == -1 || this.addKeyIfLegal(n)) {
            this.mInKbMode = true;
            this.onValidationChanged(false);
            this.updateDisplay(false);
            this.mRadialTimePickerView.setInputEnabled(false);
        }
    }

    private void tryVibrate() {
        this.mDelegator.performHapticFeedback(4);
    }

    private void updateAmPmDisplay(int n) {
        if (n == 0) {
            this.mAmPmTextView.setText(this.mAmText);
            this.mRadialTimePickerView.announceForAccessibility(this.mAmText);
            return;
        }
        if (n == 1) {
            this.mAmPmTextView.setText(this.mPmText);
            this.mRadialTimePickerView.announceForAccessibility(this.mPmText);
            return;
        }
        this.mAmPmTextView.setText(this.mDoublePlaceholderText);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateDisplay(boolean bl) {
        if (!bl && this.mTypedTimes.isEmpty()) {
            int n = this.mRadialTimePickerView.getCurrentHour();
            int n2 = this.mRadialTimePickerView.getCurrentMinute();
            this.updateHeaderHour(n, true);
            this.updateHeaderMinute(n2);
            if (!this.mIs24HourView) {
                int n3 = n < 12 ? 0 : 1;
                this.updateAmPmDisplay(n3);
            }
            this.setCurrentItemShowing(this.mRadialTimePickerView.getCurrentItemShowing(), true, true);
            this.onValidationChanged(true);
            return;
        } else {
            String string2;
            String string3;
            boolean[] blArray = new boolean[]{false, false};
            int[] nArray = this.getEnteredTime(blArray);
            String string4 = blArray[0] ? "%02d" : "%2d";
            String string5 = blArray[1] ? "%02d" : "%2d";
            if (nArray[0] == -1) {
                string3 = this.mDoublePlaceholderText;
            } else {
                Object[] objectArray = new Object[]{nArray[0]};
                string3 = String.format(string4, objectArray).replace(' ', this.mPlaceholderText);
            }
            if (nArray[1] == -1) {
                string2 = this.mDoublePlaceholderText;
            } else {
                Object[] objectArray = new Object[]{nArray[1]};
                string2 = String.format(string5, objectArray).replace(' ', this.mPlaceholderText);
            }
            this.mHourView.setText(string3);
            this.mHourView.setSelected(false);
            this.mMinuteView.setText(string2);
            this.mMinuteView.setSelected(false);
            if (this.mIs24HourView) return;
            this.updateAmPmDisplay(nArray[2]);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateHeaderAmPm() {
        if (this.mIs24HourView) {
            this.mAmPmTextView.setVisibility(8);
            return;
        }
        this.mAmPmTextView.setVisibility(0);
        boolean bl = DateFormat.getBestDateTimePattern(this.mCurrentLocale, "hm").startsWith("a");
        if (TextUtils.getLayoutDirectionFromLocale(this.mCurrentLocale) == 1) {
            bl = !bl;
        }
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.mAmPmTextView.getLayoutParams();
        if (bl) {
            layoutParams.rightMargin = this.computeMaxWidthOfNumbers(12);
            layoutParams.removeRule(1);
            layoutParams.addRule(0, 16909281);
        } else {
            layoutParams.leftMargin = this.computeMaxWidthOfNumbers(60);
            layoutParams.removeRule(0);
            layoutParams.addRule(1, 16909281);
        }
        int n = this.mInitialHourOfDay;
        int n2 = 0;
        if (n >= 12) {
            n2 = 1;
        }
        this.updateAmPmDisplay(n2);
        this.mAmPmTextView.setOnClickListener(new View.OnClickListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onClick(View view) {
                TimePickerSpinnerDelegate.this.tryVibrate();
                int n = TimePickerSpinnerDelegate.this.mRadialTimePickerView.getAmOrPm();
                if (n == 0) {
                    n = 1;
                } else if (n == 1) {
                    n = 0;
                }
                TimePickerSpinnerDelegate.this.updateAmPmDisplay(n);
                TimePickerSpinnerDelegate.this.mRadialTimePickerView.setAmOrPm(n);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateHeaderHour(int n, boolean bl) {
        String string2;
        block6: {
            char c;
            Locale locale = this.mCurrentLocale;
            String string3 = this.mIs24HourView ? "Hm" : "hm";
            String string4 = DateFormat.getBestDateTimePattern(locale, string3);
            int n2 = string4.length();
            int n3 = 0;
            while (true) {
                block8: {
                    boolean bl2;
                    block7: {
                        c = '\u0000';
                        bl2 = false;
                        if (n3 >= n2) break block7;
                        char c2 = string4.charAt(n3);
                        if (c2 != 'H' && c2 != 'h' && c2 != 'K' && c2 != 'k') break block8;
                        c = c2;
                        int n4 = n3 + 1;
                        bl2 = false;
                        if (n4 < n2) {
                            char c3 = string4.charAt(n3 + 1);
                            bl2 = false;
                            if (c2 == c3) {
                                bl2 = true;
                            }
                        }
                    }
                    string2 = bl2 ? "%02d" : "%d";
                    if (!this.mIs24HourView) break;
                    if (c == 'k' && n == 0) {
                        n = 24;
                    }
                    break block6;
                }
                ++n3;
            }
            boolean bl3 = c == 'K';
            n = TimePickerSpinnerDelegate.modulo12(n, bl3);
        }
        Object[] objectArray = new Object[]{n};
        String string5 = String.format(string2, objectArray);
        this.mHourView.setText(string5);
        if (bl) {
            this.mRadialTimePickerView.announceForAccessibility(string5);
        }
    }

    private void updateHeaderMinute(int n) {
        if (n == 60) {
            n = 0;
        }
        Locale locale = this.mCurrentLocale;
        Object[] objectArray = new Object[]{n};
        String string2 = String.format(locale, "%02d", objectArray);
        this.mRadialTimePickerView.announceForAccessibility(string2);
        this.mMinuteView.setText(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateHeaderSeparator() {
        Locale locale = this.mCurrentLocale;
        String string2 = this.mIs24HourView ? "Hm" : "hm";
        String string3 = DateFormat.getBestDateTimePattern(locale, string2);
        int n = TimePickerSpinnerDelegate.lastIndexOfAny(string3, new char[]{'H', 'h', 'K', 'k'});
        String string4 = n == -1 ? ":" : Character.toString(string3.charAt(n + 1));
        this.mSeparatorView.setText(string4);
    }

    private void updateRadialPicker(int n) {
        this.mRadialTimePickerView.initialize(this.mInitialHourOfDay, this.mInitialMinute, this.mIs24HourView);
        this.setCurrentItemShowing(n, false, true);
    }

    private void updateUI(int n) {
        this.updateRadialPicker(n);
        this.updateHeaderAmPm();
        this.updateHeaderHour(this.mInitialHourOfDay, true);
        this.updateHeaderSeparator();
        this.updateHeaderMinute(this.mInitialMinute);
        this.mDelegator.invalidate();
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        this.onPopulateAccessibilityEvent(accessibilityEvent);
        return true;
    }

    @Override
    public int getBaseline() {
        return -1;
    }

    @Override
    public Integer getCurrentHour() {
        int n = this.mRadialTimePickerView.getCurrentHour();
        if (this.mIs24HourView) {
            return n;
        }
        switch (this.mRadialTimePickerView.getAmOrPm()) {
            default: {
                return n % 12;
            }
            case 1: 
        }
        return 12 + n % 12;
    }

    @Override
    public Integer getCurrentMinute() {
        return this.mRadialTimePickerView.getCurrentMinute();
    }

    @Override
    public boolean is24HourView() {
        return this.mIs24HourView;
    }

    @Override
    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        this.updateUI(this.mRadialTimePickerView.getCurrentItemShowing());
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        accessibilityEvent.setClassName(TimePicker.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        accessibilityNodeInfo.setClassName(TimePicker.class.getName());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        int n = this.mIs24HourView ? 1 | 0x80 : 1 | 0x40;
        this.mTempCalendar.set(11, this.getCurrentHour());
        this.mTempCalendar.set(12, this.getCurrentMinute());
        String string2 = DateUtils.formatDateTime(this.mContext, this.mTempCalendar.getTimeInMillis(), n);
        accessibilityEvent.getText().add(string2);
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        SavedState savedState = (SavedState)parcelable;
        this.setInKbMode(savedState.inKbMode());
        this.setTypedTimes(savedState.getTypesTimes());
        this.initialize(savedState.getHour(), savedState.getMinute(), savedState.is24HourMode(), savedState.getCurrentItemShowing());
        this.mRadialTimePickerView.invalidate();
        if (this.mInKbMode) {
            this.tryStartingKbMode(-1);
            this.mHourView.invalidate();
        }
    }

    @Override
    public Parcelable onSaveInstanceState(Parcelable parcelable) {
        return new SavedState(parcelable, this.getCurrentHour(), this.getCurrentMinute(), this.is24HourView(), this.inKbMode(), this.getTypedTimes(), this.getCurrentItemShowing());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onValueSelected(int n, int n2, boolean bl) {
        if (n == 0) {
            this.updateHeaderHour(n2, false);
            Object[] objectArray = new Object[]{n2};
            String string2 = String.format("%d", objectArray);
            if (this.mAllowAutoAdvance && bl) {
                this.setCurrentItemShowing(1, true, false);
                string2 = string2 + ". " + this.mSelectMinutes;
            } else {
                this.mRadialTimePickerView.setContentDescription(this.mHourPickerDescription + ": " + n2);
            }
            this.mRadialTimePickerView.announceForAccessibility(string2);
            return;
        } else {
            if (n == 1) {
                this.updateHeaderMinute(n2);
                this.mRadialTimePickerView.setContentDescription(this.mMinutePickerDescription + ": " + n2);
                return;
            }
            if (n == 2) {
                this.updateAmPmDisplay(n2);
                return;
            }
            if (n != 3) return;
            if (!this.isTypedTimeFullyLegal()) {
                this.mTypedTimes.clear();
            }
            this.finishKbMode();
            return;
        }
    }

    @Override
    public void setCurrentHour(Integer n) {
        int n2 = 1;
        if (this.mInitialHourOfDay == n) {
            return;
        }
        this.mInitialHourOfDay = n;
        this.updateHeaderHour(n, n2 != 0);
        this.updateHeaderAmPm();
        this.mRadialTimePickerView.setCurrentHour(n);
        RadialTimePickerView radialTimePickerView = this.mRadialTimePickerView;
        if (this.mInitialHourOfDay < 12) {
            n2 = 0;
        }
        radialTimePickerView.setAmOrPm(n2);
        this.mDelegator.invalidate();
        this.onTimeChanged();
    }

    @Override
    public void setCurrentLocale(Locale locale) {
        super.setCurrentLocale(locale);
        this.mTempCalendar = Calendar.getInstance(locale);
    }

    @Override
    public void setCurrentMinute(Integer n) {
        if (this.mInitialMinute == n) {
            return;
        }
        this.mInitialMinute = n;
        this.updateHeaderMinute(n);
        this.mRadialTimePickerView.setCurrentMinute(n);
        this.mDelegator.invalidate();
        this.onTimeChanged();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.mHourView.setEnabled(bl);
        this.mMinuteView.setEnabled(bl);
        this.mAmPmTextView.setEnabled(bl);
        this.mRadialTimePickerView.setEnabled(bl);
        this.mIsEnabled = bl;
    }

    @Override
    public void setIs24HourView(Boolean bl) {
        int n;
        if (bl == this.mIs24HourView) {
            return;
        }
        this.mIs24HourView = bl;
        this.generateLegalTimesTree();
        this.mInitialHourOfDay = n = this.mRadialTimePickerView.getCurrentHour();
        this.updateHeaderHour(n, false);
        this.updateHeaderAmPm();
        this.updateRadialPicker(this.mRadialTimePickerView.getCurrentItemShowing());
        this.mDelegator.invalidate();
    }

    @Override
    public void setOnTimeChangedListener(TimePicker.OnTimeChangedListener onTimeChangedListener) {
        this.mOnTimeChangedListener = onTimeChangedListener;
    }

    private class Node {
        private ArrayList<Node> mChildren;
        private int[] mLegalKeys;

        public Node(int ... nArray) {
            this.mLegalKeys = nArray;
            this.mChildren = new ArrayList();
        }

        public void addChild(Node node) {
            this.mChildren.add(node);
        }

        public Node canReach(int n) {
            if (this.mChildren == null) {
                return null;
            }
            for (Node node : this.mChildren) {
                if (!node.containsKey(n)) continue;
                return node;
            }
            return null;
        }

        public boolean containsKey(int n) {
            for (int i = 0; i < this.mLegalKeys.length; ++i) {
                if (this.mLegalKeys[i] != n) continue;
                return true;
            }
            return false;
        }
    }

    private static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        private final int mCurrentItemShowing;
        private final int mHour;
        private final boolean mInKbMode;
        private final boolean mIs24HourMode;
        private final int mMinute;
        private final ArrayList<Integer> mTypedTimes;

        /*
         * Enabled aggressive block sorting
         */
        private SavedState(Parcel parcel) {
            int n = 1;
            super(parcel);
            this.mHour = parcel.readInt();
            this.mMinute = parcel.readInt();
            int n2 = parcel.readInt() == n ? n : 0;
            this.mIs24HourMode = n2;
            if (parcel.readInt() != n) {
                n = 0;
            }
            this.mInKbMode = n;
            this.mTypedTimes = parcel.readArrayList(this.getClass().getClassLoader());
            this.mCurrentItemShowing = parcel.readInt();
        }

        private SavedState(Parcelable parcelable, int n, int n2, boolean bl, boolean bl2, ArrayList<Integer> arrayList, int n3) {
            super(parcelable);
            this.mHour = n;
            this.mMinute = n2;
            this.mIs24HourMode = bl;
            this.mInKbMode = bl2;
            this.mTypedTimes = arrayList;
            this.mCurrentItemShowing = n3;
        }

        public int getCurrentItemShowing() {
            return this.mCurrentItemShowing;
        }

        public int getHour() {
            return this.mHour;
        }

        public int getMinute() {
            return this.mMinute;
        }

        public ArrayList<Integer> getTypesTimes() {
            return this.mTypedTimes;
        }

        public boolean inKbMode() {
            return this.mInKbMode;
        }

        public boolean is24HourMode() {
            return this.mIs24HourMode;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            int n2 = 1;
            super.writeToParcel(parcel, n);
            parcel.writeInt(this.mHour);
            parcel.writeInt(this.mMinute);
            int n3 = this.mIs24HourMode ? n2 : 0;
            parcel.writeInt(n3);
            if (!this.mInKbMode) {
                n2 = 0;
            }
            parcel.writeInt(n2);
            parcel.writeList(this.mTypedTimes);
            parcel.writeInt(this.mCurrentItemShowing);
        }
    }
}

