/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.util.AttributeSet;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.CompoundButton;
import com.android.internal.R;

public class ToggleButton
extends CompoundButton {
    private static final int NO_ALPHA = 255;
    private float mDisabledAlpha;
    private Drawable mIndicatorDrawable;
    private CharSequence mTextOff;
    private CharSequence mTextOn;

    public ToggleButton(Context context) {
        this(context, null);
    }

    public ToggleButton(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842827);
    }

    public ToggleButton(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public ToggleButton(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ToggleButton, n, n2);
        this.mTextOn = typedArray.getText(1);
        this.mTextOff = typedArray.getText(2);
        this.mDisabledAlpha = typedArray.getFloat(0, 0.5f);
        this.syncTextState();
        typedArray.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void syncTextState() {
        boolean bl = this.isChecked();
        if (bl && this.mTextOn != null) {
            this.setText(this.mTextOn);
            return;
        } else {
            if (bl || this.mTextOff == null) return;
            this.setText(this.mTextOff);
            return;
        }
    }

    private void updateReferenceToIndicatorDrawable(Drawable drawable2) {
        if (drawable2 instanceof LayerDrawable) {
            this.mIndicatorDrawable = ((LayerDrawable)drawable2).findDrawableByLayerId(16908311);
            return;
        }
        this.mIndicatorDrawable = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mIndicatorDrawable != null) {
            Drawable drawable2 = this.mIndicatorDrawable;
            int n = this.isEnabled() ? 255 : (int)(255.0f * this.mDisabledAlpha);
            drawable2.setAlpha(n);
        }
    }

    public CharSequence getTextOff() {
        return this.mTextOff;
    }

    public CharSequence getTextOn() {
        return this.mTextOn;
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.updateReferenceToIndicatorDrawable(this.getBackground());
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(ToggleButton.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(ToggleButton.class.getName());
    }

    @Override
    public void setBackgroundDrawable(Drawable drawable2) {
        super.setBackgroundDrawable(drawable2);
        this.updateReferenceToIndicatorDrawable(drawable2);
    }

    @Override
    public void setChecked(boolean bl) {
        super.setChecked(bl);
        this.syncTextState();
    }

    public void setTextOff(CharSequence charSequence) {
        this.mTextOff = charSequence;
    }

    public void setTextOn(CharSequence charSequence) {
        this.mTextOn = charSequence;
    }
}

