/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.http.multipart;

import com.android.internal.http.multipart.Part;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EncodingUtils;

public class MultipartEntity
extends AbstractHttpEntity {
    public static final String MULTIPART_BOUNDARY = "http.method.multipart.boundary";
    private static byte[] MULTIPART_CHARS;
    private static final String MULTIPART_FORM_CONTENT_TYPE = "multipart/form-data";
    private static final Log log;
    private boolean contentConsumed = false;
    private byte[] multipartBoundary;
    private HttpParams params;
    protected Part[] parts;

    static {
        log = LogFactory.getLog(MultipartEntity.class);
        MULTIPART_CHARS = EncodingUtils.getAsciiBytes("-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
    }

    public MultipartEntity(Part[] partArray) {
        this.setContentType(MULTIPART_FORM_CONTENT_TYPE);
        if (partArray == null) {
            throw new IllegalArgumentException("parts cannot be null");
        }
        this.parts = partArray;
        this.params = null;
    }

    public MultipartEntity(Part[] partArray, HttpParams httpParams) {
        if (partArray == null) {
            throw new IllegalArgumentException("parts cannot be null");
        }
        if (httpParams == null) {
            throw new IllegalArgumentException("params cannot be null");
        }
        this.parts = partArray;
        this.params = httpParams;
    }

    private static byte[] generateMultipartBoundary() {
        Random random = new Random();
        byte[] byArray = new byte[30 + random.nextInt(11)];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = MULTIPART_CHARS[random.nextInt(MULTIPART_CHARS.length)];
        }
        return byArray;
    }

    @Override
    public InputStream getContent() throws IOException, IllegalStateException {
        if (!this.isRepeatable() && this.contentConsumed) {
            throw new IllegalStateException("Content has been consumed");
        }
        this.contentConsumed = true;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Part.sendParts(byteArrayOutputStream, this.parts, this.multipartBoundary);
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    @Override
    public long getContentLength() {
        try {
            long l = Part.getLengthOfParts(this.parts, this.getMultipartBoundary());
            return l;
        }
        catch (Exception exception) {
            log.error("An exception occurred while getting the length of the parts", exception);
            return 0L;
        }
    }

    @Override
    public Header getContentType() {
        StringBuffer stringBuffer = new StringBuffer(MULTIPART_FORM_CONTENT_TYPE);
        stringBuffer.append("; boundary=");
        stringBuffer.append(EncodingUtils.getAsciiString(this.getMultipartBoundary()));
        return new BasicHeader("Content-Type", stringBuffer.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] getMultipartBoundary() {
        block6: {
            block5: {
                if (this.multipartBoundary != null) break block5;
                HttpParams httpParams = this.params;
                String string2 = null;
                if (httpParams != null) {
                    string2 = (String)this.params.getParameter(MULTIPART_BOUNDARY);
                }
                if (string2 == null) break block6;
                this.multipartBoundary = EncodingUtils.getAsciiBytes(string2);
            }
            return this.multipartBoundary;
        }
        this.multipartBoundary = MultipartEntity.generateMultipartBoundary();
        return this.multipartBoundary;
    }

    @Override
    public boolean isRepeatable() {
        for (int i = 0; i < this.parts.length; ++i) {
            if (this.parts[i].isRepeatable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isStreaming() {
        return false;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        Part.sendParts(outputStream, this.parts, this.getMultipartBoundary());
    }
}

