/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.SystemProperties;
import android.util.Slog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import libcore.io.IoUtils;
import libcore.io.Streams;

public class InstallerConnection {
    private static final boolean LOCAL_DEBUG = false;
    private static final String TAG = "InstallerConnection";
    private final byte[] buf = new byte[1024];
    private InputStream mIn;
    private OutputStream mOut;
    private LocalSocket mSocket;

    private boolean connect() {
        if (this.mSocket != null) {
            return true;
        }
        Slog.i(TAG, "connecting...");
        try {
            this.mSocket = new LocalSocket();
            LocalSocketAddress localSocketAddress = new LocalSocketAddress("installd", LocalSocketAddress.Namespace.RESERVED);
            this.mSocket.connect(localSocketAddress);
            this.mIn = this.mSocket.getInputStream();
            this.mOut = this.mSocket.getOutputStream();
            return true;
        }
        catch (IOException iOException) {
            this.disconnect();
            return false;
        }
    }

    private boolean readFully(byte[] byArray, int n) {
        try {
            Streams.readFully((InputStream)this.mIn, (byte[])byArray, (int)0, (int)n);
            return true;
        }
        catch (IOException iOException) {
            Slog.e(TAG, "read exception");
            this.disconnect();
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int readReply() {
        if (!this.readFully(this.buf, 2)) {
            return -1;
        }
        int n = 0xFF & this.buf[0] | (0xFF & this.buf[1]) << 8;
        if (n < 1 || n > this.buf.length) {
            Slog.e(TAG, "invalid reply length (" + n + ")");
            this.disconnect();
            return -1;
        }
        if (this.readFully(this.buf, n)) return n;
        return -1;
    }

    private boolean writeCommand(String string2) {
        byte[] byArray = string2.getBytes();
        int n = byArray.length;
        if (n < 1 || n > this.buf.length) {
            return false;
        }
        this.buf[0] = (byte)(n & 0xFF);
        this.buf[1] = (byte)(0xFF & n >> 8);
        try {
            this.mOut.write(this.buf, 0, 2);
            this.mOut.write(byArray, 0, n);
            return true;
        }
        catch (IOException iOException) {
            Slog.e(TAG, "write error");
            this.disconnect();
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int dexopt(String string2, int n, boolean bl, String string3) {
        String string4;
        if (SystemProperties.getBoolean("persist.selective.enabled", true)) {
            string4 = "O2";
            return this.dexopt(string2, n, bl, "*", string3, false, string4);
        }
        string4 = "";
        return this.dexopt(string2, n, bl, "*", string3, false, string4);
    }

    public int dexopt(String string2, int n, boolean bl, String string3, String string4) {
        return this.dexopt(string2, n, bl, "*", string3, false, string4);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int dexopt(String string2, int n, boolean bl, String string3, String string4, boolean bl2, String string5) {
        StringBuilder stringBuilder = new StringBuilder("dexopt");
        stringBuilder.append(' ');
        stringBuilder.append(string2);
        stringBuilder.append(' ');
        stringBuilder.append(n);
        String string6 = bl ? " 1" : " 0";
        stringBuilder.append(string6);
        stringBuilder.append(' ');
        stringBuilder.append(string3);
        stringBuilder.append(' ');
        stringBuilder.append(string4);
        stringBuilder.append(' ');
        String string7 = bl2 ? " 1" : " 0";
        stringBuilder.append(string7);
        stringBuilder.append(' ');
        stringBuilder.append(string5);
        return this.execute(stringBuilder.toString());
    }

    public void disconnect() {
        Slog.i(TAG, "disconnecting...");
        IoUtils.closeQuietly((AutoCloseable)this.mSocket);
        IoUtils.closeQuietly((AutoCloseable)this.mIn);
        IoUtils.closeQuietly((AutoCloseable)this.mOut);
        this.mSocket = null;
        this.mIn = null;
        this.mOut = null;
    }

    public int execute(String string2) {
        String string3 = this.transact(string2);
        try {
            int n = Integer.parseInt(string3);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public int patchoat(String string2, int n, boolean bl, String string3) {
        return this.patchoat(string2, n, bl, "*", string3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int patchoat(String string2, int n, boolean bl, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder("patchoat");
        stringBuilder.append(' ');
        stringBuilder.append(string2);
        stringBuilder.append(' ');
        stringBuilder.append(n);
        String string5 = bl ? " 1" : " 0";
        stringBuilder.append(string5);
        stringBuilder.append(' ');
        stringBuilder.append(string3);
        stringBuilder.append(' ');
        stringBuilder.append(string4);
        return this.execute(stringBuilder.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String transact(String string2) {
        synchronized (this) {
            int n;
            block8: {
                if (this.connect()) break block8;
                Slog.e(TAG, "connection failed");
                return "-1";
            }
            if (!this.writeCommand(string2)) {
                Slog.e(TAG, "write command failed? reconnect!");
                if (!this.connect()) return "-1";
                if (!this.writeCommand(string2)) return "-1";
            }
            if ((n = this.readReply()) <= 0) return "-1";
            String string3 = new String(this.buf, 0, n);
            return string3;
        }
    }
}

