/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.DialogPreference;
import android.preference.Preference;
import android.util.AttributeSet;

public class YesNoPreference
extends DialogPreference {
    private boolean mWasPositiveResult;

    public YesNoPreference(Context context) {
        this(context, null);
    }

    public YesNoPreference(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0x1010090);
    }

    public YesNoPreference(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public YesNoPreference(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
    }

    public boolean getValue() {
        return this.mWasPositiveResult;
    }

    @Override
    protected void onDialogClosed(boolean bl) {
        super.onDialogClosed(bl);
        if (this.callChangeListener(bl)) {
            this.setValue(bl);
        }
    }

    @Override
    protected Object onGetDefaultValue(TypedArray typedArray, int n) {
        return typedArray.getBoolean(n, false);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (!parcelable.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.setValue(savedState.wasPositiveResult);
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        if (this.isPersistent()) {
            return parcelable;
        }
        SavedState savedState = new SavedState(parcelable);
        savedState.wasPositiveResult = this.getValue();
        return savedState;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onSetInitialValue(boolean bl, Object object) {
        boolean bl2 = bl ? this.getPersistedBoolean(this.mWasPositiveResult) : ((Boolean)object).booleanValue();
        this.setValue(bl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setValue(boolean bl) {
        this.mWasPositiveResult = bl;
        this.persistBoolean(bl);
        boolean bl2 = !bl;
        this.notifyDependencyChange(bl2);
    }

    @Override
    public boolean shouldDisableDependents() {
        return !this.mWasPositiveResult || super.shouldDisableDependents();
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        boolean wasPositiveResult;

        /*
         * Enabled aggressive block sorting
         */
        public SavedState(Parcel parcel) {
            int n = 1;
            super(parcel);
            if (parcel.readInt() != n) {
                n = 0;
            }
            this.wasPositiveResult = n;
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            int n2 = this.wasPositiveResult ? 1 : 0;
            parcel.writeInt(n2);
        }
    }
}

