/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.SubInfoRecord;
import java.util.ArrayList;
import java.util.List;

public interface ISub
extends IInterface {
    public int addSubInfoRecord(String var1, int var2) throws RemoteException;

    public void clearDefaultsForInactiveSubIds() throws RemoteException;

    public int clearSubInfo() throws RemoteException;

    public int clearSubInfoBySlotId(int var1) throws RemoteException;

    public long[] getActiveSubIdList() throws RemoteException;

    public int getActiveSubInfoCount() throws RemoteException;

    public List<SubInfoRecord> getActiveSubInfoList() throws RemoteException;

    public int getAllSubInfoCount() throws RemoteException;

    public List<SubInfoRecord> getAllSubInfoList() throws RemoteException;

    public long getDefaultDataSubId() throws RemoteException;

    public long getDefaultSmsSubId() throws RemoteException;

    public long getDefaultSubId() throws RemoteException;

    public long getDefaultVoiceSubId() throws RemoteException;

    public int getPhoneId(long var1) throws RemoteException;

    public int getSlotId(long var1) throws RemoteException;

    public long[] getSubId(int var1) throws RemoteException;

    public SubInfoRecord getSubInfoForSubscriber(long var1) throws RemoteException;

    public List<SubInfoRecord> getSubInfoUsingIccId(String var1) throws RemoteException;

    public List<SubInfoRecord> getSubInfoUsingSlotId(int var1) throws RemoteException;

    public int setColor(int var1, long var2) throws RemoteException;

    public int setDataRoaming(int var1, long var2) throws RemoteException;

    public void setDefaultDataSubId(long var1) throws RemoteException;

    public void setDefaultSmsSubId(long var1) throws RemoteException;

    public void setDefaultVoiceSubId(long var1) throws RemoteException;

    public int setDisplayName(String var1, long var2) throws RemoteException;

    public int setDisplayNameUsingSrc(String var1, long var2, long var4) throws RemoteException;

    public int setDisplayNumber(String var1, long var2) throws RemoteException;

    public int setDisplayNumberFormat(int var1, long var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISub {
        private static final String DESCRIPTOR = "com.android.internal.telephony.ISub";
        static final int TRANSACTION_addSubInfoRecord = 8;
        static final int TRANSACTION_clearDefaultsForInactiveSubIds = 27;
        static final int TRANSACTION_clearSubInfo = 18;
        static final int TRANSACTION_clearSubInfoBySlotId = 19;
        static final int TRANSACTION_getActiveSubIdList = 28;
        static final int TRANSACTION_getActiveSubInfoCount = 7;
        static final int TRANSACTION_getActiveSubInfoList = 5;
        static final int TRANSACTION_getAllSubInfoCount = 6;
        static final int TRANSACTION_getAllSubInfoList = 4;
        static final int TRANSACTION_getDefaultDataSubId = 21;
        static final int TRANSACTION_getDefaultSmsSubId = 25;
        static final int TRANSACTION_getDefaultSubId = 17;
        static final int TRANSACTION_getDefaultVoiceSubId = 23;
        static final int TRANSACTION_getPhoneId = 20;
        static final int TRANSACTION_getSlotId = 15;
        static final int TRANSACTION_getSubId = 16;
        static final int TRANSACTION_getSubInfoForSubscriber = 1;
        static final int TRANSACTION_getSubInfoUsingIccId = 2;
        static final int TRANSACTION_getSubInfoUsingSlotId = 3;
        static final int TRANSACTION_setColor = 9;
        static final int TRANSACTION_setDataRoaming = 14;
        static final int TRANSACTION_setDefaultDataSubId = 22;
        static final int TRANSACTION_setDefaultSmsSubId = 26;
        static final int TRANSACTION_setDefaultVoiceSubId = 24;
        static final int TRANSACTION_setDisplayName = 10;
        static final int TRANSACTION_setDisplayNameUsingSrc = 11;
        static final int TRANSACTION_setDisplayNumber = 12;
        static final int TRANSACTION_setDisplayNumberFormat = 13;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISub asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof ISub) {
                return (ISub)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    SubInfoRecord subInfoRecord = this.getSubInfoForSubscriber(parcel.readLong());
                    parcel2.writeNoException();
                    if (subInfoRecord != null) {
                        parcel2.writeInt(1);
                        subInfoRecord.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<SubInfoRecord> list = this.getSubInfoUsingIccId(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<SubInfoRecord> list = this.getSubInfoUsingSlotId(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<SubInfoRecord> list = this.getAllSubInfoList();
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<SubInfoRecord> list = this.getActiveSubInfoList();
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n3 = this.getAllSubInfoCount();
                    parcel2.writeNoException();
                    parcel2.writeInt(n3);
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n4 = this.getActiveSubInfoCount();
                    parcel2.writeNoException();
                    parcel2.writeInt(n4);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n5 = this.addSubInfoRecord(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n5);
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n6 = this.setColor(parcel.readInt(), parcel.readLong());
                    parcel2.writeNoException();
                    parcel2.writeInt(n6);
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n7 = this.setDisplayName(parcel.readString(), parcel.readLong());
                    parcel2.writeNoException();
                    parcel2.writeInt(n7);
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n8 = this.setDisplayNameUsingSrc(parcel.readString(), parcel.readLong(), parcel.readLong());
                    parcel2.writeNoException();
                    parcel2.writeInt(n8);
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n9 = this.setDisplayNumber(parcel.readString(), parcel.readLong());
                    parcel2.writeNoException();
                    parcel2.writeInt(n9);
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n10 = this.setDisplayNumberFormat(parcel.readInt(), parcel.readLong());
                    parcel2.writeNoException();
                    parcel2.writeInt(n10);
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n11 = this.setDataRoaming(parcel.readInt(), parcel.readLong());
                    parcel2.writeNoException();
                    parcel2.writeInt(n11);
                    return true;
                }
                case 15: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n12 = this.getSlotId(parcel.readLong());
                    parcel2.writeNoException();
                    parcel2.writeInt(n12);
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(DESCRIPTOR);
                    long[] lArray = this.getSubId(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeLongArray(lArray);
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(DESCRIPTOR);
                    long l = this.getDefaultSubId();
                    parcel2.writeNoException();
                    parcel2.writeLong(l);
                    return true;
                }
                case 18: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n13 = this.clearSubInfo();
                    parcel2.writeNoException();
                    parcel2.writeInt(n13);
                    return true;
                }
                case 19: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n14 = this.clearSubInfoBySlotId(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n14);
                    return true;
                }
                case 20: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n15 = this.getPhoneId(parcel.readLong());
                    parcel2.writeNoException();
                    parcel2.writeInt(n15);
                    return true;
                }
                case 21: {
                    parcel.enforceInterface(DESCRIPTOR);
                    long l = this.getDefaultDataSubId();
                    parcel2.writeNoException();
                    parcel2.writeLong(l);
                    return true;
                }
                case 22: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setDefaultDataSubId(parcel.readLong());
                    parcel2.writeNoException();
                    return true;
                }
                case 23: {
                    parcel.enforceInterface(DESCRIPTOR);
                    long l = this.getDefaultVoiceSubId();
                    parcel2.writeNoException();
                    parcel2.writeLong(l);
                    return true;
                }
                case 24: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setDefaultVoiceSubId(parcel.readLong());
                    parcel2.writeNoException();
                    return true;
                }
                case 25: {
                    parcel.enforceInterface(DESCRIPTOR);
                    long l = this.getDefaultSmsSubId();
                    parcel2.writeNoException();
                    parcel2.writeLong(l);
                    return true;
                }
                case 26: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setDefaultSmsSubId(parcel.readLong());
                    parcel2.writeNoException();
                    return true;
                }
                case 27: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.clearDefaultsForInactiveSubIds();
                    parcel2.writeNoException();
                    return true;
                }
                case 28: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            long[] lArray = this.getActiveSubIdList();
            parcel2.writeNoException();
            parcel2.writeLongArray(lArray);
            return true;
        }

        private static class Proxy
        implements ISub {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public int addSubInfoRecord(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override
            public void clearDefaultsForInactiveSubIds() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(27, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int clearSubInfo() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(18, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int clearSubInfoBySlotId(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(19, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public long[] getActiveSubIdList() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(28, parcel, parcel2, 0);
                    parcel2.readException();
                    long[] lArray = parcel2.createLongArray();
                    return lArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getActiveSubInfoCount() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<SubInfoRecord> getActiveSubInfoList() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<SubInfoRecord> arrayList = parcel2.createTypedArrayList(SubInfoRecord.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getAllSubInfoCount() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<SubInfoRecord> getAllSubInfoList() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<SubInfoRecord> arrayList = parcel2.createTypedArrayList(SubInfoRecord.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public long getDefaultDataSubId() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    long l = parcel2.readLong();
                    return l;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public long getDefaultSmsSubId() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(25, parcel, parcel2, 0);
                    parcel2.readException();
                    long l = parcel2.readLong();
                    return l;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public long getDefaultSubId() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(17, parcel, parcel2, 0);
                    parcel2.readException();
                    long l = parcel2.readLong();
                    return l;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public long getDefaultVoiceSubId() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(23, parcel, parcel2, 0);
                    parcel2.readException();
                    long l = parcel2.readLong();
                    return l;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public int getPhoneId(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(20, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getSlotId(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public long[] getSubId(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                    long[] lArray = parcel2.createLongArray();
                    return lArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public SubInfoRecord getSubInfoForSubscriber(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    SubInfoRecord subInfoRecord = parcel2.readInt() != 0 ? SubInfoRecord.CREATOR.createFromParcel(parcel2) : null;
                    return subInfoRecord;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<SubInfoRecord> getSubInfoUsingIccId(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<SubInfoRecord> arrayList = parcel2.createTypedArrayList(SubInfoRecord.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<SubInfoRecord> getSubInfoUsingSlotId(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<SubInfoRecord> arrayList = parcel2.createTypedArrayList(SubInfoRecord.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int setColor(int n, long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeLong(l);
                    this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int setDataRoaming(int n, long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeLong(l);
                    this.mRemote.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setDefaultDataSubId(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(22, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setDefaultSmsSubId(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(26, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setDefaultVoiceSubId(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(24, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int setDisplayName(String string2, long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeLong(l);
                    this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int setDisplayNameUsingSrc(String string2, long l, long l2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeLong(l);
                    parcel.writeLong(l2);
                    this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int setDisplayNumber(String string2, long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeLong(l);
                    this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int setDisplayNumberFormat(int n, long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeLong(l);
                    this.mRemote.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

