/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Intent;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.CellInfo;
import android.telephony.IccOpenLogicalChannelResponse;
import android.telephony.NeighboringCellInfo;
import java.util.ArrayList;
import java.util.List;

public interface ITelephony
extends IInterface {
    public void answerRingingCall() throws RemoteException;

    public void call(String var1, String var2) throws RemoteException;

    public int checkCarrierPrivilegesForPackage(String var1) throws RemoteException;

    public void dial(String var1) throws RemoteException;

    public boolean disableDataConnectivity() throws RemoteException;

    public void disableLocationUpdates() throws RemoteException;

    public void disableLocationUpdatesForSubscriber(long var1) throws RemoteException;

    public boolean enableDataConnectivity() throws RemoteException;

    public void enableLocationUpdates() throws RemoteException;

    public void enableLocationUpdatesForSubscriber(long var1) throws RemoteException;

    public void enableSimplifiedNetworkSettingsForSubscriber(long var1, boolean var3) throws RemoteException;

    public boolean endCall() throws RemoteException;

    public boolean endCallForSubscriber(long var1) throws RemoteException;

    public int getActivePhoneType() throws RemoteException;

    public int getActivePhoneTypeForSubscriber(long var1) throws RemoteException;

    public List<CellInfo> getAllCellInfo() throws RemoteException;

    public int getCalculatedPreferredNetworkType() throws RemoteException;

    public int getCallState() throws RemoteException;

    public int getCallStateForSubscriber(long var1) throws RemoteException;

    public List<String> getCarrierPackageNamesForIntent(Intent var1) throws RemoteException;

    public int getCdmaEriIconIndex() throws RemoteException;

    public int getCdmaEriIconIndexForSubscriber(long var1) throws RemoteException;

    public int getCdmaEriIconMode() throws RemoteException;

    public int getCdmaEriIconModeForSubscriber(long var1) throws RemoteException;

    public String getCdmaEriText() throws RemoteException;

    public String getCdmaEriTextForSubscriber(long var1) throws RemoteException;

    public String getCdmaMdn(long var1) throws RemoteException;

    public String getCdmaMin(long var1) throws RemoteException;

    public Bundle getCellLocation() throws RemoteException;

    public Bundle getCellLocationForSlotID(int var1) throws RemoteException;

    public int getDataActivity() throws RemoteException;

    public boolean getDataEnabled() throws RemoteException;

    public int getDataNetworkType() throws RemoteException;

    public int getDataNetworkTypeForSubscriber(long var1) throws RemoteException;

    public int getDataState() throws RemoteException;

    public int getDefaultSim() throws RemoteException;

    public String getLine1AlphaTagForDisplay(long var1) throws RemoteException;

    public String getLine1NumberForDisplay(long var1) throws RemoteException;

    public int getLteOnCdmaMode() throws RemoteException;

    public int getLteOnCdmaModeForSubscriber(long var1) throws RemoteException;

    public List<NeighboringCellInfo> getNeighboringCellInfo(String var1) throws RemoteException;

    public int getNetworkType() throws RemoteException;

    public int getNetworkTypeForSubscriber(long var1) throws RemoteException;

    public String[] getPcscfAddress(String var1) throws RemoteException;

    public int getPreferredNetworkType() throws RemoteException;

    public boolean getSimplifiedNetworkSettingsEnabledForSubscriber(long var1) throws RemoteException;

    public int getVoiceMessageCount() throws RemoteException;

    public int getVoiceMessageCountForSubscriber(long var1) throws RemoteException;

    public int getVoiceNetworkType() throws RemoteException;

    public int getVoiceNetworkTypeForSubscriber(long var1) throws RemoteException;

    public boolean handlePinMmi(String var1) throws RemoteException;

    public boolean handlePinMmiForSubscriber(long var1, String var3) throws RemoteException;

    public int hasCarrierPrivileges() throws RemoteException;

    public boolean hasIccCard() throws RemoteException;

    public boolean hasIccCardUsingSlotId(int var1) throws RemoteException;

    public boolean iccCloseLogicalChannel(int var1) throws RemoteException;

    public byte[] iccExchangeSimIO(int var1, int var2, int var3, int var4, int var5, String var6) throws RemoteException;

    public IccOpenLogicalChannelResponse iccOpenLogicalChannel(String var1) throws RemoteException;

    public String iccTransmitApduBasicChannel(int var1, int var2, int var3, int var4, int var5, String var6) throws RemoteException;

    public String iccTransmitApduLogicalChannel(int var1, int var2, int var3, int var4, int var5, int var6, String var7) throws RemoteException;

    public int invokeOemRilRequestRaw(byte[] var1, byte[] var2) throws RemoteException;

    public boolean isDataConnectivityPossible() throws RemoteException;

    public boolean isIdle() throws RemoteException;

    public boolean isIdleForSubscriber(long var1) throws RemoteException;

    public boolean isOffhook() throws RemoteException;

    public boolean isOffhookForSubscriber(long var1) throws RemoteException;

    public boolean isRadioOn() throws RemoteException;

    public boolean isRadioOnForSubscriber(long var1) throws RemoteException;

    public boolean isRinging() throws RemoteException;

    public boolean isRingingForSubscriber(long var1) throws RemoteException;

    public boolean isSimPinEnabled() throws RemoteException;

    public boolean needMobileRadioShutdown() throws RemoteException;

    public boolean needsOtaServiceProvisioning() throws RemoteException;

    public String nvReadItem(int var1) throws RemoteException;

    public boolean nvResetConfig(int var1) throws RemoteException;

    public boolean nvWriteCdmaPrl(byte[] var1) throws RemoteException;

    public boolean nvWriteItem(int var1, String var2) throws RemoteException;

    public String sendEnvelopeWithStatus(String var1) throws RemoteException;

    public void setCellInfoListRate(int var1) throws RemoteException;

    public void setDataEnabled(boolean var1) throws RemoteException;

    public void setImsRegistrationState(boolean var1) throws RemoteException;

    public void setLine1NumberForDisplayForSubscriber(long var1, String var3, String var4) throws RemoteException;

    public boolean setOperatorBrandOverride(String var1) throws RemoteException;

    public boolean setPreferredNetworkType(int var1) throws RemoteException;

    public boolean setRadio(boolean var1) throws RemoteException;

    public boolean setRadioForSubscriber(long var1, boolean var3) throws RemoteException;

    public boolean setRadioPower(boolean var1) throws RemoteException;

    public void shutdownMobileRadios() throws RemoteException;

    public void silenceRinger() throws RemoteException;

    public boolean supplyPin(String var1) throws RemoteException;

    public boolean supplyPinForSubscriber(long var1, String var3) throws RemoteException;

    public int[] supplyPinReportResult(String var1) throws RemoteException;

    public int[] supplyPinReportResultForSubscriber(long var1, String var3) throws RemoteException;

    public boolean supplyPuk(String var1, String var2) throws RemoteException;

    public boolean supplyPukForSubscriber(long var1, String var3, String var4) throws RemoteException;

    public int[] supplyPukReportResult(String var1, String var2) throws RemoteException;

    public int[] supplyPukReportResultForSubscriber(long var1, String var3, String var4) throws RemoteException;

    public void toggleRadioOnOff() throws RemoteException;

    public void toggleRadioOnOffForSubscriber(long var1) throws RemoteException;

    public void updateServiceLocation() throws RemoteException;

    public void updateServiceLocationForSubscriber(long var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITelephony {
        private static final String DESCRIPTOR = "com.android.internal.telephony.ITelephony";
        static final int TRANSACTION_answerRingingCall = 5;
        static final int TRANSACTION_call = 2;
        static final int TRANSACTION_checkCarrierPrivilegesForPackage = 91;
        static final int TRANSACTION_dial = 1;
        static final int TRANSACTION_disableDataConnectivity = 38;
        static final int TRANSACTION_disableLocationUpdates = 35;
        static final int TRANSACTION_disableLocationUpdatesForSubscriber = 36;
        static final int TRANSACTION_enableDataConnectivity = 37;
        static final int TRANSACTION_enableLocationUpdates = 33;
        static final int TRANSACTION_enableLocationUpdatesForSubscriber = 34;
        static final int TRANSACTION_enableSimplifiedNetworkSettingsForSubscriber = 93;
        static final int TRANSACTION_endCall = 3;
        static final int TRANSACTION_endCallForSubscriber = 4;
        static final int TRANSACTION_getActivePhoneType = 47;
        static final int TRANSACTION_getActivePhoneTypeForSubscriber = 48;
        static final int TRANSACTION_getAllCellInfo = 68;
        static final int TRANSACTION_getCalculatedPreferredNetworkType = 81;
        static final int TRANSACTION_getCallState = 43;
        static final int TRANSACTION_getCallStateForSubscriber = 44;
        static final int TRANSACTION_getCarrierPackageNamesForIntent = 92;
        static final int TRANSACTION_getCdmaEriIconIndex = 49;
        static final int TRANSACTION_getCdmaEriIconIndexForSubscriber = 50;
        static final int TRANSACTION_getCdmaEriIconMode = 51;
        static final int TRANSACTION_getCdmaEriIconModeForSubscriber = 52;
        static final int TRANSACTION_getCdmaEriText = 53;
        static final int TRANSACTION_getCdmaEriTextForSubscriber = 54;
        static final int TRANSACTION_getCdmaMdn = 88;
        static final int TRANSACTION_getCdmaMin = 89;
        static final int TRANSACTION_getCellLocation = 40;
        static final int TRANSACTION_getCellLocationForSlotID = 41;
        static final int TRANSACTION_getDataActivity = 45;
        static final int TRANSACTION_getDataEnabled = 85;
        static final int TRANSACTION_getDataNetworkType = 60;
        static final int TRANSACTION_getDataNetworkTypeForSubscriber = 61;
        static final int TRANSACTION_getDataState = 46;
        static final int TRANSACTION_getDefaultSim = 70;
        static final int TRANSACTION_getLine1AlphaTagForDisplay = 97;
        static final int TRANSACTION_getLine1NumberForDisplay = 96;
        static final int TRANSACTION_getLteOnCdmaMode = 66;
        static final int TRANSACTION_getLteOnCdmaModeForSubscriber = 67;
        static final int TRANSACTION_getNeighboringCellInfo = 42;
        static final int TRANSACTION_getNetworkType = 58;
        static final int TRANSACTION_getNetworkTypeForSubscriber = 59;
        static final int TRANSACTION_getPcscfAddress = 86;
        static final int TRANSACTION_getPreferredNetworkType = 82;
        static final int TRANSACTION_getSimplifiedNetworkSettingsEnabledForSubscriber = 94;
        static final int TRANSACTION_getVoiceMessageCount = 56;
        static final int TRANSACTION_getVoiceMessageCountForSubscriber = 57;
        static final int TRANSACTION_getVoiceNetworkType = 62;
        static final int TRANSACTION_getVoiceNetworkTypeForSubscriber = 63;
        static final int TRANSACTION_handlePinMmi = 24;
        static final int TRANSACTION_handlePinMmiForSubscriber = 25;
        static final int TRANSACTION_hasCarrierPrivileges = 90;
        static final int TRANSACTION_hasIccCard = 64;
        static final int TRANSACTION_hasIccCardUsingSlotId = 65;
        static final int TRANSACTION_iccCloseLogicalChannel = 72;
        static final int TRANSACTION_iccExchangeSimIO = 75;
        static final int TRANSACTION_iccOpenLogicalChannel = 71;
        static final int TRANSACTION_iccTransmitApduBasicChannel = 74;
        static final int TRANSACTION_iccTransmitApduLogicalChannel = 73;
        static final int TRANSACTION_invokeOemRilRequestRaw = 99;
        static final int TRANSACTION_isDataConnectivityPossible = 39;
        static final int TRANSACTION_isIdle = 11;
        static final int TRANSACTION_isIdleForSubscriber = 12;
        static final int TRANSACTION_isOffhook = 7;
        static final int TRANSACTION_isOffhookForSubscriber = 8;
        static final int TRANSACTION_isRadioOn = 13;
        static final int TRANSACTION_isRadioOnForSubscriber = 14;
        static final int TRANSACTION_isRinging = 10;
        static final int TRANSACTION_isRingingForSubscriber = 9;
        static final int TRANSACTION_isSimPinEnabled = 15;
        static final int TRANSACTION_needMobileRadioShutdown = 100;
        static final int TRANSACTION_needsOtaServiceProvisioning = 55;
        static final int TRANSACTION_nvReadItem = 77;
        static final int TRANSACTION_nvResetConfig = 80;
        static final int TRANSACTION_nvWriteCdmaPrl = 79;
        static final int TRANSACTION_nvWriteItem = 78;
        static final int TRANSACTION_sendEnvelopeWithStatus = 76;
        static final int TRANSACTION_setCellInfoListRate = 69;
        static final int TRANSACTION_setDataEnabled = 84;
        static final int TRANSACTION_setImsRegistrationState = 87;
        static final int TRANSACTION_setLine1NumberForDisplayForSubscriber = 95;
        static final int TRANSACTION_setOperatorBrandOverride = 98;
        static final int TRANSACTION_setPreferredNetworkType = 83;
        static final int TRANSACTION_setRadio = 28;
        static final int TRANSACTION_setRadioForSubscriber = 29;
        static final int TRANSACTION_setRadioPower = 30;
        static final int TRANSACTION_shutdownMobileRadios = 101;
        static final int TRANSACTION_silenceRinger = 6;
        static final int TRANSACTION_supplyPin = 16;
        static final int TRANSACTION_supplyPinForSubscriber = 17;
        static final int TRANSACTION_supplyPinReportResult = 20;
        static final int TRANSACTION_supplyPinReportResultForSubscriber = 21;
        static final int TRANSACTION_supplyPuk = 18;
        static final int TRANSACTION_supplyPukForSubscriber = 19;
        static final int TRANSACTION_supplyPukReportResult = 22;
        static final int TRANSACTION_supplyPukReportResultForSubscriber = 23;
        static final int TRANSACTION_toggleRadioOnOff = 26;
        static final int TRANSACTION_toggleRadioOnOffForSubscriber = 27;
        static final int TRANSACTION_updateServiceLocation = 31;
        static final int TRANSACTION_updateServiceLocationForSubscriber = 32;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ITelephony asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof ITelephony) {
                return (ITelephony)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.dial(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.call(parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.endCall();
                    parcel2.writeNoException();
                    int n3 = bl ? 1 : 0;
                    parcel2.writeInt(n3);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.endCallForSubscriber(parcel.readLong());
                    parcel2.writeNoException();
                    int n4 = bl ? 1 : 0;
                    parcel2.writeInt(n4);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.answerRingingCall();
                    parcel2.writeNoException();
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.silenceRinger();
                    parcel2.writeNoException();
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isOffhook();
                    parcel2.writeNoException();
                    int n5 = bl ? 1 : 0;
                    parcel2.writeInt(n5);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isOffhookForSubscriber(parcel.readLong());
                    parcel2.writeNoException();
                    int n6 = bl ? 1 : 0;
                    parcel2.writeInt(n6);
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isRingingForSubscriber(parcel.readLong());
                    parcel2.writeNoException();
                    int n7 = bl ? 1 : 0;
                    parcel2.writeInt(n7);
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isRinging();
                    parcel2.writeNoException();
                    int n8 = bl ? 1 : 0;
                    parcel2.writeInt(n8);
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isIdle();
                    parcel2.writeNoException();
                    int n9 = bl ? 1 : 0;
                    parcel2.writeInt(n9);
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isIdleForSubscriber(parcel.readLong());
                    parcel2.writeNoException();
                    int n10 = bl ? 1 : 0;
                    parcel2.writeInt(n10);
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isRadioOn();
                    parcel2.writeNoException();
                    int n11 = bl ? 1 : 0;
                    parcel2.writeInt(n11);
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isRadioOnForSubscriber(parcel.readLong());
                    parcel2.writeNoException();
                    int n12 = bl ? 1 : 0;
                    parcel2.writeInt(n12);
                    return true;
                }
                case 15: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isSimPinEnabled();
                    parcel2.writeNoException();
                    int n13 = bl ? 1 : 0;
                    parcel2.writeInt(n13);
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.supplyPin(parcel.readString());
                    parcel2.writeNoException();
                    int n14 = bl ? 1 : 0;
                    parcel2.writeInt(n14);
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.supplyPinForSubscriber(parcel.readLong(), parcel.readString());
                    parcel2.writeNoException();
                    int n15 = bl ? 1 : 0;
                    parcel2.writeInt(n15);
                    return true;
                }
                case 18: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.supplyPuk(parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    int n16 = bl ? 1 : 0;
                    parcel2.writeInt(n16);
                    return true;
                }
                case 19: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.supplyPukForSubscriber(parcel.readLong(), parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    int n17 = bl ? 1 : 0;
                    parcel2.writeInt(n17);
                    return true;
                }
                case 20: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int[] nArray = this.supplyPinReportResult(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeIntArray(nArray);
                    return true;
                }
                case 21: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int[] nArray = this.supplyPinReportResultForSubscriber(parcel.readLong(), parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeIntArray(nArray);
                    return true;
                }
                case 22: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int[] nArray = this.supplyPukReportResult(parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeIntArray(nArray);
                    return true;
                }
                case 23: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int[] nArray = this.supplyPukReportResultForSubscriber(parcel.readLong(), parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeIntArray(nArray);
                    return true;
                }
                case 24: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.handlePinMmi(parcel.readString());
                    parcel2.writeNoException();
                    int n18 = bl ? 1 : 0;
                    parcel2.writeInt(n18);
                    return true;
                }
                case 25: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.handlePinMmiForSubscriber(parcel.readLong(), parcel.readString());
                    parcel2.writeNoException();
                    int n19 = bl ? 1 : 0;
                    parcel2.writeInt(n19);
                    return true;
                }
                case 26: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.toggleRadioOnOff();
                    parcel2.writeNoException();
                    return true;
                }
                case 27: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.toggleRadioOnOffForSubscriber(parcel.readLong());
                    parcel2.writeNoException();
                    return true;
                }
                case 28: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    boolean bl2 = this.setRadio(bl);
                    parcel2.writeNoException();
                    int n20 = bl2 ? 1 : 0;
                    parcel2.writeInt(n20);
                    return true;
                }
                case 29: {
                    parcel.enforceInterface(DESCRIPTOR);
                    long l = parcel.readLong();
                    boolean bl = parcel.readInt() != 0;
                    boolean bl3 = this.setRadioForSubscriber(l, bl);
                    parcel2.writeNoException();
                    int n21 = bl3 ? 1 : 0;
                    parcel2.writeInt(n21);
                    return true;
                }
                case 30: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    boolean bl4 = this.setRadioPower(bl);
                    parcel2.writeNoException();
                    int n22 = bl4 ? 1 : 0;
                    parcel2.writeInt(n22);
                    return true;
                }
                case 31: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.updateServiceLocation();
                    parcel2.writeNoException();
                    return true;
                }
                case 32: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.updateServiceLocationForSubscriber(parcel.readLong());
                    parcel2.writeNoException();
                    return true;
                }
                case 33: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.enableLocationUpdates();
                    parcel2.writeNoException();
                    return true;
                }
                case 34: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.enableLocationUpdatesForSubscriber(parcel.readLong());
                    parcel2.writeNoException();
                    return true;
                }
                case 35: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.disableLocationUpdates();
                    parcel2.writeNoException();
                    return true;
                }
                case 36: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.disableLocationUpdatesForSubscriber(parcel.readLong());
                    parcel2.writeNoException();
                    return true;
                }
                case 37: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.enableDataConnectivity();
                    parcel2.writeNoException();
                    int n23 = bl ? 1 : 0;
                    parcel2.writeInt(n23);
                    return true;
                }
                case 38: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.disableDataConnectivity();
                    parcel2.writeNoException();
                    int n24 = bl ? 1 : 0;
                    parcel2.writeInt(n24);
                    return true;
                }
                case 39: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isDataConnectivityPossible();
                    parcel2.writeNoException();
                    int n25 = bl ? 1 : 0;
                    parcel2.writeInt(n25);
                    return true;
                }
                case 40: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Bundle bundle = this.getCellLocation();
                    parcel2.writeNoException();
                    if (bundle != null) {
                        parcel2.writeInt(1);
                        bundle.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 41: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Bundle bundle = this.getCellLocationForSlotID(parcel.readInt());
                    parcel2.writeNoException();
                    if (bundle != null) {
                        parcel2.writeInt(1);
                        bundle.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 42: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<NeighboringCellInfo> list = this.getNeighboringCellInfo(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 43: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n26 = this.getCallState();
                    parcel2.writeNoException();
                    parcel2.writeInt(n26);
                    return true;
                }
                case 44: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n27 = this.getCallStateForSubscriber(parcel.readLong());
                    parcel2.writeNoException();
                    parcel2.writeInt(n27);
                    return true;
                }
                case 45: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n28 = this.getDataActivity();
                    parcel2.writeNoException();
                    parcel2.writeInt(n28);
                    return true;
                }
                case 46: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n29 = this.getDataState();
                    parcel2.writeNoException();
                    parcel2.writeInt(n29);
                    return true;
                }
                case 47: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n30 = this.getActivePhoneType();
                    parcel2.writeNoException();
                    parcel2.writeInt(n30);
                    return true;
                }
                case 48: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n31 = this.getActivePhoneTypeForSubscriber(parcel.readLong());
                    parcel2.writeNoException();
                    parcel2.writeInt(n31);
                    return true;
                }
                case 49: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n32 = this.getCdmaEriIconIndex();
                    parcel2.writeNoException();
                    parcel2.writeInt(n32);
                    return true;
                }
                case 50: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n33 = this.getCdmaEriIconIndexForSubscriber(parcel.readLong());
                    parcel2.writeNoException();
                    parcel2.writeInt(n33);
                    return true;
                }
                case 51: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n34 = this.getCdmaEriIconMode();
                    parcel2.writeNoException();
                    parcel2.writeInt(n34);
                    return true;
                }
                case 52: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n35 = this.getCdmaEriIconModeForSubscriber(parcel.readLong());
                    parcel2.writeNoException();
                    parcel2.writeInt(n35);
                    return true;
                }
                case 53: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string2 = this.getCdmaEriText();
                    parcel2.writeNoException();
                    parcel2.writeString(string2);
                    return true;
                }
                case 54: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string3 = this.getCdmaEriTextForSubscriber(parcel.readLong());
                    parcel2.writeNoException();
                    parcel2.writeString(string3);
                    return true;
                }
                case 55: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.needsOtaServiceProvisioning();
                    parcel2.writeNoException();
                    int n36 = bl ? 1 : 0;
                    parcel2.writeInt(n36);
                    return true;
                }
                case 56: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n37 = this.getVoiceMessageCount();
                    parcel2.writeNoException();
                    parcel2.writeInt(n37);
                    return true;
                }
                case 57: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n38 = this.getVoiceMessageCountForSubscriber(parcel.readLong());
                    parcel2.writeNoException();
                    parcel2.writeInt(n38);
                    return true;
                }
                case 58: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n39 = this.getNetworkType();
                    parcel2.writeNoException();
                    parcel2.writeInt(n39);
                    return true;
                }
                case 59: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n40 = this.getNetworkTypeForSubscriber(parcel.readLong());
                    parcel2.writeNoException();
                    parcel2.writeInt(n40);
                    return true;
                }
                case 60: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n41 = this.getDataNetworkType();
                    parcel2.writeNoException();
                    parcel2.writeInt(n41);
                    return true;
                }
                case 61: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n42 = this.getDataNetworkTypeForSubscriber(parcel.readLong());
                    parcel2.writeNoException();
                    parcel2.writeInt(n42);
                    return true;
                }
                case 62: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n43 = this.getVoiceNetworkType();
                    parcel2.writeNoException();
                    parcel2.writeInt(n43);
                    return true;
                }
                case 63: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n44 = this.getVoiceNetworkTypeForSubscriber(parcel.readLong());
                    parcel2.writeNoException();
                    parcel2.writeInt(n44);
                    return true;
                }
                case 64: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.hasIccCard();
                    parcel2.writeNoException();
                    int n45 = bl ? 1 : 0;
                    parcel2.writeInt(n45);
                    return true;
                }
                case 65: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.hasIccCardUsingSlotId(parcel.readInt());
                    parcel2.writeNoException();
                    int n46 = bl ? 1 : 0;
                    parcel2.writeInt(n46);
                    return true;
                }
                case 66: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n47 = this.getLteOnCdmaMode();
                    parcel2.writeNoException();
                    parcel2.writeInt(n47);
                    return true;
                }
                case 67: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n48 = this.getLteOnCdmaModeForSubscriber(parcel.readLong());
                    parcel2.writeNoException();
                    parcel2.writeInt(n48);
                    return true;
                }
                case 68: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<CellInfo> list = this.getAllCellInfo();
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 69: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setCellInfoListRate(parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 70: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n49 = this.getDefaultSim();
                    parcel2.writeNoException();
                    parcel2.writeInt(n49);
                    return true;
                }
                case 71: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IccOpenLogicalChannelResponse iccOpenLogicalChannelResponse = this.iccOpenLogicalChannel(parcel.readString());
                    parcel2.writeNoException();
                    if (iccOpenLogicalChannelResponse != null) {
                        parcel2.writeInt(1);
                        iccOpenLogicalChannelResponse.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 72: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.iccCloseLogicalChannel(parcel.readInt());
                    parcel2.writeNoException();
                    int n50 = bl ? 1 : 0;
                    parcel2.writeInt(n50);
                    return true;
                }
                case 73: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string4 = this.iccTransmitApduLogicalChannel(parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeString(string4);
                    return true;
                }
                case 74: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string5 = this.iccTransmitApduBasicChannel(parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeString(string5);
                    return true;
                }
                case 75: {
                    parcel.enforceInterface(DESCRIPTOR);
                    byte[] byArray = this.iccExchangeSimIO(parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeByteArray(byArray);
                    return true;
                }
                case 76: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string6 = this.sendEnvelopeWithStatus(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeString(string6);
                    return true;
                }
                case 77: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string7 = this.nvReadItem(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeString(string7);
                    return true;
                }
                case 78: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.nvWriteItem(parcel.readInt(), parcel.readString());
                    parcel2.writeNoException();
                    int n51 = bl ? 1 : 0;
                    parcel2.writeInt(n51);
                    return true;
                }
                case 79: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.nvWriteCdmaPrl(parcel.createByteArray());
                    parcel2.writeNoException();
                    int n52 = bl ? 1 : 0;
                    parcel2.writeInt(n52);
                    return true;
                }
                case 80: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.nvResetConfig(parcel.readInt());
                    parcel2.writeNoException();
                    int n53 = bl ? 1 : 0;
                    parcel2.writeInt(n53);
                    return true;
                }
                case 81: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n54 = this.getCalculatedPreferredNetworkType();
                    parcel2.writeNoException();
                    parcel2.writeInt(n54);
                    return true;
                }
                case 82: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n55 = this.getPreferredNetworkType();
                    parcel2.writeNoException();
                    parcel2.writeInt(n55);
                    return true;
                }
                case 83: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.setPreferredNetworkType(parcel.readInt());
                    parcel2.writeNoException();
                    int n56 = bl ? 1 : 0;
                    parcel2.writeInt(n56);
                    return true;
                }
                case 84: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.setDataEnabled(bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 85: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.getDataEnabled();
                    parcel2.writeNoException();
                    int n57 = bl ? 1 : 0;
                    parcel2.writeInt(n57);
                    return true;
                }
                case 86: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String[] stringArray = this.getPcscfAddress(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeStringArray(stringArray);
                    return true;
                }
                case 87: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.setImsRegistrationState(bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 88: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string8 = this.getCdmaMdn(parcel.readLong());
                    parcel2.writeNoException();
                    parcel2.writeString(string8);
                    return true;
                }
                case 89: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string9 = this.getCdmaMin(parcel.readLong());
                    parcel2.writeNoException();
                    parcel2.writeString(string9);
                    return true;
                }
                case 90: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n58 = this.hasCarrierPrivileges();
                    parcel2.writeNoException();
                    parcel2.writeInt(n58);
                    return true;
                }
                case 91: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n59 = this.checkCarrierPrivilegesForPackage(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n59);
                    return true;
                }
                case 92: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Intent intent = parcel.readInt() != 0 ? Intent.CREATOR.createFromParcel(parcel) : null;
                    List<String> list = this.getCarrierPackageNamesForIntent(intent);
                    parcel2.writeNoException();
                    parcel2.writeStringList(list);
                    return true;
                }
                case 93: {
                    parcel.enforceInterface(DESCRIPTOR);
                    long l = parcel.readLong();
                    boolean bl = parcel.readInt() != 0;
                    this.enableSimplifiedNetworkSettingsForSubscriber(l, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 94: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.getSimplifiedNetworkSettingsEnabledForSubscriber(parcel.readLong());
                    parcel2.writeNoException();
                    int n60 = bl ? 1 : 0;
                    parcel2.writeInt(n60);
                    return true;
                }
                case 95: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setLine1NumberForDisplayForSubscriber(parcel.readLong(), parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 96: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string10 = this.getLine1NumberForDisplay(parcel.readLong());
                    parcel2.writeNoException();
                    parcel2.writeString(string10);
                    return true;
                }
                case 97: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string11 = this.getLine1AlphaTagForDisplay(parcel.readLong());
                    parcel2.writeNoException();
                    parcel2.writeString(string11);
                    return true;
                }
                case 98: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.setOperatorBrandOverride(parcel.readString());
                    parcel2.writeNoException();
                    int n61 = bl ? 1 : 0;
                    parcel2.writeInt(n61);
                    return true;
                }
                case 99: {
                    parcel.enforceInterface(DESCRIPTOR);
                    byte[] byArray = parcel.createByteArray();
                    int n62 = parcel.readInt();
                    byte[] byArray2 = n62 < 0 ? null : new byte[n62];
                    int n63 = this.invokeOemRilRequestRaw(byArray, byArray2);
                    parcel2.writeNoException();
                    parcel2.writeInt(n63);
                    parcel2.writeByteArray(byArray2);
                    return true;
                }
                case 100: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.needMobileRadioShutdown();
                    parcel2.writeNoException();
                    int n64 = bl ? 1 : 0;
                    parcel2.writeInt(n64);
                    return true;
                }
                case 101: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            this.shutdownMobileRadios();
            parcel2.writeNoException();
            return true;
        }

        private static class Proxy
        implements ITelephony {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public void answerRingingCall() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override
            public void call(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int checkCarrierPrivilegesForPackage(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(91, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void dial(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean disableDataConnectivity() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(38, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void disableLocationUpdates() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(35, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void disableLocationUpdatesForSubscriber(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(36, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean enableDataConnectivity() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(37, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void enableLocationUpdates() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(33, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void enableLocationUpdatesForSubscriber(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(34, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void enableSimplifiedNetworkSettingsForSubscriber(long l, boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeLong(l);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(93, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public boolean endCall() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean endCallForSubscriber(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int getActivePhoneType() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(47, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getActivePhoneTypeForSubscriber(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(48, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<CellInfo> getAllCellInfo() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(68, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<CellInfo> arrayList = parcel2.createTypedArrayList(CellInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getCalculatedPreferredNetworkType() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(81, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getCallState() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(43, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getCallStateForSubscriber(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(44, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<String> getCarrierPackageNamesForIntent(Intent intent) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        parcel.writeInt(1);
                        intent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(92, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<String> arrayList = parcel2.createStringArrayList();
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getCdmaEriIconIndex() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(49, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getCdmaEriIconIndexForSubscriber(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(50, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getCdmaEriIconMode() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(51, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getCdmaEriIconModeForSubscriber(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(52, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String getCdmaEriText() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(53, parcel, parcel2, 0);
                    parcel2.readException();
                    String string2 = parcel2.readString();
                    return string2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String getCdmaEriTextForSubscriber(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(54, parcel, parcel2, 0);
                    parcel2.readException();
                    String string2 = parcel2.readString();
                    return string2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String getCdmaMdn(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(88, parcel, parcel2, 0);
                    parcel2.readException();
                    String string2 = parcel2.readString();
                    return string2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String getCdmaMin(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(89, parcel, parcel2, 0);
                    parcel2.readException();
                    String string2 = parcel2.readString();
                    return string2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Bundle getCellLocation() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(40, parcel, parcel2, 0);
                    parcel2.readException();
                    Bundle bundle = parcel2.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel2) : null;
                    return bundle;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Bundle getCellLocationForSlotID(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(41, parcel, parcel2, 0);
                    parcel2.readException();
                    Bundle bundle = parcel2.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel2) : null;
                    return bundle;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getDataActivity() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(45, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean getDataEnabled() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(85, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int getDataNetworkType() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(60, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getDataNetworkTypeForSubscriber(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(61, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getDataState() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(46, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getDefaultSim() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(70, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public String getLine1AlphaTagForDisplay(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(97, parcel, parcel2, 0);
                    parcel2.readException();
                    String string2 = parcel2.readString();
                    return string2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String getLine1NumberForDisplay(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(96, parcel, parcel2, 0);
                    parcel2.readException();
                    String string2 = parcel2.readString();
                    return string2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getLteOnCdmaMode() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(66, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getLteOnCdmaModeForSubscriber(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(67, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<NeighboringCellInfo> getNeighboringCellInfo(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(42, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<NeighboringCellInfo> arrayList = parcel2.createTypedArrayList(NeighboringCellInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getNetworkType() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(58, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getNetworkTypeForSubscriber(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(59, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String[] getPcscfAddress(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(86, parcel, parcel2, 0);
                    parcel2.readException();
                    String[] stringArray = parcel2.createStringArray();
                    return stringArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getPreferredNetworkType() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(82, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean getSimplifiedNetworkSettingsEnabledForSubscriber(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(94, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int getVoiceMessageCount() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(56, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getVoiceMessageCountForSubscriber(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(57, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getVoiceNetworkType() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(62, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getVoiceNetworkTypeForSubscriber(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(63, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean handlePinMmi(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(24, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean handlePinMmiForSubscriber(long l, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    parcel.writeString(string2);
                    this.mRemote.transact(25, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int hasCarrierPrivileges() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(90, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean hasIccCard() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(64, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean hasIccCardUsingSlotId(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(65, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl = false;
                    if (n2 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean iccCloseLogicalChannel(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(72, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl = false;
                    if (n2 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public byte[] iccExchangeSimIO(int n, int n2, int n3, int n4, int n5, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    parcel.writeInt(n4);
                    parcel.writeInt(n5);
                    parcel.writeString(string2);
                    this.mRemote.transact(75, parcel, parcel2, 0);
                    parcel2.readException();
                    byte[] byArray = parcel2.createByteArray();
                    return byArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public IccOpenLogicalChannelResponse iccOpenLogicalChannel(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(71, parcel, parcel2, 0);
                    parcel2.readException();
                    IccOpenLogicalChannelResponse iccOpenLogicalChannelResponse = parcel2.readInt() != 0 ? IccOpenLogicalChannelResponse.CREATOR.createFromParcel(parcel2) : null;
                    return iccOpenLogicalChannelResponse;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String iccTransmitApduBasicChannel(int n, int n2, int n3, int n4, int n5, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    parcel.writeInt(n4);
                    parcel.writeInt(n5);
                    parcel.writeString(string2);
                    this.mRemote.transact(74, parcel, parcel2, 0);
                    parcel2.readException();
                    String string3 = parcel2.readString();
                    return string3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String iccTransmitApduLogicalChannel(int n, int n2, int n3, int n4, int n5, int n6, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    parcel.writeInt(n4);
                    parcel.writeInt(n5);
                    parcel.writeInt(n6);
                    parcel.writeString(string2);
                    this.mRemote.transact(73, parcel, parcel2, 0);
                    parcel2.readException();
                    String string3 = parcel2.readString();
                    return string3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int invokeOemRilRequestRaw(byte[] byArray, byte[] byArray2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeByteArray(byArray);
                    if (byArray2 == null) {
                        parcel.writeInt(-1);
                    } else {
                        parcel.writeInt(byArray2.length);
                    }
                    this.mRemote.transact(99, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    parcel2.readByteArray(byArray2);
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean isDataConnectivityPossible() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(39, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isIdle() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isIdleForSubscriber(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isOffhook() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isOffhookForSubscriber(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isRadioOn() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isRadioOnForSubscriber(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isRinging() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isRingingForSubscriber(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isSimPinEnabled() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean needMobileRadioShutdown() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(100, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean needsOtaServiceProvisioning() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(55, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public String nvReadItem(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(77, parcel, parcel2, 0);
                    parcel2.readException();
                    String string2 = parcel2.readString();
                    return string2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean nvResetConfig(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(80, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl = false;
                    if (n2 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean nvWriteCdmaPrl(byte[] byArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeByteArray(byArray);
                    this.mRemote.transact(79, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean nvWriteItem(int n, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeString(string2);
                    this.mRemote.transact(78, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl = false;
                    if (n2 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public String sendEnvelopeWithStatus(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(76, parcel, parcel2, 0);
                    parcel2.readException();
                    String string3 = parcel2.readString();
                    return string3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setCellInfoListRate(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(69, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setDataEnabled(boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(84, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void setImsRegistrationState(boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(87, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void setLine1NumberForDisplayForSubscriber(long l, String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(95, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean setOperatorBrandOverride(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(98, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean setPreferredNetworkType(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(83, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl = false;
                    if (n2 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean setRadio(boolean bl) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl2;
                block3: {
                    block2: {
                        bl2 = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            boolean bl3 = bl ? bl2 : false;
                            parcel2.writeInt(bl3 ? 1 : 0);
                            this.mRemote.transact(28, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block2;
                            break block3;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl2 = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl2;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean setRadioForSubscriber(long l, boolean bl) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl2;
                block3: {
                    block2: {
                        bl2 = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            parcel2.writeLong(l);
                            boolean bl3 = bl ? bl2 : false;
                            parcel2.writeInt(bl3 ? 1 : 0);
                            this.mRemote.transact(29, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block2;
                            break block3;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl2 = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl2;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean setRadioPower(boolean bl) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl2;
                block3: {
                    block2: {
                        bl2 = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            boolean bl3 = bl ? bl2 : false;
                            parcel2.writeInt(bl3 ? 1 : 0);
                            this.mRemote.transact(30, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block2;
                            break block3;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl2 = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl2;
            }

            @Override
            public void shutdownMobileRadios() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(101, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void silenceRinger() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean supplyPin(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean supplyPinForSubscriber(long l, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    parcel.writeString(string2);
                    this.mRemote.transact(17, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int[] supplyPinReportResult(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(20, parcel, parcel2, 0);
                    parcel2.readException();
                    int[] nArray = parcel2.createIntArray();
                    return nArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int[] supplyPinReportResultForSubscriber(long l, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    parcel.writeString(string2);
                    this.mRemote.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    int[] nArray = parcel2.createIntArray();
                    return nArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean supplyPuk(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(18, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean supplyPukForSubscriber(long l, String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(19, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int[] supplyPukReportResult(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(22, parcel, parcel2, 0);
                    parcel2.readException();
                    int[] nArray = parcel2.createIntArray();
                    return nArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int[] supplyPukReportResultForSubscriber(long l, String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(23, parcel, parcel2, 0);
                    parcel2.readException();
                    int[] nArray = parcel2.createIntArray();
                    return nArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void toggleRadioOnOff() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(26, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void toggleRadioOnOffForSubscriber(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(27, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void updateServiceLocation() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(31, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void updateServiceLocationForSubscriber(long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    this.mRemote.transact(32, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

