/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ActionMode;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.android.internal.R;
import com.android.internal.widget.ScrollingTabContainerView;

public class ActionBarContainer
extends FrameLayout {
    private View mActionBarView;
    private View mActionContextView;
    private Drawable mBackground;
    private int mHeight;
    private boolean mIsSplit;
    private boolean mIsStacked;
    private boolean mIsTransitioning;
    private Drawable mSplitBackground;
    private Drawable mStackedBackground;
    private View mTabContainer;

    public ActionBarContainer(Context context) {
        this(context, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ActionBarContainer(Context context, AttributeSet attributeSet) {
        boolean bl = true;
        super(context, attributeSet);
        this.setBackground(new ActionBarBackgroundDrawable());
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ActionBar);
        this.mBackground = typedArray.getDrawable(2);
        this.mStackedBackground = typedArray.getDrawable(18);
        this.mHeight = typedArray.getDimensionPixelSize(4, -1);
        if (this.getId() == 16909237) {
            this.mIsSplit = bl;
            this.mSplitBackground = typedArray.getDrawable(19);
        }
        typedArray.recycle();
        if (this.mIsSplit) {
            if (this.mSplitBackground != null) {
                bl = false;
            }
        } else if (this.mBackground != null || this.mStackedBackground != null) {
            bl = false;
        }
        this.setWillNotDraw(bl);
    }

    private int getMeasuredHeightWithMargins(View view) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        return view.getMeasuredHeight() + layoutParams.topMargin + layoutParams.bottomMargin;
    }

    private static boolean isCollapsed(View view) {
        return view == null || view.getVisibility() == 8 || view.getMeasuredHeight() == 0;
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mBackground != null && this.mBackground.isStateful()) {
            this.mBackground.setState(this.getDrawableState());
        }
        if (this.mStackedBackground != null && this.mStackedBackground.isStateful()) {
            this.mStackedBackground.setState(this.getDrawableState());
        }
        if (this.mSplitBackground != null && this.mSplitBackground.isStateful()) {
            this.mSplitBackground.setState(this.getDrawableState());
        }
    }

    public View getTabContainer() {
        return this.mTabContainer;
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mBackground != null) {
            this.mBackground.jumpToCurrentState();
        }
        if (this.mStackedBackground != null) {
            this.mStackedBackground.jumpToCurrentState();
        }
        if (this.mSplitBackground != null) {
            this.mSplitBackground.jumpToCurrentState();
        }
    }

    @Override
    public void onFinishInflate() {
        super.onFinishInflate();
        this.mActionBarView = this.findViewById(16909235);
        this.mActionContextView = this.findViewById(16909236);
    }

    @Override
    public boolean onHoverEvent(MotionEvent motionEvent) {
        super.onHoverEvent(motionEvent);
        return true;
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return this.mIsTransitioning || super.onInterceptTouchEvent(motionEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        boolean bl2;
        super.onLayout(bl, n, n2, n3, n4);
        View view = this.mTabContainer;
        boolean bl3 = view != null && view.getVisibility() != 8;
        if (view != null && view.getVisibility() != 8) {
            int n5 = this.getMeasuredHeight();
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
            view.layout(n, n5 - view.getMeasuredHeight() - layoutParams.bottomMargin, n3, n5 - layoutParams.bottomMargin);
        }
        if (this.mIsSplit) {
            Drawable drawable2 = this.mSplitBackground;
            bl2 = false;
            if (drawable2 != null) {
                this.mSplitBackground.setBounds(0, 0, this.getMeasuredWidth(), this.getMeasuredHeight());
                bl2 = true;
            }
        } else {
            Drawable drawable3 = this.mBackground;
            bl2 = false;
            if (drawable3 != null) {
                if (this.mActionBarView.getVisibility() == 0) {
                    this.mBackground.setBounds(this.mActionBarView.getLeft(), this.mActionBarView.getTop(), this.mActionBarView.getRight(), this.mActionBarView.getBottom());
                } else if (this.mActionContextView != null && this.mActionContextView.getVisibility() == 0) {
                    this.mBackground.setBounds(this.mActionContextView.getLeft(), this.mActionContextView.getTop(), this.mActionContextView.getRight(), this.mActionContextView.getBottom());
                } else {
                    this.mBackground.setBounds(0, 0, 0, 0);
                }
                bl2 = true;
            }
            this.mIsStacked = bl3;
            if (bl3 && this.mStackedBackground != null) {
                this.mStackedBackground.setBounds(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
                bl2 = true;
            }
        }
        if (bl2) {
            this.invalidate();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onMeasure(int n, int n2) {
        if (this.mActionBarView == null && View.MeasureSpec.getMode(n2) == Integer.MIN_VALUE && this.mHeight >= 0) {
            n2 = View.MeasureSpec.makeMeasureSpec(Math.min(this.mHeight, View.MeasureSpec.getSize(n2)), Integer.MIN_VALUE);
        }
        super.onMeasure(n, n2);
        if (this.mActionBarView == null || this.mTabContainer == null || this.mTabContainer.getVisibility() == 8) {
            return;
        }
        int n3 = 0;
        int n4 = this.getChildCount();
        for (int i = 0; i < n4; ++i) {
            View view = this.getChildAt(i);
            if (view == this.mTabContainer) continue;
            int n5 = ActionBarContainer.isCollapsed(view) ? 0 : this.getMeasuredHeightWithMargins(view);
            n3 = Math.max(n3, n5);
        }
        int n6 = View.MeasureSpec.getMode(n2) == Integer.MIN_VALUE ? View.MeasureSpec.getSize(n2) : Integer.MAX_VALUE;
        this.setMeasuredDimension(this.getMeasuredWidth(), Math.min(n3 + this.getMeasuredHeightWithMargins(this.mTabContainer), n6));
    }

    @Override
    public void onResolveDrawables(int n) {
        super.onResolveDrawables(n);
        if (this.mBackground != null) {
            this.mBackground.setLayoutDirection(n);
        }
        if (this.mStackedBackground != null) {
            this.mStackedBackground.setLayoutDirection(n);
        }
        if (this.mSplitBackground != null) {
            this.mSplitBackground.setLayoutDirection(n);
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        super.onTouchEvent(motionEvent);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setPrimaryBackground(Drawable drawable2) {
        boolean bl = true;
        if (this.mBackground != null) {
            this.mBackground.setCallback(null);
            this.unscheduleDrawable(this.mBackground);
        }
        this.mBackground = drawable2;
        if (drawable2 != null) {
            drawable2.setCallback(this);
            if (this.mActionBarView != null) {
                this.mBackground.setBounds(this.mActionBarView.getLeft(), this.mActionBarView.getTop(), this.mActionBarView.getRight(), this.mActionBarView.getBottom());
            }
        }
        if (this.mIsSplit) {
            if (this.mSplitBackground != null) {
                bl = false;
            }
        } else if (this.mBackground != null || this.mStackedBackground != null) {
            bl = false;
        }
        this.setWillNotDraw(bl);
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setSplitBackground(Drawable drawable2) {
        boolean bl = true;
        if (this.mSplitBackground != null) {
            this.mSplitBackground.setCallback(null);
            this.unscheduleDrawable(this.mSplitBackground);
        }
        this.mSplitBackground = drawable2;
        if (drawable2 != null) {
            drawable2.setCallback(this);
            if (this.mIsSplit && this.mSplitBackground != null) {
                this.mSplitBackground.setBounds(0, 0, this.getMeasuredWidth(), this.getMeasuredHeight());
            }
        }
        if (this.mIsSplit) {
            if (this.mSplitBackground != null) {
                bl = false;
            }
        } else if (this.mBackground != null || this.mStackedBackground != null) {
            bl = false;
        }
        this.setWillNotDraw(bl);
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setStackedBackground(Drawable drawable2) {
        boolean bl = true;
        if (this.mStackedBackground != null) {
            this.mStackedBackground.setCallback(null);
            this.unscheduleDrawable(this.mStackedBackground);
        }
        this.mStackedBackground = drawable2;
        if (drawable2 != null) {
            drawable2.setCallback(this);
            if (this.mIsStacked && this.mStackedBackground != null) {
                this.mStackedBackground.setBounds(this.mTabContainer.getLeft(), this.mTabContainer.getTop(), this.mTabContainer.getRight(), this.mTabContainer.getBottom());
            }
        }
        if (this.mIsSplit) {
            if (this.mSplitBackground != null) {
                bl = false;
            }
        } else if (this.mBackground != null || this.mStackedBackground != null) {
            bl = false;
        }
        this.setWillNotDraw(bl);
        this.invalidate();
    }

    public void setTabContainer(ScrollingTabContainerView scrollingTabContainerView) {
        if (this.mTabContainer != null) {
            this.removeView(this.mTabContainer);
        }
        this.mTabContainer = scrollingTabContainerView;
        if (scrollingTabContainerView != null) {
            this.addView(scrollingTabContainerView);
            ViewGroup.LayoutParams layoutParams = scrollingTabContainerView.getLayoutParams();
            layoutParams.width = -1;
            layoutParams.height = -2;
            scrollingTabContainerView.setAllowCollapse(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setTransitioning(boolean bl) {
        this.mIsTransitioning = bl;
        int n = bl ? 393216 : 262144;
        this.setDescendantFocusability(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setVisibility(int n) {
        super.setVisibility(n);
        boolean bl = n == 0;
        if (this.mBackground != null) {
            this.mBackground.setVisible(bl, false);
        }
        if (this.mStackedBackground != null) {
            this.mStackedBackground.setVisible(bl, false);
        }
        if (this.mSplitBackground != null) {
            this.mSplitBackground.setVisible(bl, false);
        }
    }

    @Override
    public ActionMode startActionModeForChild(View view, ActionMode.Callback callback) {
        return null;
    }

    @Override
    protected boolean verifyDrawable(Drawable drawable2) {
        return drawable2 == this.mBackground && !this.mIsSplit || drawable2 == this.mStackedBackground && this.mIsStacked || drawable2 == this.mSplitBackground && this.mIsSplit || super.verifyDrawable(drawable2);
    }

    private class ActionBarBackgroundDrawable
    extends Drawable {
        private ActionBarBackgroundDrawable() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void draw(Canvas canvas) {
            if (ActionBarContainer.this.mIsSplit) {
                if (ActionBarContainer.this.mSplitBackground == null) return;
                ActionBarContainer.this.mSplitBackground.draw(canvas);
                return;
            }
            if (ActionBarContainer.this.mBackground != null) {
                ActionBarContainer.this.mBackground.draw(canvas);
            }
            if (ActionBarContainer.this.mStackedBackground == null || !ActionBarContainer.this.mIsStacked) return;
            ActionBarContainer.this.mStackedBackground.draw(canvas);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int getOpacity() {
            if (ActionBarContainer.this.mIsSplit) {
                if (ActionBarContainer.this.mSplitBackground == null || ActionBarContainer.this.mSplitBackground.getOpacity() != -1) return 0;
                return -1;
            }
            if (ActionBarContainer.this.mIsStacked && (ActionBarContainer.this.mStackedBackground == null || ActionBarContainer.this.mStackedBackground.getOpacity() != -1)) {
                return 0;
            }
            if (ActionBarContainer.isCollapsed(ActionBarContainer.this.mActionBarView) || ActionBarContainer.this.mBackground == null || ActionBarContainer.this.mBackground.getOpacity() != -1) return 0;
            return -1;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void getOutline(Outline outline) {
            if (ActionBarContainer.this.mIsSplit) {
                if (ActionBarContainer.this.mSplitBackground == null) return;
                ActionBarContainer.this.mSplitBackground.getOutline(outline);
                return;
            }
            if (ActionBarContainer.this.mBackground == null) return;
            ActionBarContainer.this.mBackground.getOutline(outline);
        }

        @Override
        public void setAlpha(int n) {
        }

        @Override
        public void setColorFilter(ColorFilter colorFilter) {
        }
    }
}

