/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.inputmethodservice.Keyboard;

public class PasswordEntryKeyboard
extends Keyboard {
    public static final int KEYCODE_SPACE = 32;
    private static final int SHIFT_LOCKED = 2;
    private static final int SHIFT_OFF = 0;
    private static final int SHIFT_ON = 1;
    static int sSpacebarVerticalCorrection;
    private Keyboard.Key mEnterKey;
    private Keyboard.Key mF1Key;
    private Drawable[] mOldShiftIcons = new Drawable[]{null, null};
    private Drawable mShiftIcon;
    private Keyboard.Key[] mShiftKeys = new Keyboard.Key[]{null, null};
    private Drawable mShiftLockIcon;
    private int mShiftState = 0;
    private Keyboard.Key mSpaceKey;

    public PasswordEntryKeyboard(Context context, int n) {
        this(context, n, 0);
    }

    public PasswordEntryKeyboard(Context context, int n, int n2) {
        super(context, n, n2);
        this.init(context);
    }

    public PasswordEntryKeyboard(Context context, int n, int n2, int n3) {
        this(context, n, 0, n2, n3);
    }

    public PasswordEntryKeyboard(Context context, int n, int n2, int n3, int n4) {
        super(context, n, n2, n3, n4);
        this.init(context);
    }

    public PasswordEntryKeyboard(Context context, int n, CharSequence charSequence, int n2, int n3) {
        super(context, n, charSequence, n2, n3);
    }

    private void init(Context context) {
        Resources resources = context.getResources();
        this.mShiftIcon = context.getDrawable(17303486);
        this.mShiftLockIcon = context.getDrawable(17303487);
        sSpacebarVerticalCorrection = resources.getDimensionPixelOffset(17104922);
    }

    @Override
    protected Keyboard.Key createKeyFromXml(Resources resources, Keyboard.Row row, int n, int n2, XmlResourceParser xmlResourceParser) {
        LatinKey latinKey = new LatinKey(resources, row, n, n2, xmlResourceParser);
        int n3 = latinKey.codes[0];
        if (n3 >= 0 && n3 != 10 && (n3 < 32 || n3 > 127)) {
            latinKey.label = " ";
            latinKey.setEnabled(false);
        }
        switch (latinKey.codes[0]) {
            default: {
                return latinKey;
            }
            case 10: {
                this.mEnterKey = latinKey;
                return latinKey;
            }
            case -103: {
                this.mF1Key = latinKey;
                return latinKey;
            }
            case 32: 
        }
        this.mSpaceKey = latinKey;
        return latinKey;
    }

    void enableShiftLock() {
        int n = 0;
        for (int n2 : this.getShiftKeyIndices()) {
            if (n2 < 0 || n >= this.mShiftKeys.length) continue;
            this.mShiftKeys[n] = this.getKeys().get(n2);
            if (this.mShiftKeys[n] instanceof LatinKey) {
                ((LatinKey)this.mShiftKeys[n]).enableShiftLock();
            }
            this.mOldShiftIcons[n] = this.mShiftKeys[n].icon;
            ++n;
        }
    }

    @Override
    public boolean isShifted() {
        if (this.mShiftKeys[0] != null) {
            int n = this.mShiftState;
            boolean bl = false;
            if (n != 0) {
                bl = true;
            }
            return bl;
        }
        return super.isShifted();
    }

    void setEnterKeyResources(Resources resources, int n, int n2, int n3) {
        if (this.mEnterKey != null) {
            this.mEnterKey.popupCharacters = null;
            this.mEnterKey.popupResId = 0;
            this.mEnterKey.text = null;
            this.mEnterKey.iconPreview = resources.getDrawable(n);
            this.mEnterKey.icon = resources.getDrawable(n2);
            this.mEnterKey.label = resources.getText(n3);
            if (this.mEnterKey.iconPreview != null) {
                this.mEnterKey.iconPreview.setBounds(0, 0, this.mEnterKey.iconPreview.getIntrinsicWidth(), this.mEnterKey.iconPreview.getIntrinsicHeight());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void setShiftLocked(boolean bl) {
        for (Keyboard.Key key : this.mShiftKeys) {
            if (key == null) continue;
            key.on = bl;
            key.icon = this.mShiftLockIcon;
        }
        int n = bl ? 2 : 1;
        this.mShiftState = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean setShifted(boolean bl) {
        boolean bl2;
        if (!bl) {
            bl2 = this.mShiftState != 0;
            this.mShiftState = 0;
        } else {
            int n = this.mShiftState;
            bl2 = false;
            if (n == 0) {
                bl2 = this.mShiftState == 0;
                this.mShiftState = 1;
            }
        }
        int n = 0;
        while (n < this.mShiftKeys.length) {
            if (this.mShiftKeys[n] != null) {
                if (!bl) {
                    this.mShiftKeys[n].on = false;
                    this.mShiftKeys[n].icon = this.mOldShiftIcons[n];
                } else if (this.mShiftState == 0) {
                    this.mShiftKeys[n].on = false;
                    this.mShiftKeys[n].icon = this.mShiftIcon;
                }
            }
            ++n;
        }
        return bl2;
    }

    static class LatinKey
    extends Keyboard.Key {
        private boolean mEnabled = true;
        private boolean mShiftLockEnabled;

        public LatinKey(Resources resources, Keyboard.Row row, int n, int n2, XmlResourceParser xmlResourceParser) {
            super(resources, row, n, n2, xmlResourceParser);
            if (this.popupCharacters != null && this.popupCharacters.length() == 0) {
                this.popupResId = 0;
            }
        }

        void enableShiftLock() {
            this.mShiftLockEnabled = true;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean isInside(int n, int n2) {
            if (!this.mEnabled) {
                return false;
            }
            int n3 = this.codes[0];
            if (n3 != -1 && n3 != -5) {
                if (n3 != 32) return super.isInside(n, n2);
                return super.isInside(n, n2 += sSpacebarVerticalCorrection);
            }
            n2 -= this.height / 10;
            if (n3 == -1) {
                n += this.width / 6;
            }
            if (n3 != -5) return super.isInside(n, n2);
            n -= this.width / 6;
            return super.isInside(n, n2);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onReleased(boolean bl) {
            if (!this.mShiftLockEnabled) {
                super.onReleased(bl);
                return;
            }
            boolean bl2 = !this.pressed;
            this.pressed = bl2;
        }

        void setEnabled(boolean bl) {
            this.mEnabled = bl;
        }
    }
}

