/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.StateSet;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.widget.RemoteViews;
import com.android.internal.R;

@RemoteViews.RemoteView
public class SizeAdaptiveLayout
extends ViewGroup {
    private static final long CROSSFADE_TIME = 250L;
    private static final boolean DEBUG = false;
    private static final int MAX_VALID_HEIGHT = 0;
    private static final int MIN_VALID_HEIGHT = 1;
    private static final boolean REPORT_BAD_BOUNDS = true;
    private static final String TAG = "SizeAdaptiveLayout";
    private View mActiveChild;
    private Animator.AnimatorListener mAnimatorListener;
    private int mCanceledAnimationCount;
    private View mEnteringView;
    private ObjectAnimator mFadePanel;
    private ObjectAnimator mFadeView;
    private View mLastActive;
    private View mLeavingView;
    private View mModestyPanel;
    private int mModestyPanelTop;
    private AnimatorSet mTransitionAnimation;

    public SizeAdaptiveLayout(Context context) {
        this(context, null);
    }

    public SizeAdaptiveLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public SizeAdaptiveLayout(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public SizeAdaptiveLayout(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.initialize();
    }

    static /* synthetic */ int access$008(SizeAdaptiveLayout sizeAdaptiveLayout) {
        int n = sizeAdaptiveLayout.mCanceledAnimationCount;
        sizeAdaptiveLayout.mCanceledAnimationCount = n + 1;
        return n;
    }

    static /* synthetic */ int access$010(SizeAdaptiveLayout sizeAdaptiveLayout) {
        int n = sizeAdaptiveLayout.mCanceledAnimationCount;
        sizeAdaptiveLayout.mCanceledAnimationCount = n - 1;
        return n;
    }

    static /* synthetic */ View access$102(SizeAdaptiveLayout sizeAdaptiveLayout, View view) {
        sizeAdaptiveLayout.mLeavingView = view;
        return view;
    }

    static /* synthetic */ View access$302(SizeAdaptiveLayout sizeAdaptiveLayout, View view) {
        sizeAdaptiveLayout.mEnteringView = view;
        return view;
    }

    private int clampSizeToBounds(int n, View view) {
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        int n2 = 0xFFFFFF & n;
        int n3 = Math.max(n2, layoutParams.minHeight);
        if (layoutParams.maxHeight != -1) {
            n3 = Math.min(n3, layoutParams.maxHeight);
        }
        if (n2 != n3) {
            Log.d(TAG, this + "child view " + view + " " + "measured out of bounds at " + n2 + "px " + "clamped to " + n3 + "px");
        }
        return n3;
    }

    private void initialize() {
        this.mModestyPanel = new View(this.getContext());
        Drawable drawable2 = this.getBackground();
        if (drawable2 instanceof StateListDrawable) {
            StateListDrawable stateListDrawable = (StateListDrawable)drawable2;
            stateListDrawable.setState(StateSet.WILD_CARD);
            drawable2 = stateListDrawable.getCurrent();
        }
        if (drawable2 instanceof ColorDrawable) {
            this.mModestyPanel.setBackgroundDrawable(drawable2);
        }
        LayoutParams layoutParams = new LayoutParams(-1, -1);
        this.mModestyPanel.setLayoutParams(layoutParams);
        this.addView(this.mModestyPanel);
        this.mFadePanel = ObjectAnimator.ofFloat((Object)this.mModestyPanel, "alpha", 0.0f);
        this.mFadeView = ObjectAnimator.ofFloat(null, "alpha", 0.0f);
        this.mAnimatorListener = new BringToFrontOnEnd();
        this.mTransitionAnimation = new AnimatorSet();
        this.mTransitionAnimation.play(this.mFadeView).with(this.mFadePanel);
        this.mTransitionAnimation.setDuration(250L);
        this.mTransitionAnimation.addListener(this.mAnimatorListener);
    }

    private View selectActiveChild(int n) {
        int n2 = View.MeasureSpec.getMode(n);
        int n3 = View.MeasureSpec.getSize(n);
        View view = null;
        View view2 = null;
        int n4 = 0;
        View view3 = null;
        int n5 = Integer.MAX_VALUE;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view4 = this.getChildAt(i);
            if (view4 == this.mModestyPanel) continue;
            LayoutParams layoutParams = (LayoutParams)view4.getLayoutParams();
            if (layoutParams.maxHeight == -1 && view == null) {
                view = view4;
            }
            if (layoutParams.maxHeight > n4) {
                n4 = layoutParams.maxHeight;
                view2 = view4;
            }
            if (layoutParams.minHeight < n5) {
                n5 = layoutParams.minHeight;
                view3 = view4;
            }
            if (n2 == 0 || n3 < layoutParams.minHeight || n3 > layoutParams.maxHeight) continue;
            return view4;
        }
        if (view != null) {
            view2 = view;
        }
        if (n2 == 0 || n3 > n4) {
            return view2;
        }
        return view3;
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    @Override
    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    @Override
    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    public View getModestyPanel() {
        return this.mModestyPanel;
    }

    public Animator getTransitionAnimation() {
        return this.mTransitionAnimation;
    }

    @Override
    public void onAttachedToWindow() {
        this.mLastActive = null;
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).setVisibility(8);
        }
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        this.mLastActive = this.mActiveChild;
        this.mActiveChild = this.selectActiveChild(View.MeasureSpec.makeMeasureSpec(n4 - n2, 0x40000000));
        if (this.mActiveChild == null) {
            return;
        }
        this.mActiveChild.setVisibility(0);
        if (this.mLastActive != this.mActiveChild && this.mLastActive != null) {
            this.mEnteringView = this.mActiveChild;
            this.mLeavingView = this.mLastActive;
            this.mEnteringView.setAlpha(1.0f);
            this.mModestyPanel.setAlpha(1.0f);
            this.mModestyPanel.bringToFront();
            this.mModestyPanelTop = this.mLeavingView.getHeight();
            this.mModestyPanel.setVisibility(0);
            this.mLeavingView.bringToFront();
            if (this.mTransitionAnimation.isRunning()) {
                this.mTransitionAnimation.cancel();
            }
            this.mFadeView.setTarget(this.mLeavingView);
            this.mFadeView.setFloatValues(0.0f);
            this.mFadePanel.setFloatValues(0.0f);
            this.mTransitionAnimation.setupStartValues();
            this.mTransitionAnimation.start();
        }
        int n5 = this.mActiveChild.getMeasuredWidth();
        int n6 = this.mActiveChild.getMeasuredHeight();
        this.mActiveChild.layout(0, 0, n5, n6);
        this.mModestyPanel.layout(0, this.mModestyPanelTop, n5, n6 + this.mModestyPanelTop);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        View view = this.selectActiveChild(n2);
        if (view == null) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        LayoutParams cfr_ignored_0 = (LayoutParams)view.getLayoutParams();
        this.measureChild(view, n, n2);
        int n3 = view.getMeasuredHeight();
        int n4 = view.getMeasuredHeight();
        int n5 = SizeAdaptiveLayout.combineMeasuredStates(0, view.getMeasuredState());
        this.setMeasuredDimension(SizeAdaptiveLayout.resolveSizeAndState(n4, n, n5), this.clampSizeToBounds(SizeAdaptiveLayout.resolveSizeAndState(n3, n2, n5), view));
    }

    class BringToFrontOnEnd
    implements Animator.AnimatorListener {
        static final /* synthetic */ boolean $assertionsDisabled;

        /*
         * Enabled aggressive block sorting
         */
        static {
            boolean bl = !SizeAdaptiveLayout.class.desiredAssertionStatus();
            $assertionsDisabled = bl;
        }

        BringToFrontOnEnd() {
        }

        @Override
        public void onAnimationCancel(Animator animator2) {
            SizeAdaptiveLayout.access$008(SizeAdaptiveLayout.this);
        }

        @Override
        public void onAnimationEnd(Animator animator2) {
            if (SizeAdaptiveLayout.this.mCanceledAnimationCount == 0) {
                SizeAdaptiveLayout.this.mLeavingView.setVisibility(8);
                SizeAdaptiveLayout.this.mModestyPanel.setVisibility(8);
                SizeAdaptiveLayout.this.mEnteringView.bringToFront();
                SizeAdaptiveLayout.access$302(SizeAdaptiveLayout.this, null);
                SizeAdaptiveLayout.access$102(SizeAdaptiveLayout.this, null);
                return;
            }
            SizeAdaptiveLayout.access$010(SizeAdaptiveLayout.this);
        }

        @Override
        public void onAnimationRepeat(Animator animator2) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        @Override
        public void onAnimationStart(Animator animator2) {
        }
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        public static final int UNBOUNDED = -1;
        @ViewDebug.ExportedProperty(category="layout")
        public int maxHeight;
        @ViewDebug.ExportedProperty(category="layout")
        public int minHeight;

        public LayoutParams() {
            this(0, 0);
        }

        public LayoutParams(int n, int n2) {
            this(n, n2, -1, -1);
        }

        public LayoutParams(int n, int n2, int n3, int n4) {
            super(n, n2);
            this.minHeight = n3;
            this.maxHeight = n4;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.SizeAdaptiveLayout_Layout);
            this.minHeight = typedArray.getDimensionPixelSize(1, 0);
            try {
                this.maxHeight = typedArray.getLayoutDimension(0, -1);
            }
            catch (Exception exception) {}
            typedArray.recycle();
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            this.minHeight = -1;
            this.maxHeight = -1;
        }

        @Override
        public String debug(String string2) {
            return string2 + "SizeAdaptiveLayout.LayoutParams={" + ", max=" + this.maxHeight + ", max=" + this.minHeight + "}";
        }
    }
}

