/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.media.AudioAttributes;
import android.os.Vibrator;
import android.provider.Settings;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.LinearInterpolator;
import android.view.animation.TranslateAnimation;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.internal.R;

public class SlidingTab
extends ViewGroup {
    private static final int ANIM_DURATION = 250;
    private static final int ANIM_TARGET_TIME = 500;
    private static final boolean DBG = false;
    private static final int HORIZONTAL = 0;
    private static final String LOG_TAG = "SlidingTab";
    private static final float THRESHOLD = 0.6666667f;
    private static final int TRACKING_MARGIN = 50;
    private static final int VERTICAL = 1;
    private static final long VIBRATE_LONG = 40L;
    private static final long VIBRATE_SHORT = 30L;
    private static final AudioAttributes VIBRATION_ATTRIBUTES = new AudioAttributes.Builder().setContentType(4).setUsage(13).build();
    private boolean mAnimating;
    private final Animation.AnimationListener mAnimationDoneListener = new Animation.AnimationListener(){

        @Override
        public void onAnimationEnd(Animation animation) {
            SlidingTab.this.onAnimationDone();
        }

        @Override
        public void onAnimationRepeat(Animation animation) {
        }

        @Override
        public void onAnimationStart(Animation animation) {
        }
    };
    private Slider mCurrentSlider;
    private final float mDensity;
    private int mGrabbedState = 0;
    private boolean mHoldLeftOnTransition = true;
    private boolean mHoldRightOnTransition = true;
    private final Slider mLeftSlider;
    private OnTriggerListener mOnTriggerListener;
    private final int mOrientation;
    private Slider mOtherSlider;
    private final Slider mRightSlider;
    private float mThreshold;
    private final Rect mTmpRect = new Rect();
    private boolean mTracking;
    private boolean mTriggered = false;
    private Vibrator mVibrator;

    public SlidingTab(Context context) {
        this(context, null);
    }

    public SlidingTab(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.SlidingTab);
        this.mOrientation = typedArray.getInt(0, 0);
        typedArray.recycle();
        this.mDensity = this.getResources().getDisplayMetrics().density;
        this.mLeftSlider = new Slider(this, 17302877, 17302860, 17302891);
        this.mRightSlider = new Slider(this, 17302886, 17302869, 17302891);
    }

    static /* synthetic */ boolean access$202(SlidingTab slidingTab, boolean bl) {
        slidingTab.mAnimating = bl;
        return bl;
    }

    private void cancelGrab() {
        this.mTracking = false;
        this.mTriggered = false;
        this.mOtherSlider.show(true);
        this.mCurrentSlider.reset(false);
        this.mCurrentSlider.hideTarget();
        this.mCurrentSlider = null;
        this.mOtherSlider = null;
        this.setGrabbedState(0);
    }

    private void dispatchTriggerEvent(int n) {
        this.vibrate(40L);
        if (this.mOnTriggerListener != null) {
            this.mOnTriggerListener.onTrigger(this, n);
        }
    }

    private boolean isHorizontal() {
        return this.mOrientation == 0;
    }

    private void log(String string2) {
        Log.d(LOG_TAG, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void moveHandle(float f, float f2) {
        ImageView imageView = this.mCurrentSlider.tab;
        TextView textView = this.mCurrentSlider.text;
        if (this.isHorizontal()) {
            int n = (int)f - imageView.getLeft() - imageView.getWidth() / 2;
            imageView.offsetLeftAndRight(n);
            textView.offsetLeftAndRight(n);
        } else {
            int n = (int)f2 - imageView.getTop() - imageView.getHeight() / 2;
            imageView.offsetTopAndBottom(n);
            textView.offsetTopAndBottom(n);
        }
        this.invalidate();
    }

    private void onAnimationDone() {
        this.resetView();
        this.mAnimating = false;
    }

    private void resetView() {
        this.mLeftSlider.reset(false);
        this.mRightSlider.reset(false);
    }

    private void setGrabbedState(int n) {
        if (n != this.mGrabbedState) {
            this.mGrabbedState = n;
            if (this.mOnTriggerListener != null) {
                this.mOnTriggerListener.onGrabbedStateChange(this, this.mGrabbedState);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void vibrate(long l) {
        boolean bl = true;
        synchronized (this) {
            if (Settings.System.getIntForUser(this.mContext.getContentResolver(), "haptic_feedback_enabled", 1, -2) == 0) return;
            if (!bl) return;
            if (this.mVibrator == null) {
                this.mVibrator = (Vibrator)this.getContext().getSystemService("vibrator");
            }
            this.mVibrator.vibrate(l, VIBRATION_ATTRIBUTES);
            return;
        }
    }

    private boolean withinView(float f, float f2, View view) {
        return this.isHorizontal() && f2 > -50.0f && f2 < (float)(50 + view.getHeight()) || !this.isHorizontal() && f > -50.0f && f < (float)(50 + view.getWidth());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        float f = 0.6666667f;
        float f2 = 0.3333333f;
        int n = motionEvent.getAction();
        float f3 = motionEvent.getX();
        float f4 = motionEvent.getY();
        if (this.mAnimating) {
            return false;
        }
        this.mLeftSlider.tab.getHitRect(this.mTmpRect);
        boolean bl = this.mTmpRect.contains((int)f3, (int)f4);
        this.mRightSlider.tab.getHitRect(this.mTmpRect);
        boolean bl2 = this.mTmpRect.contains((int)f3, (int)f4);
        if (!(this.mTracking || bl || bl2)) {
            return false;
        }
        switch (n) {
            default: {
                return true;
            }
            case 0: 
        }
        this.mTracking = true;
        this.mTriggered = false;
        this.vibrate(30L);
        if (bl) {
            this.mCurrentSlider = this.mLeftSlider;
            this.mOtherSlider = this.mRightSlider;
            if (!this.isHorizontal()) {
                f = f2;
            }
            this.mThreshold = f;
            this.setGrabbedState(1);
        } else {
            this.mCurrentSlider = this.mRightSlider;
            this.mOtherSlider = this.mLeftSlider;
            if (!this.isHorizontal()) {
                f2 = f;
            }
            this.mThreshold = f2;
            this.setGrabbedState(2);
        }
        this.mCurrentSlider.setState(1);
        this.mCurrentSlider.showTarget();
        this.mOtherSlider.hide();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        if (!bl) {
            return;
        }
        Slider slider = this.mLeftSlider;
        int n5 = this.isHorizontal() ? 0 : 3;
        slider.layout(n, n2, n3, n4, n5);
        Slider slider2 = this.mRightSlider;
        int n6 = this.isHorizontal() ? 1 : 2;
        slider2.layout(n, n2, n3, n4, n6);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3;
        int n4;
        View.MeasureSpec.getMode(n);
        int n5 = View.MeasureSpec.getSize(n);
        View.MeasureSpec.getMode(n2);
        int n6 = View.MeasureSpec.getSize(n2);
        this.mLeftSlider.measure();
        this.mRightSlider.measure();
        int n7 = this.mLeftSlider.getTabWidth();
        int n8 = this.mRightSlider.getTabWidth();
        int n9 = this.mLeftSlider.getTabHeight();
        int n10 = this.mRightSlider.getTabHeight();
        if (this.isHorizontal()) {
            n4 = Math.max(n5, n7 + n8);
            n3 = Math.max(n9, n10);
        } else {
            n4 = Math.max(n7, n10);
            n3 = Math.max(n6, n9 + n10);
        }
        this.setMeasuredDimension(n4, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        block6: {
            if (this.mTracking) {
                int n = motionEvent.getAction();
                float f = motionEvent.getX();
                float f2 = motionEvent.getY();
                switch (n) {
                    case 2: {
                        if (!this.withinView(f, f2, this)) break;
                        this.moveHandle(f, f2);
                        float f3 = this.isHorizontal() ? f : f2;
                        float f4 = this.mThreshold;
                        int n2 = this.isHorizontal() ? this.getWidth() : this.getHeight();
                        float f5 = f4 * (float)n2;
                        boolean bl = this.isHorizontal() ? (this.mCurrentSlider == this.mLeftSlider ? f3 > f5 : f3 < f5) : (this.mCurrentSlider == this.mLeftSlider ? f3 < f5 : f3 > f5);
                        if (!this.mTriggered && bl) {
                            this.mTriggered = true;
                            this.mTracking = false;
                            this.mCurrentSlider.setState(2);
                            boolean bl2 = this.mCurrentSlider == this.mLeftSlider;
                            int n3 = bl2 ? 1 : 2;
                            this.dispatchTriggerEvent(n3);
                            boolean bl3 = bl2 ? this.mHoldLeftOnTransition : this.mHoldRightOnTransition;
                            this.startAnimating(bl3);
                            this.setGrabbedState(0);
                        }
                    }
                    default: {
                        break block6;
                    }
                    case 1: 
                    case 3: 
                }
                this.cancelGrab();
            }
        }
        if (this.mTracking) return true;
        boolean bl = super.onTouchEvent(motionEvent);
        boolean bl4 = false;
        if (!bl) return bl4;
        return true;
    }

    @Override
    protected void onVisibilityChanged(View view, int n) {
        super.onVisibilityChanged(view, n);
        if (view == this && n != 0 && this.mGrabbedState != 0) {
            this.cancelGrab();
        }
    }

    public void reset(boolean bl) {
        this.mLeftSlider.reset(bl);
        this.mRightSlider.reset(bl);
        if (!bl) {
            this.mAnimating = false;
        }
    }

    public void setHoldAfterTrigger(boolean bl, boolean bl2) {
        this.mHoldLeftOnTransition = bl;
        this.mHoldRightOnTransition = bl2;
    }

    public void setLeftHintText(int n) {
        if (this.isHorizontal()) {
            this.mLeftSlider.setHintText(n);
        }
    }

    public void setLeftTabResources(int n, int n2, int n3, int n4) {
        this.mLeftSlider.setIcon(n);
        this.mLeftSlider.setTarget(n2);
        this.mLeftSlider.setBarBackgroundResource(n3);
        this.mLeftSlider.setTabBackgroundResource(n4);
        this.mLeftSlider.updateDrawableStates();
    }

    public void setOnTriggerListener(OnTriggerListener onTriggerListener) {
        this.mOnTriggerListener = onTriggerListener;
    }

    public void setRightHintText(int n) {
        if (this.isHorizontal()) {
            this.mRightSlider.setHintText(n);
        }
    }

    public void setRightTabResources(int n, int n2, int n3, int n4) {
        this.mRightSlider.setIcon(n);
        this.mRightSlider.setTarget(n2);
        this.mRightSlider.setBarBackgroundResource(n3);
        this.mRightSlider.setTabBackgroundResource(n4);
        this.mRightSlider.updateDrawableStates();
    }

    @Override
    public void setVisibility(int n) {
        if (n != this.getVisibility() && n == 4) {
            this.reset(false);
        }
        super.setVisibility(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    void startAnimating(final boolean bl) {
        int n;
        int n2;
        this.mAnimating = true;
        Slider slider = this.mCurrentSlider;
        if (this.isHorizontal()) {
            int n3 = slider.tab.getRight();
            int n4 = slider.tab.getWidth();
            int n5 = slider.tab.getLeft();
            int n6 = this.getWidth();
            int n7 = bl ? 0 : n4;
            n2 = slider == this.mRightSlider ? -(n3 + n6 - n7) : n6 + (n6 - n5) - n7;
            n = 0;
        } else {
            int n8 = slider.tab.getTop();
            int n9 = slider.tab.getBottom();
            int n10 = slider.tab.getHeight();
            int n11 = this.getHeight();
            int n12 = bl ? 0 : n10;
            n = slider == this.mRightSlider ? n8 + n11 - n12 : -(n11 + (n11 - n9) - n12);
            n2 = 0;
        }
        TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, n2, 0.0f, n);
        translateAnimation.setDuration(250L);
        translateAnimation.setInterpolator(new LinearInterpolator());
        translateAnimation.setFillAfter(true);
        TranslateAnimation translateAnimation2 = new TranslateAnimation(0.0f, n2, 0.0f, n);
        translateAnimation2.setDuration(250L);
        translateAnimation2.setInterpolator(new LinearInterpolator());
        translateAnimation2.setFillAfter(true);
        Animation.AnimationListener animationListener = new Animation.AnimationListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onAnimationEnd(Animation animation) {
                Animation animation2;
                if (bl) {
                    animation2 = new TranslateAnimation(n2, n2, n, n);
                    animation2.setDuration(1000L);
                    SlidingTab.access$202(SlidingTab.this, false);
                } else {
                    animation2 = new AlphaAnimation(0.5f, 1.0f);
                    animation2.setDuration(250L);
                    SlidingTab.this.resetView();
                }
                animation2.setAnimationListener(SlidingTab.this.mAnimationDoneListener);
                SlidingTab.this.mLeftSlider.startAnimation(animation2, animation2);
                SlidingTab.this.mRightSlider.startAnimation(animation2, animation2);
            }

            @Override
            public void onAnimationRepeat(Animation animation) {
            }

            @Override
            public void onAnimationStart(Animation animation) {
            }
        };
        translateAnimation.setAnimationListener(animationListener);
        slider.hideTarget();
        slider.startAnimation(translateAnimation, translateAnimation2);
    }

    public static interface OnTriggerListener {
        public static final int LEFT_HANDLE = 1;
        public static final int NO_HANDLE = 0;
        public static final int RIGHT_HANDLE = 2;

        public void onGrabbedStateChange(View var1, int var2);

        public void onTrigger(View var1, int var2);
    }

    private static class Slider {
        public static final int ALIGN_BOTTOM = 3;
        public static final int ALIGN_LEFT = 0;
        public static final int ALIGN_RIGHT = 1;
        public static final int ALIGN_TOP = 2;
        public static final int ALIGN_UNKNOWN = 4;
        private static final int STATE_ACTIVE = 2;
        private static final int STATE_NORMAL = 0;
        private static final int STATE_PRESSED = 1;
        private int alignment = 4;
        private int alignment_value;
        private int currentState = 0;
        private final ImageView tab;
        private final ImageView target;
        private final TextView text;

        Slider(ViewGroup viewGroup, int n, int n2, int n3) {
            this.tab = new ImageView(viewGroup.getContext());
            this.tab.setBackgroundResource(n);
            this.tab.setScaleType(ImageView.ScaleType.CENTER);
            this.tab.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            this.text = new TextView(viewGroup.getContext());
            this.text.setLayoutParams(new ViewGroup.LayoutParams(-2, -1));
            this.text.setBackgroundResource(n2);
            this.text.setTextAppearance(viewGroup.getContext(), 16974603);
            this.target = new ImageView(viewGroup.getContext());
            this.target.setImageResource(n3);
            this.target.setScaleType(ImageView.ScaleType.CENTER);
            this.target.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            this.target.setVisibility(4);
            viewGroup.addView(this.target);
            viewGroup.addView(this.tab);
            viewGroup.addView(this.text);
        }

        public int getTabHeight() {
            return this.tab.getMeasuredHeight();
        }

        public int getTabWidth() {
            return this.tab.getMeasuredWidth();
        }

        /*
         * Enabled aggressive block sorting
         */
        void hide() {
            boolean bl = this.alignment == 0 || this.alignment == 1;
            int n = bl ? (this.alignment == 0 ? this.alignment_value - this.tab.getRight() : this.alignment_value - this.tab.getLeft()) : 0;
            int n2 = 0;
            if (!bl) {
                n2 = this.alignment == 2 ? this.alignment_value - this.tab.getBottom() : this.alignment_value - this.tab.getTop();
            }
            TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, n, 0.0f, n2);
            translateAnimation.setDuration(250L);
            translateAnimation.setFillAfter(true);
            this.tab.startAnimation(translateAnimation);
            this.text.startAnimation(translateAnimation);
            this.target.setVisibility(4);
        }

        public void hideTarget() {
            this.target.clearAnimation();
            this.target.setVisibility(4);
        }

        void layout(int n, int n2, int n3, int n4, int n5) {
            this.alignment = n5;
            Drawable drawable2 = this.tab.getBackground();
            int n6 = drawable2.getIntrinsicWidth();
            int n7 = drawable2.getIntrinsicHeight();
            Drawable drawable3 = this.target.getDrawable();
            int n8 = drawable3.getIntrinsicWidth();
            int n9 = drawable3.getIntrinsicHeight();
            int n10 = n3 - n;
            int n11 = n4 - n2;
            int n12 = (int)(0.6666667f * (float)n10) - n8 + n6 / 2;
            int n13 = (int)(0.3333333f * (float)n10) - n6 / 2;
            int n14 = (n10 - n6) / 2;
            int n15 = n14 + n6;
            if (n5 == 0 || n5 == 1) {
                int n16 = (n11 - n9) / 2;
                int n17 = n16 + n9;
                int n18 = (n11 - n7) / 2;
                int n19 = (n11 + n7) / 2;
                if (n5 == 0) {
                    this.tab.layout(0, n18, n6, n19);
                    this.text.layout(0 - n10, n18, 0, n19);
                    this.text.setGravity(5);
                    this.target.layout(n12, n16, n12 + n8, n17);
                    this.alignment_value = n;
                    return;
                }
                this.tab.layout(n10 - n6, n18, n10, n19);
                this.text.layout(n10, n18, n10 + n10, n19);
                this.target.layout(n13, n16, n13 + n8, n17);
                this.text.setGravity(48);
                this.alignment_value = n3;
                return;
            }
            int n20 = (n10 - n8) / 2;
            int n21 = (n10 + n8) / 2;
            int n22 = (int)(0.6666667f * (float)n11) + n7 / 2 - n9;
            int n23 = (int)(0.3333333f * (float)n11) - n7 / 2;
            if (n5 == 2) {
                this.tab.layout(n14, 0, n15, n7);
                this.text.layout(n14, 0 - n11, n15, 0);
                this.target.layout(n20, n22, n21, n22 + n9);
                this.alignment_value = n2;
                return;
            }
            this.tab.layout(n14, n11 - n7, n15, n11);
            this.text.layout(n14, n11, n15, n11 + n11);
            this.target.layout(n20, n23, n21, n23 + n9);
            this.alignment_value = n4;
        }

        public void measure() {
            this.tab.measure(View.MeasureSpec.makeMeasureSpec(0, 0), View.MeasureSpec.makeMeasureSpec(0, 0));
            this.text.measure(View.MeasureSpec.makeMeasureSpec(0, 0), View.MeasureSpec.makeMeasureSpec(0, 0));
        }

        /*
         * Enabled aggressive block sorting
         */
        void reset(boolean bl) {
            int n = 1;
            this.setState(0);
            this.text.setVisibility(0);
            this.text.setTextAppearance(this.text.getContext(), 16974603);
            this.tab.setVisibility(0);
            this.target.setVisibility(4);
            if (this.alignment != 0 && this.alignment != n) {
                n = 0;
            }
            int n2 = n != 0 ? (this.alignment == 0 ? this.alignment_value - this.tab.getLeft() : this.alignment_value - this.tab.getRight()) : 0;
            int n3 = n != 0 ? 0 : (this.alignment == 2 ? this.alignment_value - this.tab.getTop() : this.alignment_value - this.tab.getBottom());
            if (bl) {
                TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, n2, 0.0f, n3);
                translateAnimation.setDuration(250L);
                translateAnimation.setFillAfter(false);
                this.text.startAnimation(translateAnimation);
                this.tab.startAnimation(translateAnimation);
                return;
            }
            if (n != 0) {
                this.text.offsetLeftAndRight(n2);
                this.tab.offsetLeftAndRight(n2);
            } else {
                this.text.offsetTopAndBottom(n3);
                this.tab.offsetTopAndBottom(n3);
            }
            this.text.clearAnimation();
            this.tab.clearAnimation();
            this.target.clearAnimation();
        }

        void setBarBackgroundResource(int n) {
            this.text.setBackgroundResource(n);
        }

        void setHintText(int n) {
            this.text.setText(n);
        }

        void setIcon(int n) {
            this.tab.setImageResource(n);
        }

        /*
         * Enabled aggressive block sorting
         */
        void setState(int n) {
            TextView textView = this.text;
            boolean bl = n == 1;
            textView.setPressed(bl);
            ImageView imageView = this.tab;
            boolean bl2 = n == 1;
            imageView.setPressed(bl2);
            if (n == 2) {
                int[] nArray = new int[]{16842914};
                if (this.text.getBackground().isStateful()) {
                    this.text.getBackground().setState(nArray);
                }
                if (this.tab.getBackground().isStateful()) {
                    this.tab.getBackground().setState(nArray);
                }
                this.text.setTextAppearance(this.text.getContext(), 16974604);
            } else {
                this.text.setTextAppearance(this.text.getContext(), 16974603);
            }
            this.currentState = n;
        }

        void setTabBackgroundResource(int n) {
            this.tab.setBackgroundResource(n);
        }

        void setTarget(int n) {
            this.target.setImageResource(n);
        }

        /*
         * Enabled aggressive block sorting
         */
        void show(boolean bl) {
            int n = 1;
            this.text.setVisibility(0);
            this.tab.setVisibility(0);
            if (bl) {
                if (this.alignment != 0 && this.alignment != n) {
                    n = 0;
                }
                int n2 = n != 0 ? (this.alignment == 0 ? this.tab.getWidth() : -this.tab.getWidth()) : 0;
                int n3 = 0;
                if (n == 0) {
                    n3 = this.alignment == 2 ? this.tab.getHeight() : -this.tab.getHeight();
                }
                TranslateAnimation translateAnimation = new TranslateAnimation(-n2, 0.0f, -n3, 0.0f);
                translateAnimation.setDuration(250L);
                this.tab.startAnimation(translateAnimation);
                this.text.startAnimation(translateAnimation);
            }
        }

        void showTarget() {
            AlphaAnimation alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
            alphaAnimation.setDuration(500L);
            this.target.startAnimation(alphaAnimation);
            this.target.setVisibility(0);
        }

        public void startAnimation(Animation animation, Animation animation2) {
            this.tab.startAnimation(animation);
            this.text.startAnimation(animation2);
        }

        public void updateDrawableStates() {
            this.setState(this.currentState);
        }
    }
}

