/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.client.core;

import de.upb.pga3.panda2.client.core.AnalysisRegistry;
import de.upb.pga3.panda2.client.core.UserInput;
import de.upb.pga3.panda2.client.core.datastructures.Mode;
import de.upb.pga3.panda2.client.core.datastructures.UIMessage;
import de.upb.pga3.panda2.client.core.datastructures.UIMessageType;
import java.io.File;
import java.util.List;

public class ConfigManager {
    public static UIMessage validateInput(UserInput userInput) {
        UIMessage uiMessage = null;
        File previousAnalysisResult = null;
        try {
            boolean isComparisonMode = userInput.getMode().equals((Object)Mode.COMPARISON);
            List<File> inputAPKFiles = userInput.getInitialInputAPKFiles();
            if (!AnalysisRegistry.getInstance().getName(userInput.getLevel()).equals("Permission Usage (Inter App - Level 2b)")) {
                File apkFile = inputAPKFiles.get(0);
                if (!apkFile.exists() || apkFile.isDirectory()) {
                    uiMessage = new UIMessage(UIMessageType.ERROR, "Input APK File doesn't exist");
                }
            } else {
                List<File> nonNativeAPKFiles = userInput.getNonNativeAPKFiles();
                block2: for (File inputAPKFile : inputAPKFiles) {
                    if (!inputAPKFile.exists() || inputAPKFile.isDirectory()) {
                        uiMessage = new UIMessage(UIMessageType.ERROR, "One of the Input APK File doesn't exist");
                        break;
                    }
                    if (uiMessage != null || nonNativeAPKFiles == null) continue;
                    for (File nonNativeAPKFile : nonNativeAPKFiles) {
                        if (nonNativeAPKFile.exists() && !nonNativeAPKFile.isDirectory()) continue;
                        uiMessage = new UIMessage(UIMessageType.ERROR, "One of the Non Native APK File doesn't exist");
                        continue block2;
                    }
                }
            }
            if (isComparisonMode && uiMessage == null && (!(previousAnalysisResult = userInput.getPreviousAnalysisResultFile()).exists() || previousAnalysisResult.isDirectory())) {
                uiMessage = new UIMessage(UIMessageType.ERROR, "Previous Analysis APK/Result File doesn't exist for Comparison Mode");
            }
            if (uiMessage == null) {
                uiMessage = new UIMessage(UIMessageType.INFO, "Provided Inputs are Valid");
            }
        }
        catch (Exception ex) {
            uiMessage = new UIMessage(UIMessageType.ERROR, "Exception in the application configuration. Please correct your inputs.");
        }
        return uiMessage;
    }
}

