/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.client.gui;

import de.upb.pga3.panda2.client.core.AnalysisRegistry;
import de.upb.pga3.panda2.client.core.ResultLoader;
import de.upb.pga3.panda2.client.gui.GUIView;
import de.upb.pga3.panda2.core.Analysis;
import de.upb.pga3.panda2.core.AnalysisFactory;
import de.upb.pga3.panda2.core.AnalysisRunner;
import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import de.upb.pga3.panda2.extension.lvl2b.ExtraAnalysisInputLvl2b;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Model {
    GUIView view;
    public static final int STATUS_READY = 0;
    public static final int STATUS_LOADING = 1;
    File saveFile = null;
    List<AnalysisResult> analysisResults = new ArrayList<AnalysisResult>();
    Map<AnalysisResult, List<String>> mapAnalysisResults = new HashMap<AnalysisResult, List<String>>();
    List<String> lastSetup = new ArrayList<String>();
    AnalysisResult currentAnalysisResult;
    int loadedCounter = 0;
    long time;
    double zoomTextual = 1.0;
    double zoomGrapical = 1.0;
    double initDevPxRatioTextual = 1.0;
    double initDevPxRatioGraphical = 1.0;
    boolean dontJumpFlag = false;

    Model(GUIView view) {
        this.view = view;
    }

    GUIView getView() {
        return this.view;
    }

    public void setLastSetup(String level, String apkStr) {
        this.lastSetup = new ArrayList<String>();
        this.lastSetup.add(level);
        this.lastSetup.add(apkStr);
    }

    public void startAnalysis(String level, File apk, File prevResult, List<File> additionalApks, boolean allmode) {
        this.setLastSetup(level, apk.toString());
        AnalysisFactory analysisFactory = null;
        AnalysisResult analysisResult = prevResult != null && prevResult.toString().substring(prevResult.toString().length() - 4, prevResult.toString().length()).equals(".pa2") ? ResultLoader.loadPreviousAnalysisResult(prevResult.toString()) : null;
        analysisFactory = AnalysisRegistry.getInstance().getFactory(level, apk, analysisResult, prevResult, additionalApks, new ExtraAnalysisInputLvl2b(allmode));
        if (analysisFactory == null) {
            GUIView.log("Could not start Analysis.\n(The selected previous result belongs to a different type of analysis. Selected analysis: " + level + ")");
            return;
        }
        List<Analysis> analysisList = analysisFactory.createAnalysis();
        AnalysisRunner analysisRunner = new AnalysisRunner();
        analysisRunner.analyzeAsync(analysisList, this.getView());
        String logStr = "Analysis started.\n\nSelected Analysis: " + level;
        if (level == "Permission Usage (Inter App - Level 2b)") {
            logStr = allmode ? String.valueOf(logStr) + " [ALL]" : String.valueOf(logStr) + " [APP]";
        }
        logStr = String.valueOf(logStr) + "\nSelected input: " + apk.toString() + "\n";
        if (additionalApks != null && level == "Permission Usage (Inter App - Level 2b)") {
            for (File additionalApk : additionalApks) {
                logStr = String.valueOf(logStr) + "Additional input: " + additionalApk.toString() + "\n";
            }
        }
        if (prevResult != null) {
            logStr = String.valueOf(logStr) + "Input for comparison: " + prevResult.toString() + "\n";
        }
        GUIView.log(logStr);
        this.getView().setStatus(1);
        this.time = new Date().getTime() / 1000L;
    }
}

