/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.core.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import soot.SootClass;
import soot.Unit;

public class IntentInformation {
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_EXPLICIT = 0;
    public static final int TYPE_IMPLICIT = 1;
    private String classNameOrActionString = "";
    private Collection<SootClass> mTargetClasses;
    private List<Unit> mLstLaunchingUnits;
    private int mTypeIntent = -1;
    private boolean mIsValid = false;

    public IntentInformation(int inType) {
        this.mTypeIntent = inType;
        this.mTargetClasses = null;
        this.mLstLaunchingUnits = new ArrayList<Unit>();
        this.mTargetClasses = null;
    }

    public void addTargetClasses(Collection<SootClass> classes) {
        if (this.mTargetClasses == null) {
            this.mTargetClasses = classes;
        } else {
            this.mTargetClasses.addAll(classes);
        }
    }

    public Collection<SootClass> getTargetClasses() {
        return this.mTargetClasses;
    }

    public List<Unit> getLstLaunchingUnits() {
        if (this.mLstLaunchingUnits != null && !this.mLstLaunchingUnits.isEmpty()) {
            return this.mLstLaunchingUnits;
        }
        return null;
    }

    public void setTypeIntent(int inType) {
        this.mTypeIntent = inType;
    }

    public int getTypeIntent() {
        return this.mTypeIntent;
    }

    public void setValid(boolean inIsValid) {
        this.mIsValid = inIsValid;
    }

    public boolean isValid() {
        return this.mIsValid;
    }

    public void addStartingUnit(Unit inUnit) {
        if (this.mLstLaunchingUnits == null) {
            this.mLstLaunchingUnits = new ArrayList<Unit>();
        }
        this.mLstLaunchingUnits.add(inUnit);
    }

    public String getClassNameOrActionString() {
        return this.classNameOrActionString;
    }

    public void setClassNameOrActionString(String classNameOrActionString) {
        this.classNameOrActionString = classNameOrActionString;
    }

    public String toString() {
        String classNameOrActionStr;
        String intentTypeStr;
        switch (this.mTypeIntent) {
            case 0: {
                intentTypeStr = "Explicit";
                classNameOrActionStr = "Classname";
                break;
            }
            case 1: {
                intentTypeStr = "Implicit";
                classNameOrActionStr = "Action String";
                break;
            }
            default: {
                intentTypeStr = "Unknown";
                classNameOrActionStr = "Classname or Action String";
            }
        }
        String output = "*** " + intentTypeStr + " Intent ***\n" + classNameOrActionStr + ": " + this.classNameOrActionString + "\nStarting unit: " + this.mLstLaunchingUnits + "\nList of targets:\n";
        for (SootClass c : this.mTargetClasses) {
            output = String.valueOf(output) + c.toString() + "\n";
        }
        return output;
    }
}

