/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.core.services;

import de.upb.pga3.panda2.core.services.XMLElement;

public class XMLAttribute<T>
extends XMLElement {
    protected String name;
    protected int type;
    protected T value;
    protected int resourceId;
    public static final int TYPE_INT_BOOLEAN = 18;
    public static final int TYPE_STRING = 3;
    public static final int TYPE_FIRST_INT = 16;
    public static final int TYPE_INT_HEX = 17;
    public static final int TYPE_REFERENCE = 1;

    public XMLAttribute(String name, T value, String ns) {
        this(name, -1, value, ns, true);
    }

    public XMLAttribute(String name, int resourceId, T value, String ns) {
        this(name, resourceId, value, ns, true);
    }

    public XMLAttribute(String name, int resourceId, T value, String ns, boolean added) {
        this(name, resourceId, -1, value, ns, added);
    }

    public XMLAttribute(String name, int resourceId, int type, T value, String ns, boolean added) {
        super(ns, added);
        this.name = name;
        this.resourceId = resourceId;
        this.type = type;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public int getResourceId() {
        return this.resourceId;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public int getType() {
        if (this.value instanceof Integer) {
            return 17;
        }
        if (this.value instanceof Boolean) {
            return 18;
        }
        return 3;
    }

    public int getAttributeType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XMLAttribute other = (XMLAttribute)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.resourceId != other.resourceId) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

