/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension.lvl2a.analyzer;

import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.core.datastructures.Transition;
import de.upb.pga3.panda2.extension.lvl2a.AnalysisGraphLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.ParameterNode;
import de.upb.pga3.panda2.extension.lvl2a.TransitionLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.TransitionType;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.ClassElement;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.FlowPath;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.MethodElement;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.PathElement;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.ResourceElement;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.StatementElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.toolkits.scalar.Pair;

public class PathFinder {
    private static final Logger LOGGER = LogManager.getLogger(PathFinder.class);
    private AnalysisGraphLvl2a mGraph;

    public void setGraph(AnalysisGraphLvl2a inGraph) {
        if (inGraph == null) {
            throw new IllegalArgumentException("The given graph must not be null!");
        }
        this.mGraph = inGraph;
    }

    public Collection<FlowPath> findPaths(Pair<Permission, Object> inSource, Pair<Permission, Object> inSink) {
        EnhancedInput input = (EnhancedInput)this.mGraph.getInput();
        LinkedHashSet<FlowPath> lstFlowPaths = new LinkedHashSet<FlowPath>();
        TransitionLvl2a rootNode = new TransitionLvl2a(inSource.getO1(), inSource.getO2());
        try {
            List<List<TransitionLvl2a>> transList = this.discoverPathInGraph(rootNode, inSink.getO2());
            for (List<TransitionLvl2a> lstTrans : transList) {
                try {
                    if (lstTrans.isEmpty()) continue;
                    FlowPath path = new FlowPath(lstTrans.size() + 2);
                    ListIterator<TransitionLvl2a> transit = lstTrans.listIterator();
                    Transition trans = null;
                    while (transit.hasNext()) {
                        trans = (TransitionLvl2a)transit.next();
                        PathFinder.addElemToPath(path, trans.getSource(), input);
                    }
                    PathFinder.addElemToPath(path, trans.getTarget(), input);
                    PathFinder.addElemToPath(path, inSink.getO1(), input);
                    lstFlowPaths.add(path);
                }
                catch (Exception ex) {
                    LOGGER.warn("Error: " + ex.getMessage());
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Cannot find paths from " + inSource.getO2().toString() + " to " + inSink.getO2().toString());
            LOGGER.error("Reason: " + ex.getMessage());
            LOGGER.debug(ex);
            return null;
        }
        LOGGER.debug("Found {} path between source {} and sink {}", lstFlowPaths.size(), inSource.getO1().getName(), inSink.getO1().getName());
        return lstFlowPaths;
    }

    private static void addElemToPath(FlowPath path, Object node, EnhancedInput input) {
        PathElement elem = PathFinder.toPathElem(node, input);
        if (elem != null) {
            path.addElement(elem);
        }
    }

    private static PathElement toPathElem(Object node, EnhancedInput input) {
        if (node instanceof Permission) {
            return ResourceElement.get((Permission)node);
        }
        if (node instanceof SootClass) {
            return ClassElement.get((SootClass)node, input);
        }
        if (node instanceof SootMethod) {
            return MethodElement.get((SootMethod)node, input);
        }
        if (node instanceof Unit) {
            return StatementElement.get((Unit)node, input);
        }
        return null;
    }

    private List<List<TransitionLvl2a>> discoverPathInGraph(TransitionLvl2a inSourceTrans, Object inSink) {
        ArrayList<TransitionLvl2a> path = new ArrayList<TransitionLvl2a>();
        ArrayList<List<TransitionLvl2a>> lstPaths = new ArrayList<List<TransitionLvl2a>>();
        HashSet<TransitionLvl2a> lstVisitedTrans = new HashSet<TransitionLvl2a>();
        this.recDiscoverPath(path, inSourceTrans, inSink, lstPaths, lstVisitedTrans);
        if (!lstPaths.isEmpty()) {
            return lstPaths;
        }
        throw new IllegalStateException("A path between source and sink could not be found!");
    }

    private void recDiscoverPath(List<TransitionLvl2a> inPath, TransitionLvl2a inCurrentTrans, Object inSinkObj, List<List<TransitionLvl2a>> inListPaths, Collection<TransitionLvl2a> inListVisitedTrans) {
        if (inListVisitedTrans.contains(inCurrentTrans)) {
            return;
        }
        inListVisitedTrans.add(inCurrentTrans);
        Object sourceTargetObj = inCurrentTrans.getTarget();
        inPath.add(inCurrentTrans);
        if (sourceTargetObj.equals(inSinkObj)) {
            inListPaths.add(new ArrayList<TransitionLvl2a>(inPath));
            inPath.remove(inCurrentTrans);
            inListVisitedTrans.remove(inCurrentTrans);
            return;
        }
        Set<TransitionLvl2a> transOut = this.filterTrans(sourceTargetObj);
        for (TransitionLvl2a tran : transOut) {
            if (inPath.contains(tran)) continue;
            this.recDiscoverPath(inPath, tran, inSinkObj, inListPaths, inListVisitedTrans);
        }
        inListVisitedTrans.remove(inCurrentTrans);
        inPath.remove(inCurrentTrans);
    }

    private Set<TransitionLvl2a> filterTrans(Object sourceTargetObj) {
        Set<Transition> inTrans = this.mGraph.getOutgoingTransitions(sourceTargetObj);
        TransitionLvl2a t2a = null;
        HashSet<TransitionLvl2a> filteredTrans = new HashSet<TransitionLvl2a>();
        for (Transition t : inTrans) {
            if (!(t instanceof TransitionLvl2a)) continue;
            t2a = (TransitionLvl2a)t;
            TransitionType type = t2a.getTransitionType();
            Object target = t2a.getTarget();
            if (type.equals((Object)TransitionType.CONTROLDEPENDENCY) && target instanceof ParameterNode || type.equals((Object)TransitionType.CONTROLFLOW) || type.equals((Object)TransitionType.SUMMARY)) continue;
            filteredTrans.add(t2a);
        }
        return filteredTrans;
    }
}

