/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension.lvl2a.graphgenerator;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;

public class DominatorComputer {
    int[] parent;
    private int[] ancestor;
    private int[] vertex;
    private int[] label;
    int[] semi;
    TIntSet[] pred;
    private TIntSet[] bucket;
    int u;
    private TIntSet[] succ;
    private int r;
    private int n;
    private int[] dom;

    public int[] computeDominatorTree(TIntSet[] inSucc, int inR, int inN) {
        int w;
        this.succ = inSucc;
        this.r = inR;
        this.n = inN;
        this.vertex = new int[this.n];
        this.parent = new int[this.n];
        this.ancestor = new int[this.n];
        this.semi = new int[this.n];
        this.label = new int[this.n];
        this.pred = new TIntHashSet[this.n];
        this.bucket = new TIntHashSet[this.n];
        this.dom = new int[this.n];
        int v = 1;
        while (v < this.n) {
            this.bucket[v] = new TIntHashSet();
            this.pred[v] = new TIntHashSet();
            this.semi[v] = 0;
            ++v;
        }
        this.n = 0;
        this.dfs(this.r);
        int i = this.n;
        while (i >= 2) {
            w = this.vertex[i];
            this.pred[w].forEach(new TIntProcedure(){

                public boolean execute(int v) {
                    DominatorComputer.this.u = DominatorComputer.this.eval(v);
                    if (DominatorComputer.this.semi[DominatorComputer.this.u] < DominatorComputer.this.semi[w]) {
                        DominatorComputer.this.semi[w] = DominatorComputer.this.semi[DominatorComputer.this.u];
                    }
                    return true;
                }
            });
            this.bucket[this.vertex[this.semi[w]]].add(w);
            this.link(this.parent[w], w);
            TIntIterator iter = this.bucket[this.parent[w]].iterator();
            while (iter.hasNext()) {
                int v2 = iter.next();
                iter.remove();
                this.u = this.eval(v2);
                this.dom[v2] = this.semi[this.u] < this.semi[v2] ? this.u : this.parent[w];
            }
            --i;
        }
        i = 2;
        while (i < this.n) {
            w = this.vertex[i];
            if (this.dom[w] != this.vertex[this.semi[w]]) {
                this.dom[w] = this.dom[this.dom[w]];
            }
            ++i;
        }
        this.dom[this.r] = 0;
        return this.dom;
    }

    private void dfs(final int v) {
        this.semi[v] = this.n + 1;
        ++this.n;
        if (this.n < this.vertex.length) {
            this.vertex[this.n] = v;
            this.label[v] = v;
            this.ancestor[v] = 0;
            this.succ[v].forEach(new TIntProcedure(){

                public boolean execute(int w) {
                    if (DominatorComputer.this.semi[w] == 0) {
                        DominatorComputer.this.parent[w] = v;
                        DominatorComputer.this.dfs(w);
                    }
                    if (DominatorComputer.this.pred[w] == null) {
                        DominatorComputer.this.pred[w] = new TIntHashSet();
                    }
                    DominatorComputer.this.pred[w].add(v);
                    return true;
                }
            });
        }
    }

    private void compress(int v) {
        if (this.ancestor[this.ancestor[v]] != 0) {
            this.compress(this.ancestor[v]);
            if (this.semi[this.label[this.ancestor[v]]] < this.semi[this.label[v]]) {
                this.label[v] = this.label[this.ancestor[v]];
            }
            this.ancestor[v] = this.ancestor[this.ancestor[v]];
        }
    }

    private int eval(int v) {
        if (this.ancestor[v] == 0) {
            return v;
        }
        this.compress(v);
        return this.label[v];
    }

    private void link(int a, int w) {
        this.ancestor[w] = a;
    }
}

