/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension.lvl2b.graphgenerator;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.ResultInput;
import de.upb.pga3.panda2.core.services.CoreServices;
import de.upb.pga3.panda2.core.services.IntentInformation;
import de.upb.pga3.panda2.extension.lvl1.AnalysisResultLvl1;
import de.upb.pga3.panda2.extension.lvl2b.graphgenerator.NodeLinkerLvl2b;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IntentAnalyzerLvl2b {
    private static final Logger LOGGER = LogManager.getLogger(IntentAnalyzerLvl2b.class);
    private ResultInput ri;
    private NodeLinkerLvl2b nodeLinker;

    public IntentAnalyzerLvl2b(ResultInput ri) {
        this.ri = ri;
        this.nodeLinker = new NodeLinkerLvl2b(new AnalysisGraph(ri));
    }

    public void analyzeIntents() {
        EnhancedInput ei = null;
        int i = 0;
        while (i < this.ri.getResults().size()) {
            ei = (EnhancedInput)((AnalysisResultLvl1)this.ri.getResults().get(i)).getAnalysisGraph().getInput();
            for (Collection<IntentInformation> intentInfoCollection : ei.getIntents().values()) {
                for (IntentInformation intentInfo : intentInfoCollection) {
                    if (intentInfo.getTypeIntent() != 1) continue;
                    int j = 0;
                    while (j < this.ri.getResults().size()) {
                        EnhancedInput tempEi = (EnhancedInput)((AnalysisResultLvl1)this.ri.getResults().get(j)).getAnalysisGraph().getInput();
                        if (ei != tempEi) {
                            intentInfo.addTargetClasses(CoreServices.getStatementAnalyzerInstance().getTargetsByActionString(intentInfo.getClassNameOrActionString(), tempEi));
                        }
                        ++j;
                    }
                    this.nodeLinker.link(intentInfo);
                }
            }
            ++i;
        }
    }

    public AnalysisGraph getGraph() {
        return this.nodeLinker.getGraph();
    }
}

