/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.test.core.services;

import de.upb.pga3.panda2.client.core.datastructures.ManifestInfo;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.IntentFilter;
import de.upb.pga3.panda2.core.services.ManifestXMLParser;
import java.nio.file.Path;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ManifestXMLParserTest {
    ManifestXMLParser mp;
    EnhancedInput ei;
    Path p;
    String path;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.path = "test_resources/SimpleIntents.apk";
        this.mp = new ManifestXMLParser(this.path);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void getLstProviderstest() {
        List<String> providers = this.mp.getLstProviders();
        Assert.assertNull(providers);
    }

    @Test
    public void getLstReceiverstest() {
        List<String> receivers = this.mp.getLstProviders();
        Assert.assertNull(receivers);
    }

    @Test
    public void getLstServicestest() {
        List<String> services = this.mp.getLstProviders();
        Assert.assertNull(services);
    }

    @Test
    public void getLstActivitiestest() {
        List<String> activities = this.mp.getLstActivities();
        Assert.assertNotNull(activities);
    }

    @Test
    public void getLstActivitiesValuetest() {
        List<String> activities = this.mp.getLstActivities();
        Assert.assertEquals((Object)"com.mycompany.simpleintents.MainActivity", (Object)activities.get(0).toString());
    }

    @Test
    public void getLstActivitiesNegativetest() {
        List<String> activities = this.mp.getLstActivities();
        Assert.assertNotEquals((Object)"com.mycompany.simpleintents", (Object)activities.get(1).toString());
    }

    @Test
    public void getManifestInfotest() {
        ManifestInfo mi = this.mp.getManifestInfo();
        Assert.assertNotNull((Object)mi);
    }

    @Test
    public void getManifestInfoValuetest() {
        String packageName = this.mp.getManifestInfo().getPackage();
        Assert.assertEquals((Object)"com.mycompany.simpleintents", (Object)packageName);
    }

    @Test
    public void getIntentFilterstest() {
        List<IntentFilter> filters = this.mp.getManifestInfo().getIntentFilters();
        Assert.assertNull(filters);
    }

    @Test
    public void getIntentFiltersValuetest() {
        List<IntentFilter> filters = this.mp.getIntentFilters();
        Assert.assertEquals((Object)"android.intent.action.MAIN", (Object)filters.get(0).getActionName());
    }

    @Test
    public void getIntentFiltersNegativetest() {
        List<IntentFilter> filters = this.mp.getIntentFilters();
        Assert.assertNotEquals((Object)"android.intent.action", (Object)filters.get(0).getActionName());
    }

    @Test
    public void versionCodeValuetest() {
        String versionCode = this.mp.getManifestInfo().getVersionCode();
        Assert.assertEquals((Object)"1", (Object)versionCode);
    }

    @Test
    public void versionNameValuetest() {
        String versionName = this.mp.getManifestInfo().getVersionName();
        Assert.assertEquals((Object)"1.0", (Object)versionName);
    }

    @Test
    public void versionNameCodePackageValuetest() {
        this.mp.getManifestInfo().setVersionName("2.0");
        this.mp.getManifestInfo().setVersionCode("2");
        this.mp.getManifestInfo().setPackage("MAIN");
        Assert.assertEquals((Object)"2.0", (Object)this.mp.getManifestInfo().getVersionName());
        Assert.assertEquals((Object)"2", (Object)this.mp.getManifestInfo().getVersionCode());
        Assert.assertEquals((Object)"MAIN", (Object)this.mp.getManifestInfo().getPackage());
    }
}

