/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.test.extension.lvl1.graphgenerator;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.services.IntentInformation;
import de.upb.pga3.panda2.extension.Enhancer;
import de.upb.pga3.panda2.extension.lvl1.graphgenerator.GraphGeneratorLvl1;
import de.upb.pga3.panda2.extension.lvl1.graphgenerator.IntentAnalyzerLvl1;
import de.upb.pga3.panda2.extension.lvl1.graphgenerator.NodeLinkerLvl1;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import soot.Body;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;

public class NodeLinkerLvl1Test {
    Enhancer enhancer;
    EnhancedInput enhInput;
    GraphGeneratorLvl1 ggl;
    IntentAnalyzerLvl1 intentAnalyzer;
    NodeLinkerLvl1 nl;
    AnalysisGraph ag;
    IntentInformation ii;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        Path p = Paths.get("test_resources/SimpleIntents.apk", new String[0]);
        this.enhancer = new Enhancer();
        this.enhInput = (EnhancedInput)this.enhancer.enhance(p);
        this.ggl = new GraphGeneratorLvl1();
        this.ag = this.ggl.generateGraph(this.enhInput, p);
        this.intentAnalyzer = new IntentAnalyzerLvl1(this.enhInput);
        List<SootClass> testclass = NodeLinkerLvl1Test.findClasses((EnhancedInput)this.intentAnalyzer.getGraph().getInput());
        Unit testStmt = NodeLinkerLvl1Test.findStmt("MainActivity", "launch_explicit", "(android.content.Context,java.lang.Class)", (EnhancedInput)this.intentAnalyzer.getGraph().getInput());
        this.ii = new IntentInformation(-1);
    }

    private static Unit findStmt(String className, String methodName, String unitCharSeq, EnhancedInput ei) {
        Unit u = null;
        SootClass[] sootClassArray = ei.getAppClasses();
        int n = sootClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            SootClass componentOrClass = sootClassArray[n2];
            if (componentOrClass.getName().toString().contains(className)) {
                for (SootMethod method : componentOrClass.getMethods()) {
                    if (!method.getName().toString().contains(methodName) || componentOrClass.isInterface()) continue;
                    Body body = method.retrieveActiveBody();
                    for (Unit stm : body.getUnits()) {
                        if (!stm.toString().contains(unitCharSeq)) continue;
                        u = stm;
                    }
                }
            }
            ++n2;
        }
        return u;
    }

    private static List<SootClass> findClasses(EnhancedInput ei) {
        SootClass[] classes;
        ArrayList<SootClass> sootclassLst = new ArrayList<SootClass>();
        SootClass[] sootClassArray = classes = ei.getAppClasses();
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            SootClass c = sootClassArray[n2];
            System.out.println(c);
            sootclassLst.add(c);
            ++n2;
        }
        return sootclassLst;
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void nodelinkertest() {
        this.nl = new NodeLinkerLvl1(this.ag);
        this.nl.link(this.ii);
        Assert.assertNotNull((Object)this.nl.getGraph().getOutgoingTransitions(this.ii).toString());
    }
}

