/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.test.extension.lvl2b.graphgenerator;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.Input;
import de.upb.pga3.panda2.core.datastructures.ResultInput;
import de.upb.pga3.panda2.extension.Enhancer;
import de.upb.pga3.panda2.extension.lvl1.AnalysisResultLvl1;
import de.upb.pga3.panda2.extension.lvl1.analyzer.AnalyzerLvl1;
import de.upb.pga3.panda2.extension.lvl1.graphgenerator.GraphGeneratorLvl1;
import de.upb.pga3.panda2.extension.lvl2b.graphgenerator.IntentAnalyzerLvl2b;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import soot.Body;
import soot.PatchingChain;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;

public class IntentAnalyzerLvl2bTest {
    EnhancedInput ei;
    IntentAnalyzerLvl2b intentAnalyze;
    Enhancer enhancer1;
    Enhancer enhancer2;
    EnhancedInput enhInput1;
    EnhancedInput enhInput2;
    GraphGeneratorLvl1 ggl1;
    GraphGeneratorLvl1 ggl2;
    AnalyzerLvl1 az1;
    AnalyzerLvl1 az2;
    AnalysisResultLvl1 anRst1;
    AnalysisResultLvl1 anRst2;
    Input inInput1;
    ResultInput resultIP;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        Path p1 = Paths.get("test_resources/OnlyImplicit.apk", new String[0]);
        Path p2 = Paths.get("test_resources/OnlyExplicit.apk", new String[0]);
        this.enhancer1 = new Enhancer();
        this.enhInput1 = (EnhancedInput)this.enhancer1.enhance(p1);
        this.ggl1 = new GraphGeneratorLvl1();
        AnalysisGraph ag1 = this.ggl1.generateGraph(this.enhInput1, p1);
        this.az1 = new AnalyzerLvl1();
        this.anRst1 = new AnalysisResultLvl1(ag1);
        this.anRst1 = (AnalysisResultLvl1)this.az1.analyze(ag1, null);
        this.enhancer2 = new Enhancer();
        this.enhInput2 = (EnhancedInput)this.enhancer2.enhance(p2);
        this.ggl2 = new GraphGeneratorLvl1();
        AnalysisGraph ag2 = this.ggl2.generateGraph(this.enhInput2, p2);
        this.az2 = new AnalyzerLvl1();
        this.anRst2 = new AnalysisResultLvl1(ag2);
        this.anRst2 = (AnalysisResultLvl1)this.az2.analyze(ag2, null);
        ArrayList<AnalysisResult> anaList = new ArrayList<AnalysisResult>();
        anaList.add(this.anRst1);
        anaList.add(this.anRst2);
        this.resultIP = new ResultInput(anaList);
        this.intentAnalyze = new IntentAnalyzerLvl2b(this.resultIP);
    }

    private static Unit findStmt(String className, String methodName, String unitCharSeq, ResultInput ri) {
        Unit stmt = null;
        for (AnalysisResult anaRst : ri.getResults()) {
            SootClass[] classes;
            AnalysisResultLvl1 ana = (AnalysisResultLvl1)anaRst;
            EnhancedInput ei = (EnhancedInput)ana.getAnalysisGraph().getInput();
            SootClass[] sootClassArray = classes = ei.getAppClasses();
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                SootClass c = sootClassArray[n2];
                if (c.getName().toString().contains(className)) {
                    List<SootMethod> methods = c.getMethods();
                    for (SootMethod m : methods) {
                        if (!m.getName().toString().contains(methodName)) continue;
                        Body body = m.retrieveActiveBody();
                        PatchingChain<Unit> units = body.getUnits();
                        for (Unit u : units) {
                            ei.mapUnitToBody(u, body);
                            if (!u.toString().contains(unitCharSeq)) continue;
                            stmt = u;
                        }
                    }
                }
                ++n2;
            }
        }
        return stmt;
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void analysisExplicitIntentstest() {
        this.intentAnalyze.analyzeIntents();
        Unit testStmt = IntentAnalyzerLvl2bTest.findStmt("MainActivity", "launch_explicit", "(android.content.Context,java.lang.Class)", (ResultInput)this.intentAnalyze.getGraph().getInput());
        Assert.assertNotNull(this.intentAnalyze.getGraph().getOutgoingTransitions(testStmt));
    }
}

