/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2;

import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.jf.dexlib2.Opcode;

public class Opcodes {
    private final Opcode[] opcodesByValue = new Opcode[256];
    private final HashMap<String, Opcode> opcodesByName = Maps.newHashMap();

    public Opcodes(int api, boolean experimental) {
        for (Opcode opcode : Opcode.values()) {
            if (opcode.format.isPayloadFormat || api > opcode.getMaxApi() || api < opcode.getMinApi() || !experimental && opcode.isExperimental()) continue;
            this.opcodesByValue[opcode.value] = opcode;
            this.opcodesByName.put(opcode.name.toLowerCase(), opcode);
        }
    }

    @Nullable
    public Opcode getOpcodeByName(String opcodeName) {
        return this.opcodesByName.get(opcodeName.toLowerCase());
    }

    @Nullable
    public Opcode getOpcodeByValue(int opcodeValue) {
        switch (opcodeValue) {
            case 256: {
                return Opcode.PACKED_SWITCH_PAYLOAD;
            }
            case 512: {
                return Opcode.SPARSE_SWITCH_PAYLOAD;
            }
            case 768: {
                return Opcode.ARRAY_PAYLOAD;
            }
        }
        if (opcodeValue >= 0 && opcodeValue < this.opcodesByValue.length) {
            return this.opcodesByValue[opcodeValue];
        }
        return null;
    }
}

