/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked;

import javax.annotation.Nonnull;
import org.jf.dexlib2.dexbacked.BaseDexReader;
import org.jf.util.ExceptionWithContext;

public class BaseDexBuffer {
    @Nonnull
    final byte[] buf;

    public BaseDexBuffer(@Nonnull byte[] buf) {
        this.buf = buf;
    }

    public int readSmallUint(int offset) {
        byte[] buf = this.buf;
        int result = buf[offset] & 0xFF | (buf[offset + 1] & 0xFF) << 8 | (buf[offset + 2] & 0xFF) << 16 | buf[offset + 3] << 24;
        if (result < 0) {
            throw new ExceptionWithContext("Encountered small uint that is out of range at offset 0x%x", offset);
        }
        return result;
    }

    public int readOptionalUint(int offset) {
        byte[] buf = this.buf;
        int result = buf[offset] & 0xFF | (buf[offset + 1] & 0xFF) << 8 | (buf[offset + 2] & 0xFF) << 16 | buf[offset + 3] << 24;
        if (result < -1) {
            throw new ExceptionWithContext("Encountered optional uint that is out of range at offset 0x%x", offset);
        }
        return result;
    }

    public int readUshort(int offset) {
        byte[] buf = this.buf;
        return buf[offset] & 0xFF | (buf[offset + 1] & 0xFF) << 8;
    }

    public int readUbyte(int offset) {
        return this.buf[offset] & 0xFF;
    }

    public long readLong(int offset) {
        byte[] buf = this.buf;
        return (long)(buf[offset] & 0xFF | (buf[offset + 1] & 0xFF) << 8 | (buf[offset + 2] & 0xFF) << 16) | ((long)buf[offset + 3] & 0xFFL) << 24 | ((long)buf[offset + 4] & 0xFFL) << 32 | ((long)buf[offset + 5] & 0xFFL) << 40 | ((long)buf[offset + 6] & 0xFFL) << 48 | (long)buf[offset + 7] << 56;
    }

    public int readInt(int offset) {
        byte[] buf = this.buf;
        return buf[offset] & 0xFF | (buf[offset + 1] & 0xFF) << 8 | (buf[offset + 2] & 0xFF) << 16 | buf[offset + 3] << 24;
    }

    public int readShort(int offset) {
        byte[] buf = this.buf;
        return buf[offset] & 0xFF | buf[offset + 1] << 8;
    }

    public int readByte(int offset) {
        return this.buf[offset];
    }

    @Nonnull
    public BaseDexReader readerAt(int offset) {
        return new BaseDexReader<BaseDexBuffer>(this, offset);
    }

    @Nonnull
    protected byte[] getBuf() {
        return this.buf;
    }
}

