/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import java.util.HashSet;
import java.util.Set;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.OneRegisterInstruction;
import org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import org.jf.dexlib2.iface.instruction.formats.Instruction21c;
import org.jf.dexlib2.iface.reference.TypeReference;
import soot.Type;
import soot.dexpler.DexBody;
import soot.dexpler.DexType;
import soot.dexpler.instructions.DexlibAbstractInstruction;
import soot.jimple.AssignStmt;
import soot.jimple.ClassConstant;
import soot.jimple.Jimple;

public class ConstClassInstruction
extends DexlibAbstractInstruction {
    AssignStmt assign = null;

    public ConstClassInstruction(Instruction instruction, int codeAdress) {
        super(instruction, codeAdress);
    }

    @Override
    public void jimplify(DexBody body) {
        if (!(this.instruction instanceof Instruction21c)) {
            throw new IllegalArgumentException("Expected Instruction21c but got: " + this.instruction.getClass());
        }
        ReferenceInstruction constClass = (ReferenceInstruction)this.instruction;
        TypeReference tidi = (TypeReference)constClass.getReference();
        String type = tidi.getType();
        if (type.startsWith("L") && type.endsWith(";")) {
            type = type.replaceAll("^L", "").replaceAll(";$", "");
        }
        int dest = ((OneRegisterInstruction)this.instruction).getRegisterA();
        ClassConstant cst = ClassConstant.v(type);
        this.assign = Jimple.v().newAssignStmt(body.getRegisterLocal(dest), cst);
        this.setUnit(this.assign);
        this.addTags(this.assign);
        body.add(this.assign);
    }

    @Override
    boolean overridesRegister(int register) {
        OneRegisterInstruction i = (OneRegisterInstruction)this.instruction;
        int dest = i.getRegisterA();
        return register == dest;
    }

    @Override
    public Set<Type> introducedTypes() {
        ReferenceInstruction i = (ReferenceInstruction)this.instruction;
        HashSet<Type> types = new HashSet<Type>();
        types.add(DexType.toSoot((TypeReference)i.getReference()));
        return types;
    }
}

