/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.logic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import soot.Body;
import soot.BodyTransformer;
import soot.Unit;
import soot.jimple.Stmt;
import soot.jimple.toolkits.annotation.logic.Loop;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.MHGDominatorsFinder;
import soot.toolkits.graph.UnitGraph;

public class LoopFinder
extends BodyTransformer {
    private UnitGraph g;
    private HashMap<Stmt, List<Stmt>> loops;

    public Collection<Loop> loops() {
        HashSet<Loop> result = new HashSet<Loop>();
        for (Map.Entry<Stmt, List<Stmt>> entry : this.loops.entrySet()) {
            result.add(new Loop(entry.getKey(), entry.getValue(), this.g));
        }
        return result;
    }

    protected void internalTransform(Body b, String phaseName, Map options) {
        this.g = new ExceptionalUnitGraph(b);
        MHGDominatorsFinder<Unit> a = new MHGDominatorsFinder<Unit>(this.g);
        this.loops = new HashMap();
        for (Stmt stmt : b.getUnits()) {
            List<Unit> succs = this.g.getSuccsOf(stmt);
            List<Unit> dominaters = a.getDominators(stmt);
            ArrayList<Stmt> headers = new ArrayList<Stmt>();
            for (Stmt stmt2 : succs) {
                if (!dominaters.contains(stmt2)) continue;
                headers.add(stmt2);
            }
            for (Stmt header : headers) {
                List<Stmt> loopBody = this.getLoopBodyFor(header, stmt);
                if (this.loops.containsKey(header)) {
                    List<Stmt> lb1 = this.loops.get(header);
                    this.loops.put(header, this.union(lb1, loopBody));
                    continue;
                }
                this.loops.put(header, loopBody);
            }
        }
    }

    private List<Stmt> getLoopBodyFor(Stmt header, Stmt node) {
        ArrayList<Stmt> loopBody = new ArrayList<Stmt>();
        Stack<Unit> stack = new Stack<Unit>();
        loopBody.add(header);
        stack.push(node);
        while (!stack.isEmpty()) {
            Stmt next = (Stmt)stack.pop();
            if (loopBody.contains(next)) continue;
            loopBody.add(0, next);
            Iterator<Unit> it = this.g.getPredsOf(next).iterator();
            while (it.hasNext()) {
                stack.push(it.next());
            }
        }
        assert (node == header && loopBody.size() == 1 || loopBody.get(loopBody.size() - 2) == node);
        assert (loopBody.get(loopBody.size() - 1) == header);
        return loopBody;
    }

    private List<Stmt> union(List<Stmt> l1, List<Stmt> l2) {
        for (Stmt next : l2) {
            if (l1.contains(next)) continue;
            l1.add(next);
        }
        return l1;
    }
}

