/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.G;
import soot.Local;
import soot.Timers;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.options.Options;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ForwardFlowAnalysisExtended;
import soot.toolkits.scalar.LiveLocals;
import soot.toolkits.scalar.LocalDefs;
import soot.util.Cons;
import soot.util.Switchable;

public class SmartLocalDefs
implements LocalDefs {
    private final Map<Cons<Unit, Local>, List<Unit>> answer;
    private final Map<Local, Set<Unit>> localToDefs;
    private final UnitGraph graph;
    private final LocalDefsAnalysis analysis;
    private final Map<Unit, BitSet> liveLocalsAfter;

    public void printAnswer() {
        System.out.println(this.answer.toString());
    }

    private static <T> List<T> asList(Set<T> a, Set<T> b) {
        if (a == null || b == null || a.isEmpty() || b.isEmpty()) {
            return Collections.emptyList();
        }
        if (a.size() < b.size()) {
            ArrayList<T> c = new ArrayList<T>(a);
            c.retainAll(b);
            return c;
        }
        ArrayList<T> c = new ArrayList<T>(b);
        c.retainAll(a);
        return c;
    }

    public SmartLocalDefs(UnitGraph g, LiveLocals live) {
        this.graph = g;
        if (Options.v().time()) {
            Timers.v().defsTimer.start();
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + g.getBody().getMethod().getName() + "]     Constructing SmartLocalDefs...");
        }
        int n = this.graph.getBody().getLocalCount();
        Local[] locals = new Local[n];
        int[] oldNumbers = new int[n];
        n = 0;
        Iterator<Switchable> i$ = this.graph.getBody().getLocals().iterator();
        while (i$.hasNext()) {
            Local local;
            locals[n] = local = i$.next();
            oldNumbers[n] = local.getNumber();
            local.setNumber(n++);
        }
        this.localToDefs = new HashMap<Local, Set<Unit>>();
        this.liveLocalsAfter = new HashMap<Unit, BitSet>();
        for (Unit u : this.graph) {
            BitSet set = new BitSet(n);
            for (Local l : live.getLiveLocalsAfter(u)) {
                set.set(l.getNumber());
            }
            this.liveLocalsAfter.put(u, set);
            Local l = this.localDef(u);
            if (l == null) continue;
            this.addDefOf(l, u);
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + g.getBody().getMethod().getName() + "]        done localToDefs map...");
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + g.getBody().getMethod().getName() + "]        done unitToMask map...");
        }
        this.analysis = new LocalDefsAnalysis(this.graph);
        this.answer = new HashMap<Cons<Unit, Local>, List<Unit>>();
        for (Unit u : this.graph) {
            Set s1 = (Set)this.analysis.getFlowBefore(u);
            if (s1 == null || s1.isEmpty()) continue;
            for (ValueBox vb : u.getUseBoxes()) {
                Cons<Unit, Local> key;
                List<Unit> lst;
                Local l;
                Set<Unit> s2;
                Value v = vb.getValue();
                if (!(v instanceof Local) || (s2 = this.defsOf(l = (Local)v)) == null || s2.isEmpty() || (lst = SmartLocalDefs.asList(s1, s2)).isEmpty() || this.answer.containsKey(key = new Cons<Unit, Local>(u, l))) continue;
                this.answer.put(key, lst);
            }
        }
        for (int i = 0; i < locals.length; ++i) {
            locals[i].setNumber(oldNumbers[i]);
        }
        if (Options.v().time()) {
            Timers.v().defsTimer.end();
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + g.getBody().getMethod().getName() + "]     SmartLocalDefs finished.");
        }
    }

    private Local localDef(Unit u) {
        List<ValueBox> defBoxes = u.getDefBoxes();
        int size = defBoxes.size();
        if (size == 0) {
            return null;
        }
        if (size != 1) {
            throw new RuntimeException();
        }
        ValueBox vb = defBoxes.get(0);
        Value v = vb.getValue();
        if (!(v instanceof Local)) {
            return null;
        }
        return (Local)v;
    }

    private Set<Unit> defsOf(Local l) {
        Set<Unit> s = this.localToDefs.get(l);
        if (s == null) {
            return Collections.emptySet();
        }
        return s;
    }

    private void addDefOf(Local l, Unit u) {
        Set<Unit> s = this.localToDefs.get(l);
        if (s == null) {
            s = new HashSet<Unit>();
            this.localToDefs.put(l, s);
        }
        s.add(u);
    }

    @Override
    public List<Unit> getDefsOfAt(Local l, Unit s) {
        List<Unit> lst = this.answer.get(new Cons<Unit, Local>(s, l));
        if (lst == null) {
            return Collections.emptyList();
        }
        return lst;
    }

    public UnitGraph getGraph() {
        return this.graph;
    }

    class LocalDefsAnalysis
    extends ForwardFlowAnalysisExtended<Unit, Set<Unit>> {
        LocalDefsAnalysis(UnitGraph g) {
            super(g);
            this.doAnalysis();
        }

        @Override
        protected void mergeInto(Unit succNode, Set<Unit> inout, Set<Unit> in) {
            inout.addAll(in);
        }

        @Override
        protected void merge(Set<Unit> in1, Set<Unit> in2, Set<Unit> out) {
            throw new RuntimeException("should never be called");
        }

        @Override
        protected void flowThrough(Set<Unit> in, Unit u, Unit succ, Set<Unit> out) {
            ExceptionalUnitGraph exGraph = this.graph instanceof ExceptionalUnitGraph ? (ExceptionalUnitGraph)this.graph : null;
            out.clear();
            BitSet liveLocals = (BitSet)SmartLocalDefs.this.liveLocalsAfter.get(u);
            Local l = SmartLocalDefs.this.localDef(u);
            if (l == null) {
                for (Unit inU : in) {
                    if (!liveLocals.get(SmartLocalDefs.this.localDef(inU).getNumber())) continue;
                    out.add(inU);
                }
            } else {
                Set allDefUnits = SmartLocalDefs.this.defsOf(l);
                boolean isExceptionalTarget = false;
                if (exGraph != null) {
                    for (ExceptionalUnitGraph.ExceptionDest ed : exGraph.getExceptionDests(u)) {
                        if (ed.getTrap() == null || ed.getTrap().getHandlerUnit() != succ) continue;
                        isExceptionalTarget = true;
                    }
                }
                for (Unit inU : in) {
                    if (!liveLocals.get(SmartLocalDefs.this.localDef(inU).getNumber()) || !isExceptionalTarget && allDefUnits.contains(inU)) continue;
                    out.add(inU);
                }
                assert (isExceptionalTarget || !out.removeAll(allDefUnits));
                if (liveLocals.get(l.getNumber()) && !isExceptionalTarget) {
                    out.add(u);
                }
            }
        }

        @Override
        protected void copy(Set<Unit> sourceSet, Set<Unit> destSet) {
            destSet.clear();
            destSet.addAll(sourceSet);
        }

        @Override
        protected Set<Unit> newInitialFlow() {
            return new HashSet<Unit>();
        }

        @Override
        protected Set<Unit> entryInitialFlow() {
            return new HashSet<Unit>();
        }
    }
}

