package de.upb.pga3.panda2.demos;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;

import de.upb.pga3.panda2.client.core.datastructures.ManifestInfo;
import de.upb.pga3.panda2.core.SootAdapter;
import de.upb.pga3.panda2.core.SootAdapter.SootPhase;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.core.services.A3XMLParser;
import de.upb.pga3.panda2.core.services.CoreServices;
import soot.Body;
import soot.PatchingChain;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;

/**
 *
 * @author Arjya
 *
 */
public class EnhancedInputForTestingNew {

	/**
	 * Returns the EnhancedInput object for an App containing one Implicit and
	 * one Explicit intent
	 *
	 * @param path
	 *
	 * @return
	 *
	 * @author Arjya
	 */
	public static EnhancedInput generateEnhancedInputForApp(final Path path) {

		final String className = "MainActivity";
		final String methodName = "launch_implicit";
		final String unitCharSeq = "Uri parse";

		SootAdapter.getInstance().init(path);
		SootAdapter.getInstance().run(SootPhase.WJTP);

		final String appName = "SimpleIntents";
		final ManifestInfo manifestInfo = A3XMLParser.getInstance().getManifestInformation();

		final EnhancedInput ei = new EnhancedInput(appName, manifestInfo);
		ei.setScene(Scene.v());

		final Permission[] allPermissions = { new Permission("INTERNET") };

		addPermissionToApp(allPermissions, ei);
		addPermissionToElement(className, methodName, unitCharSeq, new Permission("INTERNET"), ei);

		return ei;
	}

	/**
	 * Returns the EnhancedInput object for an App containing one Explicit
	 * Intent
	 *
	 * @param path
	 *
	 * @return
	 *
	 * @author Arjya
	 */
	public static EnhancedInput generateEnhancedInputForOnlyExplicitApp(final Path path) {

		SootAdapter.getInstance().init(path);
		SootAdapter.getInstance().run(SootPhase.WJTP);

		final String appName = "OnlyExplicit";
		final ManifestInfo manifestInfo = A3XMLParser.getInstance().getManifestInformation();

		final EnhancedInput ei = new EnhancedInput(appName, manifestInfo);
		ei.setScene(Scene.v());

		return ei;
	}

	/**
	 * Returns the EnhancedInput object for an App containing one Implicit
	 * Intent
	 *
	 * @param path
	 *
	 * @return
	 *
	 * @author Arjya
	 */
	public static EnhancedInput generateEnhancedInputForOnlyImplicitApp(final Path path) {

		SootAdapter.getInstance().init(path);
		SootAdapter.getInstance().run(SootPhase.WJTP);

		final String appName = "OnlyImplicit";
		final ManifestInfo manifestInfo = A3XMLParser.getInstance().getManifestInformation();

		final EnhancedInput ei = new EnhancedInput(appName, manifestInfo);
		ei.setScene(Scene.v());

		return ei;
	}

	/**
	 * Adds permissions to the enhanced Input
	 *
	 * @param permissions
	 * @param ei
	 */
	private static void addPermissionToApp(final Permission[] permissions, final EnhancedInput ei) {

		final Collection<Permission> lstPerm = CoreServices.getDataStorageInstance().getAllPermissions().values();
		for (final Permission newPermission : permissions) {
			if (newPermission != null && newPermission.getName().length() > 0) {
				Permission foundPermission = null;
				for (final Permission item : lstPerm) {
					if (item.getName().contains(newPermission.getName())) {
						foundPermission = item;
					}
				}

				ei.addPermission(foundPermission);
			}

		}

	}

	/**
	 * adds permission to an unit
	 *
	 * @param className
	 * @param methodName
	 * @param unitCharSeq
	 * @param permission
	 * @param ei
	 */

	private static void addPermissionToElement(final String className, final String methodName,
			final String unitCharSeq, final Permission permission, final EnhancedInput ei) {

		final Collection<Permission> lstPerm = CoreServices.getDataStorageInstance().getAllPermissions().values();
		final SootClass[] classes = ei.getAppClasses();
		for (final SootClass c : classes) {
			if (c.getName().toString().contains(className)) {
				final List<SootMethod> methods = c.getMethods();
				for (final SootMethod m : methods) {
					if (m.getName().toString().contains(methodName)) {
						final Body body = m.retrieveActiveBody();
						final PatchingChain<Unit> units = body.getUnits();
						for (final Unit u : units) {
							ei.mapUnitToBody(u, body);
							if (u.toString().contains(unitCharSeq)) {
								for (final Permission item : lstPerm) {
									if (item.getName().contains(permission.getName())) {
										ei.addPermissionTo(u, permission);
									}
								}

							}
						}

					}
				}
			}
		}
	}
}
