package de.upb.pga3.ate;

import java.util.ArrayList;
import java.util.List;

import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.extension.lvl1.AnalysisResultLvl1;
import de.upb.pga3.panda2.extension.lvl1.ResultTypeLvl1;

/**
 *
 * This class is used to check expected permissions for Level 1, in the analysis
 * result generated.
 *
 * @author Abhinav
 */
public class Level1Exp {
	String displayString = new String();
	List<String> getExpResults = new ArrayList<String>();
	final AnalysisResult analysisResult;
	boolean pcLevel1 = false;

	public Level1Exp(final List<String> getExpResults, final AnalysisResult analysisResult) {
		this.getExpResults = getExpResults;
		this.analysisResult = analysisResult;
		go();
	}

	/**
	 * This method checks the expected permissions and permission group obtained
	 * from analysis result. {@link Level1Exp}.
	 *
	 *
	 */
	private void go() {
		final TextReader tr = new TextReader(this.getExpResults);
		this.displayString += "\nExpected Results:- ";

		final List<Permission> permissionsM = ((AnalysisResultLvl1) this.analysisResult).getApp()
				.getPermissions(ResultTypeLvl1.MISSING);
		final List<Permission> permissionsR = ((AnalysisResultLvl1) this.analysisResult).getApp()
				.getPermissions(ResultTypeLvl1.REQUIRED);
		final List<Permission> permissionsO = ((AnalysisResultLvl1) this.analysisResult).getApp()
				.getPermissions(ResultTypeLvl1.MAYBE_REQUIRED);
		final List<Permission> permissionsU = ((AnalysisResultLvl1) this.analysisResult).getApp()
				.getPermissions(ResultTypeLvl1.UNUSED);
		final List<Permission> permissionsG = ((AnalysisResultLvl1) this.analysisResult).getApp()
				.getPermissions(ResultTypeLvl1.MAYBE_MISSING);

		final List<String> getExpResultsM = tr.getterExpResultsM();
		final List<String> getExpResultsR = tr.getterExpResultsR();
		final List<String> getExpResultsO = tr.getterExpResultsO();
		final List<String> getExpResultsU = tr.getterExpResultsU();
		final List<String> getExpResultsG = tr.getterExpResultsG();

		int noCount = 0;

		for (int i = 0; i < getExpResultsM.size(); i++) {
			noCount += 1;
			if (permissionsM.size() != 0) {
				for (int j = 0; j < permissionsM.size(); j++) {
					Level1Exp.this.pcLevel1 = false;
					if (permissionsM.get(j).getName().contains(getExpResultsM.get(i))) {
						Level1Exp.this.pcLevel1 = true;
						this.displayString += "\n" + noCount + ".-" + getExpResultsM.get(i) + "(MISSING)" + "\n"
								+ "=>FOUND";

						break;
					}
				}
				//
				if (Level1Exp.this.pcLevel1 == false) {
					this.displayString += "\n" + noCount + ".-" + getExpResultsM.get(i) + "(MISSING)" + "\n"
							+ "=>NOT FOUND";

				}
			}

			else {
				this.displayString += "\n" + noCount + ".-" + getExpResultsM.get(i) + "(MISSING)" + "\n"
						+ "=>NOT FOUND";

			}
		}
		for (int i = 0; i < getExpResultsR.size(); i++) {
			noCount += 1;
			if (permissionsR.size() != 0) {
				for (int j = 0; j < permissionsR.size(); j++) {
					Level1Exp.this.pcLevel1 = false;
					if (permissionsR.get(j).getName().contains(getExpResultsR.get(i))) {
						Level1Exp.this.pcLevel1 = true;
						this.displayString += "\n" + noCount + ".-" + getExpResultsR.get(i) + "(REQUIRED)" + "\n"
								+ "=>FOUND";

						break;
					}
				}
				if (Level1Exp.this.pcLevel1 == false) {
					this.displayString += "\n" + noCount + ".-" + getExpResultsR.get(i) + "(REQUIRED)" + "\n"
							+ "=>NOT FOUND";

				}

			} else {
				this.displayString += "\n" + noCount + ".-" + getExpResultsR.get(i) + "(REQUIRED)" + "\n"
						+ "=>NOT FOUND";

			}
		}
		for (int i = 0; i < getExpResultsO.size(); i++) {
			noCount += 1;
			if (permissionsO.size() != 0) {
				for (int j = 0; j < permissionsO.size(); j++) {
					Level1Exp.this.pcLevel1 = false;
					if (permissionsO.get(j).getName().contains(getExpResultsO.get(i))) {
						Level1Exp.this.pcLevel1 = true;
						this.displayString += "\n" + noCount + ".-" + getExpResultsO.get(i) + "(MAY BE REQUIRED)" + "\n"
								+ "=>FOUND";

						break;
					}
				}
				if (Level1Exp.this.pcLevel1 == false) {
					this.displayString += "\n" + noCount + ".-" + getExpResultsO.get(i) + "(MAY BE REQUIRED)" + "\n"
							+ "=>NOT FOUND";

				}
			} else {
				this.displayString += "\n" + noCount + ".-" + getExpResultsO.get(i) + "(MAY BE REQUIRED)" + "\n"
						+ "=>NOT FOUND";

			}
		}
		for (int i = 0; i < getExpResultsU.size(); i++) {

			noCount += 1;

			if (permissionsU.size() != 0) {

				for (int j = 0; j < permissionsU.size(); j++) {

					Level1Exp.this.pcLevel1 = false;
					if (permissionsU.get(j).getName().contains(getExpResultsU.get(i))) {
						Level1Exp.this.pcLevel1 = true;
						this.displayString += "\n" + noCount + ".-" + getExpResultsU.get(i) + "(UNUSED)" + "\n"
								+ "=>FOUND";

						break;
					}
				}
				if (Level1Exp.this.pcLevel1 == false) {

					this.displayString += "\n" + noCount + ".-" + getExpResultsU.get(i) + "(UNUSED)" + "\n"
							+ "=>NOT FOUND";

				}

			}

			else {

				this.displayString += "\n" + noCount + ".-" + getExpResultsU.get(i) + "(UNUSED)" + "\n" + "=>NOT FOUND";

			}
		}
		for (int i = 0; i < getExpResultsG.size(); i++) {

			noCount += 1;
			if (permissionsG.size() != 0) {
				for (int j = 0; j < permissionsG.size(); j++) {

					Level1Exp.this.pcLevel1 = false;
					if (permissionsG.get(j).getName().contains(getExpResultsG.get(i))) {
						Level1Exp.this.pcLevel1 = true;
						this.displayString += "\n" + noCount + ".-" + getExpResultsG.get(i) + "(MAY BE MISSING)" + "\n"
								+ "=>FOUND";

						break;
					}
				}
				if (Level1Exp.this.pcLevel1 == false) {
					this.displayString += "\n" + noCount + ".-" + getExpResultsG.get(i) + "(MAY BE MISSING)" + "\n"
							+ "=>NOT FOUND";

				}
			} else {
				this.displayString += "\n" + noCount + ".-" + getExpResultsG.get(i) + "(MAY BE MISSING)" + "\n"
						+ "=>NOT FOUND";

			}
		}
		Level1Exp.this.pcLevel1 = false;
		this.getExpResults.clear();
		System.gc();
	}

	/**
	 * This method returns string to be presented to the user. {@link Level1Exp}
	 * .
	 *
	 *
	 */
	public String getterDisplayString() {
		return this.displayString;
	}
}
