
package de.upb.pga3.ate;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.extension.lvl2a.AnalysisResultLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.FlowPath;

/**
 *
 * This class is used to check expected path between source and sink in the
 * analysis result.
 *
 * @author Abhinav
 */
public class Level2aExp {
	String displayString = new String();
	List<String> getExpResults = new ArrayList<String>();
	final AnalysisResult analysisResult;
	boolean pcLevel2a = false;
	boolean sourceSinkChecker = false;

	public Level2aExp(final List<String> getExpResults, final AnalysisResult analysisResult) {
		this.getExpResults = getExpResults;
		this.analysisResult = analysisResult;
		go();
	}

	/**
	 * This method checks the expected path between source and sink in the
	 * analysis result. {@link Level2aExp}.
	 *
	 *
	 */
	private void go() {
		final TextReader tr = new TextReader(this.getExpResults);
		this.displayString += "\nExpected Results:- ";

		final List<Permission> getExpResultsSource = new ArrayList<Permission>();
		final List<Permission> getExpResultsSink = new ArrayList<Permission>();
		Permission p1 = new Permission("");
		Permission p2 = new Permission("");

		for (int i = 0; i < tr.getterExpResultsSource().size(); i++) {
			p1 = new Permission(tr.getterExpResultsSource().get(i));
			getExpResultsSource.add(p1);
		}

		for (int i = 0; i < tr.getterExpResultsSink().size(); i++) {
			p2 = new Permission(tr.getterExpResultsSink().get(i));
			getExpResultsSink.add(p2);
		}

		final Set<FlowPath> flowPathSet = ((AnalysisResultLvl2a) this.analysisResult).getPaths();
		int noCount = 0;
		for (int j = 0; j < getExpResultsSource.size(); j++) {
			Level2aExp.this.sourceSinkChecker = false;
			for (final FlowPath fp : flowPathSet) {

				if (fp.getSource().getPermissionName().equals(getExpResultsSource.get(j).getName())
						&& fp.getSink().getPermissionName().equals(getExpResultsSink.get(j).getName())) {

					Level2aExp.this.sourceSinkChecker = true;
					noCount += 1;
					Level2aExp.this.displayString += "\n" + noCount + ".-" + getExpResultsSource.get(j).getName()
							+ "(SOURCE)" + "\n" + getExpResultsSink.get(j).getName() + "(SINK)" + "\n" + "=>FOUND";

					break;

				}

			}
			if (Level2aExp.this.sourceSinkChecker == false) {
				noCount += 1;
				Level2aExp.this.displayString += "\n" + noCount + ".-" + getExpResultsSource.get(j).getName()
						+ "(SOURCE)" + "\n" + getExpResultsSink.get(j).getName() + "(SINK)" + "\n" + "=>NOT FOUND";

			}

		}
		this.getExpResults.clear();
		System.gc();

	}

	/**
	 * This method returns string to be presented to the user.
	 * {@link Level2aExp}.
	 *
	 *
	 */

	public String getterDisplayString() {
		return this.displayString;
	}
}
