
package de.upb.pga3.ate;

import java.util.ArrayList;
import java.util.List;

import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import de.upb.pga3.panda2.extension.lvl2b.AnalysisResultLvl2b;
import de.upb.pga3.panda2.extension.lvl2b.ResultTypeLvl2b;

/**
 *
 * This class is used to check expected type access of permissions in between
 * the applications.
 *
 * @author Abhinav
 */

public class Level2bExp {
	String displayString = new String();
	List<String> getExpResults = new ArrayList<String>();
	final AnalysisResult analysisResult;
	boolean pcLevel2b = false;

	public Level2bExp(final List<String> getExpResults, final AnalysisResult analysisResult) {
		this.getExpResults = getExpResults;
		this.analysisResult = analysisResult;
		go();
	}

	/**
	 * This method checks expected type access of permissions in between the
	 * applications. {@link Level2aExp}.
	 *
	 *
	 */
	private void go() {
		final TextReader tr = new TextReader(this.getExpResults);
		this.displayString += "\nExpected Results:- ";

		final List<String> getExpResultsD = tr.getterExpResultsD();
		final List<String> getExpResultsI = tr.getterExpResultsI();
		final List<String> getExpResultsDI = tr.getterExpResultsDI();

		final List<String> getExpResultsDirect = new ArrayList<String>();
		final List<String> getExpResultsIndirect = new ArrayList<String>();
		final List<String> getExpResultsBoth = new ArrayList<String>();

		final int sizer = ((AnalysisResultLvl2b) this.analysisResult).getApp().getResultItems(ResultTypeLvl2b.ALL)
				.size();

		for (int i = 0; i < sizer; i++) {

			final int checker = ((AnalysisResultLvl2b) this.analysisResult).getApp().getResultItems(ResultTypeLvl2b.ALL)
					.get(i).getDirect();

			final String permission = ((AnalysisResultLvl2b) this.analysisResult).getApp()
					.getResultItems(ResultTypeLvl2b.ALL).get(i).getPermission().getName();
			if (checker == 0) {
				getExpResultsDirect.add(permission);

			} else if (checker == 1) {
				getExpResultsIndirect.add(permission);

			} else if (checker == 2) {
				getExpResultsBoth.add(permission);

			}
		}
		//

		int noCount = 0;
		for (int i = 0; i < getExpResultsD.size(); i++) {
			noCount += 1;
			if (getExpResultsDirect.size() != 0) {
				for (int j = 0; j < getExpResultsDirect.size(); j++) {
					Level2bExp.this.pcLevel2b = false;

					if (getExpResultsDirect.get(j).contains(getExpResultsD.get(i))) {
						Level2bExp.this.pcLevel2b = true;
						this.displayString += "\n" + noCount + ".-" + getExpResultsD.get(i) + "(DIRECT)" + "\n"
								+ "=>FOUND";

						break;
					}
				}
				if (Level2bExp.this.pcLevel2b == false) {
					this.displayString += "\n" + noCount + ".-" + getExpResultsD.get(i) + "(DIRECT)" + "\n"
							+ "=>NOT FOUND";

				}

			} else {
				this.displayString += "\n" + noCount + ".-" + getExpResultsD.get(i) + "(DIRECT)" + "\n" + "=>NOT FOUND";

			}
		}
		for (int i = 0; i < getExpResultsI.size(); i++) {
			noCount += 1;
			if (getExpResultsIndirect.size() != 0) {
				for (int j = 0; j < getExpResultsIndirect.size(); j++) {
					Level2bExp.this.pcLevel2b = false;

					if (getExpResultsIndirect.get(j).contains(getExpResultsI.get(i))) {
						Level2bExp.this.pcLevel2b = true;
						this.displayString += "\n" + noCount + ".-" + getExpResultsI.get(i) + "(INDIRECT)" + "\n"
								+ "=>FOUND";

						break;
					}
				}
				if (Level2bExp.this.pcLevel2b == false) {
					this.displayString += "\n" + noCount + ".-" + getExpResultsI.get(i) + "(INDIRECT)" + "\n"
							+ "=>NOT FOUND";

				}

			} else {
				this.displayString += "\n" + noCount + ".-" + getExpResultsI.get(i) + "(INDIRECT)" + "\n"
						+ "=>NOT FOUND";

			}
		}
		for (int i = 0; i < getExpResultsDI.size(); i++) {
			noCount += 1;
			if (getExpResultsBoth.size() != 0) {
				for (int j = 0; j < getExpResultsBoth.size(); j++) {
					Level2bExp.this.pcLevel2b = false;

					if (getExpResultsBoth.get(j).contains(getExpResultsDI.get(i))) {
						Level2bExp.this.pcLevel2b = true;
						this.displayString += "\n" + noCount + ".-" + getExpResultsDI.get(i) + "(BOTH)" + "\n"
								+ "=>FOUND";

						break;
					}
				}
				if (Level2bExp.this.pcLevel2b == false) {
					this.displayString += "\n" + noCount + ".-" + getExpResultsDI.get(i) + "(BOTH)" + "\n"
							+ "=>NOT FOUND";

				}

			} else {
				this.displayString += "\n" + noCount + ".-" + getExpResultsDI.get(i) + "(BOTH)" + "\n" + "=>NOT FOUND";

			}
		}
		Level2bExp.this.pcLevel2b = false;
	}

	/**
	 * This method returns string to be presented to the user.
	 * {@link Level2bExp}.
	 *
	 *
	 */
	public String getterDisplayString() {
		return this.displayString;
	}
}