package de.upb.pga3.panda2.client.core;

import java.util.List;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;

import de.upb.pga3.panda2.client.core.datastructures.Mode;
import de.upb.pga3.panda2.client.core.datastructures.ResultRepresentation;
import de.upb.pga3.panda2.client.core.datastructures.ResultView;
import de.upb.pga3.panda2.client.core.datastructures.ToolSpecificOption;
import de.upb.pga3.panda2.core.datastructures.DetailLevel;
import de.upb.pga3.panda2.utilities.Constants;

/**
 * This Class represents the core business logic from CommandLine perspective by
 * extending the abstract class Client.
 *
 * @author Sriram
 */

public class ClientCommandLine extends Client {

	/*
	 * Boolean variable for representing whether the user requested to view or
	 * save the result
	 */
	private boolean isSaveResult;

	/*
	 * Boolean variable for representing whether the user requested to view the
	 * result as Graphical View
	 */
	private boolean isGraphicalViewResult;

	/*
	 * Boolean variable for representing whether the user requested to view the
	 * result as Messages
	 */
	private boolean isMessageViewResult;

	/*
	 * Boolean variable for representing whether the program should get
	 * terminated after showing the result or not.
	 */
	private boolean isProgramTerminate;

	/*
	 * Boolean variable for representing whether the scenario is used for
	 * testing or not.
	 */
	private boolean isTestingScenario;

	/*
	 * Boolean variable for representing whether the LOAD option is selected by
	 * user.
	 */
	private boolean isLoadOptionSelected;

	/*
	 * Boolean variable for representing whether the HELP option is selected by
	 * user.
	 */
	private boolean isHelpOptionSelected;

	/**
	 * Constructor without parameter.
	 *
	 * Uses the Super Constructor without parameters of the super class
	 *
	 * It also creates the required user object within the super constructor
	 * method e.g. the {@link UserInput}
	 */
	public ClientCommandLine() {
		super();
	}

	/**
	 * Constructor with parameter.
	 *
	 * Uses the super class Constructor with parameters
	 *
	 * It also creates the required user object within the method e.g. the
	 * {@link UserInput}
	 *
	 * @param level
	 *            Represents the Level selected by the user.
	 * @param levelSpecificMode
	 *            Represents the mode specific to the level by the user. Value
	 *            of this value will be null for Level1 and Level2a.
	 * @param mode
	 *            Represents the Mode selected by the user.
	 *
	 *
	 */
	/*
	 * public ClientCommandLine(final Level level, final LevelSpecificMode
	 * levelSpecificMode, final Mode mode) { super(level, levelSpecificMode,
	 * mode); }
	 */

	/**
	 *
	 * Get the boolean value of the isGraphicalViewResult variable.
	 *
	 * @return boolean
	 */
	public boolean isGraphicalViewResult() {
		return this.isGraphicalViewResult;
	}

	/**
	 * Set the boolean value for isGraphicalViewResult variable.
	 *
	 * @param isGraphicalViewResult
	 *            boolean value
	 */
	public void setGraphicalViewResult(final boolean isGraphicalViewResult) {
		this.isGraphicalViewResult = isGraphicalViewResult;
	}

	/**
	 * Method for validating the user input based on the utility library class
	 * JCommander.
	 *
	 * It also creates the required user object within the method e.g. the
	 * {@link JCommander}
	 *
	 * @param args
	 *            The String[] represents the command line parameters give by
	 *            the user.
	 * @return boolean value
	 */
	public boolean validateCommandLineInputArguments(final String... args) {
		final JCommander jCommander = new JCommander(getUserInput());
		try {
			jCommander.parse(args);
			final UserInput userInput = getUserInput();
			final ToolSpecificOption toolSpecificOption = userInput.getTsOption();
			final ResultRepresentation resultRepresentation = userInput.getResultRepresentation();
			final ResultView resultView = userInput.getResultView();
			if (!toolSpecificOption.equals(ToolSpecificOption.ANALYSIS)) {
				setLoadOptionSelected(toolSpecificOption.equals(ToolSpecificOption.LOAD));
				if (!isLoadOptionSelected()) {
					setHelpOptionSelected(true);
					jCommander.usage();
				} else {
					if (userInput.getFilePath() == null || userInput.getFilePath().isEmpty()) {
						throw new ParameterException("File for viewing the result is not given. "
								+ "Please input the correct value as this field is mandatory for the LOADING/VIEWING mode");
					} else {
						if (!userInput.getFilePath().toLowerCase().endsWith(Constants.SAVED_RESULT_EXTENSION)) {
							throw new ParameterException(
									"A file is without an PA2 extension. Unsupported input file format for LOADING the result. File name= "
											+ userInput.getFilePath());
						}
					}
				}
			} else {
				if (userInput.getLevel() == null) {
					throw new ParameterException("Level value is " + userInput.getLevel() + ". "
							+ "Please input the correct value as this field (-l) is mandatory for the ANALYSIS mode");
				} else {
					if (AnalysisRegistry.getInstance().getName(userInput.getLevel()).equals(AnalysisRegistry.LEVEL2B)) {
						if (userInput.getLevelSpecificMode() == null) {
							throw new ParameterException("Level Specific Mode value is "
									+ userInput.getLevelSpecificMode() + ". "
									+ "Please input the correct value as this field (-lm) is mandatory for LEVEL2B");
						}
					}
				}
				if (userInput.getSelectedInitialInput() == null || userInput.getSelectedInitialInput().isEmpty()) {
					throw new ParameterException("Input APK's are not given. "
							+ "Please input the correct value as this field (-i) is mandatory for the ANALYSIS mode");
				} else {
					for (final String input : userInput.getSelectedInitialInput()) {
						if (!input.toLowerCase().endsWith(Constants.APK_EXTENSION)) {
							throw new ParameterException(
									"A file is without an APK extension. Unsupported input file format. File name= "
											+ input);
						}
					}
				}
			}
			if (!isHelpOptionSelected()) {
				if (resultRepresentation != null) {
					setSaveResult(resultRepresentation.equals(ResultRepresentation.SAVE));
				}
				if (resultView != null && !resultView.equals(ResultView.TEXTUAL)) {
					setGraphicalViewResult(resultView.equals(ResultView.GRAPHICAL));
					if (!isGraphicalViewResult()) {
						setMessageViewResult(true);
					}
				}
				if (userInput.getSelectedComparisonInput() != null
						&& !userInput.getSelectedComparisonInput().trim().equals("")) {
					userInput.setMode(Mode.COMPARISON);
					setComparisonMode(true);
				}
				setProgramTerminate(userInput.isTerminate());
				setTestingScenario(userInput.isTestingScenario());
			}
		} catch (final ParameterException ex) {
			JCommander.getConsole().println("Cannot parse arguments: " + ex.getMessage());
			jCommander.usage();
			return false;
		}
		return true;
	}

	/**
	 * Method for validating the user selection whether the user entered value
	 * is selected for continuing the analysis or not.
	 *
	 * @param continueAnalysis
	 *            The String represents the value give by the user.
	 * @return boolean value
	 */
	public boolean continueAnalysis(final String continueAnalysis) {

		String userSelectedValue = continueAnalysis;
		if (userSelectedValue == null) {
			userSelectedValue = "Yes";
		}
		return (userSelectedValue.equalsIgnoreCase("Yes") || userSelectedValue.equalsIgnoreCase("Y") ? true : false);
	}

	/**
	 * Method for fetching the filtered textual result as a String. Currently
	 * used as abstract method.
	 *
	 * @param detailLevel
	 *            the instance of implemented classes of the DetailLevel
	 *            interface
	 * @param resultFilter
	 *            Result filters as the instances of the list of String.
	 * @return textualResult, represents the analysis textual result as instance
	 *         of the String class
	 */
	@Override
	public String filterTextViewResult(final DetailLevel detailLevel, final List<String> resultFilter) {
		final String textualResult = getAnalysisResult().getTextualResult(detailLevel, resultFilter,
				getUserInput().isShowTestStatistics());
		return textualResult;
	}

	/*
	 *
	 *
	 * Not implemented as the following methods are not required now.
	 *
	 * public void displayCommandLineTextualResult(final String
	 * textualAnalysisResult) {
	 *
	 *
	 * }
	 *
	 *
	 * public void displayGraphicalResult(final String graphicalAnalysisResult)
	 * {
	 *
	 * }
	 *
	 *
	 * public void displayCommandLineMessageResult(final Collection<Message>
	 * messages) {
	 *
	 * }
	 */

	/**
	 *
	 * Get the boolean value of the isSaveResult variable.
	 *
	 * @return boolean
	 */
	public boolean isSaveResult() {
		return this.isSaveResult;
	}

	/**
	 * Set the boolean value for isSaveResult variable.
	 *
	 * @param isSaveResult
	 *            boolean value
	 */
	public void setSaveResult(final boolean isSaveResult) {
		this.isSaveResult = isSaveResult;
	}

	/**
	 * @return the isMessageViewResult
	 */
	public boolean isMessageViewResult() {
		return this.isMessageViewResult;
	}

	/**
	 * @param isMessageViewResult
	 *            the isMessageViewResult to set
	 */
	public void setMessageViewResult(final boolean isMessageViewResult) {
		this.isMessageViewResult = isMessageViewResult;
	}

	/**
	 * @return the isProgramTerminate
	 */
	public boolean isProgramTerminate() {
		return this.isProgramTerminate;
	}

	/**
	 * @param isProgramTerminate
	 *            the isProgramTerminate to set
	 */
	public void setProgramTerminate(final boolean isProgramTerminate) {
		this.isProgramTerminate = isProgramTerminate;
	}

	/**
	 * @return the isTestingScenario
	 */
	public boolean isTestingScenario() {
		return this.isTestingScenario;
	}

	/**
	 * @param isTestingScenario
	 *            the isTestingScenario to set
	 */
	public void setTestingScenario(final boolean isTestingScenario) {
		this.isTestingScenario = isTestingScenario;
	}

	/**
	 * @return the isLoadOptionSelected
	 */
	public boolean isLoadOptionSelected() {
		return this.isLoadOptionSelected;
	}

	/**
	 * @param isLoadOptionSelected
	 *            the isLoadOptionSelected to set
	 */
	public void setLoadOptionSelected(final boolean isLoadOptionSelected) {
		this.isLoadOptionSelected = isLoadOptionSelected;
	}

	/**
	 * @return the isHelpOptionSelected
	 */
	public boolean isHelpOptionSelected() {
		return this.isHelpOptionSelected;
	}

	/**
	 * @param isHelpOptionSelected
	 *            the isHelpOptionSelected to set
	 */
	public void setHelpOptionSelected(final boolean isHelpOptionSelected) {
		this.isHelpOptionSelected = isHelpOptionSelected;
	}

	@Override
	public String filterGraphicalViewResult(final DetailLevel detailLevel, final List<String> resultFilter) {
		return null;
	}

}
