package de.upb.pga3.panda2.client.core.datastructures;

/**
 * Enumeration for representing different level specific modes. This enumeration
 * represents the values only for level 2b.
 *
 * @author Sriram
 *
 */
public enum LevelSpecificMode {

	// Values specific to LevelSpecificMode
	APP, ALL;

	/**
	 * Method for getting the instance of the LevelSpecificMode enumeration
	 * based on the passed String value.
	 *
	 * @param code
	 * @return levelSpecificMode, if the parameter code matches the value of the
	 *         enumeration. else, null value will be returned.
	 */
	public static LevelSpecificMode fromString(final String code) {
		for (final LevelSpecificMode levelSpecificMode : LevelSpecificMode
				.values()) {
			if (levelSpecificMode.toString().equalsIgnoreCase(code)) {
				return levelSpecificMode;
			}
		}
		return null;
	}

}
